
#line 1 "../../src/hb-ot-shape-complex-indic-machine.rl"
/*
 * Copyright © 2011,2012  Google, Inc.
 *
 *  This is part of HarfBuzz, a text shaping library.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * Google Author(s): Behdad Esfahbod
 */

#ifndef HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH
#define HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH

#include "hb-private.hh"


#line 36 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
static const unsigned char _indic_syllable_machine_trans_keys[] = {
	1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 
	5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 4u, 4u, 6u, 6u, 
	16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 
	7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 
	5u, 7u, 7u, 7u, 4u, 4u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 
	4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 
	5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 4u, 4u, 6u, 6u, 
	16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 7u, 7u, 
	5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 
	7u, 7u, 4u, 4u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 5u, 7u, 5u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 
	7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 1u, 16u, 13u, 13u, 4u, 4u, 6u, 6u, 
	16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 
	3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 
	3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 5u, 14u, 8u, 14u, 
	5u, 9u, 9u, 9u, 9u, 9u, 3u, 17u, 3u, 9u, 8u, 9u, 3u, 9u, 3u, 13u, 
	3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 
	4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 6u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 
	3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 
	3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 3u, 14u, 3u, 14u, 
	4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 
	4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 
	4u, 14u, 5u, 14u, 8u, 14u, 5u, 9u, 9u, 9u, 9u, 9u, 3u, 17u, 3u, 9u, 
	8u, 9u, 3u, 9u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 
	4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 6u, 14u, 
	3u, 14u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 
	3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 4u, 14u, 1u, 16u, 3u, 14u, 
	3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 
	3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 
	3u, 14u, 4u, 14u, 5u, 14u, 8u, 14u, 5u, 9u, 9u, 9u, 9u, 9u, 3u, 17u, 
	3u, 9u, 8u, 9u, 3u, 9u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 
	6u, 14u, 3u, 14u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 4u, 14u, 
	3u, 14u, 4u, 14u, 3u, 14u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 
	4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 
	4u, 14u, 1u, 16u, 3u, 17u, 3u, 14u, 4u, 14u, 5u, 14u, 8u, 14u, 5u, 9u, 
	9u, 9u, 9u, 9u, 3u, 17u, 3u, 9u, 8u, 9u, 3u, 9u, 3u, 13u, 3u, 14u, 
	3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 
	5u, 14u, 3u, 14u, 4u, 14u, 6u, 14u, 3u, 14u, 1u, 16u, 3u, 14u, 3u, 14u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 3u, 14u, 3u, 14u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 14u, 1u, 16u, 3u, 17u, 1u, 16u, 4u, 14u, 1u, 16u, 
	3u, 17u, 3u, 14u, 4u, 14u, 5u, 9u, 9u, 9u, 9u, 9u, 3u, 14u, 3u, 14u, 
	1u, 16u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 
	4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 8u, 14u, 3u, 17u, 3u, 9u, 8u, 9u, 
	3u, 9u, 3u, 13u, 1u, 16u, 0
};

static const char _indic_syllable_machine_key_spans[] = {
	16, 1, 3, 3, 1, 3, 3, 1, 
	3, 3, 1, 3, 3, 1, 1, 1, 
	1, 4, 1, 1, 4, 1, 1, 4, 
	1, 1, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 16, 1, 3, 3, 
	1, 3, 3, 1, 3, 3, 1, 3, 
	3, 1, 1, 1, 1, 4, 1, 1, 
	4, 1, 1, 4, 1, 1, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	16, 1, 3, 3, 1, 3, 3, 1, 
	3, 3, 1, 3, 3, 1, 1, 1, 
	1, 4, 1, 1, 4, 1, 1, 4, 
	1, 1, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 16, 1, 3, 3, 1, 
	3, 3, 1, 3, 3, 1, 3, 3, 
	1, 1, 1, 1, 4, 1, 1, 4, 
	1, 1, 4, 1, 1, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 3, 3, 3, 3, 1, 3, 3, 
	1, 3, 3, 1, 16, 1, 1, 1, 
	1, 4, 1, 1, 4, 1, 1, 4, 
	1, 1, 16, 15, 12, 11, 16, 15, 
	12, 11, 16, 15, 12, 11, 16, 15, 
	12, 11, 16, 15, 12, 11, 10, 7, 
	5, 1, 1, 15, 7, 2, 7, 11, 
	12, 12, 11, 10, 12, 11, 10, 12, 
	11, 10, 12, 11, 9, 12, 11, 16, 
	12, 12, 16, 16, 16, 16, 16, 12, 
	12, 16, 16, 16, 16, 16, 12, 12, 
	16, 16, 16, 16, 16, 12, 12, 16, 
	16, 16, 16, 16, 12, 12, 12, 12, 
	11, 16, 15, 12, 11, 16, 15, 12, 
	11, 16, 15, 12, 11, 16, 15, 12, 
	11, 10, 7, 5, 1, 1, 15, 7, 
	2, 7, 11, 12, 12, 11, 10, 12, 
	11, 10, 12, 11, 10, 12, 11, 9, 
	12, 16, 12, 12, 16, 16, 16, 16, 
	16, 12, 12, 16, 16, 16, 16, 16, 
	12, 12, 16, 16, 16, 16, 16, 12, 
	12, 16, 16, 16, 16, 11, 16, 12, 
	12, 11, 16, 15, 12, 11, 16, 15, 
	12, 11, 16, 15, 12, 11, 16, 15, 
	12, 11, 10, 7, 5, 1, 1, 15, 
	7, 2, 7, 11, 12, 12, 11, 10, 
	12, 11, 10, 12, 11, 10, 12, 11, 
	9, 12, 16, 12, 12, 16, 16, 16, 
	16, 16, 12, 12, 16, 16, 16, 16, 
	16, 12, 12, 16, 16, 16, 16, 16, 
	12, 12, 16, 16, 16, 16, 16, 11, 
	12, 11, 12, 12, 11, 16, 15, 12, 
	11, 16, 15, 12, 11, 16, 15, 12, 
	11, 16, 15, 12, 11, 10, 7, 5, 
	1, 1, 15, 7, 2, 7, 11, 12, 
	12, 11, 10, 12, 11, 10, 12, 11, 
	10, 12, 11, 9, 12, 16, 12, 12, 
	16, 16, 16, 16, 16, 12, 12, 16, 
	16, 16, 16, 16, 12, 12, 16, 16, 
	16, 16, 16, 12, 12, 16, 16, 16, 
	16, 16, 12, 16, 15, 16, 11, 16, 
	15, 12, 11, 5, 1, 1, 12, 12, 
	16, 12, 11, 10, 12, 11, 10, 12, 
	11, 10, 12, 11, 7, 15, 7, 2, 
	7, 11, 16
};

static const short _indic_syllable_machine_index_offsets[] = {
	0, 17, 19, 23, 27, 29, 33, 37, 
	39, 43, 47, 49, 53, 57, 59, 61, 
	63, 65, 70, 72, 74, 79, 81, 83, 
	88, 90, 92, 104, 116, 128, 140, 152, 
	164, 176, 188, 200, 212, 229, 231, 235, 
	239, 241, 245, 249, 251, 255, 259, 261, 
	265, 269, 271, 273, 275, 277, 282, 284, 
	286, 291, 293, 295, 300, 302, 304, 316, 
	328, 340, 352, 364, 376, 388, 400, 412, 
	424, 441, 443, 447, 451, 453, 457, 461, 
	463, 467, 471, 473, 477, 481, 483, 485, 
	487, 489, 494, 496, 498, 503, 505, 507, 
	512, 514, 516, 528, 540, 552, 564, 576, 
	588, 600, 612, 624, 641, 643, 647, 651, 
	653, 657, 661, 663, 667, 671, 673, 677, 
	681, 683, 685, 687, 689, 694, 696, 698, 
	703, 705, 707, 712, 714, 716, 728, 740, 
	752, 764, 776, 788, 800, 812, 824, 836, 
	848, 860, 864, 868, 872, 876, 878, 882, 
	886, 888, 892, 896, 898, 915, 917, 919, 
	921, 923, 928, 930, 932, 937, 939, 941, 
	946, 948, 950, 967, 983, 996, 1008, 1025, 
	1041, 1054, 1066, 1083, 1099, 1112, 1124, 1141, 
	1157, 1170, 1182, 1199, 1215, 1228, 1240, 1251, 
	1259, 1265, 1267, 1269, 1285, 1293, 1296, 1304, 
	1316, 1329, 1342, 1354, 1365, 1378, 1390, 1401, 
	1414, 1426, 1437, 1450, 1462, 1472, 1485, 1497, 
	1514, 1527, 1540, 1557, 1574, 1591, 1608, 1625, 
	1638, 1651, 1668, 1685, 1702, 1719, 1736, 1749, 
	1762, 1779, 1796, 1813, 1830, 1847, 1860, 1873, 
	1890, 1907, 1924, 1941, 1958, 1971, 1984, 1997, 
	2010, 2022, 2039, 2055, 2068, 2080, 2097, 2113, 
	2126, 2138, 2155, 2171, 2184, 2196, 2213, 2229, 
	2242, 2254, 2265, 2273, 2279, 2281, 2283, 2299, 
	2307, 2310, 2318, 2330, 2343, 2356, 2368, 2379, 
	2392, 2404, 2415, 2428, 2440, 2451, 2464, 2476, 
	2486, 2499, 2516, 2529, 2542, 2559, 2576, 2593, 
	2610, 2627, 2640, 2653, 2670, 2687, 2704, 2721, 
	2738, 2751, 2764, 2781, 2798, 2815, 2832, 2849, 
	2862, 2875, 2892, 2909, 2926, 2943, 2955, 2972, 
	2985, 2998, 3010, 3027, 3043, 3056, 3068, 3085, 
	3101, 3114, 3126, 3143, 3159, 3172, 3184, 3201, 
	3217, 3230, 3242, 3253, 3261, 3267, 3269, 3271, 
	3287, 3295, 3298, 3306, 3318, 3331, 3344, 3356, 
	3367, 3380, 3392, 3403, 3416, 3428, 3439, 3452, 
	3464, 3474, 3487, 3504, 3517, 3530, 3547, 3564, 
	3581, 3598, 3615, 3628, 3641, 3658, 3675, 3692, 
	3709, 3726, 3739, 3752, 3769, 3786, 3803, 3820, 
	3837, 3850, 3863, 3880, 3897, 3914, 3931, 3948, 
	3960, 3973, 3985, 3998, 4011, 4023, 4040, 4056, 
	4069, 4081, 4098, 4114, 4127, 4139, 4156, 4172, 
	4185, 4197, 4214, 4230, 4243, 4255, 4266, 4274, 
	4280, 4282, 4284, 4300, 4308, 4311, 4319, 4331, 
	4344, 4357, 4369, 4380, 4393, 4405, 4416, 4429, 
	4441, 4452, 4465, 4477, 4487, 4500, 4517, 4530, 
	4543, 4560, 4577, 4594, 4611, 4628, 4641, 4654, 
	4671, 4688, 4705, 4722, 4739, 4752, 4765, 4782, 
	4799, 4816, 4833, 4850, 4863, 4876, 4893, 4910, 
	4927, 4944, 4961, 4974, 4991, 5007, 5024, 5036, 
	5053, 5069, 5082, 5094, 5100, 5102, 5104, 5117, 
	5130, 5147, 5160, 5172, 5183, 5196, 5208, 5219, 
	5232, 5244, 5255, 5268, 5280, 5288, 5304, 5312, 
	5315, 5323, 5335
};

static const short _indic_syllable_machine_indicies[] = {
	1, 2, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 3, 0, 4, 4, 5, 0, 6, 
	6, 5, 0, 5, 0, 7, 7, 8, 
	0, 9, 9, 8, 0, 8, 0, 10, 
	10, 11, 0, 12, 12, 11, 0, 11, 
	0, 13, 13, 14, 0, 15, 15, 14, 
	0, 14, 0, 16, 0, 17, 0, 18, 
	0, 19, 13, 13, 14, 0, 20, 0, 
	21, 0, 22, 10, 10, 11, 0, 23, 
	0, 24, 0, 25, 7, 7, 8, 0, 
	26, 0, 27, 0, 28, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 28, 0, 
	28, 4, 4, 5, 0, 0, 0, 0, 
	0, 29, 28, 0, 30, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 30, 0, 
	30, 4, 4, 5, 0, 0, 0, 0, 
	0, 31, 30, 0, 32, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 32, 0, 
	32, 4, 4, 5, 0, 0, 0, 0, 
	0, 33, 32, 0, 34, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 34, 0, 
	34, 4, 4, 5, 0, 0, 0, 0, 
	0, 35, 34, 0, 36, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 36, 0, 
	36, 4, 4, 5, 0, 0, 0, 0, 
	0, 37, 36, 0, 39, 40, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 39, 38, 41, 38, 42, 
	42, 43, 38, 44, 44, 43, 38, 43, 
	38, 45, 45, 46, 38, 47, 47, 46, 
	38, 46, 38, 48, 48, 49, 38, 50, 
	50, 49, 38, 49, 38, 51, 51, 52, 
	38, 53, 53, 52, 38, 52, 38, 54, 
	38, 55, 38, 56, 38, 57, 51, 51, 
	52, 38, 58, 38, 59, 38, 60, 48, 
	48, 49, 38, 61, 38, 62, 38, 63, 
	45, 45, 46, 38, 64, 38, 65, 38, 
	66, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 66, 38, 66, 42, 42, 43, 
	38, 38, 38, 38, 38, 67, 66, 38, 
	68, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 68, 38, 68, 42, 42, 43, 
	38, 38, 38, 38, 38, 69, 68, 38, 
	70, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 70, 38, 70, 42, 42, 43, 
	38, 38, 38, 38, 38, 71, 70, 38, 
	72, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 72, 38, 72, 42, 42, 43, 
	38, 38, 38, 38, 38, 73, 72, 38, 
	74, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 74, 38, 74, 42, 42, 43, 
	38, 38, 38, 38, 38, 75, 74, 38, 
	77, 78, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 77, 
	76, 79, 76, 80, 80, 81, 76, 83, 
	83, 81, 82, 81, 82, 84, 84, 85, 
	76, 86, 86, 85, 76, 85, 76, 87, 
	87, 88, 76, 89, 89, 88, 76, 88, 
	76, 90, 90, 91, 76, 92, 92, 91, 
	76, 91, 76, 93, 76, 94, 76, 95, 
	76, 96, 90, 90, 91, 76, 97, 76, 
	98, 76, 99, 87, 87, 88, 76, 100, 
	76, 101, 76, 102, 84, 84, 85, 76, 
	103, 76, 104, 76, 105, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 105, 76, 
	105, 80, 80, 81, 76, 76, 76, 76, 
	76, 106, 105, 76, 107, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 107, 76, 
	107, 80, 80, 81, 76, 76, 76, 76, 
	76, 108, 107, 76, 109, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 109, 76, 
	109, 80, 80, 81, 76, 76, 76, 76, 
	76, 110, 109, 76, 111, 80, 80, 81, 
	82, 82, 82, 82, 82, 82, 111, 82, 
	111, 80, 80, 81, 76, 76, 76, 76, 
	76, 112, 111, 76, 113, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 113, 76, 
	115, 116, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 115, 
	114, 117, 114, 118, 118, 119, 114, 120, 
	120, 119, 114, 119, 114, 121, 121, 122, 
	114, 123, 123, 122, 114, 122, 114, 124, 
	124, 125, 114, 126, 126, 125, 114, 125, 
	114, 127, 127, 128, 114, 129, 129, 128, 
	114, 128, 114, 130, 114, 131, 114, 132, 
	114, 133, 127, 127, 128, 114, 134, 114, 
	135, 114, 136, 124, 124, 125, 114, 137, 
	114, 138, 114, 139, 121, 121, 122, 114, 
	140, 114, 141, 114, 142, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 142, 114, 
	142, 118, 118, 119, 114, 114, 114, 114, 
	114, 143, 142, 114, 144, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 144, 114, 
	144, 118, 118, 119, 114, 114, 114, 114, 
	114, 145, 144, 114, 146, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 146, 114, 
	146, 118, 118, 119, 114, 114, 114, 114, 
	114, 147, 146, 114, 148, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 148, 114, 
	148, 118, 118, 119, 114, 114, 114, 114, 
	114, 149, 148, 114, 150, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 150, 114, 
	150, 118, 118, 119, 114, 114, 114, 114, 
	114, 151, 150, 114, 113, 80, 80, 81, 
	76, 76, 76, 76, 76, 152, 113, 76, 
	111, 80, 80, 81, 0, 0, 0, 0, 
	0, 153, 111, 0, 154, 154, 155, 0, 
	6, 6, 155, 0, 156, 156, 157, 0, 
	158, 158, 157, 0, 157, 0, 159, 159, 
	160, 0, 161, 161, 160, 0, 160, 0, 
	162, 162, 163, 0, 164, 164, 163, 0, 
	163, 0, 165, 166, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 165, 0, 167, 0, 168, 0, 169, 
	0, 170, 0, 171, 162, 162, 163, 0, 
	172, 0, 173, 0, 174, 159, 159, 160, 
	0, 175, 0, 176, 0, 177, 156, 156, 
	157, 0, 178, 0, 179, 0, 181, 182, 
	183, 184, 185, 186, 81, 187, 188, 180, 
	189, 189, 152, 190, 191, 192, 180, 194, 
	195, 196, 197, 5, 198, 199, 200, 193, 
	193, 37, 201, 193, 193, 181, 193, 202, 
	195, 203, 203, 5, 198, 199, 200, 193, 
	193, 193, 201, 193, 195, 203, 203, 5, 
	198, 199, 200, 193, 193, 193, 201, 193, 
	204, 193, 193, 193, 18, 205, 193, 198, 
	199, 193, 193, 193, 193, 206, 193, 204, 
	193, 207, 208, 209, 210, 5, 198, 199, 
	200, 193, 193, 35, 211, 193, 193, 204, 
	193, 212, 208, 213, 213, 5, 198, 199, 
	200, 193, 193, 193, 211, 193, 208, 213, 
	213, 5, 198, 199, 200, 193, 193, 193, 
	211, 193, 214, 193, 193, 193, 18, 215, 
	193, 198, 199, 193, 193, 193, 193, 206, 
	193, 214, 193, 216, 217, 218, 219, 5, 
	198, 199, 200, 193, 193, 33, 220, 193, 
	193, 214, 193, 221, 217, 222, 222, 5, 
	198, 199, 200, 193, 193, 193, 220, 193, 
	217, 222, 222, 5, 198, 199, 200, 193, 
	193, 193, 220, 193, 223, 193, 193, 193, 
	18, 224, 193, 198, 199, 193, 193, 193, 
	193, 206, 193, 223, 193, 225, 226, 227, 
	228, 5, 198, 199, 200, 193, 193, 31, 
	229, 193, 193, 223, 193, 230, 226, 231, 
	231, 5, 198, 199, 200, 193, 193, 193, 
	229, 193, 226, 231, 231, 5, 198, 199, 
	200, 193, 193, 193, 229, 193, 232, 193, 
	193, 193, 18, 233, 193, 198, 199, 193, 
	193, 193, 193, 206, 193, 232, 193, 234, 
	235, 236, 237, 5, 198, 199, 200, 193, 
	193, 29, 238, 193, 193, 232, 193, 239, 
	235, 240, 240, 5, 198, 199, 200, 193, 
	193, 193, 238, 193, 235, 240, 240, 5, 
	198, 199, 200, 193, 193, 193, 238, 193, 
	18, 241, 193, 198, 199, 193, 193, 193, 
	193, 206, 193, 198, 199, 193, 193, 193, 
	193, 206, 193, 242, 193, 193, 193, 199, 
	193, 199, 193, 243, 193, 244, 193, 245, 
	246, 193, 198, 199, 193, 193, 193, 3, 
	193, 193, 193, 1, 193, 2, 193, 193, 
	193, 193, 198, 199, 193, 198, 199, 193, 
	244, 193, 193, 193, 193, 198, 199, 193, 
	244, 193, 245, 193, 193, 198, 199, 193, 
	193, 193, 3, 193, 18, 193, 247, 247, 
	5, 198, 199, 193, 193, 193, 193, 206, 
	193, 248, 27, 249, 250, 8, 198, 199, 
	193, 193, 193, 193, 206, 193, 27, 249, 
	250, 8, 198, 199, 193, 193, 193, 193, 
	206, 193, 249, 249, 8, 198, 199, 193, 
	193, 193, 193, 206, 193, 251, 24, 252, 
	253, 11, 198, 199, 193, 193, 193, 193, 
	206, 193, 24, 252, 253, 11, 198, 199, 
	193, 193, 193, 193, 206, 193, 252, 252, 
	11, 198, 199, 193, 193, 193, 193, 206, 
	193, 254, 21, 255, 256, 14, 198, 199, 
	193, 193, 193, 193, 206, 193, 21, 255, 
	256, 14, 198, 199, 193, 193, 193, 193, 
	206, 193, 255, 255, 14, 198, 199, 193, 
	193, 193, 193, 206, 193, 257, 18, 193, 
	258, 193, 198, 199, 193, 193, 193, 193, 
	206, 193, 18, 193, 258, 193, 198, 199, 
	193, 193, 193, 193, 206, 193, 259, 193, 
	198, 199, 193, 193, 193, 193, 206, 193, 
	18, 193, 193, 193, 193, 198, 199, 193, 
	193, 193, 193, 206, 193, 235, 240, 240, 
	5, 198, 199, 193, 193, 193, 193, 238, 
	193, 1, 2, 193, 193, 18, 241, 193, 
	198, 199, 193, 193, 193, 193, 206, 193, 
	1, 193, 234, 235, 240, 240, 5, 198, 
	199, 200, 193, 193, 193, 238, 193, 234, 
	235, 236, 240, 5, 198, 199, 200, 193, 
	193, 29, 238, 193, 232, 193, 260, 193, 
	247, 247, 5, 198, 199, 193, 193, 193, 
	193, 206, 193, 232, 193, 232, 193, 193, 
	193, 193, 193, 193, 198, 199, 193, 193, 
	193, 193, 206, 193, 232, 193, 232, 193, 
	193, 193, 193, 261, 193, 198, 199, 193, 
	193, 193, 193, 206, 193, 232, 193, 232, 
	193, 260, 193, 193, 193, 193, 198, 199, 
	193, 193, 193, 193, 206, 193, 232, 193, 
	232, 2, 193, 193, 18, 233, 193, 198, 
	199, 193, 193, 193, 193, 206, 193, 232, 
	193, 225, 226, 231, 231, 5, 198, 199, 
	200, 193, 193, 193, 229, 193, 225, 226, 
	227, 231, 5, 198, 199, 200, 193, 193, 
	31, 229, 193, 223, 193, 262, 193, 247, 
	247, 5, 198, 199, 193, 193, 193, 193, 
	206, 193, 223, 193, 223, 193, 193, 193, 
	193, 193, 193, 198, 199, 193, 193, 193, 
	193, 206, 193, 223, 193, 223, 193, 193, 
	193, 193, 263, 193, 198, 199, 193, 193, 
	193, 193, 206, 193, 223, 193, 223, 193, 
	262, 193, 193, 193, 193, 198, 199, 193, 
	193, 193, 193, 206, 193, 223, 193, 223, 
	2, 193, 193, 18, 224, 193, 198, 199, 
	193, 193, 193, 193, 206, 193, 223, 193, 
	216, 217, 222, 222, 5, 198, 199, 200, 
	193, 193, 193, 220, 193, 216, 217, 218, 
	222, 5, 198, 199, 200, 193, 193, 33, 
	220, 193, 214, 193, 264, 193, 247, 247, 
	5, 198, 199, 193, 193, 193, 193, 206, 
	193, 214, 193, 214, 193, 193, 193, 193, 
	193, 193, 198, 199, 193, 193, 193, 193, 
	206, 193, 214, 193, 214, 193, 193, 193, 
	193, 265, 193, 198, 199, 193, 193, 193, 
	193, 206, 193, 214, 193, 214, 193, 264, 
	193, 193, 193, 193, 198, 199, 193, 193, 
	193, 193, 206, 193, 214, 193, 214, 2, 
	193, 193, 18, 215, 193, 198, 199, 193, 
	193, 193, 193, 206, 193, 214, 193, 207, 
	208, 213, 213, 5, 198, 199, 200, 193, 
	193, 193, 211, 193, 207, 208, 209, 213, 
	5, 198, 199, 200, 193, 193, 35, 211, 
	193, 204, 193, 266, 193, 247, 247, 5, 
	198, 199, 193, 193, 193, 193, 206, 193, 
	204, 193, 204, 193, 193, 193, 193, 193, 
	193, 198, 199, 193, 193, 193, 193, 206, 
	193, 204, 193, 204, 193, 193, 193, 193, 
	267, 193, 198, 199, 193, 193, 193, 193, 
	206, 193, 204, 193, 204, 193, 266, 193, 
	193, 193, 193, 198, 199, 193, 193, 193, 
	193, 206, 193, 204, 193, 204, 2, 193, 
	193, 18, 205, 193, 198, 199, 193, 193, 
	193, 193, 206, 193, 204, 193, 194, 195, 
	203, 203, 5, 198, 199, 200, 193, 193, 
	193, 201, 193, 194, 195, 196, 203, 5, 
	198, 199, 200, 193, 193, 37, 201, 193, 
	269, 270, 271, 272, 43, 273, 274, 268, 
	268, 268, 75, 275, 268, 276, 270, 277, 
	272, 43, 273, 274, 268, 268, 268, 268, 
	275, 268, 270, 277, 272, 43, 273, 274, 
	268, 268, 268, 268, 275, 268, 278, 268, 
	268, 268, 56, 279, 268, 273, 274, 268, 
	268, 268, 268, 280, 268, 278, 268, 281, 
	282, 283, 284, 43, 273, 274, 268, 268, 
	268, 73, 285, 268, 268, 278, 268, 286, 
	282, 287, 287, 43, 273, 274, 268, 268, 
	268, 268, 285, 268, 282, 287, 287, 43, 
	273, 274, 268, 268, 268, 268, 285, 268, 
	288, 268, 268, 268, 56, 289, 268, 273, 
	274, 268, 268, 268, 268, 280, 268, 288, 
	268, 290, 291, 292, 293, 43, 273, 274, 
	268, 268, 268, 71, 294, 268, 268, 288, 
	268, 295, 291, 296, 296, 43, 273, 274, 
	268, 268, 268, 268, 294, 268, 291, 296, 
	296, 43, 273, 274, 268, 268, 268, 268, 
	294, 268, 297, 268, 268, 268, 56, 298, 
	268, 273, 274, 268, 268, 268, 268, 280, 
	268, 297, 268, 299, 300, 301, 302, 43, 
	273, 274, 268, 268, 268, 69, 303, 268, 
	268, 297, 268, 304, 300, 305, 305, 43, 
	273, 274, 268, 268, 268, 268, 303, 268, 
	300, 305, 305, 43, 273, 274, 268, 268, 
	268, 268, 303, 268, 306, 268, 268, 268, 
	56, 307, 268, 273, 274, 268, 268, 268, 
	268, 280, 268, 306, 268, 308, 309, 310, 
	311, 43, 273, 274, 268, 268, 268, 67, 
	312, 268, 268, 306, 268, 313, 309, 314, 
	314, 43, 273, 274, 268, 268, 268, 268, 
	312, 268, 309, 314, 314, 43, 273, 274, 
	268, 268, 268, 268, 312, 268, 56, 315, 
	268, 273, 274, 268, 268, 268, 268, 280, 
	268, 273, 274, 268, 268, 268, 268, 280, 
	268, 316, 268, 268, 268, 274, 268, 274, 
	268, 317, 268, 318, 268, 319, 320, 268, 
	273, 274, 268, 268, 268, 41, 268, 268, 
	268, 39, 268, 40, 268, 268, 268, 268, 
	273, 274, 268, 273, 274, 268, 318, 268, 
	268, 268, 268, 273, 274, 268, 318, 268, 
	319, 268, 268, 273, 274, 268, 268, 268, 
	41, 268, 56, 268, 321, 321, 43, 273, 
	274, 268, 268, 268, 268, 280, 268, 322, 
	65, 323, 324, 46, 273, 274, 268, 268, 
	268, 268, 280, 268, 65, 323, 324, 46, 
	273, 274, 268, 268, 268, 268, 280, 268, 
	323, 323, 46, 273, 274, 268, 268, 268, 
	268, 280, 268, 325, 62, 326, 327, 49, 
	273, 274, 268, 268, 268, 268, 280, 268, 
	62, 326, 327, 49, 273, 274, 268, 268, 
	268, 268, 280, 268, 326, 326, 49, 273, 
	274, 268, 268, 268, 268, 280, 268, 328, 
	59, 329, 330, 52, 273, 274, 268, 268, 
	268, 268, 280, 268, 59, 329, 330, 52, 
	273, 274, 268, 268, 268, 268, 280, 268, 
	329, 329, 52, 273, 274, 268, 268, 268, 
	268, 280, 268, 331, 56, 268, 332, 268, 
	273, 274, 268, 268, 268, 268, 280, 268, 
	56, 268, 332, 268, 273, 274, 268, 268, 
	268, 268, 280, 268, 333, 268, 273, 274, 
	268, 268, 268, 268, 280, 268, 56, 268, 
	268, 268, 268, 273, 274, 268, 268, 268, 
	268, 280, 268, 39, 40, 268, 268, 56, 
	315, 268, 273, 274, 268, 268, 268, 268, 
	280, 268, 39, 268, 308, 309, 314, 314, 
	43, 273, 274, 268, 268, 268, 268, 312, 
	268, 308, 309, 310, 314, 43, 273, 274, 
	268, 268, 268, 67, 312, 268, 306, 268, 
	334, 268, 321, 321, 43, 273, 274, 268, 
	268, 268, 268, 280, 268, 306, 268, 306, 
	268, 268, 268, 268, 268, 268, 273, 274, 
	268, 268, 268, 268, 280, 268, 306, 268, 
	306, 268, 268, 268, 268, 335, 268, 273, 
	274, 268, 268, 268, 268, 280, 268, 306, 
	268, 306, 268, 334, 268, 268, 268, 268, 
	273, 274, 268, 268, 268, 268, 280, 268, 
	306, 268, 306, 40, 268, 268, 56, 307, 
	268, 273, 274, 268, 268, 268, 268, 280, 
	268, 306, 268, 299, 300, 305, 305, 43, 
	273, 274, 268, 268, 268, 268, 303, 268, 
	299, 300, 301, 305, 43, 273, 274, 268, 
	268, 268, 69, 303, 268, 297, 268, 336, 
	268, 321, 321, 43, 273, 274, 268, 268, 
	268, 268, 280, 268, 297, 268, 297, 268, 
	268, 268, 268, 268, 268, 273, 274, 268, 
	268, 268, 268, 280, 268, 297, 268, 297, 
	268, 268, 268, 268, 337, 268, 273, 274, 
	268, 268, 268, 268, 280, 268, 297, 268, 
	297, 268, 336, 268, 268, 268, 268, 273, 
	274, 268, 268, 268, 268, 280, 268, 297, 
	268, 297, 40, 268, 268, 56, 298, 268, 
	273, 274, 268, 268, 268, 268, 280, 268, 
	297, 268, 290, 291, 296, 296, 43, 273, 
	274, 268, 268, 268, 268, 294, 268, 290, 
	291, 292, 296, 43, 273, 274, 268, 268, 
	268, 71, 294, 268, 288, 268, 338, 268, 
	321, 321, 43, 273, 274, 268, 268, 268, 
	268, 280, 268, 288, 268, 288, 268, 268, 
	268, 268, 268, 268, 273, 274, 268, 268, 
	268, 268, 280, 268, 288, 268, 288, 268, 
	268, 268, 268, 339, 268, 273, 274, 268, 
	268, 268, 268, 280, 268, 288, 268, 288, 
	268, 338, 268, 268, 268, 268, 273, 274, 
	268, 268, 268, 268, 280, 268, 288, 268, 
	288, 40, 268, 268, 56, 289, 268, 273, 
	274, 268, 268, 268, 268, 280, 268, 288, 
	268, 281, 282, 287, 287, 43, 273, 274, 
	268, 268, 268, 268, 285, 268, 281, 282, 
	283, 287, 43, 273, 274, 268, 268, 268, 
	73, 285, 268, 278, 268, 340, 268, 321, 
	321, 43, 273, 274, 268, 268, 268, 268, 
	280, 268, 278, 268, 278, 268, 268, 268, 
	268, 268, 268, 273, 274, 268, 268, 268, 
	268, 280, 268, 278, 268, 278, 268, 268, 
	268, 268, 341, 268, 273, 274, 268, 268, 
	268, 268, 280, 268, 278, 268, 278, 268, 
	340, 268, 268, 268, 268, 273, 274, 268, 
	268, 268, 268, 280, 268, 278, 268, 74, 
	42, 42, 43, 268, 268, 268, 268, 268, 
	268, 74, 268, 278, 40, 268, 268, 56, 
	279, 268, 273, 274, 268, 268, 268, 268, 
	280, 268, 278, 268, 269, 270, 277, 272, 
	43, 273, 274, 268, 268, 268, 268, 275, 
	268, 343, 184, 344, 344, 81, 187, 188, 
	342, 342, 342, 342, 190, 342, 184, 344, 
	344, 81, 187, 188, 342, 342, 342, 342, 
	190, 342, 345, 342, 342, 342, 95, 346, 
	342, 187, 188, 342, 342, 342, 342, 347, 
	342, 345, 342, 348, 349, 350, 351, 81, 
	187, 188, 342, 342, 342, 112, 352, 342, 
	342, 345, 342, 353, 349, 354, 354, 81, 
	187, 188, 342, 342, 342, 342, 352, 342, 
	349, 354, 354, 81, 187, 188, 342, 342, 
	342, 342, 352, 342, 355, 342, 342, 342, 
	95, 356, 342, 187, 188, 342, 342, 342, 
	342, 347, 342, 355, 342, 357, 358, 359, 
	360, 81, 187, 188, 342, 342, 342, 110, 
	361, 342, 342, 355, 342, 362, 358, 363, 
	363, 81, 187, 188, 342, 342, 342, 342, 
	361, 342, 358, 363, 363, 81, 187, 188, 
	342, 342, 342, 342, 361, 342, 364, 342, 
	342, 342, 95, 365, 342, 187, 188, 342, 
	342, 342, 342, 347, 342, 364, 342, 366, 
	367, 368, 369, 81, 187, 188, 342, 342, 
	342, 108, 370, 342, 342, 364, 342, 371, 
	367, 372, 372, 81, 187, 188, 342, 342, 
	342, 342, 370, 342, 367, 372, 372, 81, 
	187, 188, 342, 342, 342, 342, 370, 342, 
	373, 342, 342, 342, 95, 374, 342, 187, 
	188, 342, 342, 342, 342, 347, 342, 373, 
	342, 375, 376, 377, 378, 81, 187, 188, 
	342, 342, 342, 106, 379, 342, 342, 373, 
	342, 380, 376, 381, 381, 81, 187, 188, 
	342, 342, 342, 342, 379, 342, 376, 381, 
	381, 81, 187, 188, 342, 342, 342, 342, 
	379, 342, 95, 382, 342, 187, 188, 342, 
	342, 342, 342, 347, 342, 187, 188, 342, 
	342, 342, 342, 347, 342, 383, 342, 342, 
	342, 188, 342, 188, 342, 384, 342, 385, 
	342, 386, 387, 342, 187, 188, 342, 342, 
	342, 79, 342, 342, 342, 77, 342, 78, 
	342, 342, 342, 342, 187, 188, 342, 187, 
	188, 342, 385, 342, 342, 342, 342, 187, 
	188, 342, 385, 342, 386, 342, 342, 187, 
	188, 342, 342, 342, 79, 342, 95, 342, 
	388, 388, 81, 187, 188, 342, 342, 342, 
	342, 347, 342, 389, 104, 390, 391, 85, 
	187, 188, 342, 342, 342, 342, 347, 342, 
	104, 390, 391, 85, 187, 188, 342, 342, 
	342, 342, 347, 342, 390, 390, 85, 187, 
	188, 342, 342, 342, 342, 347, 342, 392, 
	101, 393, 394, 88, 187, 188, 342, 342, 
	342, 342, 347, 342, 101, 393, 394, 88, 
	187, 188, 342, 342, 342, 342, 347, 342, 
	393, 393, 88, 187, 188, 342, 342, 342, 
	342, 347, 342, 395, 98, 396, 397, 91, 
	187, 188, 342, 342, 342, 342, 347, 342, 
	98, 396, 397, 91, 187, 188, 342, 342, 
	342, 342, 347, 342, 396, 396, 91, 187, 
	188, 342, 342, 342, 342, 347, 342, 398, 
	95, 342, 399, 342, 187, 188, 342, 342, 
	342, 342, 347, 342, 95, 342, 399, 342, 
	187, 188, 342, 342, 342, 342, 347, 342, 
	400, 342, 187, 188, 342, 342, 342, 342, 
	347, 342, 95, 342, 342, 342, 342, 187, 
	188, 342, 342, 342, 342, 347, 342, 77, 
	78, 342, 342, 95, 382, 342, 187, 188, 
	342, 342, 342, 342, 347, 342, 77, 342, 
	375, 376, 381, 381, 81, 187, 188, 342, 
	342, 342, 342, 379, 342, 375, 376, 377, 
	381, 81, 187, 188, 342, 342, 342, 106, 
	379, 342, 373, 342, 401, 342, 388, 388, 
	81, 187, 188, 342, 342, 342, 342, 347, 
	342, 373, 342, 373, 342, 342, 342, 342, 
	342, 342, 187, 188, 342, 342, 342, 342, 
	347, 342, 373, 342, 373, 342, 342, 342, 
	342, 402, 342, 187, 188, 342, 342, 342, 
	342, 347, 342, 373, 342, 373, 342, 401, 
	342, 342, 342, 342, 187, 188, 342, 342, 
	342, 342, 347, 342, 373, 342, 373, 78, 
	342, 342, 95, 374, 342, 187, 188, 342, 
	342, 342, 342, 347, 342, 373, 342, 366, 
	367, 372, 372, 81, 187, 188, 342, 342, 
	342, 342, 370, 342, 366, 367, 368, 372, 
	81, 187, 188, 342, 342, 342, 108, 370, 
	342, 364, 342, 403, 342, 388, 388, 81, 
	187, 188, 342, 342, 342, 342, 347, 342, 
	364, 342, 364, 342, 342, 342, 342, 342, 
	342, 187, 188, 342, 342, 342, 342, 347, 
	342, 364, 342, 364, 342, 342, 342, 342, 
	404, 342, 187, 188, 342, 342, 342, 342, 
	347, 342, 364, 342, 364, 342, 403, 342, 
	342, 342, 342, 187, 188, 342, 342, 342, 
	342, 347, 342, 364, 342, 364, 78, 342, 
	342, 95, 365, 342, 187, 188, 342, 342, 
	342, 342, 347, 342, 364, 342, 357, 358, 
	363, 363, 81, 187, 188, 342, 342, 342, 
	342, 361, 342, 357, 358, 359, 363, 81, 
	187, 188, 342, 342, 342, 110, 361, 342, 
	355, 342, 405, 342, 388, 388, 81, 187, 
	188, 342, 342, 342, 342, 347, 342, 355, 
	342, 355, 342, 342, 342, 342, 342, 342, 
	187, 188, 342, 342, 342, 342, 347, 342, 
	355, 342, 355, 342, 342, 342, 342, 406, 
	342, 187, 188, 342, 342, 342, 342, 347, 
	342, 355, 342, 355, 342, 405, 342, 342, 
	342, 342, 187, 188, 342, 342, 342, 342, 
	347, 342, 355, 342, 355, 78, 342, 342, 
	95, 356, 342, 187, 188, 342, 342, 342, 
	342, 347, 342, 355, 342, 348, 349, 354, 
	354, 81, 187, 188, 342, 342, 342, 342, 
	352, 342, 348, 349, 350, 354, 81, 187, 
	188, 342, 342, 342, 112, 352, 342, 345, 
	342, 407, 342, 388, 388, 81, 187, 188, 
	342, 342, 342, 342, 347, 342, 345, 342, 
	345, 342, 342, 342, 342, 342, 342, 187, 
	188, 342, 342, 342, 342, 347, 342, 345, 
	342, 345, 342, 342, 342, 342, 408, 342, 
	187, 188, 342, 342, 342, 342, 347, 342, 
	345, 342, 345, 342, 407, 342, 342, 342, 
	342, 187, 188, 342, 342, 342, 342, 347, 
	342, 345, 342, 345, 78, 342, 342, 95, 
	346, 342, 187, 188, 342, 342, 342, 342, 
	347, 342, 345, 342, 113, 80, 80, 81, 
	409, 409, 409, 409, 409, 152, 113, 409, 
	183, 184, 344, 344, 81, 187, 188, 342, 
	342, 342, 342, 190, 342, 113, 80, 80, 
	81, 409, 409, 409, 409, 409, 409, 113, 
	409, 411, 412, 413, 414, 119, 415, 416, 
	410, 410, 410, 151, 417, 410, 418, 412, 
	414, 414, 119, 415, 416, 410, 410, 410, 
	410, 417, 410, 412, 414, 414, 119, 415, 
	416, 410, 410, 410, 410, 417, 410, 419, 
	410, 410, 410, 132, 420, 410, 415, 416, 
	410, 410, 410, 410, 421, 410, 419, 410, 
	422, 423, 424, 425, 119, 415, 416, 410, 
	410, 410, 149, 426, 410, 410, 419, 410, 
	427, 423, 428, 428, 119, 415, 416, 410, 
	410, 410, 410, 426, 410, 423, 428, 428, 
	119, 415, 416, 410, 410, 410, 410, 426, 
	410, 429, 410, 410, 410, 132, 430, 410, 
	415, 416, 410, 410, 410, 410, 421, 410, 
	429, 410, 431, 432, 433, 434, 119, 415, 
	416, 410, 410, 410, 147, 435, 410, 410, 
	429, 410, 436, 432, 437, 437, 119, 415, 
	416, 410, 410, 410, 410, 435, 410, 432, 
	437, 437, 119, 415, 416, 410, 410, 410, 
	410, 435, 410, 438, 410, 410, 410, 132, 
	439, 410, 415, 416, 410, 410, 410, 410, 
	421, 410, 438, 410, 440, 441, 442, 443, 
	119, 415, 416, 410, 410, 410, 145, 444, 
	410, 410, 438, 410, 445, 441, 446, 446, 
	119, 415, 416, 410, 410, 410, 410, 444, 
	410, 441, 446, 446, 119, 415, 416, 410, 
	410, 410, 410, 444, 410, 447, 410, 410, 
	410, 132, 448, 410, 415, 416, 410, 410, 
	410, 410, 421, 410, 447, 410, 449, 450, 
	451, 452, 119, 415, 416, 410, 410, 410, 
	143, 453, 410, 410, 447, 410, 454, 450, 
	455, 455, 119, 415, 416, 410, 410, 410, 
	410, 453, 410, 450, 455, 455, 119, 415, 
	416, 410, 410, 410, 410, 453, 410, 132, 
	456, 410, 415, 416, 410, 410, 410, 410, 
	421, 410, 415, 416, 410, 410, 410, 410, 
	421, 410, 457, 410, 410, 410, 416, 410, 
	416, 410, 458, 410, 459, 410, 460, 461, 
	410, 415, 416, 410, 410, 410, 117, 410, 
	410, 410, 115, 410, 116, 410, 410, 410, 
	410, 415, 416, 410, 415, 416, 410, 459, 
	410, 410, 410, 410, 415, 416, 410, 459, 
	410, 460, 410, 410, 415, 416, 410, 410, 
	410, 117, 410, 132, 410, 462, 462, 119, 
	415, 416, 410, 410, 410, 410, 421, 410, 
	463, 141, 464, 465, 122, 415, 416, 410, 
	410, 410, 410, 421, 410, 141, 464, 465, 
	122, 415, 416, 410, 410, 410, 410, 421, 
	410, 464, 464, 122, 415, 416, 410, 410, 
	410, 410, 421, 410, 466, 138, 467, 468, 
	125, 415, 416, 410, 410, 410, 410, 421, 
	410, 138, 467, 468, 125, 415, 416, 410, 
	410, 410, 410, 421, 410, 467, 467, 125, 
	415, 416, 410, 410, 410, 410, 421, 410, 
	469, 135, 470, 471, 128, 415, 416, 410, 
	410, 410, 410, 421, 410, 135, 470, 471, 
	128, 415, 416, 410, 410, 410, 410, 421, 
	410, 470, 470, 128, 415, 416, 410, 410, 
	410, 410, 421, 410, 472, 132, 410, 473, 
	410, 415, 416, 410, 410, 410, 410, 421, 
	410, 132, 410, 473, 410, 415, 416, 410, 
	410, 410, 410, 421, 410, 474, 410, 415, 
	416, 410, 410, 410, 410, 421, 410, 132, 
	410, 410, 410, 410, 415, 416, 410, 410, 
	410, 410, 421, 410, 115, 116, 410, 410, 
	132, 456, 410, 415, 416, 410, 410, 410, 
	410, 421, 410, 115, 410, 449, 450, 455, 
	455, 119, 415, 416, 410, 410, 410, 410, 
	453, 410, 449, 450, 451, 455, 119, 415, 
	416, 410, 410, 410, 143, 453, 410, 447, 
	410, 475, 410, 462, 462, 119, 415, 416, 
	410, 410, 410, 410, 421, 410, 447, 410, 
	447, 410, 410, 410, 410, 410, 410, 415, 
	416, 410, 410, 410, 410, 421, 410, 447, 
	410, 447, 410, 410, 410, 410, 476, 410, 
	415, 416, 410, 410, 410, 410, 421, 410, 
	447, 410, 447, 410, 475, 410, 410, 410, 
	410, 415, 416, 410, 410, 410, 410, 421, 
	410, 447, 410, 447, 116, 410, 410, 132, 
	448, 410, 415, 416, 410, 410, 410, 410, 
	421, 410, 447, 410, 440, 441, 446, 446, 
	119, 415, 416, 410, 410, 410, 410, 444, 
	410, 440, 441, 442, 446, 119, 415, 416, 
	410, 410, 410, 145, 444, 410, 438, 410, 
	477, 410, 462, 462, 119, 415, 416, 410, 
	410, 410, 410, 421, 410, 438, 410, 438, 
	410, 410, 410, 410, 410, 410, 415, 416, 
	410, 410, 410, 410, 421, 410, 438, 410, 
	438, 410, 410, 410, 410, 478, 410, 415, 
	416, 410, 410, 410, 410, 421, 410, 438, 
	410, 438, 410, 477, 410, 410, 410, 410, 
	415, 416, 410, 410, 410, 410, 421, 410, 
	438, 410, 438, 116, 410, 410, 132, 439, 
	410, 415, 416, 410, 410, 410, 410, 421, 
	410, 438, 410, 431, 432, 437, 437, 119, 
	415, 416, 410, 410, 410, 410, 435, 410, 
	431, 432, 433, 437, 119, 415, 416, 410, 
	410, 410, 147, 435, 410, 429, 410, 479, 
	410, 462, 462, 119, 415, 416, 410, 410, 
	410, 410, 421, 410, 429, 410, 429, 410, 
	410, 410, 410, 410, 410, 415, 416, 410, 
	410, 410, 410, 421, 410, 429, 410, 429, 
	410, 410, 410, 410, 480, 410, 415, 416, 
	410, 410, 410, 410, 421, 410, 429, 410, 
	429, 410, 479, 410, 410, 410, 410, 415, 
	416, 410, 410, 410, 410, 421, 410, 429, 
	410, 429, 116, 410, 410, 132, 430, 410, 
	415, 416, 410, 410, 410, 410, 421, 410, 
	429, 410, 422, 423, 428, 428, 119, 415, 
	416, 410, 410, 410, 410, 426, 410, 422, 
	423, 424, 428, 119, 415, 416, 410, 410, 
	410, 149, 426, 410, 419, 410, 481, 410, 
	462, 462, 119, 415, 416, 410, 410, 410, 
	410, 421, 410, 419, 410, 419, 410, 410, 
	410, 410, 410, 410, 415, 416, 410, 410, 
	410, 410, 421, 410, 419, 410, 419, 410, 
	410, 410, 410, 482, 410, 415, 416, 410, 
	410, 410, 410, 421, 410, 419, 410, 419, 
	410, 481, 410, 410, 410, 410, 415, 416, 
	410, 410, 410, 410, 421, 410, 419, 410, 
	419, 116, 410, 410, 132, 420, 410, 415, 
	416, 410, 410, 410, 410, 421, 410, 419, 
	410, 411, 412, 414, 414, 119, 415, 416, 
	410, 410, 410, 410, 417, 410, 181, 182, 
	183, 184, 483, 344, 81, 187, 188, 342, 
	189, 189, 152, 190, 342, 181, 342, 194, 
	484, 196, 197, 5, 198, 199, 200, 193, 
	193, 37, 201, 193, 193, 181, 193, 204, 
	182, 183, 184, 485, 486, 81, 487, 488, 
	193, 189, 189, 152, 489, 193, 204, 193, 
	113, 80, 80, 81, 198, 199, 193, 193, 
	193, 152, 490, 193, 491, 2, 342, 342, 
	342, 408, 342, 187, 188, 342, 342, 342, 
	342, 347, 342, 491, 342, 492, 349, 493, 
	494, 81, 487, 488, 193, 193, 193, 153, 
	352, 193, 193, 491, 193, 495, 349, 354, 
	354, 81, 487, 488, 193, 193, 193, 193, 
	352, 193, 349, 354, 354, 81, 487, 488, 
	193, 193, 193, 193, 352, 193, 496, 193, 
	193, 193, 488, 193, 488, 193, 243, 193, 
	492, 349, 354, 354, 81, 487, 488, 193, 
	193, 193, 193, 352, 193, 492, 349, 493, 
	354, 81, 487, 488, 193, 193, 193, 153, 
	352, 193, 204, 193, 266, 113, 497, 497, 
	155, 198, 199, 193, 193, 193, 193, 490, 
	193, 204, 193, 498, 179, 499, 500, 157, 
	487, 488, 193, 193, 193, 193, 501, 193, 
	179, 499, 500, 157, 487, 488, 193, 193, 
	193, 193, 501, 193, 499, 499, 157, 487, 
	488, 193, 193, 193, 193, 501, 193, 502, 
	176, 503, 504, 160, 487, 488, 193, 193, 
	193, 193, 501, 193, 176, 503, 504, 160, 
	487, 488, 193, 193, 193, 193, 501, 193, 
	503, 503, 160, 487, 488, 193, 193, 193, 
	193, 501, 193, 505, 173, 506, 507, 163, 
	487, 488, 193, 193, 193, 193, 501, 193, 
	173, 506, 507, 163, 487, 488, 193, 193, 
	193, 193, 501, 193, 506, 506, 163, 487, 
	488, 193, 193, 193, 193, 501, 193, 508, 
	170, 193, 509, 193, 487, 488, 193, 193, 
	193, 193, 501, 193, 170, 193, 509, 193, 
	487, 488, 193, 193, 193, 193, 501, 193, 
	487, 488, 193, 193, 193, 193, 501, 193, 
	510, 193, 511, 512, 193, 487, 488, 193, 
	193, 193, 167, 193, 193, 193, 165, 193, 
	166, 193, 193, 193, 193, 487, 488, 193, 
	487, 488, 193, 510, 193, 193, 193, 193, 
	487, 488, 193, 510, 193, 511, 193, 193, 
	487, 488, 193, 193, 193, 167, 193, 491, 
	166, 342, 342, 95, 346, 342, 187, 188, 
	342, 342, 342, 342, 347, 342, 491, 342, 
	0
};

static const short _indic_syllable_machine_trans_targs[] = {
	170, 195, 197, 198, 3, 201, 4, 6, 
	204, 7, 9, 207, 10, 12, 210, 13, 
	15, 16, 191, 18, 19, 209, 21, 22, 
	206, 24, 25, 203, 212, 216, 220, 223, 
	227, 230, 234, 237, 241, 244, 170, 270, 
	272, 273, 39, 276, 40, 42, 279, 43, 
	45, 282, 46, 48, 285, 49, 51, 52, 
	266, 54, 55, 284, 57, 58, 281, 60, 
	61, 278, 287, 290, 294, 297, 301, 304, 
	308, 311, 315, 319, 170, 343, 345, 346, 
	75, 349, 170, 76, 78, 352, 79, 81, 
	355, 82, 84, 358, 85, 87, 88, 339, 
	90, 91, 357, 93, 94, 354, 96, 97, 
	351, 360, 363, 367, 370, 374, 377, 381, 
	384, 388, 170, 418, 420, 421, 110, 424, 
	111, 113, 427, 114, 116, 430, 117, 119, 
	433, 120, 122, 123, 414, 125, 126, 432, 
	128, 129, 429, 131, 132, 426, 435, 438, 
	442, 445, 449, 452, 456, 459, 463, 466, 
	392, 478, 146, 481, 148, 484, 149, 151, 
	487, 152, 154, 490, 155, 493, 495, 496, 
	159, 160, 492, 162, 163, 489, 165, 166, 
	486, 168, 169, 483, 170, 171, 246, 320, 
	322, 391, 393, 340, 342, 394, 390, 467, 
	468, 170, 172, 174, 35, 245, 192, 194, 
	214, 243, 173, 34, 175, 239, 0, 176, 
	178, 33, 238, 236, 177, 32, 179, 232, 
	180, 182, 31, 231, 229, 181, 30, 183, 
	225, 184, 186, 29, 224, 222, 185, 28, 
	187, 218, 188, 190, 27, 217, 215, 189, 
	26, 200, 193, 170, 196, 1, 199, 2, 
	202, 5, 23, 205, 8, 20, 208, 11, 
	17, 211, 14, 213, 219, 221, 226, 228, 
	233, 235, 240, 242, 170, 247, 249, 71, 
	317, 267, 269, 318, 248, 70, 250, 313, 
	36, 251, 253, 69, 312, 310, 252, 68, 
	254, 306, 255, 257, 67, 305, 303, 256, 
	66, 258, 299, 259, 261, 65, 298, 296, 
	260, 64, 262, 292, 263, 265, 63, 291, 
	289, 264, 62, 275, 268, 170, 271, 37, 
	274, 38, 277, 41, 59, 280, 44, 56, 
	283, 47, 53, 286, 50, 288, 293, 295, 
	300, 302, 307, 309, 314, 316, 170, 321, 
	106, 323, 386, 72, 324, 326, 105, 385, 
	383, 325, 104, 327, 379, 328, 330, 103, 
	378, 376, 329, 102, 331, 372, 332, 334, 
	101, 371, 369, 333, 100, 335, 365, 336, 
	338, 99, 364, 362, 337, 98, 348, 341, 
	170, 344, 73, 347, 74, 350, 77, 95, 
	353, 80, 92, 356, 83, 89, 359, 86, 
	361, 366, 368, 373, 375, 380, 382, 387, 
	389, 170, 170, 395, 397, 142, 141, 415, 
	417, 465, 396, 398, 461, 107, 399, 401, 
	140, 460, 458, 400, 139, 402, 454, 403, 
	405, 138, 453, 451, 404, 137, 406, 447, 
	407, 409, 136, 446, 444, 408, 135, 410, 
	440, 411, 413, 134, 439, 437, 412, 133, 
	423, 416, 170, 419, 108, 422, 109, 425, 
	112, 130, 428, 115, 127, 431, 118, 124, 
	434, 121, 436, 441, 443, 448, 450, 455, 
	457, 462, 464, 143, 469, 470, 480, 475, 
	477, 498, 471, 472, 473, 144, 479, 474, 
	476, 145, 482, 147, 167, 156, 485, 150, 
	164, 488, 153, 161, 491, 158, 494, 157, 
	497
};

static const char _indic_syllable_machine_trans_actions[] = {
	1, 2, 0, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	0, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 4, 2, 0, 0, 
	0, 2, 5, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 2, 6, 2, 6, 2, 6, 2, 
	6, 2, 7, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	6, 8, 0, 2, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 2, 0, 0, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 11, 2, 2, 6, 
	2, 12, 12, 0, 0, 2, 2, 6, 
	2, 13, 2, 2, 0, 2, 0, 0, 
	2, 2, 2, 0, 2, 2, 0, 2, 
	2, 0, 2, 2, 2, 0, 2, 2, 
	2, 2, 0, 2, 2, 2, 0, 2, 
	2, 2, 2, 0, 2, 2, 2, 0, 
	2, 2, 2, 2, 0, 2, 2, 2, 
	0, 2, 0, 14, 0, 0, 2, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 15, 2, 2, 0, 
	2, 0, 0, 2, 2, 0, 2, 2, 
	0, 2, 2, 0, 2, 2, 2, 0, 
	2, 2, 2, 2, 0, 2, 2, 2, 
	0, 2, 2, 2, 2, 0, 2, 2, 
	2, 0, 2, 2, 2, 2, 0, 2, 
	2, 2, 0, 2, 0, 16, 0, 0, 
	2, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 17, 6, 
	0, 6, 6, 0, 6, 2, 0, 6, 
	2, 6, 0, 6, 6, 6, 2, 0, 
	6, 2, 6, 0, 6, 6, 6, 2, 
	0, 6, 2, 6, 0, 6, 6, 6, 
	2, 0, 6, 2, 6, 0, 6, 0, 
	18, 0, 0, 2, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 19, 20, 2, 2, 0, 0, 0, 
	0, 2, 2, 2, 2, 0, 2, 2, 
	0, 2, 2, 2, 0, 2, 2, 2, 
	2, 0, 2, 2, 2, 0, 2, 2, 
	2, 2, 0, 2, 2, 2, 0, 2, 
	2, 2, 2, 0, 2, 2, 2, 0, 
	2, 0, 21, 0, 0, 2, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 0, 0, 8, 2, 0, 
	0, 2, 2, 8, 8, 0, 8, 8, 
	0, 0, 2, 0, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 0, 
	2
};

static const char _indic_syllable_machine_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 9, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0
};

static const char _indic_syllable_machine_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 10, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0
};

static const short _indic_syllable_machine_eof_trans[] = {
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	77, 77, 77, 83, 83, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	83, 77, 77, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 77, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 0, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 410, 
	343, 410, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 343, 194, 194, 194, 343, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 343
};

static const int indic_syllable_machine_start = 170;
static const int indic_syllable_machine_first_final = 170;
static const int indic_syllable_machine_error = -1;

static const int indic_syllable_machine_en_main = 170;


#line 36 "../../src/hb-ot-shape-complex-indic-machine.rl"



#line 91 "../../src/hb-ot-shape-complex-indic-machine.rl"


#define found_syllable(syllable_type) \
  HB_STMT_START { \
    if (0) fprintf (stderr, "syllable %d..%d %s\n", last, p+1, #syllable_type); \
    for (unsigned int i = last; i < p+1; i++) \
      info[i].syllable() = (syllable_serial << 4) | syllable_type; \
    last = p+1; \
    syllable_serial++; \
    if (unlikely (syllable_serial == 16)) syllable_serial = 1; \
  } HB_STMT_END

static void
find_syllables (hb_buffer_t *buffer)
{
  unsigned int p, pe, eof, ts HB_UNUSED, te, act;
  int cs;
  hb_glyph_info_t *info = buffer->info;
  
#line 1273 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	{
	cs = indic_syllable_machine_start;
	ts = 0;
	te = 0;
	act = 0;
	}

#line 112 "../../src/hb-ot-shape-complex-indic-machine.rl"


  p = 0;
  pe = eof = buffer->len;

  unsigned int last = 0;
  unsigned int syllable_serial = 1;
  
#line 1290 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	{
	int _slen;
	int _trans;
	const unsigned char *_keys;
	const short *_inds;
	if ( p == pe )
		goto _test_eof;
_resume:
	switch ( _indic_syllable_machine_from_state_actions[cs] ) {
	case 10:
#line 1 "NONE"
	{ts = p;}
	break;
#line 1304 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	}

	_keys = _indic_syllable_machine_trans_keys + (cs<<1);
	_inds = _indic_syllable_machine_indicies + _indic_syllable_machine_index_offsets[cs];

	_slen = _indic_syllable_machine_key_spans[cs];
	_trans = _inds[ _slen > 0 && _keys[0] <=( info[p].indic_category()) &&
		( info[p].indic_category()) <= _keys[1] ?
		( info[p].indic_category()) - _keys[0] : _slen ];

_eof_trans:
	cs = _indic_syllable_machine_trans_targs[_trans];

	if ( _indic_syllable_machine_trans_actions[_trans] == 0 )
		goto _again;

	switch ( _indic_syllable_machine_trans_actions[_trans] ) {
	case 2:
#line 1 "NONE"
	{te = p+1;}
	break;
	case 14:
#line 83 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (consonant_syllable); }}
	break;
	case 16:
#line 84 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (vowel_syllable); }}
	break;
	case 21:
#line 85 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (standalone_cluster); }}
	break;
	case 18:
#line 86 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (broken_cluster); }}
	break;
	case 11:
#line 87 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (non_indic_cluster); }}
	break;
	case 13:
#line 83 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (consonant_syllable); }}
	break;
	case 15:
#line 84 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (vowel_syllable); }}
	break;
	case 20:
#line 85 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (standalone_cluster); }}
	break;
	case 17:
#line 86 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (broken_cluster); }}
	break;
	case 19:
#line 87 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (non_indic_cluster); }}
	break;
	case 1:
#line 83 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (consonant_syllable); }}
	break;
	case 3:
#line 84 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (vowel_syllable); }}
	break;
	case 7:
#line 85 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (standalone_cluster); }}
	break;
	case 4:
#line 86 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (broken_cluster); }}
	break;
	case 5:
#line 1 "NONE"
	{	switch( act ) {
	case 1:
	{{p = ((te))-1;} found_syllable (consonant_syllable); }
	break;
	case 4:
	{{p = ((te))-1;} found_syllable (broken_cluster); }
	break;
	case 5:
	{{p = ((te))-1;} found_syllable (non_indic_cluster); }
	break;
	}
	}
	break;
	case 8:
#line 1 "NONE"
	{te = p+1;}
#line 83 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{act = 1;}
	break;
	case 6:
#line 1 "NONE"
	{te = p+1;}
#line 86 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{act = 4;}
	break;
	case 12:
#line 1 "NONE"
	{te = p+1;}
#line 87 "../../src/hb-ot-shape-complex-indic-machine.rl"
	{act = 5;}
	break;
#line 1415 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	}

_again:
	switch ( _indic_syllable_machine_to_state_actions[cs] ) {
	case 9:
#line 1 "NONE"
	{ts = 0;}
	break;
#line 1424 "../../src/hb-ot-shape-complex-indic-machine.hh.tmp"
	}

	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	if ( _indic_syllable_machine_eof_trans[cs] > 0 ) {
		_trans = _indic_syllable_machine_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	}

#line 121 "../../src/hb-ot-shape-complex-indic-machine.rl"

}

#endif /* HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH */
