/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.BoxInfo;
import org.jmol.util.Quadric;
import org.jmol.util.SimpleUnitCell;

class UnitCell
extends SimpleUnitCell {
    private Point3f[] vertices;
    private Point3f cartesianOffset = new Point3f();
    private Point3f fractionalOffset = new Point3f();
    static final double twoP2 = 19.739208802178716;

    UnitCell(float[] fArray) {
        super(fArray);
        this.calcUnitcellVertices();
    }

    private final void toFractionalUnitCell(Point3f point3f) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        this.matrixCartesianToFractional.transform(point3f);
        point3f.x = UnitCell.toFractional(point3f.x);
        point3f.y = UnitCell.toFractional(point3f.y);
        point3f.z = UnitCell.toFractional(point3f.z);
    }

    private static float toFractional(float f) {
        if ((f = (float)((double)f - Math.floor(f))) > 0.9999f || f < 1.0E-4f) {
            f = 0.0f;
        }
        return f;
    }

    final void toUnitCell(Point3f point3f, Point3f point3f2) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        this.toFractionalUnitCell(point3f);
        if (point3f2 != null) {
            point3f.add(point3f2);
        }
        this.matrixFractionalToCartesian.transform(point3f);
    }

    void setOffset(Point3f point3f) {
        this.fractionalOffset.set(point3f);
        this.matrixCartesianToFractional.m03 = -point3f.x;
        this.matrixCartesianToFractional.m13 = -point3f.y;
        this.matrixCartesianToFractional.m23 = -point3f.z;
        this.cartesianOffset.set(point3f);
        this.matrixFractionalToCartesian.m03 = 0.0f;
        this.matrixFractionalToCartesian.m13 = 0.0f;
        this.matrixFractionalToCartesian.m23 = 0.0f;
        this.matrixFractionalToCartesian.transform(this.cartesianOffset);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
    }

    void setOffset(int n) {
        this.setOffset(UnitCell.ijkToPoint3f(n));
    }

    static Point3f ijkToPoint3f(int n) {
        Point3f point3f = new Point3f();
        point3f.x = n / 100 - 5;
        point3f.y = n % 100 / 10 - 5;
        point3f.z = n % 10 - 5;
        return point3f;
    }

    final String dumpInfo(boolean bl) {
        return "a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", alpha=" + this.alpha + ", beta=" + this.beta + ", gamma=" + this.gamma + (bl ? "\nfractional to cartesian: " + this.matrixFractionalToCartesian + "\ncartesian to fractional: " + this.matrixCartesianToFractional : "");
    }

    Point3f[] getVertices() {
        return this.vertices;
    }

    Point3f getCartesianOffset() {
        return this.cartesianOffset;
    }

    Point3f getFractionalOffset() {
        return this.fractionalOffset;
    }

    Object[] getEllipsoid(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        if (this.data == null) {
            this.data = new SimpleUnitCell.Data(this);
        }
        float[] fArray2 = new float[6];
        if (fArray[0] == 0.0f) {
            fArray2[1] = (float)Math.sqrt(fArray[7]);
            return new Object[]{null, fArray2};
        }
        int n = (int)fArray[6];
        boolean bl = n == 4 || n == 5 || n == 8 || n == 9;
        double d = 2 - n % 2;
        double d2 = n == 8 || n == 9 || n == 10 ? 19.739208802178716 : (n == 4 || n == 5 ? 0.25 : (n == 2 || n == 3 ? Math.log(2.0) : 1.0));
        double d3 = (double)fArray[0] * d2 * (bl ? this.data.a_ * this.data.a_ : 1.0);
        double d4 = (double)fArray[1] * d2 * (bl ? this.data.b_ * this.data.b_ : 1.0);
        double d5 = (double)fArray[2] * d2 * (bl ? this.data.c_ * this.data.c_ : 1.0);
        double d6 = (double)fArray[3] * d2 * (bl ? this.data.a_ * this.data.b_ : 1.0) * d;
        double d7 = (double)fArray[4] * d2 * (bl ? this.data.a_ * this.data.c_ : 1.0) * d;
        double d8 = (double)fArray[5] * d2 * (bl ? this.data.b_ * this.data.c_ : 1.0) * d;
        fArray[7] = (float)Math.pow(d3 / 19.739208802178716 / this.data.a_ / this.data.a_ * d4 / 19.739208802178716 / this.data.b_ / this.data.b_ * d5 / 19.739208802178716 / this.data.c_ / this.data.c_, 0.3333);
        double[] dArray = new double[]{(double)(this.a * this.a) * d3 + (double)(this.b * this.b) * this.data.cosGamma * this.data.cosGamma * d4 + (double)(this.c * this.c) * this.data.cosBeta * this.data.cosBeta * d5 + (double)(this.a * this.b) * this.data.cosGamma * d6 + (double)(this.b * this.c) * this.data.cosGamma * this.data.cosBeta * d8 + (double)(this.a * this.c) * this.data.cosBeta * d7, (double)(this.b * this.b) * this.data.sinGamma * this.data.sinGamma * d4 + (double)(this.c * this.c) * this.data.cA_ * this.data.cA_ * d5 + (double)(this.b * this.c) * this.data.cA_ * this.data.sinGamma * d8, (double)(this.c * this.c) * this.data.cB_ * this.data.cB_ * d5, (double)(2.0f * this.b * this.b) * this.data.cosGamma * this.data.sinGamma * d4 + (double)(2.0f * this.c * this.c) * this.data.cA_ * this.data.cosBeta * d5 + (double)(this.a * this.b) * this.data.sinGamma * d6 + (double)(this.b * this.c) * (this.data.cA_ * this.data.cosGamma + this.data.sinGamma * this.data.cosBeta) * d8 + (double)(this.a * this.c) * this.data.cA_ * d7, (double)(2.0f * this.c * this.c) * this.data.cB_ * this.data.cosBeta * d5 + (double)(this.b * this.c) * this.data.cosGamma * d8 + (double)(this.a * this.c) * this.data.cB_ * d7, (double)(2.0f * this.c * this.c) * this.data.cA_ * this.data.cB_ * d5 + (double)(this.b * this.c) * this.data.cB_ * this.data.sinGamma * d8};
        Vector3f[] vector3fArray = new Vector3f[3];
        for (int i = 0; i < 3; ++i) {
            vector3fArray[i] = new Vector3f();
        }
        Quadric.getAxesForEllipsoid(dArray, vector3fArray, fArray2);
        double d9 = Math.sqrt(0.5) / Math.PI;
        for (int i = 0; i < 3; ++i) {
            fArray2[i] = (float)(d9 / (double)fArray2[i]);
        }
        return new Object[]{vector3fArray, fArray2};
    }

    private void calcUnitcellVertices() {
        if (this.notionalUnitcell == null || this.notionalUnitcell[0] == 0.0f) {
            return;
        }
        this.vertices = new Point3f[8];
        int n = 8;
        while (--n >= 0) {
            this.vertices[n] = new Point3f();
            this.matrixFractionalToCartesian.transform(BoxInfo.unitCubePoints[n], this.vertices[n]);
        }
    }

    public Point3f[] getCanonicalCopy(float f) {
        Point3f[] point3fArray = new Point3f[8];
        for (int i = 0; i < 8; ++i) {
            point3fArray[i] = new Point3f(BoxInfo.unitCubePoints[i]);
            this.matrixFractionalToCartesian.transform(point3fArray[i]);
        }
        return BoxInfo.getCanonicalCopy(point3fArray, f);
    }
}

