#include "stdafx.h"
#include "Core/Io/Serial.h"

struct SerialCancel {
	SerialStream *serial;

	SerialCancel(SerialStream *stream) : serial(stream) {}

	void start() {
		os::UThread::sleep(50);
		serial->close();
		serial = null;
	}
};

// Note: This is not enabled by default since there might not always be serial ports available.
BEGIN_TESTX(SerialCancelTest, Core) {
	Engine &e = gEngine();

	Array<SerialPort *> *ports = serialPorts(e);
	VERIFY(ports->any());

	SerialStream *port = ports->at(0)->open(new (e) SerialOptions());

	SerialCancel cancel(port);
	os::UThread::spawn(util::memberVoidFn(&cancel, &SerialCancel::start));

	Buffer b = port->input()->read(32);
	CHECK_EQ(b.filled(), 0);

	while (cancel.serial)
		os::UThread::leave();
} END_TEST

