% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arfima.R, R/arima.R
\name{forecast.fracdiff}
\alias{forecast.fracdiff}
\alias{forecast.Arima}
\alias{forecast.forecast_ARIMA}
\alias{forecast.ar}
\title{Forecasting using ARIMA or ARFIMA models}
\usage{
\method{forecast}{fracdiff}(
  object,
  h = 10,
  level = c(80, 95),
  fan = FALSE,
  simulate = FALSE,
  bootstrap = FALSE,
  innov = NULL,
  npaths = 5000,
  lambda = object$lambda,
  biasadj = attr(lambda, "biasadj"),
  ...
)

\method{forecast}{Arima}(
  object,
  h = if (object$arma[5] > 1) 2 * object$arma[5] else 10,
  level = c(80, 95),
  fan = FALSE,
  xreg = NULL,
  simulate = FALSE,
  bootstrap = FALSE,
  innov = NULL,
  npaths = 5000,
  lambda = object$lambda,
  biasadj = attr(lambda, "biasadj"),
  ...
)

\method{forecast}{ar}(
  object,
  h = 10,
  level = c(80, 95),
  fan = FALSE,
  simulate = FALSE,
  bootstrap = FALSE,
  innov = NULL,
  npaths = 5000,
  lambda = NULL,
  biasadj = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{Arima}, \code{ar} or \code{fracdiff}. Usually
the result of a call to \code{\link[stats:arima]{stats::arima()}}, \code{\link[=auto.arima]{auto.arima()}}, \code{\link[stats:ar]{stats::ar()}},
\code{\link[=arfima]{arfima()}} or \code{\link[fracdiff:fracdiff]{fracdiff::fracdiff()}}.}

\item{h}{Number of periods for forecasting. If \code{xreg} is used, \code{h}
is ignored and the number of forecast periods is set to the number of rows
of \code{xreg}.}

\item{level}{Confidence levels for prediction intervals.}

\item{fan}{If \code{TRUE}, \code{level} is set to \code{seq(51, 99, by = 3)}.
This is suitable for fan plots.}

\item{simulate}{If \code{TRUE}, prediction intervals are produced by simulation rather
than using analytic formulae. Errors are assumed to be normally distributed.}

\item{bootstrap}{If \code{TRUE}, then prediction intervals are produced by
simulation using resampled errors (rather than normally distributed errors). Ignored if \code{innov} is not \code{NULL}.}

\item{innov}{Optional matrix of future innovations to be used in
simulations. Ignored if \code{simulate = FALSE}. If provided, this overrides the \code{bootstrap} argument. The matrix
should have \code{h} rows and \code{npaths} columns.}

\item{npaths}{Number of sample paths used in computing simulated prediction
intervals.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda = "auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted
values, a regular back transformation will result in median forecasts. If
biasadj is \code{TRUE}, an adjustment will be made to produce mean forecasts
and fitted values.}

\item{...}{Other arguments are ignored.}

\item{xreg}{Future values of any regression variables. A numerical vector or
matrix of external regressors; it should not be a data frame.}
}
\value{
An object of class \code{forecast}.
}
\description{
Returns forecasts and other information for univariate ARIMA models.
}
\details{
For \code{Arima} or \code{ar} objects, the function calls \code{\link[stats:predict.arima]{stats::predict.Arima()}} or
\link[stats:ar]{stats::predict.ar} and constructs an object of class \code{forecast} from the
results. For \code{fracdiff} objects, the calculations are all done within
\code{\link[fracdiff:fracdiff]{fracdiff::fracdiff()}} using the equations given by Peiris and Perera (1988).
}
\section{forecast class}{

An object of class \code{forecast} is a list usually containing at least
the following elements:
\describe{
\item{model}{A list containing information about the fitted model}
\item{method}{The name of the forecasting method as a character string}
\item{mean}{Point forecasts as a time series}
\item{lower}{Lower limits for prediction intervals}
\item{upper}{Upper limits for prediction intervals}
\item{level}{The confidence values associated with the prediction intervals}
\item{x}{The original time series.}
\item{residuals}{Residuals from the fitted model. For models with additive
errors, the residuals will be x minus the fitted values.}
\item{fitted}{Fitted values (one-step forecasts)}
}
The function \code{summary} can be used to obtain and print a summary of the
results, while the functions \code{plot} and \code{autoplot} produce plots of the forecasts and
prediction intervals. The generic accessors functions \code{fitted.values} and \code{residuals}
extract various useful features from the underlying model.
}

\examples{
fit <- Arima(WWWusage, c(3, 1, 0))
plot(forecast(fit))

library(fracdiff)
x <- fracdiff.sim(100, ma = -0.4, d = 0.3)$series
fit <- arfima(x)
plot(forecast(fit, h = 30))

}
\references{
Peiris, M. & Perera, B. (1988), On prediction with fractionally
differenced ARIMA models, \emph{Journal of Time Series Analysis},
\bold{9}(3), 215-220.
}
\seealso{
\code{\link[stats:predict.arima]{stats::predict.Arima()}}, \code{\link[stats:ar]{stats::predict.ar()}}, \code{\link[=auto.arima]{auto.arima()}},
\code{\link[=Arima]{Arima()}}, \code{\link[stats:arima]{stats::arima()}}, \code{\link[stats:ar]{stats::ar()}}, \code{\link[=arfima]{arfima()}}.
}
\author{
Rob J Hyndman
}
\keyword{ts}
