% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{labelizor}
\alias{labelizor}
\title{Replace displayed text with labels}
\usage{
labelizor(x, j = NULL, labels, part = "all")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{labels}{a named vector whose names will be used to identify
values to replace and values will be used as labels.}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}
}
\description{
\code{labelizor()} substitutes text values shown in a flextable
with human-readable labels. This is useful to turn column
values such as variable names, factor levels or coded strings
into presentation-ready wording (e.g. \code{"Sepal.Length"} to
\code{"Sepal Length"}).

\code{labels} can be either a \strong{named character vector} (names
identify values to find, values are the replacement labels)
or a \strong{function} applied to every text chunk (e.g. \code{\link[=toupper]{toupper()}}).

Only the displayed content is affected; the underlying data
of the flextable is unchanged.
}
\examples{
\dontshow{
data.table::setDTthreads(1)
}
z <- summarizor(
  x = CO2[-c(1, 4)],
  by = "Treatment",
  overall_label = "Overall"
)

ft_1 <- as_flextable(z, separate_with = "variable")

ft_1 <- labelizor(
  x = ft_1, j = c("stat"),
  labels = c(Missing = "Kouign amann")
)

ft_1 <- labelizor(
  x = ft_1, j = c("variable"),
  labels = toupper
)

ft_1
}
\seealso{
\code{\link[=mk_par]{mk_par()}}, \code{\link[=append_chunks]{append_chunks()}}, \code{\link[=prepend_chunks]{prepend_chunks()}}
}
