% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downlit-md.R
\name{downlit_md_path}
\alias{downlit_md_path}
\alias{downlit_md_string}
\title{Syntax highlight and link a md document}
\usage{
downlit_md_path(in_path, out_path, format = NULL)

downlit_md_string(x, format = NULL)
}
\arguments{
\item{in_path, out_path}{Input and output paths for markdown file.}

\item{format}{Pandoc format; defaults to "gfm" if you have pandoc 2.0.0 or
greater, otherwise "markdown_github".}

\item{x}{A string containing markdown.}
}
\value{
\code{downlit_md_path()} invisibly returns \code{output_path};
\code{downlit_md_string()} returns a string containing markdown.
}
\description{
\verb{downlit_md_*} works by traversing the markdown AST generated by Pandoc.
It applies \code{\link[=highlight]{highlight()}} to \code{CodeBlock}s and \code{\link[=autolink]{autolink()}} to inline \code{Code}.

Use \code{downlit_md_path()} to transform a file on disk; use
\code{downlit_md_string()} to transform a string containing markdown as part
of a larger pipeline.

Needs pandoc 1.19 or later.
}
\examples{
\dontshow{if (rlang::is_installed("rmarkdown")) withAutoprint(\{ # examplesIf}
if (rmarkdown::pandoc_available("1.19")) {
downlit_md_string("`base::t()`")
downlit_md_string("`base::t`")
downlit_md_string("* `base::t`")

# But don't highlight in headings
downlit_md_string("## `base::t`")
}
\dontshow{\}) # examplesIf}
}
