# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AutoGeneratedDomainNameLabelScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Available auto-generated domain name scopes."""

    TENANT_REUSE = "TenantReuse"
    SUBSCRIPTION_REUSE = "SubscriptionReuse"
    RESOURCE_GROUP_REUSE = "ResourceGroupReuse"
    NO_REUSE = "NoReuse"


class CheckNameAvailabilityReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible reasons for a name not being available."""

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"


class CommunicationsPlatform(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Available platform types."""

    OPERATOR_CONNECT = "OperatorConnect"
    TEAMS_PHONE_MOBILE = "TeamsPhoneMobile"


class Connectivity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """How this deployment connects back to the operator network."""

    PUBLIC_ADDRESS = "PublicAddress"
    """This deployment connects to the operator network using a Public IP address, e.g. when using
    #: MAPS"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class E911Type(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The method for terminating emergency calls to the PSTN."""

    STANDARD = "Standard"
    """Emergency calls are not handled different from other calls"""
    DIRECT_TO_ESRP = "DirectToEsrp"
    """Emergency calls are routed directly to the ESRP"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the resource."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the current CommunicationsGateway resource."""

    CHANGE_PENDING = "ChangePending"
    """The resource has been created or updated, but the CommunicationsGateway service has not yet
    #: been updated to reflect the changes."""
    COMPLETE = "Complete"
    """The CommunicationsGateway service is up and running with the parameters specified in the
    #: resource."""


class TeamsCodecs(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The voice codecs expected for communication with Teams."""

    PCMA = "PCMA"
    PCMU = "PCMU"
    G722 = "G722"
    G722_2 = "G722_2"
    SILK8 = "SILK_8"
    SILK16 = "SILK_16"


class TestLinePurpose(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The purpose of the TestLine resource."""

    MANUAL = "Manual"
    AUTOMATED = "Automated"
