/**
 * Convert a single file-input element into a 'multiple' input list
 * Usage:
 *   1. Create a file input element (no name)
 *      eg. <input type="file" id="first_file_element">
 *   2. Create a DIV for the output to be written to
 *      eg. <div id="files_list"></div>
 *   3. Instantiate a MultiSelector object, passing in the DIV and an (optional) maximum number of files
 *      eg. var multi_selector = new MultiSelector( document.getElementById( 'files_list' ), 3 );
 *   4. Add the first element
 *      eg. multi_selector.addElement( document.getElementById( 'first_file_element' ) );
 *   5. That's it.
 *   You might (will) want to play around with the addListRow() method to make the output prettier.
 *   You might also want to change the line
 *       element.name = 'file_' + this.count;
 *   ...to a naming convention that makes more sense to you.
 * Licence:
 *   Use this however/wherever you like, just don't blame me if it breaks anything.
 * Credit:
 *   If you're nice, you'll leave this bit:
 *   Class by Stickman -- http://www.the-stickman.com
 *      with thanks to:
 *      [for Safari fixes]
 *         Luis Torrefranca -- http://www.law.pitt.edu
 *         and
 *         Shawn Parker & John Pennypacker -- http://www.fuzzycoconut.com
 *      [for duplicate name bug]
 *         'neal'
 */
function MultiSelector( list_target, max, racine ){
	// racine du site
	this.racine = racine;
	// Where to write the list
	this.list_target = list_target;
	// How many elements?
	this.count = 0;
	// How many elements?
	this.id = 0;
	// Is there a maximum?
	if( max ){
		this.max = max;
	} else {
		this.max = -1;
	};

	/**
	 * Add a new file input element
	 */
	this.addElement = function( element ){

		// Make sure it's a file input element
		if( element.tagName == 'INPUT' && element.type == 'file' ){

			// Element name -- what number am I?
			element.name = 'file_' + this.id++;

			// Add reference to this object
			element.multi_selector = this;

			// What to do when a file is selected
			element.onchange = function(){

				// New file input
				var new_element = document.createElement( 'input' );
				new_element.type = 'file';

				// Add new element
				this.parentNode.insertBefore( new_element, this );

				// Apply 'update' to element
				this.multi_selector.addElement( new_element );

				// Update list
				this.multi_selector.addListRow( this );

				// Hide this: we can't use display:none because Safari doesn't like it
				this.style.position = 'absolute';
				this.style.left = '-1000px';

			};
			// If we've reached maximum number, disable input element
			if( this.max != -1 && this.count >= this.max ){
				element.disabled = true;
			};
			// File element counter
			this.count++;
			// Most recent element
			this.current_element = element;

		} else {
			// This can only be applied to file input elements!
			alert( 'Error: not a file input element' );
		};

	};

	/**
	 * Add a new row to the list of files
	 */
	this.addListRow = function( element ){

		// Row div
		var new_row = document.createElement( 'div' );
		new_row.setAttribute("class","rowfile");
		new_row.setAttribute("className","rowfile"); /* Hack IE */
		// Delete link
		var new_row_button = document.createElement('a');
		new_row_button.setAttribute('href', 'javascript:void(0)');
		new_row_button.innerHTML = '<img src="'+this.racine+'core/admin/theme/images/delete.gif" alt="" />';
		new_row_button.setAttribute("class","btnDelete");
		new_row_button.setAttribute("className","btnDelete"); /* Hack IE */

		// file title
		var new_row_div = document.createElement('div');
		new_row_div.innerHTML = '&nbsp;'+this.basename(element.value);
		new_row_div.setAttribute("class","divtitle");
		new_row_div.setAttribute("className","divtitle"); /* Hack IE */

		// References
		new_row.element = element;

		// Delete function
		new_row_button.onclick= function(){

			// Remove element from form
			this.parentNode.element.parentNode.removeChild( this.parentNode.element );

			// Remove this row from the list
			this.parentNode.parentNode.removeChild( this.parentNode );

			// Decrement counter
			this.parentNode.element.multi_selector.count--;

			// Re-enable input element (if it's disabled)
			this.parentNode.element.multi_selector.current_element.disabled = false;

			// Appease Safari
			//    without it Safari wants to reload the browser window
			//    which nixes your already queued uploads
			return false;
		};
		// Add button
		new_row.appendChild( new_row_button );
		// Add file title
		new_row.appendChild( new_row_div );
		// Add it to the list
		this.list_target.appendChild( new_row );
	};

	this.basename = function(path) {
		return path.replace(/\\/g,'/').replace( /.*\//, '' );
	};
};