// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Stetic.Metacity {

	using System;
	using System.Reflection;
	using System.Collections;
	using System.Runtime.InteropServices;

	internal class Preview : Gtk.Bin
	{
		static Theme theme;
		public static bool ThemeError = false;
			
		public static Metacity.Preview Create (TopLevelWindow window)
		{
			Metacity.Preview metacityPreview;

			try {
				Metacity.Preview.Init ();
				metacityPreview = new Metacity.Preview ();
			}
			catch {
				return null;
			}

			switch (window.TypeHint) {
				case Gdk.WindowTypeHint.Normal:
					metacityPreview.FrameType = Metacity.FrameType.Normal;
					break;
				case Gdk.WindowTypeHint.Dialog:
					metacityPreview.FrameType = window.Modal ? Metacity.FrameType.ModalDialog : Metacity.FrameType.Dialog;
					break;
				case Gdk.WindowTypeHint.Menu:
					metacityPreview.FrameType = Metacity.FrameType.Menu;
					break;
				case Gdk.WindowTypeHint.Splashscreen:
					metacityPreview.FrameType = Metacity.FrameType.Border;
					break;
				case Gdk.WindowTypeHint.Utility:
					metacityPreview.FrameType = Metacity.FrameType.Utility;
					break;
				default:
					metacityPreview.FrameType = Metacity.FrameType.Normal;
					break;
			}

			Metacity.FrameFlags flags =
				Metacity.FrameFlags.AllowsDelete |
				Metacity.FrameFlags.AllowsVerticalResize |
				Metacity.FrameFlags.AllowsHorizontalResize |
				Metacity.FrameFlags.AllowsMove |
				Metacity.FrameFlags.AllowsShade |
				Metacity.FrameFlags.HasFocus;

			if (window.Resizable)
				flags = flags | Metacity.FrameFlags.AllowsMaximize;

			metacityPreview.FrameFlags = flags;
			metacityPreview.ShowAll ();
			metacityPreview.AddWindow (window);

			metacityPreview.Theme = GetTheme ();

			return metacityPreview;
		}

		public void AddWindow (TopLevelWindow window)
		{
			base.Add (window);

			Title = window.Title ?? string.Empty;
			window.PropertyChanged += OnWindowPropChange;
			Destroyed += delegate {
				window.PropertyChanged -= OnWindowPropChange;
			};
		}

		void OnWindowPropChange (object ob, EventArgs e)
		{
			Title = ((TopLevelWindow)ob).Title ?? string.Empty;
		}

		static Theme GetTheme ()
		{
			if (theme == null) {
				try {
					Assembly assm = Assembly.LoadWithPartialName ("gconf-sharp");
					Type client_type = assm.GetType ("GConf.Client");
					MethodInfo method = client_type.GetMethod ("Get", BindingFlags.Instance | BindingFlags.Public);
					object client = Activator.CreateInstance (client_type, new object[] {
						
					});
					string themeName = (string)method.Invoke (client, new object[] { "/apps/metacity/general/theme" });
					theme = Metacity.Theme.Load (themeName);
				} catch {
					// Set theme error flag - in case of a theme error a solid background needs to be drawn.
					ThemeError = true;
					// Don't crash if metacity is not available
					return null;
				}
			}
			return theme;
		}

		/*		static void GConfNotify (object obj, GConf.NotifyEventArgs args)
				{
					if (args.Key == "/apps/metacity/general/theme") {
						theme = Metacity.Theme.Load ((string)args.Value);
						foreach (Metacity.Preview prev in wrappers.Values)
							prev.Theme = Theme;
					}
				}
		*/

		~Preview ( )
		{
			Dispose();
		}

		[Obsolete]
		protected Preview(GLib.GType gtype) : base(gtype) {}
		public Preview(IntPtr raw) : base(raw) {}

		[DllImport("libmetacity-private.so.0")]
		static extern IntPtr meta_preview_new();

		public Preview () : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Preview)) {
				CreateNativeObject (new string [0], new GLib.Value[0]);
				return;
			}
			Raw = meta_preview_new();
		}

		[DllImport("libmetacity-private.so.0")]
		static extern void meta_preview_set_title(IntPtr raw, IntPtr title);

		public string Title {
			set  {
				IntPtr title_as_native = GLib.Marshaller.StringToPtrGStrdup (value);
				meta_preview_set_title(Handle, title_as_native);
				GLib.Marshaller.Free (title_as_native);
			}
		}

		[DllImport("libmetacity-private.so.0")]
		static extern void meta_preview_set_button_layout(IntPtr raw, ref Stetic.Metacity.ButtonLayout button_layout);

		public Stetic.Metacity.ButtonLayout ButtonLayout
		{
			set  {
				meta_preview_set_button_layout(Handle, ref value);
			}
		}

		[DllImport("libmetacity-private.so.0")]
		static extern void meta_preview_set_theme(IntPtr raw, IntPtr theme);

		public Metacity.Theme Theme {
			set  {
				meta_preview_set_theme(Handle, (value == null ? IntPtr.Zero : value.Handle));
			}
		}

		[DllImport("libmetacity-private.so.0")]
		static extern IntPtr meta_preview_get_mini_icon();

		public static Gdk.Pixbuf MiniIcon { 
			get {
				IntPtr raw_ret = meta_preview_get_mini_icon();
				Gdk.Pixbuf ret = GLib.Object.GetObject(raw_ret) as Gdk.Pixbuf;
				return ret;
			}
		}

		[DllImport("libmetacity-private.so.0")]
		static extern IntPtr meta_preview_get_icon();

		public static Gdk.Pixbuf Icon { 
			get {
				IntPtr raw_ret = meta_preview_get_icon();
				Gdk.Pixbuf ret = GLib.Object.GetObject(raw_ret) as Gdk.Pixbuf;
				return ret;
			}
		}

		[DllImport("libmetacity-private.so.0")]
		static extern void meta_preview_set_frame_type(IntPtr raw, int type);

		public Stetic.Metacity.FrameType FrameType
		{ 
			set {
				meta_preview_set_frame_type(Handle, (int) value);
			}
		}

		[DllImport("libmetacity-private.so.0")]
		static extern IntPtr meta_preview_get_type();

		public static new GLib.GType GType { 
			get {
				IntPtr raw_ret = meta_preview_get_type();
				GLib.GType ret = new GLib.GType(raw_ret);
				return ret;
			}
		}

		[DllImport("libmetacity-private.so.0")]
		static extern void meta_preview_set_frame_flags(IntPtr raw, int flags);

		public Stetic.Metacity.FrameFlags FrameFlags
		{ 
			set {
				meta_preview_set_frame_flags(Handle, (int) value);
			}
		}


		public static void Init()
		{
			GtkSharp.MetacitySharp.ObjectManager.Initialize ();
		}
	}
}
