#!/bin/bash
# Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
# HYPRE Project Developers. See the top-level COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)

testname=`basename $0 .sh`

# Echo usage information
case $1 in
   -h|-help)
      cat <<EOF

   $0 [-h|-help] {src_dir}

   where: {src_dir}  is the hypre source directory
          -h|-help   prints this usage information and exits

   This script checks for 'MPI_' in certain sections of hypre.

   Example usage: $0 ../src

EOF
      exit
      ;;
esac

# Setup
src_dir=`cd $1; pwd`
shift

cd $src_dir

find . -type f -print | egrep '[.]*[.](c|cc|cpp|cxx|C|h|hpp|hxx|H)$' |
  egrep -v '/docs' |
  egrep -v '/examples' |
  egrep -v '/FEI_mv' |
  egrep -v '/hypre/include' |
  egrep -v '/test/ij_mp.c' |
  egrep -v '/test/struct_mp.c' |
  egrep -v '/test/test_mp.c' |
  egrep -v '/test/test_mp_pcg.c' |
  egrep -v '/test/test_mp_pcg_3d.c' > check-mpi.files

egrep '(^|[^[:alnum:]_]+)MPI_' `cat check-mpi.files` |
  egrep -v 'MPI_Comm([^_]|$)' >&2

rm -f check-mpi.files
