﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
//
// Generated by Fuzzlyn v2.5 on 2025-04-11 19:29:41
// Run on X64 Windows
// Seed: 557319528607462789-vectort,vector128,vector256,x86aes,x86avx,x86avx2,x86avx512bw,x86avx512bwvl,x86avx512cd,x86avx512cdvl,x86avx512dq,x86avx512dqvl,x86avx512f,x86avx512fvl,x86avx512fx64,x86bmi1,x86bmi1x64,x86bmi2,x86bmi2x64,x86fma,x86lzcnt,x86lzcntx64,x86pclmulqdq,x86popcnt,x86popcntx64,x86sse,x86ssex64,x86sse2,x86sse2x64,x86sse3,x86sse41,x86sse41x64,x86sse42,x86sse42x64,x86ssse3,x86x86base
// Reduced from 41.1 KiB to 0.7 KiB in 00:01:23
// Debug: Outputs <0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1>
// Release: Outputs <0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1>

using System;
using System.Numerics;
using System.Runtime.Intrinsics;
using System.Runtime.Intrinsics.X86;
using Xunit;

public class Runtime_114572
{
    public static Vector256<ushort> s_2;
    public static ushort s_4;
    public static byte s_ub = 1;
    public static ushort s_us = 1;

    [Fact]
    public static void Problem()
    {
        if (Avx512F.VL.IsSupported)
        {
            var vr11 = Vector256.Create<ushort>(0);
            var vr12 = Vector256.Create<ushort>(1);
            var vr13 = (ushort)0;
            var vr14 = Vector256.CreateScalar(vr13);
            var vr15 = (ushort)1;
            var vr16 = Vector256.CreateScalar(vr15);
            var vr17 = Vector256.Create<ushort>(s_4);
            var vr18 = Avx2.Max(vr16, vr17);
            s_2 = Avx512F.VL.TernaryLogic(vr11, vr12, Avx512BW.VL.CompareGreaterThanOrEqual(vr14, vr18), 216);
            System.Console.WriteLine(s_2);
            Assert.Equal(Vector256.Create((ushort)0, (ushort)1, (ushort)1, (ushort)1, (ushort)1, (ushort)1, (ushort)1, (ushort)1, (ushort)1, (ushort)1, (ushort)1, (ushort)1, (ushort)1, (ushort)1, (ushort)1, (ushort)1), s_2);
        }
    }

    [Fact]
    public static void Problem2()
    {
        if (Avx512F.VL.IsSupported)
        {
            var v0 = Vector128<ushort>.Zero;
            var v1 = Vector128<ushort>.One;
            var vs = Vector128.CreateScalar(s_us);

            var vr = Avx512F.VL.TernaryLogic(v0, v1, Avx512BW.VL.CompareGreaterThanOrEqual(v0, vs), 0xE4);
            Console.WriteLine(vr);
            Assert.Equal(Vector128.Create((ushort)1, (ushort)0, (ushort)0, (ushort)0, (ushort)0, (ushort)0, (ushort)0, (ushort)0), vr);
        }
    }

    [Fact]
    public static void Problem3()
    {
        if (Avx512F.VL.IsSupported)
        {
            var v0 = Vector128<byte>.Zero;
            var v1 = Vector128<byte>.One;
            var vs = Vector128.CreateScalar(s_ub);

            var vr = Avx512F.VL.TernaryLogic(v0, v1, Avx512BW.VL.CompareGreaterThanOrEqual(v0, vs), 0xE4);
            Console.WriteLine(vr);
            Assert.Equal(Vector128.Create((byte)1, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0), vr);
        }
    }
}
