vcpkg_fail_port_install(ON_TARGET "UWP" "iOS" "Android" ON_ARCH "x86" "arm")

vcpkg_check_linkage(ONLY_DYNAMIC_LIBRARY)

vcpkg_from_github(
	OUT_SOURCE_PATH SOURCE_PATH
	REPO DragonJoker/Ashes
	REF 8331722d80fbd10d0bad87bd0a010c71a01a81c1
	SHA512 a14b2a46c033a5e539a73e875d7ea98af5585f30b45293243e5dde5dc00e1f293b1917d62eda427c69c852ad6e6437eb5a8dd5b2e1dedf3b8f2b5e2fc3c24152
)
vcpkg_configure_cmake(
	SOURCE_PATH ${SOURCE_PATH}
	PREFER_NINJA
	OPTIONS
		-DCMAKE_INSTALL_PREFIX=${CURRENT_INSTALLED_DIR}
		-DPROJECTS_USE_PRECOMPILED_HEADERS=OFF
		-DVCPKG_PACKAGE_BUILD=ON
		-DASHES_BUILD_TEMPLATES=OFF
		-DASHES_BUILD_TESTS=OFF
		-DASHES_BUILD_INFO=OFF
		-DASHES_BUILD_SAMPLES=OFF
)

vcpkg_install_cmake()
vcpkg_fixup_cmake_targets(CONFIG_PATH lib/cmake/ashes)

file(INSTALL ${SOURCE_PATH}/LICENSE DESTINATION ${CURRENT_PACKAGES_DIR}/share/${PORT} RENAME copyright)
