/* SPDX-License-Identifier: Zlib */

#include "plugin.h"

ZATHURA_PLUGIN_REGISTER_WITH_FUNCTIONS("cb", VERSION_MAJOR, VERSION_MINOR, VERSION_REV,
                                       ZATHURA_PLUGIN_FUNCTIONS({
                                           .document_open           = cb_document_open,
                                           .document_free           = cb_document_free,
                                           .document_index_generate = cb_document_index_generate,
                                           .page_init               = cb_page_init,
                                           .page_clear              = cb_page_clear,
                                           .page_render_cairo       = cb_page_render_cairo,
                                       }),
                                       ZATHURA_PLUGIN_MIMETYPES({
                                           "application/x-cbr",
                                           "application/x-rar",
                                           "application/x-cbz",
                                           "application/zip",
                                           "application/x-cb7",
                                           "application/x-7z-compressed",
                                           "application/x-cbt",
                                           "application/x-tar",
                                           "inode/directory",
                                       }))
