---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, listes, énumérations, style, puces, 
              itemize, babel
---

# Comment changer le style des puces d'une liste `itemize` ?

L'environnement `itemize` propose par défaut des puces suivant le style 
anglais. Voici un exemple illustrant les quatre niveaux de profondeur 
d'une liste (sachant que la question 
"[](/3_composition/texte/listes/augmenter_la_profondeur_des_listes)" 
vous explique comment dépasser cette limite de quatre).

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici un extrait d'une classification du vivant détaillant les métazoaires. 
Wikipédia précise à cet égard que ce type de classification porte souvent 
à débat :
\begin{itemize}
  \item Bacteria (bactéries) ;
  \item Archaea (archées) ;
  \item Eukaryota (eucaryotes) :
  \begin{itemize}
    \item Opisthokonta (opisthocontes) :
    \begin{itemize}
      \item Metazoa (métazoaires ou animaux pluricellulaires) :
      \begin{itemize}
        \item Cnidaria (cnidaires),
        \item Cténophora (cténaires),
        \item Bilateria (animaux bilatériens).
      \end{itemize}
    \end{itemize}
  \end{itemize}
\end{itemize}
\end{document}
```


## Avec les commandes de base

Quatre commandes définissent les puces des différents niveaux :
- `\labelitemi` pour le premier niveau ;
- `\labelitemii` pour le deuxième niveau ;
- `\labelitemiii` pour le troisième niveau ;
- `\labelitemiv` pour le quatrième niveau.

Ces commandes peuvent toutes être 
[redéfinies](/2_programmation/macros/commande_newcommand).
En voici un exemple, qui n'a pas valeur de modèle visuel (loin s'en faut). 
Notez qu'il illustre la possibilité d'utiliser des 
[symboles mathématiques](/4_domaines_specialises/mathematiques/symboles/start).

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{amssymb}        % Des caractères mathématiques de plus
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \renewcommand{\labelitemi}{$\vartriangleright$}
  \renewcommand{\labelitemii}{---}
  \renewcommand{\labelitemiii}{+}
  \renewcommand{\labelitemiv}{-}

\begin{document}
Voici un extrait d'une classification du vivant détaillant les métazoaires. 
Wikipédia précise à cet égard que ce type de classification porte souvent 
à débat :
\begin{itemize}
  \item Bacteria (bactéries) ;
  \item Archaea (archées) ;
  \item Eukaryota (eucaryotes) :
  \begin{itemize}
    \item Opisthokonta (opisthocontes) :
    \begin{itemize}
      \item Metazoa (métazoaires ou animaux pluricellulaires) :
      \begin{itemize}
        \item Cnidaria (cnidaires),
        \item Cténophora (cténaires),
        \item Bilateria (animaux bilatériens).
      \end{itemize}
    \end{itemize}
  \end{itemize}
\end{itemize}
\end{document}
```


## Avec l'extension <ctanpkg:babel>

L'extension <ctanpkg:babel> modifie la présentation des listes dès lors 
que l'option `french` est choisie. Toutefois, cette modification est mise en place 
lorsque la commande `\begin{document}` est interprêtée. Dès lors, 
la méthode proposée ci-dessus ne fonctionne plus car les redéfinitions sont écrasées 
par celle de <ctanpkg:babel>.

Cependant, <ctanpkg:babel> propose une mécanique pour permettre l'application 
de ce type de redéfinitions. La commande `\AtBeginDocument`, 
que l'extension met à disposition, prend pour argument des définitions 
qui seront appliquées après celles de <ctanpkg:babel> en début de document.
Voici donc notre exemple corrigé de ce point. 

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{amssymb}        % Des caractères mathématiques de plus
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \AtBeginDocument{%
    \renewcommand{\labelitemi}{$\vartriangleright$}%
    \renewcommand{\labelitemii}{---}%
    \renewcommand{\labelitemiii}{+}%
    \renewcommand{\labelitemiv}{-}%
    }

\begin{document}
Voici un extrait d'une classification du vivant détaillant les métazoaires. 
Wikipédia précise à cet égard que ce type de classification porte souvent 
à débat :
\begin{itemize}
  \item Bacteria (bactéries) ;
  \item Archaea (archées) ;
  \item Eukaryota (eucaryotes) :
  \begin{itemize}
    \item Opisthokonta (opisthocontes) :
    \begin{itemize}
      \item Metazoa (métazoaires ou animaux pluricellulaires) :
      \begin{itemize}
        \item Cnidaria (cnidaires),
        \item Cténophora (cténaires),
        \item Bilateria (animaux bilatériens).
      \end{itemize}
    \end{itemize}
  \end{itemize}
\end{itemize}
\end{document}
```