## TFSA-2023-012: NPE in TensorArrayConcatV2

### CVE Number
CVE-2023-25663

### Impact
When ctx->step_containter() is a null ptr, the Lookup function will be executed with a null pointer.
```python
import tensorflow as tf
tf.raw_ops.TensorArrayConcatV2(handle=['a', 'b'], flow_in = 0.1, dtype=tf.int32, element_shape_except0=1)
```

### Patches
We have patched the issue in GitHub commit [239139d2ae6a81ae9ba499ad78b56d9b2931538a](https://github.com/tensorflow/tensorflow/commit/239139d2ae6a81ae9ba499ad78b56d9b2931538a).

The fix will be included in TensorFlow 2.12.0. We will also cherrypick this commit on TensorFlow 2.11.1


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Yu Tian