static const byte kEoB1ChargenStartLevelsAmiga[60] = {
	0x03, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x01,
	0x03, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x01,
	0x03, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x01,
	0x02, 0x02, 0x00, 0x02, 0x02, 0x03, 0x00, 0x02,
	0x02, 0x02, 0x00, 0x02, 0x01, 0x01, 0x02, 0x03,
	0x03, 0x02, 0x00, 0x02, 0x02, 0x03, 0x00, 0x02,
	0x01, 0x02, 0x01, 0x03, 0x02, 0x02, 0x00, 0x02,
	0x02, 0x02, 0x00, 0x02
};

static const ByteProvider kEoB1ChargenStartLevelsAmigaProvider = { ARRAYSIZE(kEoB1ChargenStartLevelsAmiga), kEoB1ChargenStartLevelsAmiga };

static const byte kEoB1ChargenClassMinStatsAmiga[90] = {
	0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00,
	0x0e, 0x0d, 0x0e, 0x00, 0x0c, 0x00, 0x0d, 0x00,
	0x09, 0x11, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x09, 0x00, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x00, 0x00, 0x09, 0x00, 0x00, 0x09, 0x00, 0x00,
	0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09,
	0x00, 0x09, 0x00, 0x00, 0x00, 0x09, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x00, 0x00,
	0x09, 0x09, 0x09, 0x00, 0x00, 0x00, 0x0d, 0x00,
	0x0e, 0x0d, 0x0e, 0x00, 0x00, 0x09, 0x09, 0x00,
	0x00, 0x00
};

static const ByteProvider kEoB1ChargenClassMinStatsAmigaProvider = { ARRAYSIZE(kEoB1ChargenClassMinStatsAmiga), kEoB1ChargenClassMinStatsAmiga };

static const byte kEoB1ChargenRaceMinStatsAmiga[36] = {
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08,
	0x03, 0x07, 0x07, 0x08, 0x03, 0x04, 0x03, 0x06,
	0x06, 0x03, 0x08, 0x03, 0x03, 0x03, 0x0c, 0x02,
	0x06, 0x07, 0x02, 0x03, 0x08, 0x03, 0x07, 0x06,
	0x03, 0x08, 0x0a, 0x03
};

static const ByteProvider kEoB1ChargenRaceMinStatsAmigaProvider = { ARRAYSIZE(kEoB1ChargenRaceMinStatsAmiga), kEoB1ChargenRaceMinStatsAmiga };

static const uint16 kEoB1ChargenRaceMaxStatsAmiga[36] = {
	0x6412, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x6412, 0x0012,
	0x0012, 0x0013, 0x0011, 0x0012, 0x6412, 0x0012, 0x0012, 0x0012,
	0x0012, 0x0012, 0x6412, 0x0012, 0x0012, 0x0011, 0x0013, 0x0010,
	0x6412, 0x0013, 0x0011, 0x0012, 0x0012, 0x0012, 0x0011, 0x0012,
	0x0011, 0x0013, 0x0012, 0x0012
};

static const Uint16Provider kEoB1ChargenRaceMaxStatsAmigaProvider = { ARRAYSIZE(kEoB1ChargenRaceMaxStatsAmiga), kEoB1ChargenRaceMaxStatsAmiga };

static const byte kEoB1SaveThrowTable1Amiga[50] = {
	0x10, 0x0e, 0x0d, 0x0b, 0x0a, 0x08, 0x07, 0x05,
	0x04, 0x03, 0x12, 0x10, 0x0f, 0x0d, 0x0c, 0x0a,
	0x09, 0x07, 0x06, 0x05, 0x11, 0x0f, 0x0e, 0x0c,
	0x0b, 0x09, 0x08, 0x06, 0x05, 0x04, 0x14, 0x11,
	0x10, 0x0d, 0x0c, 0x09, 0x08, 0x05, 0x04, 0x04,
	0x13, 0x11, 0x10, 0x0e, 0x0d, 0x0b, 0x0a, 0x08,
	0x07, 0x06
};

static const ByteProvider kEoB1SaveThrowTable1AmigaProvider = { ARRAYSIZE(kEoB1SaveThrowTable1Amiga), kEoB1SaveThrowTable1Amiga };

static const byte kEoB1SaveThrowTable2Amiga[25] = {
	0x0e, 0x0d, 0x0b, 0x0a, 0x08, 0x0b, 0x09, 0x07,
	0x05, 0x03, 0x0d, 0x0b, 0x09, 0x07, 0x05, 0x0f,
	0x0d, 0x0b, 0x09, 0x07, 0x0c, 0x0a, 0x08, 0x06,
	0x04
};

static const ByteProvider kEoB1SaveThrowTable2AmigaProvider = { ARRAYSIZE(kEoB1SaveThrowTable2Amiga), kEoB1SaveThrowTable2Amiga };

static const byte kEoB1SaveThrowTable3Amiga[35] = {
	0x0a, 0x09, 0x07, 0x06, 0x05, 0x04, 0x02, 0x0e,
	0x0d, 0x0b, 0x0a, 0x09, 0x08, 0x06, 0x0d, 0x0c,
	0x0a, 0x09, 0x08, 0x07, 0x05, 0x10, 0x0f, 0x0d,
	0x0c, 0x0b, 0x0a, 0x08, 0x0f, 0x0e, 0x0c, 0x0b,
	0x0a, 0x09, 0x07
};

static const ByteProvider kEoB1SaveThrowTable3AmigaProvider = { ARRAYSIZE(kEoB1SaveThrowTable3Amiga), kEoB1SaveThrowTable3Amiga };

static const byte kEoB1SaveThrowTable4Amiga[30] = {
	0x0d, 0x0c, 0x0b, 0x0a, 0x09, 0x08, 0x0e, 0x0c,
	0x0a, 0x08, 0x06, 0x07, 0x0c, 0x0b, 0x0a, 0x09,
	0x08, 0x04, 0x10, 0x0f, 0x0e, 0x0d, 0x0c, 0x0b,
	0x0f, 0x0d, 0x0b, 0x09, 0x07, 0x05
};

static const ByteProvider kEoB1SaveThrowTable4AmigaProvider = { ARRAYSIZE(kEoB1SaveThrowTable4Amiga), kEoB1SaveThrowTable4Amiga };

static const byte kEoB1SaveThrwLvlIndexAmiga[6] = {
	0x11, 0x15, 0x13, 0x15, 0x11, 0x11
};

static const ByteProvider kEoB1SaveThrwLvlIndexAmigaProvider = { ARRAYSIZE(kEoB1SaveThrwLvlIndexAmiga), kEoB1SaveThrwLvlIndexAmiga };

static const byte kEoB1SaveThrwModDivAmiga[6] = {
	0x02, 0x05, 0x03, 0x04, 0x02, 0x02
};

static const ByteProvider kEoB1SaveThrwModDivAmigaProvider = { ARRAYSIZE(kEoB1SaveThrwModDivAmiga), kEoB1SaveThrwModDivAmiga };

static const byte kEoB1SaveThrwModExtAmiga[6] = {
	0x0A, 0x05, 0x07, 0x06, 0x0A, 0x0A
};

static const ByteProvider kEoB1SaveThrwModExtAmigaProvider = { ARRAYSIZE(kEoB1SaveThrwModExtAmiga), kEoB1SaveThrwModExtAmiga };

static const char *const kEoB1IntroFilesOpeningAmiga[6] = {
	"AND.CPS",
	"SSI.CPS",
	"PRESENT.CPS",
	"DAND.CPS",
	"WESTWOOD.CPS",
	""
};

static const StringListProvider kEoB1IntroFilesOpeningAmigaProvider = { ARRAYSIZE(kEoB1IntroFilesOpeningAmiga), kEoB1IntroFilesOpeningAmiga };

static const char *const kEoB1IntroFilesTowerAmiga[2] = {
	"",
	"TOWRMAGE.CPS"
};

static const StringListProvider kEoB1IntroFilesTowerAmigaProvider = { ARRAYSIZE(kEoB1IntroFilesTowerAmiga), kEoB1IntroFilesTowerAmiga };

static const char *const kEoB1IntroFilesOrbAmiga[2] = {
	"ORB.CPS",
	"TOWRMAGE.CPS"
};

static const StringListProvider kEoB1IntroFilesOrbAmigaProvider = { ARRAYSIZE(kEoB1IntroFilesOrbAmiga), kEoB1IntroFilesOrbAmiga };

static const char *const kEoB1IntroFilesWdEntryAmiga[4] = {
	"",
	"WTRDP1.CPS",
	"WTRDP2.CPS",
	"WTRDP3.CPS"
};

static const StringListProvider kEoB1IntroFilesWdEntryAmigaProvider = { ARRAYSIZE(kEoB1IntroFilesWdEntryAmiga), kEoB1IntroFilesWdEntryAmiga };

static const char *const kEoB1IntroFilesKingAmiga[2] = {
	"KING.CPS",
	"ADVENTUR.CPS"
};

static const StringListProvider kEoB1IntroFilesKingAmigaProvider = { ARRAYSIZE(kEoB1IntroFilesKingAmiga), kEoB1IntroFilesKingAmiga };

static const char *const kEoB1IntroFilesHandsAmiga[1] = {
	"HANDS.CPS"
};

static const StringListProvider kEoB1IntroFilesHandsAmigaProvider = { ARRAYSIZE(kEoB1IntroFilesHandsAmiga), kEoB1IntroFilesHandsAmiga };

static const char *const kEoB1IntroFilesWdExitAmiga[5] = {
	"WTRDP3.CPS",
	"",
	"ORB.CPS",
	"TUNNEL.CPS",
	""
};

static const StringListProvider kEoB1IntroFilesWdExitAmigaProvider = { ARRAYSIZE(kEoB1IntroFilesWdExitAmiga), kEoB1IntroFilesWdExitAmiga };

static const char *const kEoB1IntroFilesTunnelAmiga[2] = {
	"AVALANCH.CPS",
	"ZOOMTUNL.CPS"
};

static const StringListProvider kEoB1IntroFilesTunnelAmigaProvider = { ARRAYSIZE(kEoB1IntroFilesTunnelAmiga), kEoB1IntroFilesTunnelAmiga };

static const byte kEoB1IntroOpeningFrmDelayAmiga[5] = {
	0x14, 0x32, 0x64, 0x32, 0x8C
};

static const ByteProvider kEoB1IntroOpeningFrmDelayAmigaProvider = { ARRAYSIZE(kEoB1IntroOpeningFrmDelayAmiga), kEoB1IntroOpeningFrmDelayAmiga };

static const byte kEoB1IntroWdEncodeXAmiga[31] = {
	0x00, 0x18, 0x02, 0x04, 0x1a, 0x05, 0x10, 0x06,
	0x10, 0x07, 0x11, 0x04, 0x13, 0x05, 0x06, 0x13,
	0x09, 0x14, 0x0b, 0x0d, 0x16, 0x0d, 0x16, 0x0e,
	0x1a, 0x0e, 0x17, 0x0f, 0x1b, 0x0f, 0x17
};

static const ByteProvider kEoB1IntroWdEncodeXAmigaProvider = { ARRAYSIZE(kEoB1IntroWdEncodeXAmiga), kEoB1IntroWdEncodeXAmiga };

static const byte kEoB1IntroWdEncodeYAmiga[31] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01
};

static const ByteProvider kEoB1IntroWdEncodeYAmigaProvider = { ARRAYSIZE(kEoB1IntroWdEncodeYAmiga), kEoB1IntroWdEncodeYAmiga };

static const byte kEoB1IntroWdEncodeWHAmiga[31] = {
	0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01
};

static const ByteProvider kEoB1IntroWdEncodeWHAmigaProvider = { ARRAYSIZE(kEoB1IntroWdEncodeWHAmiga), kEoB1IntroWdEncodeWHAmiga };

static const uint16 kEoB1IntroWdDsXAmiga[31] = {
	0x0120, 0x0120, 0x0120, 0x0130, 0x0130, 0x00b2, 0x00b2, 0x00bc,
	0x00bc, 0x00ae, 0x00ae, 0x0125, 0x0125, 0x0125, 0x0101, 0x0101,
	0x00e9, 0x00e9, 0x00e9, 0x00ab, 0x00ab, 0x00cc, 0x00cc, 0x00f0,
	0x00f0, 0x010c, 0x010c, 0x00e0, 0x00e0, 0x00ba, 0x00ba
};

static const Uint16Provider kEoB1IntroWdDsXAmigaProvider = { ARRAYSIZE(kEoB1IntroWdDsXAmiga), kEoB1IntroWdDsXAmiga };

static const byte kEoB1IntroWdDsYAmiga[31] = {
	0x28, 0x28, 0x28, 0x38, 0x38, 0x26, 0x26, 0x1d,
	0x1d, 0x34, 0x34, 0x50, 0x50, 0x50, 0x50, 0x50,
	0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x2a, 0x2a, 0x66,
	0x66, 0x67, 0x67, 0x1c, 0x1c, 0x44, 0x44
};

static const ByteProvider kEoB1IntroWdDsYAmigaProvider = { ARRAYSIZE(kEoB1IntroWdDsYAmiga), kEoB1IntroWdDsYAmiga };

static const byte kEoB1IntroTvlX1Amiga[6] = {
	0x00, 0x08, 0x10, 0x00, 0x0F, 0x00
};

static const ByteProvider kEoB1IntroTvlX1AmigaProvider = { ARRAYSIZE(kEoB1IntroTvlX1Amiga), kEoB1IntroTvlX1Amiga };

static const byte kEoB1IntroTvlY1Amiga[6] = {
	0x00, 0x00, 0x00, 0x30, 0x36, 0x86
};

static const ByteProvider kEoB1IntroTvlY1AmigaProvider = { ARRAYSIZE(kEoB1IntroTvlY1Amiga), kEoB1IntroTvlY1Amiga };

static const byte kEoB1IntroTvlX2Amiga[6] = {
	0x10, 0x10, 0x0F, 0x0C, 0x0B, 0x0B
};

static const ByteProvider kEoB1IntroTvlX2AmigaProvider = { ARRAYSIZE(kEoB1IntroTvlX2Amiga), kEoB1IntroTvlX2Amiga };

static const byte kEoB1IntroTvlY2Amiga[6] = {
	0x35, 0x35, 0x35, 0x35, 0x35, 0x61
};

static const ByteProvider kEoB1IntroTvlY2AmigaProvider = { ARRAYSIZE(kEoB1IntroTvlY2Amiga), kEoB1IntroTvlY2Amiga };

static const byte kEoB1IntroTvlWAmiga[6] = {
	0x08, 0x08, 0x0B, 0x0F, 0x12, 0x12
};

static const ByteProvider kEoB1IntroTvlWAmigaProvider = { ARRAYSIZE(kEoB1IntroTvlWAmiga), kEoB1IntroTvlWAmiga };

static const byte kEoB1IntroTvlHAmiga[6] = {
	0x1A, 0x30, 0x36, 0x45, 0x50, 0x28
};

static const ByteProvider kEoB1IntroTvlHAmigaProvider = { ARRAYSIZE(kEoB1IntroTvlHAmiga), kEoB1IntroTvlHAmiga };

static const byte kEoB1IntroOrbFadePalAmiga[64] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x33,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x37, 0x00, 0x00, 0x05, 0x55, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0a, 0xdd, 0x06, 0x9c, 0x05, 0x5b, 0x0f, 0xff
};

static const ByteProvider kEoB1IntroOrbFadePalAmigaProvider = { ARRAYSIZE(kEoB1IntroOrbFadePalAmiga), kEoB1IntroOrbFadePalAmiga };

static const byte kEoB1DoorShapeDefsAmiga[96] = {
	0x00, 0x00, 0x0a, 0x48, 0x11, 0x98, 0x07, 0x2f,
	0x19, 0x48, 0x04, 0x1d, 0x0a, 0x00, 0x0a, 0x48,
	0x1d, 0x48, 0x07, 0x2f, 0x19, 0x68, 0x04, 0x1d,
	0x14, 0x00, 0x06, 0x48, 0x24, 0x48, 0x04, 0x2f,
	0x1e, 0x78, 0x03, 0x1d, 0x1a, 0x00, 0x0c, 0x48,
	0x00, 0x90, 0x07, 0x29, 0x21, 0x78, 0x04, 0x1b,
	0x00, 0xbc, 0x0a, 0x0c, 0x0a, 0xbc, 0x06, 0x08,
	0x0a, 0xc4, 0x04, 0x02, 0x07, 0x4a, 0x09, 0x37,
	0x00, 0x4a, 0x07, 0x25, 0x07, 0xa0, 0x05, 0x17,
	0x07, 0x82, 0x09, 0x1c, 0x00, 0x70, 0x07, 0x13,
	0x0c, 0xa0, 0x05, 0x0b, 0x10, 0x48, 0x09, 0x4b,
	0x18, 0x98, 0x07, 0x2e, 0x1f, 0x98, 0x04, 0x1d
};

static const ByteProvider kEoB1DoorShapeDefsAmigaProvider = { ARRAYSIZE(kEoB1DoorShapeDefsAmiga), kEoB1DoorShapeDefsAmiga };

static const byte kEoB1DoorSwitchShapeDefsAmiga[96] = {
	0x25, 0x78, 0x01, 0x07, 0x25, 0x88, 0x01, 0x03,
	0x25, 0x90, 0x01, 0x01, 0x25, 0x78, 0x01, 0x07,
	0x25, 0x88, 0x01, 0x03, 0x25, 0x90, 0x01, 0x01,
	0x26, 0x78, 0x01, 0x0b, 0x26, 0x88, 0x01, 0x06,
	0x26, 0x90, 0x01, 0x04, 0x27, 0x78, 0x01, 0x0e,
	0x27, 0x88, 0x01, 0x08, 0x25, 0x90, 0x01, 0x01,
	0x25, 0x78, 0x01, 0x07, 0x25, 0x88, 0x01, 0x03,
	0x25, 0x90, 0x01, 0x01, 0x25, 0x98, 0x01, 0x0b,
	0x25, 0xa8, 0x01, 0x06, 0x25, 0xb0, 0x01, 0x04,
	0x25, 0x98, 0x01, 0x0b, 0x25, 0xa8, 0x01, 0x05,
	0x25, 0xb0, 0x01, 0x04, 0x26, 0x98, 0x01, 0x0a,
	0x26, 0xa8, 0x01, 0x04, 0x25, 0x90, 0x01, 0x01
};

static const ByteProvider kEoB1DoorSwitchShapeDefsAmigaProvider = { ARRAYSIZE(kEoB1DoorSwitchShapeDefsAmiga), kEoB1DoorSwitchShapeDefsAmiga };

static const byte kEoB1DoorSwitchCoordsAmiga[48] = {
	0x82, 0x24, 0x74, 0x27, 0x00, 0x00, 0x82, 0x24,
	0x74, 0x27, 0x00, 0x00, 0x5b, 0x36, 0x5a, 0x33,
	0x5a, 0x2d, 0x88, 0x26, 0x74, 0x29, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x24,
	0x73, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x80, 0x2b, 0x74, 0x2b, 0x00, 0x00
};

static const ByteProvider kEoB1DoorSwitchCoordsAmigaProvider = { ARRAYSIZE(kEoB1DoorSwitchCoordsAmiga), kEoB1DoorSwitchCoordsAmiga };

static const byte kEoB1MonsterPropertiesAmiga[616] = {
	0x07, 0x12, 0xff, 0x01, 0x01, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x00, 0x0f, 0x00, 0x02,
	0x4b, 0x02, 0xff, 0x00, 0x07, 0x11, 0x02, 0x01,
	0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x78, 0x01, 0x38, 0x39, 0x00, 0xff, 0x00,
	0x04, 0x10, 0x01, 0x01, 0x01, 0x06, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0c, 0x00,
	0x00, 0x00, 0x00, 0x04, 0x00, 0x41, 0x00, 0x42,
	0x43, 0x00, 0x02, 0x00, 0x08, 0x0f, 0x02, 0x01,
	0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
	0x00, 0x41, 0x00, 0x49, 0x4a, 0x00, 0x03, 0x00,
	0x04, 0x10, 0x02, 0x02, 0x01, 0x04, 0x01, 0x01,
	0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0x02, 0x36,
	0x37, 0x04, 0xff, 0x14, 0x05, 0x11, 0x03, 0x01,
	0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x00, 0x41, 0x00, 0x2f, 0x30, 0x00, 0xff, 0x00,
	0x05, 0x0f, 0x02, 0x01, 0x01, 0x08, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00,
	0x00, 0x00, 0x00, 0x02, 0x02, 0x8a, 0x02, 0x31,
	0x26, 0x00, 0xff, 0x00, 0x03, 0x0c, 0x07, 0x01,
	0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x02, 0xda, 0x00, 0x2d, 0x2e, 0x00, 0xff, 0x00,
	0x05, 0x07, 0x0a, 0x01, 0x01, 0x08, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00,
	0x00, 0x00, 0x00, 0x04, 0x05, 0xdc, 0x00, 0x40,
	0x41, 0x00, 0x07, 0x00, 0x04, 0x0f, 0x06, 0x02,
	0x01, 0x08, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02,
	0x03, 0xcf, 0x01, 0x27, 0x28, 0x00, 0xff, 0x00,
	0x05, 0x0d, 0x06, 0x03, 0x01, 0x08, 0x00, 0x01,
	0x04, 0x00, 0x01, 0x04, 0x00, 0x00, 0x28, 0x00,
	0x00, 0x00, 0x00, 0x02, 0x05, 0x78, 0x02, 0x25,
	0x24, 0x00, 0xff, 0x00, 0x04, 0x0d, 0x05, 0x02,
	0x01, 0x04, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x04, 0xe2, 0x00, 0x3e, 0x3f, 0x00, 0xff, 0x00,
	0x03, 0x0e, 0x04, 0x01, 0x01, 0x08, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x02, 0x8a, 0x00, 0x2b,
	0x2c, 0x00, 0xff, 0x3c, 0xff, 0x07, 0x0a, 0x01,
	0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02,
	0x27, 0x10, 0x02, 0x44, 0x45, 0x00, 0xff, 0x64,
	0xff, 0x07, 0x09, 0x01, 0x03, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x07, 0xd0, 0x00, 0x18,
	0xff, 0x08, 0xff, 0x00, 0x03, 0x0d, 0x07, 0x01,
	0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02,
	0x13, 0x88, 0x02, 0x29, 0x2a, 0x02, 0xff, 0x3c,
	0x05, 0x0d, 0x07, 0x01, 0x01, 0x06, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x02, 0x13, 0x88, 0x00, 0x34,
	0x35, 0x02, 0xff, 0x00, 0x05, 0x0b, 0x08, 0x01,
	0x05, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0x40, 0x00, 0x3a, 0x3b, 0xff, 0xff, 0x5a,
	0x02, 0x0f, 0x05, 0x01, 0x01, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x00,
	0x00, 0x00, 0x00, 0x02, 0x01, 0x0e, 0x02, 0x3c,
	0x3d, 0x00, 0xff, 0x00, 0xfe, 0x0d, 0x08, 0x01,
	0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02,
	0x0f, 0xa0, 0x02, 0x48, 0x47, 0x00, 0xff, 0x32,
	0x04, 0x0d, 0x07, 0x01, 0x01, 0x0a, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x02, 0x03, 0xcf, 0x01, 0x33,
	0x32, 0x00, 0xff, 0x28, 0x00, 0x05, 0x23, 0x01,
	0x01, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x36, 0xb0, 0x02, 0xff, 0xff, 0xff, 0xff, 0x64
};

static const ByteProvider kEoB1MonsterPropertiesAmigaProvider = { ARRAYSIZE(kEoB1MonsterPropertiesAmiga), kEoB1MonsterPropertiesAmiga };

static const byte kEoB1EnemyMageSpellListAmiga[10] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x05,
	0x06, 0x00
};

static const ByteProvider kEoB1EnemyMageSpellListAmigaProvider = { ARRAYSIZE(kEoB1EnemyMageSpellListAmiga), kEoB1EnemyMageSpellListAmiga };

static const byte kEoB1EnemyMageSfxAmiga[10] = {
	0x00, 0x55, 0x55, 0x55, 0x55, 0x62, 0x62, 0x1F,
	0x62, 0x02
};

static const ByteProvider kEoB1EnemyMageSfxAmigaProvider = { ARRAYSIZE(kEoB1EnemyMageSfxAmiga), kEoB1EnemyMageSfxAmiga };

static const byte kEoB1BeholderSpellListAmiga[4] = {
	0x02, 0x0A, 0x0B, 0x62
};

static const ByteProvider kEoB1BeholderSpellListAmigaProvider = { ARRAYSIZE(kEoB1BeholderSpellListAmiga), kEoB1BeholderSpellListAmiga };

static const byte kEoB1BeholderSfxAmiga[4] = {
	0x62, 0x53, 0x40, 0x00
};

static const ByteProvider kEoB1BeholderSfxAmigaProvider = { ARRAYSIZE(kEoB1BeholderSfxAmiga), kEoB1BeholderSfxAmiga };

static const byte kEoB1NpcShpDataAmiga[76] = {
	0x00, 0x00, 0x06, 0x40, 0x06, 0x00, 0x07, 0x48,
	0x0d, 0x00, 0x06, 0x30, 0x13, 0x00, 0x05, 0x38,
	0x18, 0x00, 0x05, 0x38, 0x1d, 0x00, 0x05, 0x38,
	0x22, 0x00, 0x06, 0x48, 0x00, 0x48, 0x06, 0x56,
	0x06, 0x48, 0x05, 0x40, 0x0b, 0x48, 0x05, 0x40,
	0x10, 0x48, 0x05, 0x30, 0x06, 0x88, 0x03, 0x18,
	0x09, 0x88, 0x03, 0x18, 0x0c, 0x88, 0x03, 0x18,
	0x0f, 0x88, 0x03, 0x18, 0x12, 0x88, 0x03, 0x18,
	0x15, 0x88, 0x03, 0x18, 0x18, 0x48, 0x06, 0x58,
	0x1e, 0x48, 0x0a, 0x48
};

static const ByteProvider kEoB1NpcShpDataAmigaProvider = { ARRAYSIZE(kEoB1NpcShpDataAmiga), kEoB1NpcShpDataAmiga };

static const byte kEoB1NpcSubShpIndex1Amiga[6] = {
	0x09, 0x08, 0x08, 0x09, 0x09, 0x0A
};

static const ByteProvider kEoB1NpcSubShpIndex1AmigaProvider = { ARRAYSIZE(kEoB1NpcSubShpIndex1Amiga), kEoB1NpcSubShpIndex1Amiga };

static const byte kEoB1NpcSubShpIndex2Amiga[6] = {
	0x0D, 0x0B, 0x0C, 0x0E, 0x0F, 0x10
};

static const ByteProvider kEoB1NpcSubShpIndex2AmigaProvider = { ARRAYSIZE(kEoB1NpcSubShpIndex2Amiga), kEoB1NpcSubShpIndex2Amiga };

static const byte kEoB1NpcSubShpYAmiga[6] = {
	0x34, 0x31, 0x31, 0x34, 0x34, 0x45
};

static const ByteProvider kEoB1NpcSubShpYAmigaProvider = { ARRAYSIZE(kEoB1NpcSubShpYAmiga), kEoB1NpcSubShpYAmiga };

static const char *const kEoB1EnchantedStringAmiga[1] = {
	"%s +%d"
};

static const StringListProvider kEoB1EnchantedStringAmigaProvider = { ARRAYSIZE(kEoB1EnchantedStringAmiga), kEoB1EnchantedStringAmiga };

static const byte kEoB1SpellLevelsMageAmiga[26] = {
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02,
	0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x05, 0x05,
	0x05, 0x00
};

static const ByteProvider kEoB1SpellLevelsMageAmigaProvider = { ARRAYSIZE(kEoB1SpellLevelsMageAmiga), kEoB1SpellLevelsMageAmiga };

static const byte kEoB1SpellLevelsClericAmiga[25] = {
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02,
	0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x01,
	0x00
};

static const ByteProvider kEoB1SpellLevelsClericAmigaProvider = { ARRAYSIZE(kEoB1SpellLevelsClericAmiga), kEoB1SpellLevelsClericAmiga };

static const byte kEoB1NumSpellsClericAmiga[50] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x03,
	0x02, 0x00, 0x00, 0x00, 0x03, 0x03, 0x01, 0x00,
	0x00, 0x03, 0x03, 0x02, 0x00, 0x00, 0x03, 0x03,
	0x02, 0x01, 0x00, 0x03, 0x03, 0x03, 0x02, 0x00,
	0x04, 0x04, 0x03, 0x02, 0x01, 0x04, 0x04, 0x03,
	0x03, 0x02
};

static const ByteProvider kEoB1NumSpellsClericAmigaProvider = { ARRAYSIZE(kEoB1NumSpellsClericAmiga), kEoB1NumSpellsClericAmiga };

static const byte kEoB1NumSpellsWisAdjAmiga[40] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02,
	0x01, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00,
	0x00, 0x02, 0x02, 0x01, 0x00, 0x00, 0x02, 0x02,
	0x01, 0x01, 0x00, 0x03, 0x02, 0x01, 0x02, 0x00
};

static const ByteProvider kEoB1NumSpellsWisAdjAmigaProvider = { ARRAYSIZE(kEoB1NumSpellsWisAdjAmiga), kEoB1NumSpellsWisAdjAmiga };

static const byte kEoB1NumSpellsPalAmiga[60] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x02,
	0x02, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB1NumSpellsPalAmigaProvider = { ARRAYSIZE(kEoB1NumSpellsPalAmiga), kEoB1NumSpellsPalAmiga };

static const byte kEoB1NumSpellsMageAmiga[55] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x03,
	0x02, 0x00, 0x00, 0x00, 0x04, 0x02, 0x01, 0x00,
	0x00, 0x04, 0x02, 0x02, 0x00, 0x00, 0x04, 0x03,
	0x02, 0x01, 0x00, 0x04, 0x03, 0x03, 0x02, 0x00,
	0x04, 0x03, 0x03, 0x02, 0x01, 0x04, 0x04, 0x03,
	0x02, 0x02, 0x04, 0x04, 0x04, 0x03, 0x03
};

static const ByteProvider kEoB1NumSpellsMageAmigaProvider = { ARRAYSIZE(kEoB1NumSpellsMageAmiga), kEoB1NumSpellsMageAmiga };

static const uint32 kEoB1ExperienceTable0Amiga[12] = {
	0x00000000, 0x000007D0, 0x00000FA0, 0x00001F40, 0x00003E80, 0x00007D00, 0x0000FA00, 0x0001E848,
	0x0003D090, 0x0007A120, 0x000B71B0, 0xFFFFFFFF
};

static const Uint32Provider kEoB1ExperienceTable0AmigaProvider = { ARRAYSIZE(kEoB1ExperienceTable0Amiga), kEoB1ExperienceTable0Amiga };

static const uint32 kEoB1ExperienceTable1Amiga[12] = {
	0x00000000, 0x000009C4, 0x00001388, 0x00002710, 0x00004E20, 0x00009C40, 0x0000EA60, 0x00015F90,
	0x00020F58, 0x0003D090, 0x0005B8D8, 0xFFFFFFFF
};

static const Uint32Provider kEoB1ExperienceTable1AmigaProvider = { ARRAYSIZE(kEoB1ExperienceTable1Amiga), kEoB1ExperienceTable1Amiga };

static const uint32 kEoB1ExperienceTable2Amiga[11] = {
	0x00000000, 0x000005DC, 0x00000BB8, 0x00001770, 0x000032C8, 0x00006B6C, 0x0000D6D8, 0x0001ADB0,
	0x00036EE8, 0x0006DDD0, 0xFFFFFFFF
};

static const Uint32Provider kEoB1ExperienceTable2AmigaProvider = { ARRAYSIZE(kEoB1ExperienceTable2Amiga), kEoB1ExperienceTable2Amiga };

static const uint32 kEoB1ExperienceTable3Amiga[12] = {
	0x00000000, 0x000004E2, 0x000009C4, 0x00001388, 0x00002710, 0x00004E20, 0x00009C40, 0x00011170,
	0x0001ADB0, 0x00027100, 0x00035B60, 0xFFFFFFFF
};

static const Uint32Provider kEoB1ExperienceTable3AmigaProvider = { ARRAYSIZE(kEoB1ExperienceTable3Amiga), kEoB1ExperienceTable3Amiga };

static const uint32 kEoB1ExperienceTable4Amiga[12] = {
	0x00000000, 0x000008CA, 0x00001194, 0x00002328, 0x00004650, 0x00008CA0, 0x000124F8, 0x000249F0,
	0x000493E0, 0x000927C0, 0x000DBBA0, 0xFFFFFFFF
};

static const Uint32Provider kEoB1ExperienceTable4AmigaProvider = { ARRAYSIZE(kEoB1ExperienceTable4Amiga), kEoB1ExperienceTable4Amiga };

static const byte kEoB1ExpObjectTblIndexAmiga[9] = {
	0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
	0x00
};

static const ByteProvider kEoB1ExpObjectTblIndexAmigaProvider = { ARRAYSIZE(kEoB1ExpObjectTblIndexAmiga), kEoB1ExpObjectTblIndexAmiga };

static const byte kEoB1ExpObjectShpStartAmiga[4] = {
	0x07, 0x0C, 0x0F, 0x12
};

static const ByteProvider kEoB1ExpObjectShpStartAmigaProvider = { ARRAYSIZE(kEoB1ExpObjectShpStartAmiga), kEoB1ExpObjectShpStartAmiga };

static const byte kEoB1ExpObjectTbl1Amiga[13] = {
	0x1f, 0x07, 0x1f, 0x07, 0x18, 0x07, 0x18, 0x19,
	0x18, 0x19, 0x18, 0x19, 0x00
};

static const ByteProvider kEoB1ExpObjectTbl1AmigaProvider = { ARRAYSIZE(kEoB1ExpObjectTbl1Amiga), kEoB1ExpObjectTbl1Amiga };

static const byte kEoB1ExpObjectTbl2Amiga[10] = {
	0x1f, 0x1c, 0x1f, 0x1c, 0x1d, 0x1e, 0x10, 0x1e,
	0x10, 0x00
};

static const ByteProvider kEoB1ExpObjectTbl2AmigaProvider = { ARRAYSIZE(kEoB1ExpObjectTbl2Amiga), kEoB1ExpObjectTbl2Amiga };

static const byte kEoB1ExpObjectTbl3Amiga[11] = {
	0x07, 0x1b, 0x07, 0x1b, 0x08, 0x1b, 0x08, 0x10,
	0x08, 0x10, 0x00
};

static const ByteProvider kEoB1ExpObjectTbl3AmigaProvider = { ARRAYSIZE(kEoB1ExpObjectTbl3Amiga), kEoB1ExpObjectTbl3Amiga };

static const byte kEoB1ExpObjectYAmiga[4] = {
	0x77, 0x67, 0x4F, 0x3F
};

static const ByteProvider kEoB1ExpObjectYAmigaProvider = { ARRAYSIZE(kEoB1ExpObjectYAmiga), kEoB1ExpObjectYAmiga };

static const byte kEoB1SparkDefStepsAmiga[8] = {
	0x40, 0x90, 0xE4, 0xB9, 0x6E, 0x1B, 0x06, 0x01
};

static const ByteProvider kEoB1SparkDefStepsAmigaProvider = { ARRAYSIZE(kEoB1SparkDefStepsAmiga), kEoB1SparkDefStepsAmiga };

static const byte kEoB1SparkDefSubStepsAmiga[4] = {
	0xC0, 0x30, 0x0C, 0x03
};

static const ByteProvider kEoB1SparkDefSubStepsAmigaProvider = { ARRAYSIZE(kEoB1SparkDefSubStepsAmiga), kEoB1SparkDefSubStepsAmiga };

static const byte kEoB1SparkDefShiftAmiga[4] = {
	0x06, 0x04, 0x02, 0x00
};

static const ByteProvider kEoB1SparkDefShiftAmigaProvider = { ARRAYSIZE(kEoB1SparkDefShiftAmiga), kEoB1SparkDefShiftAmiga };

static const byte kEoB1SparkDefAddAmiga[8] = {
	0x08, 0x06, 0x1C, 0x14, 0x0D, 0x18, 0x0D, 0x0F
};

static const ByteProvider kEoB1SparkDefAddAmigaProvider = { ARRAYSIZE(kEoB1SparkDefAddAmiga), kEoB1SparkDefAddAmiga };

static const byte kEoB1SparkDefXAmiga[6] = {
	0x17, 0x20, 0x17, 0x20, 0x17, 0x20
};

static const ByteProvider kEoB1SparkDefXAmigaProvider = { ARRAYSIZE(kEoB1SparkDefXAmiga), kEoB1SparkDefXAmiga };

static const byte kEoB1SparkDefYAmiga[6] = {
	0x02, 0x02, 0x34, 0x34, 0x66, 0x66
};

static const ByteProvider kEoB1SparkDefYAmigaProvider = { ARRAYSIZE(kEoB1SparkDefYAmiga), kEoB1SparkDefYAmiga };

static const uint32 kEoB1SparkOfFlags1Amiga[11] = {
	0x40000000, 0x95000000, 0xEA550000, 0xBFAA5400, 0x6AFFA954, 0x15AAFEA9, 0x0055ABFE, 0x000056AB,
	0x00000156, 0x00000001, 0x00000000
};

static const Uint32Provider kEoB1SparkOfFlags1AmigaProvider = { ARRAYSIZE(kEoB1SparkOfFlags1Amiga), kEoB1SparkOfFlags1Amiga };

static const uint32 kEoB1SparkOfFlags2Amiga[16] = {
	0xC0000000, 0x30000000, 0x0C000000, 0x03000000, 0x00C00000, 0x00300000, 0x000C0000, 0x00030000,
	0x0000C000, 0x00003000, 0x00000C00, 0x00000300, 0x000000C0, 0x00000030, 0x0000000C, 0x00000003
};

static const Uint32Provider kEoB1SparkOfFlags2AmigaProvider = { ARRAYSIZE(kEoB1SparkOfFlags2Amiga), kEoB1SparkOfFlags2Amiga };

static const byte kEoB1SparkOfShiftAmiga[16] = {
	0x1E, 0x1C, 0x1A, 0x18, 0x16, 0x14, 0x12, 0x10,
	0x0E, 0x0C, 0x0A, 0x08, 0x06, 0x04, 0x02, 0x00
};

static const ByteProvider kEoB1SparkOfShiftAmigaProvider = { ARRAYSIZE(kEoB1SparkOfShiftAmiga), kEoB1SparkOfShiftAmiga };

static const byte kEoB1SparkOfXAmiga[16] = {
	0x50, 0x70, 0x30, 0x68, 0x20, 0x60, 0x38, 0x78,
	0x80, 0x48, 0x58, 0x28, 0x60, 0x40, 0x70, 0x48
};

static const ByteProvider kEoB1SparkOfXAmigaProvider = { ARRAYSIZE(kEoB1SparkOfXAmiga), kEoB1SparkOfXAmiga };

static const byte kEoB1SparkOfYAmiga[16] = {
	0x31, 0x2B, 0x48, 0x17, 0x16, 0x48, 0x35, 0x1B,
	0x43, 0x2E, 0x24, 0x28, 0x38, 0x1C, 0x16, 0x44
};

static const ByteProvider kEoB1SparkOfYAmigaProvider = { ARRAYSIZE(kEoB1SparkOfYAmiga), kEoB1SparkOfYAmiga };

static const byte kEoB1SpellPropertiesAmiga[1060] = {
	0x00, 0x00, 0x05, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xd0,
	0x01, 0x00, 0x00, 0x00, 0xb3, 0xc2, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xb4, 0x38, 0x00, 0x00,
	0x00, 0x00, 0x07, 0xd6, 0x00, 0x00, 0x00, 0x00,
	0xb4, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x57, 0x01, 0x00, 0x00, 0x07, 0xe4,
	0x08, 0x00, 0x00, 0x00, 0xb5, 0x5a, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xb5, 0xa6, 0x5f, 0x00,
	0x00, 0x00, 0x07, 0xf2, 0x00, 0x00, 0x00, 0x00,
	0xb5, 0xce, 0x00, 0x00, 0xb5, 0xf2, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00,
	0xb6, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xb6, 0x72, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08,
	0x02, 0x00, 0x00, 0x00, 0xb6, 0x8e, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x40, 0x58, 0x00,
	0x00, 0x00, 0x08, 0x18, 0x01, 0x00, 0x00, 0x00,
	0xb7, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0xaa, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x26, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0xc8, 0x00, 0x00, 0xb7, 0xf2, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x01, 0x00, 0x00, 0x08, 0x38,
	0x00, 0x00, 0x00, 0x00, 0xb8, 0x28, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x08, 0x48, 0x01, 0x00, 0x00, 0x00,
	0xb8, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x08, 0x56,
	0x00, 0x00, 0x00, 0x00, 0xb8, 0xf4, 0x00, 0x00,
	0xb9, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x62, 0x01,
	0x00, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00,
	0xb9, 0x4e, 0x00, 0x00, 0xb9, 0x78, 0x00, 0x00,
	0x00, 0x00, 0x63, 0x01, 0x00, 0x00, 0x08, 0x6c,
	0x08, 0x00, 0x00, 0x00, 0xb9, 0xa8, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xba, 0x06, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x72, 0x00, 0x00, 0x00, 0x00,
	0xba, 0x16, 0x00, 0x00, 0xba, 0x48, 0x00, 0x00,
	0x00, 0x00, 0x65, 0x01, 0x00, 0x00, 0x08, 0x7e,
	0x08, 0x00, 0x00, 0x00, 0xba, 0xd2, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0xaa, 0x5e, 0x00,
	0x00, 0x00, 0x08, 0x96, 0x00, 0x00, 0x00, 0x00,
	0xba, 0xfa, 0x00, 0x00, 0xbb, 0x24, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x01, 0x00, 0x00, 0x08, 0xa6,
	0x02, 0x00, 0x00, 0x00, 0xbb, 0x54, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xbb, 0xec, 0x66, 0x00,
	0x00, 0x00, 0x08, 0xb6, 0x00, 0x00, 0x00, 0x00,
	0xbc, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x67, 0x01, 0x00, 0x00, 0x08, 0xbc,
	0x00, 0x00, 0x00, 0x00, 0xbc, 0xb4, 0x00, 0x00,
	0xbc, 0xde, 0x00, 0x00, 0x00, 0x00, 0x59, 0x01,
	0x00, 0x00, 0x08, 0xc6, 0x01, 0x00, 0x00, 0x00,
	0xbd, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x5d, 0x00, 0x00, 0x00, 0x08, 0xd0,
	0x00, 0x00, 0x00, 0x00, 0xbd, 0xf2, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x08, 0xda, 0x00, 0x00, 0x00, 0x00,
	0xbd, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x76, 0x01, 0x00, 0x00, 0x08, 0xe8,
	0x00, 0x00, 0x00, 0x00, 0xbf, 0x0c, 0x00, 0x00,
	0xbf, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x65, 0x01,
	0x00, 0x00, 0x08, 0xf6, 0x08, 0x00, 0x00, 0x00,
	0xbf, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xc0, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x08, 0xfc,
	0x01, 0x00, 0x00, 0x00, 0xc0, 0x2c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00,
	0x00, 0x00, 0x09, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0xc0, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6b, 0x01, 0x00, 0x00, 0x07, 0xe4,
	0x08, 0x00, 0x00, 0x00, 0xb5, 0x5a, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xb5, 0xa6, 0x5f, 0x00,
	0x00, 0x00, 0x09, 0x22, 0x01, 0x00, 0x00, 0x00,
	0xc0, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xc0, 0x9c, 0x6e, 0x00, 0x00, 0x00, 0x09, 0x38,
	0x01, 0x00, 0x00, 0x00, 0xc0, 0xac, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xc1, 0x48, 0x5b, 0x00,
	0x00, 0x00, 0x09, 0x3c, 0x02, 0x00, 0x00, 0x00,
	0xc2, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0x40, 0x63, 0x00, 0x00, 0x00, 0x08, 0x72,
	0x00, 0x00, 0x00, 0x00, 0xba, 0x16, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x01,
	0x00, 0x00, 0x09, 0x48, 0x01, 0x00, 0x00, 0x00,
	0xc1, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xc1, 0xc8, 0x6f, 0x00, 0x00, 0x00, 0x09, 0x54,
	0x08, 0x00, 0x00, 0x00, 0xc2, 0xb2, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00,
	0x00, 0x00, 0x08, 0x48, 0x01, 0x00, 0x00, 0x00,
	0xb8, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x09, 0x60,
	0x04, 0x00, 0x00, 0x00, 0xc2, 0xd4, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xc3, 0x0e, 0x00, 0x00,
	0x00, 0x00, 0x09, 0x72, 0x08, 0x00, 0x00, 0x00,
	0xc3, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xc3, 0x64, 0x00, 0x00, 0x00, 0x00, 0x09, 0x7a,
	0x08, 0x00, 0x00, 0x00, 0xc3, 0x7a, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x09, 0x8c, 0x01, 0x00, 0x00, 0x00,
	0xc3, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x09, 0xa0,
	0x00, 0x00, 0x00, 0x00, 0xc3, 0xea, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x01,
	0x00, 0x00, 0x09, 0xb6, 0x01, 0x00, 0x00, 0x00,
	0xc4, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x73, 0x00, 0x00, 0x00, 0x09, 0xc8,
	0x08, 0x00, 0x00, 0x00, 0xc4, 0x28, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xc4, 0x82, 0x6e, 0x00,
	0x00, 0x00, 0x09, 0xe8, 0x04, 0x00, 0x00, 0x00,
	0xc4, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x0a, 0x02,
	0x01, 0x00, 0x00, 0x00, 0xc4, 0xb4, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0x00,
	0x00, 0x00, 0x0a, 0x18, 0x00, 0x00, 0x00, 0x00,
	0xc4, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x01, 0x00, 0x00, 0x0a, 0x2e,
	0x00, 0x00, 0x00, 0x00, 0xc4, 0xec, 0x00, 0x00,
	0xc5, 0x16, 0x00, 0x00, 0x00, 0x00, 0x62, 0x01,
	0x00, 0x00, 0x0a, 0x3c, 0x01, 0x00, 0x00, 0x00,
	0xc5, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x75, 0x00, 0x00, 0x00, 0x0a, 0x48,
	0x01, 0x00, 0x00, 0x00, 0xc6, 0xb4, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00,
	0x00, 0x00, 0x05, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xc5, 0x78, 0x00, 0x00,
	0x00, 0x00, 0x75, 0x00, 0x00, 0x00, 0x05, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xc5, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x75, 0x00,
	0x00, 0x00, 0x05, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xc6, 0x3c, 0x00, 0x00,
	0x00, 0x00, 0x75, 0x00
};

static const ByteProvider kEoB1SpellPropertiesAmigaProvider = { ARRAYSIZE(kEoB1SpellPropertiesAmiga), kEoB1SpellPropertiesAmiga };

static const byte kEoB1MagicFlightPropsAmiga[80] = {
	0x04, 0xff, 0x41, 0x09, 0x0a, 0xff, 0x04, 0x05,
	0x0d, 0xff, 0x7a, 0x06, 0x0e, 0xff, 0x0c, 0x05,
	0x10, 0xff, 0x4a, 0x0a, 0x12, 0x06, 0x38, 0x07,
	0x15, 0x06, 0x7a, 0x08, 0x19, 0xff, 0x4a, 0x0a,
	0x2f, 0xff, 0x4b, 0x06, 0x32, 0xff, 0x09, 0x07,
	0x33, 0xff, 0x09, 0x0a, 0x34, 0xff, 0x09, 0x0a,
	0x01, 0x01, 0x00, 0x00, 0x03, 0xfd, 0x02, 0xfe,
	0x01, 0xff, 0x00, 0x00, 0x00, 0x98, 0x00, 0x18,
	0x00, 0x78, 0x00, 0x38, 0x00, 0x58, 0x40, 0x40,
	0x38, 0x38, 0x38, 0x38, 0xe0, 0x20, 0x01, 0xff
};

static const ByteProvider kEoB1MagicFlightPropsAmigaProvider = { ARRAYSIZE(kEoB1MagicFlightPropsAmiga), kEoB1MagicFlightPropsAmiga };

static const byte kEoB1TurnUndeadEffectAmiga[140] = {
	0x0a, 0x07, 0x04, 0x00, 0x00, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0d, 0x0a,
	0x07, 0x04, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0x10, 0x0d, 0x0a, 0x07,
	0x04, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x13, 0x10, 0x0d, 0x0a, 0x07, 0x04,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x14, 0x13, 0x10, 0x0d, 0x0a, 0x07, 0x04, 0x00,
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x63, 0x14,
	0x13, 0x10, 0x0d, 0x0a, 0x07, 0x04, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x00, 0x63, 0x63, 0x14, 0x13,
	0x10, 0x0d, 0x0a, 0x07, 0x04, 0x00, 0x00, 0x00,
	0x00, 0xff, 0x63, 0x63, 0x63, 0x14, 0x13, 0x10,
	0x0d, 0x0a, 0x07, 0x04, 0x04, 0x00, 0x00, 0x00,
	0x63, 0x63, 0x63, 0x63, 0x14, 0x13, 0x10, 0x0d,
	0x0a, 0x07, 0x07, 0x04, 0x04, 0x00, 0x63, 0x63,
	0x63, 0x63, 0x63, 0x14, 0x13, 0x10, 0x0d, 0x0a,
	0x0a, 0x07, 0x07, 0x04
};

static const ByteProvider kEoB1TurnUndeadEffectAmigaProvider = { ARRAYSIZE(kEoB1TurnUndeadEffectAmiga), kEoB1TurnUndeadEffectAmiga };

static const byte kEoB1BurningHandsDestAmiga[8] = {
	0x02, 0x03, 0x00, 0x02, 0x00, 0x01, 0x01, 0x03
};

static const ByteProvider kEoB1BurningHandsDestAmigaProvider = { ARRAYSIZE(kEoB1BurningHandsDestAmiga), kEoB1BurningHandsDestAmiga };

static const byte kEoB1ConeOfColdDest1Amiga[7] = {
	0xE0, 0xC0, 0xC1, 0xBF, 0xA0, 0x9F, 0xA1
};

static const ByteProvider kEoB1ConeOfColdDest1AmigaProvider = { ARRAYSIZE(kEoB1ConeOfColdDest1Amiga), kEoB1ConeOfColdDest1Amiga };

static const byte kEoB1ConeOfColdDest2Amiga[7] = {
	0x01, 0x02, 0xE2, 0x22, 0x03, 0xE3, 0x23
};

static const ByteProvider kEoB1ConeOfColdDest2AmigaProvider = { ARRAYSIZE(kEoB1ConeOfColdDest2Amiga), kEoB1ConeOfColdDest2Amiga };

static const byte kEoB1ConeOfColdDest3Amiga[7] = {
	0x20, 0x40, 0x3F, 0x41, 0x60, 0x5F, 0x61
};

static const ByteProvider kEoB1ConeOfColdDest3AmigaProvider = { ARRAYSIZE(kEoB1ConeOfColdDest3Amiga), kEoB1ConeOfColdDest3Amiga };

static const byte kEoB1ConeOfColdDest4Amiga[7] = {
	0xFF, 0xFE, 0x1E, 0xDE, 0xFD, 0x1D, 0xDD
};

static const ByteProvider kEoB1ConeOfColdDest4AmigaProvider = { ARRAYSIZE(kEoB1ConeOfColdDest4Amiga), kEoB1ConeOfColdDest4Amiga };

static const byte kEoB1ConeOfColdGfxTblAmiga[8] = {
	0x1f, 0x1c, 0x1f, 0x1c, 0x1d, 0x1e, 0x1d, 0x00
};

static const ByteProvider kEoB1ConeOfColdGfxTblAmigaProvider = { ARRAYSIZE(kEoB1ConeOfColdGfxTblAmiga), kEoB1ConeOfColdGfxTblAmiga };

static const byte kEoB1DscDoorShapeIndexAmiga[32] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03
};

static const ByteProvider kEoB1DscDoorShapeIndexAmigaProvider = { ARRAYSIZE(kEoB1DscDoorShapeIndexAmiga), kEoB1DscDoorShapeIndexAmiga };

static const byte kEoB1WllFlagPresetAmiga[25] = {
	0x07, 0x00, 0x40, 0xA8, 0x88, 0x88, 0x88, 0x9F,
	0xA8, 0x88, 0x88, 0x88, 0x9F, 0xAA, 0x8A, 0x8A,
	0x8A, 0x9F, 0xAA, 0x8A, 0x8A, 0x8A, 0x9F, 0x03,
	0x03
};

static const ByteProvider kEoB1WllFlagPresetAmigaProvider = { ARRAYSIZE(kEoB1WllFlagPresetAmiga), kEoB1WllFlagPresetAmiga };

static const uint16 kEoB1DscShapeCoordsAmiga[180] = {
	0xff91, 0xffc1, 0xffa1, 0xffc1, 0xff75, 0xffc5, 0xff8b, 0xffc5,
	0xff88, 0xffc3, 0xffb4, 0xffc1, 0xffc4, 0xffc1, 0xffa1, 0xffc5,
	0xffb6, 0xffc5, 0xffb0, 0xffc3, 0xffd5, 0xffc1, 0xffe5, 0xffc1,
	0xffcb, 0xffc5, 0xffe1, 0xffc5, 0xffd8, 0xffc3, 0xfff8, 0xffc1,
	0x0008, 0xffc1, 0xfff6, 0xffc5, 0x000a, 0xffc5, 0x0000, 0xffc3,
	0x001b, 0xffc1, 0x002b, 0xffc1, 0x001f, 0xffc5, 0x0035, 0xffc5,
	0x0028, 0xffc3, 0x003c, 0xffc1, 0x004c, 0xffc1, 0x004a, 0xffc5,
	0x005f, 0xffc5, 0x0050, 0xffc3, 0x005f, 0xffc1, 0x006f, 0xffc1,
	0x0075, 0xffc5, 0x008b, 0xffc5, 0x0078, 0xffc3, 0xff8a, 0xffcb,
	0xffa4, 0xffcb, 0xff68, 0xffd3, 0xff88, 0xffd3, 0xff8a, 0xffce,
	0xffbe, 0xffcb, 0xffd8, 0xffcb, 0xffac, 0xffd3, 0xffcd, 0xffd3,
	0xffc5, 0xffce, 0xfff3, 0xffcb, 0x000d, 0xffcb, 0xfff0, 0xffd3,
	0x0010, 0xffd3, 0x0000, 0xffce, 0x0028, 0xffcb, 0x0042, 0xffcb,
	0x0033, 0xffd3, 0x0054, 0xffd3, 0x003b, 0xffce, 0x005c, 0xffcb,
	0x0076, 0xffcb, 0x0078, 0xffd3, 0x0098, 0xffd3, 0x0076, 0xffce,
	0xff92, 0xffdd, 0xffbd, 0xffdd, 0xff74, 0xffea, 0xffad, 0xffea,
	0xff9e, 0xffe2, 0xffea, 0xffdd, 0x0016, 0xffdd, 0xffe5, 0xffea,
	0x001b, 0xffea, 0x0000, 0xffe2, 0x0043, 0xffdd, 0x006e, 0xffdd,
	0x0053, 0xffea, 0x008c, 0xffea, 0x0062, 0xffe2, 0xff80, 0xfffc,
	0x0080, 0xfffc, 0xff80, 0xffbe, 0x0080, 0xffbe, 0x0080, 0x0000,
	0xffda, 0xfffc, 0x0026, 0xfffc, 0xffda, 0xffbe, 0x0026, 0xffbe,
	0x0000, 0x0000, 0xff80, 0xfffc, 0x0080, 0xfffc, 0xff80, 0xffbe,
	0x0080, 0xffbe, 0x0080, 0x0000
};

static const Uint16Provider kEoB1DscShapeCoordsAmigaProvider = { ARRAYSIZE(kEoB1DscShapeCoordsAmiga), kEoB1DscShapeCoordsAmiga };

static const byte kEoB1DscDoorScaleOffsAmiga[32] = {
	0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x0D, 0x0D, 0x0D,
	0x0D, 0x0D, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x1F
};

static const ByteProvider kEoB1DscDoorScaleOffsAmigaProvider = { ARRAYSIZE(kEoB1DscDoorScaleOffsAmiga), kEoB1DscDoorScaleOffsAmiga };

static const byte kEoB1DscDoorScaleMult1Amiga[4] = {
	0x08, 0x0C, 0x12, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult1AmigaProvider = { ARRAYSIZE(kEoB1DscDoorScaleMult1Amiga), kEoB1DscDoorScaleMult1Amiga };

static const byte kEoB1DscDoorScaleMult2Amiga[4] = {
	0x00, 0x02, 0x04, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult2AmigaProvider = { ARRAYSIZE(kEoB1DscDoorScaleMult2Amiga), kEoB1DscDoorScaleMult2Amiga };

static const byte kEoB1DscDoorScaleMult3Amiga[4] = {
	0x04, 0x06, 0x09, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult3AmigaProvider = { ARRAYSIZE(kEoB1DscDoorScaleMult3Amiga), kEoB1DscDoorScaleMult3Amiga };

static const byte kEoB1DscDoorScaleMult4Amiga[4] = {
	0x00, 0x02, 0x04, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult4AmigaProvider = { ARRAYSIZE(kEoB1DscDoorScaleMult4Amiga), kEoB1DscDoorScaleMult4Amiga };

static const byte kEoB1DscDoorScaleMult5Amiga[4] = {
	0x07, 0x0B, 0x0E, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult5AmigaProvider = { ARRAYSIZE(kEoB1DscDoorScaleMult5Amiga), kEoB1DscDoorScaleMult5Amiga };

static const byte kEoB1DscDoorScaleMult6Amiga[4] = {
	0x00, 0x02, 0x04, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult6AmigaProvider = { ARRAYSIZE(kEoB1DscDoorScaleMult6Amiga), kEoB1DscDoorScaleMult6Amiga };

static const byte kEoB1DscDoorXEAmiga[32] = {
	0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x0D, 0x0D, 0x0D,
	0x0D, 0x0D, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x1F
};

static const ByteProvider kEoB1DscDoorXEAmigaProvider = { ARRAYSIZE(kEoB1DscDoorXEAmiga), kEoB1DscDoorXEAmiga };

static const byte kEoB1DscDoorY1Amiga[4] = {
	0x3A, 0x47, 0x56, 0x00
};

static const ByteProvider kEoB1DscDoorY1AmigaProvider = { ARRAYSIZE(kEoB1DscDoorY1Amiga), kEoB1DscDoorY1Amiga };

static const byte kEoB1DscDoorY3Amiga[4] = {
	0x20, 0x20, 0x18, 0x00
};

static const ByteProvider kEoB1DscDoorY3AmigaProvider = { ARRAYSIZE(kEoB1DscDoorY3Amiga), kEoB1DscDoorY3Amiga };

static const byte kEoB1DscDoorY4Amiga[4] = {
	0x1E, 0x18, 0x10, 0x30
};

static const ByteProvider kEoB1DscDoorY4AmigaProvider = { ARRAYSIZE(kEoB1DscDoorY4Amiga), kEoB1DscDoorY4Amiga };

static const byte kEoB1DscDoorY5Amiga[4] = {
	0x30, 0x34, 0x3B, 0x3A
};

static const ByteProvider kEoB1DscDoorY5AmigaProvider = { ARRAYSIZE(kEoB1DscDoorY5Amiga), kEoB1DscDoorY5Amiga };

static const byte kEoB1DscDoorY6Amiga[4] = {
	0x3A, 0x45, 0x5A, 0x00
};

static const ByteProvider kEoB1DscDoorY6AmigaProvider = { ARRAYSIZE(kEoB1DscDoorY6Amiga), kEoB1DscDoorY6Amiga };

static const byte kEoB1DscDoorY7Amiga[4] = {
	0x3B, 0x47, 0x58, 0x00
};

static const ByteProvider kEoB1DscDoorY7AmigaProvider = { ARRAYSIZE(kEoB1DscDoorY7Amiga), kEoB1DscDoorY7Amiga };

static const uint16 kEoB1DscDoorCoordsExtAmiga[36] = {
	0x0000, 0x0000, 0xFFE8, 0x0010, 0x0020, 0x0040, 0x0048, 0x0068,
	0x0070, 0x0090, 0x00A0, 0x00C8, 0x0000, 0x0000, 0x0000, 0x0000,
	0xFFE8, 0x0030, 0x0038, 0x0078, 0x0080, 0x00C8, 0x0000, 0x0000,
	0xFFA8, 0x0020, 0x0028, 0x0088, 0x0090, 0x0108, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000
};

static const Uint16Provider kEoB1DscDoorCoordsExtAmigaProvider = { ARRAYSIZE(kEoB1DscDoorCoordsExtAmiga), kEoB1DscDoorCoordsExtAmiga };

static const byte kEoB1DscDoorFrameY1Amiga[32] = {
	0x20, 0x18, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x20, 0x20, 0x18, 0x00, 0x1E, 0x18, 0x10, 0x00,
	0x3A, 0x48, 0x60, 0x78, 0x3A, 0x46, 0x56, 0x00,
	0x78, 0x78, 0x78, 0x78, 0x1F, 0x18, 0x0F, 0x00
};

static const ByteProvider kEoB1DscDoorFrameY1AmigaProvider = { ARRAYSIZE(kEoB1DscDoorFrameY1Amiga), kEoB1DscDoorFrameY1Amiga };

static const byte kEoB1DscDoorFrameY2Amiga[32] = {
	0x20, 0x18, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x20, 0x20, 0x18, 0x00, 0x1E, 0x18, 0x10, 0x00,
	0x3A, 0x48, 0x60, 0x78, 0x3A, 0x46, 0x56, 0x00,
	0x78, 0x78, 0x78, 0x78, 0x1F, 0x18, 0x0F, 0x00
};

static const ByteProvider kEoB1DscDoorFrameY2AmigaProvider = { ARRAYSIZE(kEoB1DscDoorFrameY2Amiga), kEoB1DscDoorFrameY2Amiga };

static const byte kEoB1DscDoorFrameIndex1Amiga[12] = {
	0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x08, 0x08,
	0x08, 0x0C, 0x0C, 0x1C
};

static const ByteProvider kEoB1DscDoorFrameIndex1AmigaProvider = { ARRAYSIZE(kEoB1DscDoorFrameIndex1Amiga), kEoB1DscDoorFrameIndex1Amiga };

static const byte kEoB1DscDoorFrameIndex2Amiga[12] = {
	0x10, 0x10, 0x10, 0x18, 0x18, 0x18, 0x10, 0x10,
	0x10, 0x14, 0x14, 0x18
};

static const ByteProvider kEoB1DscDoorFrameIndex2AmigaProvider = { ARRAYSIZE(kEoB1DscDoorFrameIndex2Amiga), kEoB1DscDoorFrameIndex2Amiga };

static const byte kEoB1DscItemPosIndexAmiga[16] = {
	0x00, 0x01, 0x02, 0x03, 0x02, 0x00, 0x03, 0x01,
	0x03, 0x02, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02
};

static const ByteProvider kEoB1DscItemPosIndexAmigaProvider = { ARRAYSIZE(kEoB1DscItemPosIndexAmiga), kEoB1DscItemPosIndexAmiga };

static const uint16 kEoB1DscItemShpXAmiga[18] = {
	0xFFC8, 0xFFF8, 0x0028, 0x0058, 0x0088, 0x00B8, 0x00E8, 0xFFB8,
	0x0008, 0x0058, 0x00A8, 0x00F8, 0xFFD8, 0x0058, 0x00D8, 0xFFA8,
	0x0058, 0x0108
};

static const Uint16Provider kEoB1DscItemShpXAmigaProvider = { ARRAYSIZE(kEoB1DscItemShpXAmiga), kEoB1DscItemShpXAmiga };

static const byte kEoB1DscItemScaleIndexAmiga[18] = {
	0xFF, 0xFF, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02,
	0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0xFF, 0xFF,
	0x25, 0x00
};

static const ByteProvider kEoB1DscItemScaleIndexAmigaProvider = { ARRAYSIZE(kEoB1DscItemScaleIndexAmiga), kEoB1DscItemScaleIndexAmiga };

static const byte kEoB1DscItemTileIndexAmiga[18] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0x09, 0xFF, 0x0B,
	0x0C, 0x0D
};

static const ByteProvider kEoB1DscItemTileIndexAmigaProvider = { ARRAYSIZE(kEoB1DscItemTileIndexAmiga), kEoB1DscItemTileIndexAmiga };

static const byte kEoB1DscItemShapeMapAmiga[90] = {
	0x00, 0x00, 0x00, 0x04, 0x01, 0x02, 0x03, 0x04,
	0x05, 0x06, 0x07, 0x07, 0x12, 0x06, 0x0f, 0x12,
	0x14, 0x17, 0x13, 0x11, 0x15, 0x0d, 0x09, 0x09,
	0x16, 0x1f, 0x0c, 0x23, 0x0c, 0x0c, 0x0c, 0x0b,
	0x0a, 0x1c, 0x1c, 0x1a, 0x1b, 0x21, 0x1d, 0x1d,
	0x22, 0x22, 0x22, 0x00, 0x08, 0x00, 0x25, 0x18,
	0x16, 0x17, 0x16, 0x17, 0x16, 0x17, 0x19, 0x23,
	0x10, 0x1e, 0x24, 0x18, 0x1c, 0x20, 0x12, 0x21,
	0x1e, 0x23, 0x1c, 0x00, 0x20, 0x11, 0x11, 0x0d,
	0x1f, 0x09, 0x09, 0x15, 0x15, 0x0f, 0x05, 0x0c,
	0x1e, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1b,
	0x1b, 0x00
};

static const ByteProvider kEoB1DscItemShapeMapAmigaProvider = { ARRAYSIZE(kEoB1DscItemShapeMapAmiga), kEoB1DscItemShapeMapAmiga };

static const byte kEoB1DscTelptrShpCoordsAmiga[156] = {
	0x0c, 0x07, 0x1a, 0x01, 0x3e, 0x03, 0x0c, 0x1a,
	0x2a, 0x13, 0x40, 0x18, 0x02, 0x2d, 0x16, 0x25,
	0x28, 0x32, 0x36, 0x27, 0x0a, 0x3e, 0x16, 0x49,
	0x3e, 0x44, 0x06, 0x06, 0x2a, 0x04, 0x37, 0x0a,
	0x04, 0x1b, 0x1a, 0x16, 0x37, 0x1d, 0x0e, 0x2a,
	0x1b, 0x35, 0x2e, 0x28, 0x42, 0x30, 0x06, 0x47,
	0x06, 0x47, 0x2d, 0x4c, 0x0a, 0x04, 0x14, 0x00,
	0x2e, 0x01, 0x0c, 0x10, 0x1f, 0x10, 0x2f, 0x10,
	0x12, 0x18, 0x28, 0x1d, 0x01, 0x21, 0x08, 0x2a,
	0x11, 0x32, 0x2f, 0x2e, 0x1f, 0x25, 0x02, 0x02,
	0x01, 0x11, 0x01, 0x2f, 0x08, 0x1e, 0x11, 0x0e,
	0x11, 0x26, 0x1c, 0x01, 0x1e, 0x19, 0x1f, 0x33,
	0x24, 0x11, 0x26, 0x05, 0x28, 0x2b, 0x2f, 0x22,
	0x00, 0x13, 0x05, 0x01, 0x06, 0x08, 0x09, 0x0c,
	0x04, 0x1a, 0x08, 0x1f, 0x12, 0x05, 0x12, 0x15,
	0x16, 0x10, 0x1a, 0x08, 0x1a, 0x1d, 0x0a, 0x00,
	0x0a, 0x00, 0x00, 0x09, 0x00, 0x1e, 0x04, 0x11,
	0x08, 0x16, 0x08, 0x06, 0x10, 0x00, 0x11, 0x0d,
	0x12, 0x20, 0x15, 0x02, 0x14, 0x09, 0x16, 0x1b,
	0x1a, 0x14, 0x1a, 0x14
};

static const ByteProvider kEoB1DscTelptrShpCoordsAmigaProvider = { ARRAYSIZE(kEoB1DscTelptrShpCoordsAmiga), kEoB1DscTelptrShpCoordsAmiga };

static const byte kEoB1PortalSeqDataAmiga[126] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,
	0x02, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,
	0x04, 0x00, 0x03, 0x00, 0x02, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x04,
	0x00, 0x01, 0x01, 0x00, 0x02, 0x01, 0x03, 0x02,
	0x02, 0x03, 0x01, 0x04, 0x00, 0x02, 0x01, 0x03,
	0x02, 0x04, 0x03, 0x02, 0x04, 0x03, 0x03, 0x04,
	0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x05, 0x04, 0x06, 0x03, 0x07,
	0x02, 0x08, 0x02, 0x08, 0x01, 0x09, 0x01, 0x09,
	0x01, 0x09, 0x00, 0x0a, 0xff, 0xff
};

static const ByteProvider kEoB1PortalSeqDataAmigaProvider = { ARRAYSIZE(kEoB1PortalSeqDataAmiga), kEoB1PortalSeqDataAmiga };

static const byte kEoB1DscMonsterFrmOffsTbl1Amiga[32] = {
	0x04, 0xfe, 0x01, 0x03, 0x03, 0x04, 0xfe, 0x01,
	0x01, 0x03, 0x04, 0xfe, 0xfe, 0x01, 0x03, 0x04,
	0xfc, 0xfd, 0xff, 0x02, 0x02, 0xfc, 0xfd, 0xff,
	0xff, 0x02, 0xfc, 0xfd, 0xfd, 0xff, 0x02, 0xfc
};

static const ByteProvider kEoB1DscMonsterFrmOffsTbl1AmigaProvider = { ARRAYSIZE(kEoB1DscMonsterFrmOffsTbl1Amiga), kEoB1DscMonsterFrmOffsTbl1Amiga };

static const byte kEoB1DscMonsterFrmOffsTbl2Amiga[32] = {
	0x04, 0xfe, 0x01, 0x03, 0x03, 0x04, 0xfe, 0x01,
	0x01, 0x03, 0x04, 0xfe, 0xfe, 0x01, 0x03, 0x04,
	0x04, 0xfd, 0x01, 0x02, 0x02, 0x04, 0xfd, 0x01,
	0x01, 0x02, 0x04, 0xfd, 0xfd, 0x01, 0x02, 0x04
};

static const ByteProvider kEoB1DscMonsterFrmOffsTbl2AmigaProvider = { ARRAYSIZE(kEoB1DscMonsterFrmOffsTbl2Amiga), kEoB1DscMonsterFrmOffsTbl2Amiga };

static const uint16 kEoB1InvSlotXAmiga[27] = {
	0x00e6, 0x0116, 0x00b5, 0x00c7, 0x00b5, 0x00c7, 0x00b5, 0x00c7,
	0x00b5, 0x00c7, 0x00b5, 0x00c7, 0x00b5, 0x00c7, 0x00b5, 0x00c7,
	0x00e1, 0x00e0, 0x00e1, 0x012a, 0x011f, 0x0115, 0x012c, 0x012c,
	0x012c, 0x00e4, 0x00f0
};

static const Uint16Provider kEoB1InvSlotXAmigaProvider = { ARRAYSIZE(kEoB1InvSlotXAmiga), kEoB1InvSlotXAmiga };

static const byte kEoB1InvSlotYAmiga[27] = {
	0x74, 0x74, 0x28, 0x28, 0x3a, 0x3a, 0x4c, 0x4c,
	0x5e, 0x5e, 0x70, 0x70, 0x82, 0x82, 0x94, 0x94,
	0x38, 0x4c, 0x60, 0x37, 0x4b, 0x89, 0x5e, 0x70,
	0x82, 0x88, 0x88
};

static const ByteProvider kEoB1InvSlotYAmigaProvider = { ARRAYSIZE(kEoB1InvSlotYAmiga), kEoB1InvSlotYAmiga };

static const uint16 kEoB1SlotValidationFlagsAmiga[27] = {
	0x0008, 0x0008, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
	0x0001, 0x0002, 0x0004, 0x0020, 0x0040, 0x0010, 0xFFFF, 0x0080,
	0x0080, 0x0100, 0x0100
};

static const Uint16Provider kEoB1SlotValidationFlagsAmigaProvider = { ARRAYSIZE(kEoB1SlotValidationFlagsAmiga), kEoB1SlotValidationFlagsAmiga };

static const byte kEoB1ProjectileWeaponTypesAmiga[8] = {
	0x10, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x12
};

static const ByteProvider kEoB1ProjectileWeaponTypesAmigaProvider = { ARRAYSIZE(kEoB1ProjectileWeaponTypesAmiga), kEoB1ProjectileWeaponTypesAmiga };

static const byte kEoB1WandTypesAmiga[7] = {
	0x00, 0x12, 0x18, 0x28, 0x0D, 0xFF, 0x04
};

static const ByteProvider kEoB1WandTypesAmigaProvider = { ARRAYSIZE(kEoB1WandTypesAmiga), kEoB1WandTypesAmiga };

static const byte kEoB1DrawObjPosIndexAmiga[20] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x02, 0x00, 0x03,
	0x01, 0x04, 0x02, 0x03, 0x00, 0x01, 0x04, 0x01,
	0x03, 0x00, 0x02, 0x04
};

static const ByteProvider kEoB1DrawObjPosIndexAmigaProvider = { ARRAYSIZE(kEoB1DrawObjPosIndexAmiga), kEoB1DrawObjPosIndexAmiga };

static const byte kEoB1FlightObjFlipIndexAmiga[16] = {
	0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00
};

static const ByteProvider kEoB1FlightObjFlipIndexAmigaProvider = { ARRAYSIZE(kEoB1FlightObjFlipIndexAmiga), kEoB1FlightObjFlipIndexAmiga };

static const byte kEoB1FlightObjShpMapAmiga[88] = {
	0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,
	0xff, 0xff, 0x03, 0xff, 0x05, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0x02, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

static const ByteProvider kEoB1FlightObjShpMapAmigaProvider = { ARRAYSIZE(kEoB1FlightObjShpMapAmiga), kEoB1FlightObjShpMapAmiga };

static const byte kEoB1FlightObjSclIndexAmiga[72] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
	0xff, 0xff, 0x03, 0x03, 0xff, 0xff, 0x03, 0x03,
	0xff, 0xff, 0x03, 0x03, 0xff, 0xff, 0x03, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x01, 0xff, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0xff, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

static const ByteProvider kEoB1FlightObjSclIndexAmigaProvider = { ARRAYSIZE(kEoB1FlightObjSclIndexAmiga), kEoB1FlightObjSclIndexAmiga };

static const byte kEoB1DscShapeIndexAmiga[36] = {
	0x01, 0x01, 0x04, 0x0a, 0x04, 0x08, 0x04, 0x01,
	0x04, 0xf8, 0x04, 0xf6, 0x00, 0x00, 0x03, 0x09,
	0x03, 0x07, 0x03, 0x01, 0x03, 0xf9, 0x03, 0xf7,
	0x02, 0x06, 0x02, 0x01, 0x02, 0xfa, 0x01, 0x05,
	0x01, 0x01, 0x01, 0xfb
};

static const ByteProvider kEoB1DscShapeIndexAmigaProvider = { ARRAYSIZE(kEoB1DscShapeIndexAmiga), kEoB1DscShapeIndexAmiga };

static const uint16 kEoB1DscXAmiga[18] = {
	0xFF70, 0xFFA0, 0xFFD0, 0x0000, 0x0030, 0x0060, 0x0090, 0xFF60,
	0xFFB0, 0x0000, 0x0050, 0x00A0, 0xFF80, 0x0000, 0x0080, 0x0000,
	0x0000, 0x0000
};

static const Uint16Provider kEoB1DscXAmigaProvider = { ARRAYSIZE(kEoB1DscXAmiga), kEoB1DscXAmiga };

static const byte kEoB1DscTileIndexAmiga[18] = {
	0x00, 0x06, 0x01, 0x05, 0x02, 0x04, 0x03, 0x07,
	0x0B, 0x08, 0x0A, 0x09, 0x0C, 0x0E, 0x0D, 0x0F,
	0x11, 0x10
};

static const ByteProvider kEoB1DscTileIndexAmigaProvider = { ARRAYSIZE(kEoB1DscTileIndexAmiga), kEoB1DscTileIndexAmiga };

static const byte kEoB1DscDimData1Amiga[324] = {
	0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7,
	0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7,
	0xd8, 0xd7, 0xd8, 0xd8, 0x02, 0xd8, 0xd8, 0xd8,
	0xd8, 0xfe, 0xd7, 0xd8, 0xd8, 0xd8, 0xd7, 0x03,
	0xd8, 0xfd, 0xd8, 0xd8, 0xd8, 0xfe, 0xd8, 0x08,
	0xd8, 0xd8, 0xd8, 0xfe, 0xd7, 0x06, 0xd8, 0xd8,
	0xfa, 0x03, 0xd8, 0xfd, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xfa, 0xd7,
	0x10, 0xd8, 0xfd, 0xd7, 0x13, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xf2, 0xd8, 0x14, 0xd8, 0xd8,
	0xd8, 0xf0, 0xd7, 0x14, 0xd8, 0xed, 0x10, 0xd8,
	0xd8, 0x13, 0xd8, 0xd8, 0xd8, 0xd8, 0xec, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd7, 0x14, 0xd8, 0xed,
	0xd7, 0xd8, 0xd8, 0x13, 0xd7, 0xd7, 0xd7, 0xd7,
	0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7,
	0xd7, 0xd7, 0xd7, 0xd7, 0xd8, 0xd7, 0xd7, 0xd7,
	0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7,
	0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd8, 0xd7,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0x06, 0xd8, 0xd8, 0xfa, 0x03, 0xd8, 0xfd,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xfa, 0xd8, 0x10, 0xd8, 0xfd, 0xd7,
	0x13, 0xfd, 0xd8, 0x13, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xf0, 0xd8, 0xd8,
	0xd8, 0xed, 0x10, 0xd8, 0xd8, 0x13, 0xd7, 0xd7,
	0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7,
	0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd8, 0xd7,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0x03, 0xd8, 0xfd,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xfd, 0xd8,
	0x13, 0xfd, 0xd8, 0x13, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xed, 0xd8, 0xd8, 0xd8, 0x13, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8,
	0xd8, 0xd8, 0xd8, 0xd8
};

static const ByteProvider kEoB1DscDimData1AmigaProvider = { ARRAYSIZE(kEoB1DscDimData1Amiga), kEoB1DscDimData1Amiga };

static const byte kEoB1DscDimData2Amiga[648] = {
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x00, 0x16, 0x16, 0x00, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x02, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x02, 0x16, 0x00, 0x04, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x16, 0x00, 0x00, 0x03,
	0x00, 0x16, 0x03, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x02, 0x16, 0x00, 0x16, 0x00, 0x08,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x02,
	0x16, 0x00, 0x00, 0x06, 0x00, 0x16, 0x00, 0x16,
	0x06, 0x16, 0x00, 0x03, 0x00, 0x16, 0x03, 0x00,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x06, 0x16, 0x08, 0x0e,
	0x00, 0x10, 0x00, 0x16, 0x03, 0x16, 0x06, 0x10,
	0x00, 0x13, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x0e, 0x16,
	0x00, 0x16, 0x00, 0x14, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x10, 0x16, 0x16, 0x00, 0x00, 0x14,
	0x00, 0x16, 0x13, 0x16, 0x00, 0x10, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x13, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x14, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x12, 0x16, 0x14, 0x16, 0x00, 0x16, 0x13, 0x16,
	0x16, 0x00, 0x00, 0x16, 0x00, 0x16, 0x00, 0x13,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x00, 0x16, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x00, 0x16, 0x16, 0x00,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x06, 0x00, 0x16, 0x00, 0x16,
	0x06, 0x16, 0x00, 0x03, 0x00, 0x16, 0x03, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x06, 0x16, 0x00, 0x16,
	0x00, 0x10, 0x00, 0x16, 0x03, 0x16, 0x07, 0x0f,
	0x00, 0x13, 0x03, 0x16, 0x00, 0x16, 0x00, 0x13,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x10, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x13, 0x16, 0x00, 0x10, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x13, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x00, 0x16, 0x16, 0x00,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x03, 0x00, 0x16, 0x03, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x03, 0x16, 0x00, 0x16,
	0x00, 0x13, 0x03, 0x16, 0x00, 0x16, 0x00, 0x13,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x13, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x13, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16
};

static const ByteProvider kEoB1DscDimData2AmigaProvider = { ARRAYSIZE(kEoB1DscDimData2Amiga), kEoB1DscDimData2Amiga };

static const byte kEoB1DscBlockMapAmiga[12] = {
	0x02, 0x03, 0x00, 0x01, 0x01, 0x02, 0x03, 0x00,
	0x03, 0x00, 0x01, 0x02
};

static const ByteProvider kEoB1DscBlockMapAmigaProvider = { ARRAYSIZE(kEoB1DscBlockMapAmiga), kEoB1DscBlockMapAmiga };

static const byte kEoB1DscDimMapAmiga[18] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x03,
	0x03, 0x03
};

static const ByteProvider kEoB1DscDimMapAmigaProvider = { ARRAYSIZE(kEoB1DscDimMapAmiga), kEoB1DscDimMapAmiga };

static const byte kEoB1DscBlockIndexAmiga[72] = {
	0x9d, 0x9e, 0x9f, 0xa0, 0xa1, 0xa2, 0xa3, 0xbe,
	0xbf, 0xc0, 0xc1, 0xc2, 0xdf, 0xe0, 0xe1, 0xff,
	0x00, 0x01, 0xa3, 0xc3, 0xe3, 0x03, 0x23, 0x43,
	0x63, 0xc2, 0xe2, 0x02, 0x22, 0x42, 0xe1, 0x01,
	0x21, 0xe0, 0x00, 0x20, 0x63, 0x62, 0x61, 0x60,
	0x5f, 0x5e, 0x5d, 0x42, 0x41, 0x40, 0x3f, 0x3e,
	0x21, 0x20, 0x1f, 0x01, 0x00, 0xff, 0x5d, 0x3d,
	0x1d, 0xfd, 0xdd, 0xbd, 0x9d, 0x3e, 0x1e, 0xfe,
	0xde, 0xbe, 0x1f, 0xff, 0xdf, 0x20, 0x00, 0xe0
};

static const ByteProvider kEoB1DscBlockIndexAmigaProvider = { ARRAYSIZE(kEoB1DscBlockIndexAmiga), kEoB1DscBlockIndexAmiga };

static const byte kEoB1ClassModifierFlagsAmiga[15] = {
	0x01, 0x01, 0x05, 0x02, 0x04, 0x08, 0x05, 0x09,
	0x03, 0x0B, 0x0A, 0x0C, 0x07, 0x05, 0x06
};

static const ByteProvider kEoB1ClassModifierFlagsAmigaProvider = { ARRAYSIZE(kEoB1ClassModifierFlagsAmiga), kEoB1ClassModifierFlagsAmiga };

static const byte kEoB1MonsterStepTable01Amiga[4] = {
	0xE0, 0x01, 0x20, 0xFF
};

static const ByteProvider kEoB1MonsterStepTable01AmigaProvider = { ARRAYSIZE(kEoB1MonsterStepTable01Amiga), kEoB1MonsterStepTable01Amiga };

static const byte kEoB1MonsterStepTable2Amiga[8] = {
	0x07, 0xFA, 0x05, 0xFC, 0x03, 0xFE, 0x01, 0x00
};

static const ByteProvider kEoB1MonsterStepTable2AmigaProvider = { ARRAYSIZE(kEoB1MonsterStepTable2Amiga), kEoB1MonsterStepTable2Amiga };

static const byte kEoB1MonsterStepTable3Amiga[8] = {
	0xF9, 0x06, 0xFB, 0x04, 0xFD, 0x02, 0xFF, 0x00
};

static const ByteProvider kEoB1MonsterStepTable3AmigaProvider = { ARRAYSIZE(kEoB1MonsterStepTable3Amiga), kEoB1MonsterStepTable3Amiga };

static const byte kEoB1MonsterCloseAttPosTable1Amiga[4] = {
	0x00, 0x01, 0x03, 0x02
};

static const ByteProvider kEoB1MonsterCloseAttPosTable1AmigaProvider = { ARRAYSIZE(kEoB1MonsterCloseAttPosTable1Amiga), kEoB1MonsterCloseAttPosTable1Amiga };

static const byte kEoB1MonsterCloseAttPosTable21Amiga[8] = {
	0x00, 0x01, 0x02, 0x03, 0x00, 0x02, 0x01, 0x03
};

static const ByteProvider kEoB1MonsterCloseAttPosTable21AmigaProvider = { ARRAYSIZE(kEoB1MonsterCloseAttPosTable21Amiga), kEoB1MonsterCloseAttPosTable21Amiga };

static const byte kEoB1MonsterCloseAttChkTable1Amiga[16] = {
	0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00
};

static const ByteProvider kEoB1MonsterCloseAttChkTable1AmigaProvider = { ARRAYSIZE(kEoB1MonsterCloseAttChkTable1Amiga), kEoB1MonsterCloseAttChkTable1Amiga };

static const byte kEoB1MonsterCloseAttChkTable2Amiga[16] = {
	0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00
};

static const ByteProvider kEoB1MonsterCloseAttChkTable2AmigaProvider = { ARRAYSIZE(kEoB1MonsterCloseAttChkTable2Amiga), kEoB1MonsterCloseAttChkTable2Amiga };

static const byte kEoB1MonsterCloseAttDstTable1Amiga[16] = {
	0x02, 0x03, 0x00, 0x01, 0x01, 0x02, 0x03, 0x00,
	0x00, 0x01, 0x02, 0x03, 0x03, 0x00, 0x01, 0x02
};

static const ByteProvider kEoB1MonsterCloseAttDstTable1AmigaProvider = { ARRAYSIZE(kEoB1MonsterCloseAttDstTable1Amiga), kEoB1MonsterCloseAttDstTable1Amiga };

static const byte kEoB1MonsterCloseAttDstTable2Amiga[48] = {
	0x01, 0x00, 0x03, 0x02, 0x05, 0x04, 0x00, 0x01,
	0x02, 0x03, 0x04, 0x05, 0x05, 0x03, 0x01, 0x04,
	0x02, 0x00, 0x01, 0x03, 0x05, 0x00, 0x02, 0x04,
	0x04, 0x05, 0x02, 0x03, 0x00, 0x01, 0x05, 0x04,
	0x03, 0x02, 0x01, 0x00, 0x00, 0x02, 0x04, 0x01,
	0x03, 0x05, 0x04, 0x02, 0x00, 0x05, 0x03, 0x01
};

static const ByteProvider kEoB1MonsterCloseAttDstTable2AmigaProvider = { ARRAYSIZE(kEoB1MonsterCloseAttDstTable2Amiga), kEoB1MonsterCloseAttDstTable2Amiga };

static const byte kEoB1MonsterProximityTableAmiga[32] = {
	0x02, 0x03, 0x00, 0x01, 0x03, 0x02, 0x01, 0x00,
	0x00, 0x02, 0x01, 0x03, 0x02, 0x00, 0x03, 0x01,
	0x01, 0x00, 0x03, 0x02, 0x00, 0x01, 0x02, 0x03,
	0x03, 0x01, 0x00, 0x02, 0x01, 0x03, 0x02, 0x00
};

static const ByteProvider kEoB1MonsterProximityTableAmigaProvider = { ARRAYSIZE(kEoB1MonsterProximityTableAmiga), kEoB1MonsterProximityTableAmiga };

static const byte kEoB1FindBlockMonstersTableAmiga[64] = {
	0x04, 0x02, 0x01, 0x03, 0x04, 0x03, 0x00, 0x02,
	0x04, 0x00, 0x03, 0x01, 0x04, 0x01, 0x02, 0x00,
	0x04, 0x01, 0x02, 0x03, 0x04, 0x00, 0x03, 0x02,
	0x04, 0x03, 0x00, 0x01, 0x04, 0x02, 0x01, 0x00,
	0x04, 0x02, 0x01, 0x03, 0x04, 0x03, 0x00, 0x02,
	0x04, 0x00, 0x03, 0x01, 0x04, 0x01, 0x02, 0x00,
	0x04, 0x01, 0x02, 0x03, 0x04, 0x00, 0x03, 0x02,
	0x04, 0x03, 0x00, 0x01, 0x04, 0x02, 0x01, 0x00
};

static const ByteProvider kEoB1FindBlockMonstersTableAmigaProvider = { ARRAYSIZE(kEoB1FindBlockMonstersTableAmiga), kEoB1FindBlockMonstersTableAmiga };

static const byte kEoB1MonsterDirChangeTableAmiga[16] = {
	0xff, 0x06, 0x02, 0xff, 0x00, 0x07, 0x01, 0xff,
	0x04, 0x05, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff
};

static const ByteProvider kEoB1MonsterDirChangeTableAmigaProvider = { ARRAYSIZE(kEoB1MonsterDirChangeTableAmiga), kEoB1MonsterDirChangeTableAmiga };

static const uint16 kEoB1EncodeMonsterDefsAmiga[168] = {
	0x0000, 0x0000, 0x0007, 0x0060, 0x0007, 0x0028, 0x000c, 0x0039,
	0x0013, 0x0028, 0x000c, 0x0039, 0x001f, 0x0000, 0x0007, 0x0060,
	0x0000, 0x0060, 0x0007, 0x0060, 0x0007, 0x0060, 0x0007, 0x0060,
	0x000e, 0x0060, 0x0005, 0x0038, 0x0000, 0x0000, 0x0005, 0x0042,
	0x0007, 0x0000, 0x0008, 0x0027, 0x0013, 0x0000, 0x0008, 0x0027,
	0x001f, 0x0000, 0x0005, 0x0042, 0x001d, 0x0060, 0x0005, 0x0038,
	0x000e, 0x0098, 0x0003, 0x0020, 0x0000, 0x0000, 0x0004, 0x0030,
	0x0007, 0x0000, 0x0005, 0x001a, 0x0013, 0x0000, 0x0005, 0x001a,
	0x001f, 0x0000, 0x0004, 0x0030, 0x001f, 0x0098, 0x0003, 0x0020,
	0x0000, 0x0000, 0x0007, 0x0060, 0x0007, 0x0000, 0x0007, 0x0060,
	0x000e, 0x0000, 0x0007, 0x0060, 0x0015, 0x0000, 0x0007, 0x0060,
	0x001c, 0x0000, 0x0007, 0x0060, 0x0000, 0x0060, 0x0007, 0x0060,
	0x0007, 0x0060, 0x0006, 0x003f, 0x000d, 0x0060, 0x0006, 0x003f,
	0x0013, 0x0060, 0x0006, 0x003f, 0x0019, 0x0060, 0x0006, 0x003f,
	0x001b, 0x0060, 0x0005, 0x0038, 0x0020, 0x0060, 0x0005, 0x0038,
	0x0007, 0x008c, 0x0003, 0x002b, 0x000b, 0x008c, 0x0003, 0x002b,
	0x000f, 0x008c, 0x0003, 0x002b, 0x0013, 0x008c, 0x0003, 0x002b,
	0x0013, 0x0098, 0x0003, 0x0020, 0x0016, 0x0098, 0x0003, 0x0020,
	0x0000, 0x0000, 0x000a, 0x0057, 0x000a, 0x0000, 0x000a, 0x0057,
	0x0014, 0x0000, 0x000a, 0x0057, 0x001e, 0x0000, 0x000a, 0x0057,
	0x0000, 0x0058, 0x000a, 0x0057, 0x000a, 0x0058, 0x000a, 0x0057
};

static const Uint16Provider kEoB1EncodeMonsterDefsAmigaProvider = { ARRAYSIZE(kEoB1EncodeMonsterDefsAmiga), kEoB1EncodeMonsterDefsAmiga };

static const EoBCharacter kEoB1NpcPresetsAmiga[9] = {
	{ 0x00, 0x01,
	  18, 18, 59, 59,  5,  5, 11, 11, 14, 14, 16, 16,  9,  9,
	    45,   45, 10, 0, 1, 0, 2, -1, 100, { 4, 0, 0 },
	  { 0x00001F40, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  17, 17,  0,  0,  9,  9, 15, 15, 13, 13, 18, 18, 17, 17,
	    55,   55, 10, 0, 0, 0, 0, -2, 100, { 7, 0, 0 },
	  { 0x000130B0, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  11, 11,  0,  0, 17, 17, 13, 13, 18, 18,  8,  8, 12, 12,
	    20,   20, 10, 0, 4, 3, 4, -3, 100, { 7, 0, 0 },
	  { 0x00011170, 0x00000000, 0x00000000 }, 0x00B3126B,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  10, 10,  0,  0, 12, 12,  9,  9, 15, 15, 17, 17, 17, 17,
	    52,   52, 10, 0, 4, 4, 0, -4, 100, { 6, 0, 0 },
	  { 0x00004E20, 0x00000000, 0x00000000 }, 0xFFFFFFFF,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  16, 16,  0,  0, 14, 14, 16, 16, 18, 18, 17, 17,  7,  7,
	    45,   45, 10, 0, 1, 1, 2, -5, 100, { 6, 0, 0 },
	  { 0x0000CF08, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  17, 17,  0,  0, 11, 11, 14, 14, 19, 19, 18, 18, 16, 16,
	    32,   32, 10, 0, 10, 5, 5, -6, 100, { 5, 0, 0 },
	  { 0x00002D3F, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  17, 17,  0,  0, 11, 11, 15, 15, 15, 15, 19, 19,  9,  9,
	     3,   45,  3, 0, 6, 0, 1, -7, 25, { 5, 0, 0 },
	  { 0x00003F6A, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0024, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0029, 0x0000, 0x002B, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  18, 18, 29, 29, 13, 13, 11, 11, 16, 16, 17, 17, 14, 14,
	    28,   28, 10, 0, 6, 0, 0, -8, 100, { 3, 0, 0 },
	  { 0x000013A0, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0024, 0x0000, 0x0030, 0x0037, 0x0037, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0029, 0x0000, 0x002B, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  18, 18, 92, 92, 15, 15, 15, 15, 12, 12, 19, 19, 17, 17,
	     3,   45,  3, 0, 6, 0, 1, -9, 25, { 5, 0, 0 },
	  { 0x00001F40, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } }
};

static const EoBCharacterProvider kEoB1NpcPresetsAmigaProvider = { ARRAYSIZE(kEoB1NpcPresetsAmiga), kEoB1NpcPresetsAmiga };

static const byte kEoB1CouncilAnimData1Amiga[78] = {
	0x21, 0x58, 0x03, 0x10, 0x07, 0x60, 0x24, 0x58,
	0x03, 0x10, 0x07, 0x60, 0x00, 0x0b, 0x68, 0x02,
	0x08, 0x0b, 0x60, 0x0d, 0x68, 0x02, 0x08, 0x0b,
	0x60, 0x00, 0x0f, 0x68, 0x01, 0x08, 0x0f, 0x48,
	0x10, 0x68, 0x01, 0x08, 0x0f, 0x48, 0x00, 0x07,
	0x68, 0x02, 0x08, 0x21, 0x58, 0x09, 0x68, 0x02,
	0x08, 0x21, 0x58, 0x00, 0x00, 0x70, 0x03, 0x10,
	0x25, 0x60, 0x00, 0x80, 0x03, 0x10, 0x25, 0x60,
	0x00, 0x21, 0x48, 0x03, 0x10, 0x19, 0x50, 0x24,
	0x48, 0x03, 0x10, 0x19, 0x50, 0x00
};

static const ByteProvider kEoB1CouncilAnimData1AmigaProvider = { ARRAYSIZE(kEoB1CouncilAnimData1Amiga), kEoB1CouncilAnimData1Amiga };

static const byte kEoB1CouncilAnimData2Amiga[78] = {
	0x0f, 0x98, 0x03, 0x18, 0x00, 0x40, 0x0c, 0x98,
	0x03, 0x18, 0x00, 0x40, 0x00, 0x06, 0x70, 0x03,
	0x20, 0x07, 0x38, 0x03, 0x70, 0x03, 0x20, 0x07,
	0x38, 0x00, 0x03, 0x90, 0x03, 0x20, 0x0d, 0x38,
	0x00, 0x90, 0x03, 0x20, 0x0d, 0x38, 0x00, 0x09,
	0x98, 0x03, 0x18, 0x19, 0x38, 0x06, 0x98, 0x03,
	0x18, 0x19, 0x38, 0x00, 0x15, 0x98, 0x03, 0x18,
	0x1f, 0x40, 0x12, 0x98, 0x03, 0x18, 0x1f, 0x40,
	0x00, 0x1b, 0x98, 0x03, 0x18, 0x25, 0x38, 0x18,
	0x98, 0x03, 0x18, 0x25, 0x38, 0x00
};

static const ByteProvider kEoB1CouncilAnimData2AmigaProvider = { ARRAYSIZE(kEoB1CouncilAnimData2Amiga), kEoB1CouncilAnimData2Amiga };

static const byte kEoB1CouncilAnimData3Amiga[12] = {
	0x1f, 0x68, 0x07, 0x30, 0x11, 0x40, 0x18, 0x68,
	0x07, 0x30, 0x11, 0x40
};

static const ByteProvider kEoB1CouncilAnimData3AmigaProvider = { ARRAYSIZE(kEoB1CouncilAnimData3Amiga), kEoB1CouncilAnimData3Amiga };

static const byte kEoB1CouncilAnimData4Amiga[24] = {
	0x00, 0xb0, 0x05, 0x10, 0x00, 0x78, 0x09, 0x70,
	0x04, 0x28, 0x0c, 0x68,	0x11, 0x68, 0x07, 0x30,
	0x11, 0x60, 0x00, 0xb0,	0x05, 0x10, 0x1e, 0x78
};

static const ByteProvider kEoB1CouncilAnimData4AmigaProvider = { ARRAYSIZE(kEoB1CouncilAnimData4Amiga), kEoB1CouncilAnimData4Amiga };

static const byte kEoB1EyesAnimDataAmiga[28] = {
	0x01, 0x00, 0x0f, 0x01, 0x00, 0x0f, 0x02, 0x03,
	0x04, 0x0f, 0x01, 0x04, 0x0f, 0x01, 0x04, 0x0f,
	0x01, 0x04, 0x0f, 0x03, 0x02, 0x00, 0x0f, 0x02,
	0x03, 0x04, 0x28, 0xff
};

static const ByteProvider kEoB1EyesAnimDataAmigaProvider = { ARRAYSIZE(kEoB1EyesAnimDataAmiga), kEoB1EyesAnimDataAmiga };

static const uint16 kEoB1HandsAnimDataAmiga[24] = {
	0xfffd, 0x004c, 0x0018, 0x0047, 0x0036, 0x0041, 0x004c, 0x0039,
	0x0059, 0x0032, 0x00db, 0x0055, 0x00c2, 0x0049, 0x00a9, 0x003c,
	0x0090, 0x0030, 0x0057, 0x0035, 0x0059, 0x0034, 0x005b, 0x0033
};

static const Uint16Provider kEoB1HandsAnimDataAmigaProvider = { ARRAYSIZE(kEoB1HandsAnimDataAmiga), kEoB1HandsAnimDataAmiga };

static const byte kEoB1TextFrameDurationAmiga[153] = {
	0x04, 0x02, 0x05, 0x02, 0x0b, 0x02, 0x04, 0x02,
	0x08, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x02, 0x05, 0x02, 0x06, 0x02, 0x08,
	0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x02, 0x02, 0x05, 0x7e, 0x05,
	0x02, 0x03, 0x02, 0x03, 0x7e, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x02, 0x04, 0x02,
	0x05, 0x02, 0x07, 0x02, 0x02, 0x02, 0x06, 0x02,
	0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02,
	0x08, 0x02, 0x04, 0x02, 0x03, 0x02, 0x0a, 0x7f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x05, 0x02, 0x04, 0x02, 0x05, 0x02, 0x02, 0x05,
	0x02, 0x03, 0x02, 0x03, 0x02, 0x04, 0x02, 0x0a,
	0x7f
};

static const ByteProvider kEoB1TextFrameDurationAmigaProvider = { ARRAYSIZE(kEoB1TextFrameDurationAmiga), kEoB1TextFrameDurationAmiga };

static const char *const kEoB1SoundMapAmiga[120] = {
	"",
	"button",
	"L1M1A",
	"door",
	"door",
	"slam",
	"button",
	"button",
	"transmute",
	"eat",
	"magica",
	"throw",
	"plate",
	"passage",
	"unlock",
	"teleport",
	"undead",
	"pit",
	"itemland",
	"",
	"",
	"playhit",
	"death",
	"text",
	"electric",
	"dart",
	"dart",
	"unlock",
	"bonus",
	"bump",
	"",
	"electric",
	"playswing",
	"hum",
	"panel",
	"explode",
	"L10M2M",
	"L10M2A",
	"L4M1M",
	"beastatk",
	"L9M2M",
	"L8M1A",
	"L8M1M",
	"L7M1A",
	"L7M1M",
	"L5M1A",
	"L5M1M",
	"flindatk",
	"L3M2M",
	"L4M1A",
	"L8M2M",
	"houndatk",
	"scream",
	"L6M1M",
	"L3M1A",
	"L3M1M",
	"sloshsuck",
	"L1M2M",
	"flayeratk",
	"",
	"rustatk",
	"L9M1M",
	"L10M1A",
	"L10M1M",
	"blade",
	"L7M2M",
	"blade",
	"L2M2M",
	"L12M2A",
	"L12M2M",
	"",
	"L11M1M",
	"L11M1A",
	"L2M1A",
	"L2M1M",
	"L1M1M",
	"button",
	"",
	"drop",
	"text",
	"magicb",
	"lock",
	"",
	"",
	"",
	"Missile",
	"",
	"burnhands",
	"electric",
	"fireball",
	"",
	"magica",
	"magica",
	"magica",
	"magicb",
	"magicb",
	"acid",
	"magicb",
	"fireball",
	"acid",
	"magica",
	"magicb",
	"magicb",
	"undead",
	"magica",
	"magica",
	"magica",
	"magicb",
	"cause",
	"magicb",
	"magicb",
	"magica",
	"magicb",
	"magica",
	"magica",
	"magica",
	"magica",
	"cause",
	"",
	"door"
};

static const StringListProvider kEoB1SoundMapAmigaProvider = { ARRAYSIZE(kEoB1SoundMapAmiga), kEoB1SoundMapAmiga };

static const char *const kEoB1LevelSoundFiles1Amiga[26] = {
	"",
	"",
	"sloshsuck1",
	"",
	"blade1",
	"",
	"beastatk1",
	"",
	"rustatk1",
	"",
	"rustatk1",
	"blade1",
	"scream1",
	"",
	"blade1",
	"",
	"houndatk1",
	"",
	"rustatk1",
	"beastatk1",
	"blade1",
	"",
	"beastatk1",
	"flayeratk1",
	"",
	""
};

static const StringListProvider kEoB1LevelSoundFiles1AmigaProvider = { ARRAYSIZE(kEoB1LevelSoundFiles1Amiga), kEoB1LevelSoundFiles1Amiga };

static const char *const kEoB1LevelSoundFiles2Amiga[26] = {
	"",
	"",
	"move1",
	"leechmov1",
	"move21",
	"",
	"move21",
	"kuotoamov1",
	"spidermov1",
	"",
	"spidermov1",
	"move21",
	"move21",
	"",
	"move1",
	"move21",
	"move1",
	"spidermov1",
	"move1",
	"move21",
	"mantismov1",
	"move21",
	"move21",
	"",
	"move21",
	""
};

static const StringListProvider kEoB1LevelSoundFiles2AmigaProvider = { ARRAYSIZE(kEoB1LevelSoundFiles2Amiga), kEoB1LevelSoundFiles2Amiga };

static const char *const kEoB1SoundFilesIntroAmiga[6] = {
	"INTRO1.CPS",
	"INTRO2.CPS",
	"INTRO4.CPS",
	"INTRO5.CPS",
	"NEWINTRO1.CPS",
	"CHARGEN1.CPS"
};

static const StringListProvider kEoB1SoundFilesIntroAmigaProvider = { ARRAYSIZE(kEoB1SoundFilesIntroAmiga), kEoB1SoundFilesIntroAmiga };

static const char *const kEoB1SoundFilesIngameAmiga[5] = {
	"SFX1.CPS",
	"SFX2.CPS",
	"SFX3.CPS",
	"SFX4.CPS",
	"HUM1.CPS"
};

static const StringListProvider kEoB1SoundFilesIngameAmigaProvider = { ARRAYSIZE(kEoB1SoundFilesIngameAmiga), kEoB1SoundFilesIngameAmiga };

static const char *const kEoB1SoundFilesFinaleAmiga[3] = {
	"FINALE2.CPS",
	"FINALE1.CPS",
	"FINALE.CPS"
};

static const StringListProvider kEoB1SoundFilesFinaleAmigaProvider = { ARRAYSIZE(kEoB1SoundFilesFinaleAmiga), kEoB1SoundFilesFinaleAmiga };

