/*  This file is part of SAIL (https://github.com/HappySeaFox/sail)

    Copyright (c) 2020 Dmitry Baryshev

    The MIT License

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.
*/

#pragma once

#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>

#include <tiffio.h>

#include <sail-common/common.h>
#include <sail-common/export.h>
#include <sail-common/status.h>

struct sail_iccp;
struct sail_meta_data_node;
struct sail_resolution;
struct sail_variant;

SAIL_HIDDEN void tiff_private_my_error_fn(const char* module, const char* format, va_list ap);

SAIL_HIDDEN void tiff_private_my_warning_fn(const char* module, const char* format, va_list ap);

SAIL_HIDDEN enum SailCompression tiff_private_compression_to_sail_compression(int compression);

SAIL_HIDDEN sail_status_t tiff_private_sail_compression_to_compression(enum SailCompression compression,
                                                                       int* tiff_compression);

SAIL_HIDDEN enum SailPixelFormat tiff_private_bpp_to_pixel_format(int bpp);

SAIL_HIDDEN sail_status_t tiff_private_sail_pixel_format_from_tiff(TIFF* tiff, enum SailPixelFormat* result);

SAIL_HIDDEN sail_status_t tiff_private_sail_pixel_format_to_tiff(enum SailPixelFormat pixel_format,
                                                                  uint16_t* photometric,
                                                                  uint16_t* bits_per_sample,
                                                                  uint16_t* samples_per_pixel);

SAIL_HIDDEN void tiff_private_zero_tiff_image(TIFFRGBAImage* img);

SAIL_HIDDEN sail_status_t tiff_private_fetch_iccp(TIFF* tiff, struct sail_iccp** iccp);

SAIL_HIDDEN sail_status_t tiff_private_fetch_meta_data(TIFF* tiff, struct sail_meta_data_node*** last_meta_data_node);

SAIL_HIDDEN sail_status_t tiff_private_write_meta_data(TIFF* tiff, const struct sail_meta_data_node* meta_data_node);

SAIL_HIDDEN sail_status_t tiff_private_fetch_xmp(TIFF* tiff, struct sail_meta_data_node*** last_meta_data_node);

SAIL_HIDDEN sail_status_t tiff_private_write_xmp(TIFF* tiff, const struct sail_meta_data_node* meta_data_node);

SAIL_HIDDEN sail_status_t tiff_private_fetch_resolution(TIFF* tiff, struct sail_resolution** resolution);

SAIL_HIDDEN sail_status_t tiff_private_write_resolution(TIFF* tiff, const struct sail_resolution* resolution);

SAIL_HIDDEN bool tiff_private_tuning_key_value_callback(const char* key,
                                                        const struct sail_variant* value,
                                                        void* user_data);
