# Changelog

## Release 25.12 (2025-12-12)

### Breaking Changes

- Changed all uv fields to uvi, BREAKING change to UV sensors (#3131)
- Removed Python 2.7 support (#3320)

### Highlights

- Added support for GIF2020OCECNA to Orion-Endpoint (#3392)
- Added support for Voltcraft Energy Count 3000 (ec3k) (#3373)
- Added support for ORIA WA150KM freezer thermometer (#3143)
- Added support for Fine Offset Electronics WS85 weather station (#3354)
- Added support for UniFan-24V universal 24V fan controller (#3142)
- Added support for BM5-v2 battery monitor  (#3126)
- Added support for Baldr-E0666TH Thermo-Hygrometer (#3360)
- Added support for more Interlogix-Security sensor types (#3361)
- Added support for Fine Offset WH43 air quality sensor (#3303)
- Added support for newer smoke alarms to Interlogix-Security (#3163)
- Added support for Orion Endpoint Badger water meter GIF2014W-OSE (#3374)
- Added support for TFA 30.3802.02 to LaCrosse-R3 (#3366)
- Added support for Maverick-XR50 BBQ meat thermometer (#3293)
- Added support for Homelead-HG9901 soil sensor (#3299)
- Added support for Nexus-Sauna (#3327)
- Added support for ThermoPro TX-7B Outdoor Thermometer Hygrometer (#3311)
- Added support for Oregon Scientific THGR228N (closes #3121)
- Added support for BMW GEN2 TPMS (#3302)
- Added support for Apator Metra E-RM 30 water meter (#3203)
- Added support for RainPoint HCS012ARF Rain Gauge sensor (#3240)
- Added support for Oregon Scientific V3 models (#3234)
- Changed dB estimate to display true RSSI (#3283)
- Added gap+pulse period distribution to analyzer (#3263)
- Added availability online/offline MQTT LWT option (#1547)

### Changed

- Change Oil-SonicAdv depth to 12 bits (#3411)
- Added TX-Button to Oregon-THGR810 (closes #3413)
- Updated Windows cross-build to rtlsdr-2.0.2 (closes #3349)
- Updated AVE TPMS to battery_pct
- Fixed Visonic-Powercode decode on bad reception (#3340)
- Fixed overflow in rfraw test data parsing (closes #3375)
- Added decode_mc flex option
- Fixed unit_of_measurement for windspeed to mph in rtl_433_mqtt_hass.py (#3337)
- Fixed Steelmate pressure formula (#3209)
- Added demod state reset between input files (#3310)
- Fixed battery_ok in EcoWitt-WH40 (closes #3298)
- Added UCS vendor to LandisGyr-GS (#3280)
- Improve Truck TPMS decoder (#3272)
- Fixed HA script class for energy_kWh (closes #3255)
- Added Auriol HG11911 to list of supported devices (#3244)
- Fixed negative temperatures on RainPoint-Soil (#3212)

## Release 25.02 (2025-02-19)

### Breaking Changes

- Changed state key value to ON/OFF, BREAKING CHANGE for Waveman-Switch (#2946)

### Highlights

- Added support for General Motors TPMS (#3191)
- Added Globe Thermometer for 8-in-1 sensor to Bresser-7in1 (#3193)
- Added rain start detection feature for WS90 sensor (#3183)
- Added id key to IDM and NETIDM (#3164)
- Added decoder conf for Hormann remotes (#3162)
- Added client cert option to HA script (#3160)
- Added support for Revolt ZX-7717 power meter (#3125)
- Added support for Gridstream RF protocol from Landis & Gyr meters (#2616)
- Added decoder conf for Rako wireless lighting controls (#3124)
- Added support for Quinetic Switches and Sensors (#3098)
- Added support for DeltaDore X3D (#1911)
- Fixed Prometheus exposition format for metrics endpoint (#3107)
- Added support for Bresser/Explore Scientific ST1005H (#3092)
- Improved HA script to round battery level display (#3100)
- Fixed M-Bus Mode C Format B for wmbusmeters (#3091)
- Added support for Thermopro TP828B Meat Thermometers 2 probes (#3085)
- Added support for Arexx TL-3TSN, TSN-33MN and similar sensors (#3076)
- Improved decoder conf qx-30x to support multiple switches and multi-gang versions (#3008)

### Changed

- Changed LandisGyr-GS location output (#3185)
- Changed Rubicson, Nexus, Solight-TE44, Baldr-Rain priority (#3175)
- Added energy msg to Revolt-ZX7717
- Added broadcast flag for syslog output (#3171)
- Fixed argument handling in sigrok file generation (#3161)
- Fixed MQTT reconnect timer (closes #3145)
- Added reconnect throttling to Influx output (#3135)
- Added reconnect throttling to MQTT output (#3134)

## Release 24.10 (2024-10-30)

### Breaking Changes

- Changed to pm_2_5_ug_m3, pm_10_ug_m3, BREAKING change to Bresser-7in1 (#2953)
- Changed Smoke-GS558, Akhan-100F14 to default disabled BREAKING CHANGE (#2958)
- Changed distance_km to storm_dist_km, BREAKING change to Bresser-Lightning (#2855)

### Highlights

- Added support for Technoline TX960 to Acurite-606TX decoder (#3078)
- Added support for Risco 2 way Agility protocol, Risco PIR/PET Sensor RWX95PA (#3066)
- Added support for Rosstech Digital Control Unit DCU-706/Sundance/Jacuzzi (#2612)
- Added support for Arexx Multilogger (#2487)
- Updated Fineoffset-WS90 to new FW timings (#3063)
- Added decoder conf for oma blind remote (#3058)
- Added decoder conf for iVac Pro remote (#3049)
- Added Vevor Weather Station 7-in-1 (#3023)
- Added support for Ecowitt WH46 air quality sensor (#3010)
- Added open in browser script (#2158)
- Added decoder conf for Hornbach MSRC-SAL Awning remote (#3009)
- Added support for Geevon TX16-3 outdoor sensor (#2910)
- Added support for Arad Master Meter water utility meter (#2984)
- Added support for ThermoPro TP829b and Improve rtl_433_mqtt_hass.py (#2964)
- Added Support for Chamberlain CWPIRC pir sensor (#2962)
- Added support for Nice One to Nice-FlorS (#2960)
- Added Support for Ecowitt WN34D and improve FineOffset WN34 (#2944)
- Added decoder conf for rolleaseacmedia blind controller (#2947)
- Added decoder conf for Thomson kinetic doorbell (#2940)
- Added ST389 temperature sensor for ORIA WA50 freezer thermometer (#2937)
- Added decoder conf for Dewenwils BH-V (#2926)
- Added Support BMW Gen3 TPMS (#2900)
- Added decoder conf for self powered QX-305 & QX-302 switches (#2903)
- Improved BMW Gen4-Gen5 TPMS and Add Support Audi TPMS Pressure Alert (#2901)
- Added support for Audi TPMS and BMW Gen4 TPMS (#2897)
- Added support for ThermoPro TP28b (#2882)
- Added Support for Mueller Hot Rod water meter (#2887)
- Added Support for Thermor DG950 Weather Station (#2886)
- Added darker colors for light terminal backgrounds (#2864)
- Added support for Watts WFHT-RF thermostat (#2648)
- Added honor the NO_COLOR env var
- Added RTL433_COLOR=always/never/auto env var
- Added support for BMW Gen5 TPMS multi-brand HUF, Continental, Schrader/Sensata (#2834)
- Added support for Bresser CO2 PN 7009977 and HCHO/VOC PN 7009978 sensors (#2815)
- Added support for Fine Offset WN32B (closes #2303)
- Added support for Fine Offset / Ecowitt WH55 water leak sensor (closes #2756)
- Added support for TechniSat IMETEO X6 and improve Holman-AOK (#2759)
- Added Motonet MTX, MarQuant Rain note to Schou-72543 (#2686)

### Changed

- Added extract_bytes_uart_parity utility function
- Fixed Acurite-590TX timings (closes #3039)
- Changed rtl_433_mqtt_hass.py to add supercap_V key
- examples: Added dup filtering to mqtt_relay (#3018)
- Fixed wmbus raw data output length (#2749)
- examples: Added ability for mqtt_relay to use a config file (#3013)
- Added MQTT dedup republish filter example (closes #2990)
- Added TX-Button to inFactory-TH
- examples: Changed mqtt_relay to always use id in topic (#3014) (#3014)
- examples: Improved mqtt_relay to make individual and json topics optional (#2975)
- examples: Removed obsolete sigrok example scripts (#2979)
- Changed Klimalogg-Pro max humidity (closes #2967)
- Changed to type-safe data_append alternative (#2667)
- Fixed rain_rate_in_h template in HA script (#2782)
- Improved Ecowitt WH53 (#2934)
- Fixed Bresser-5in1 omit temp/hum on error
- Improved Wireless-MBus 3of6 decoding (#2883)
- Added HA script compat for paho-mqtt 2.0.0 via legacy callback API (#2916)
- Fixed Nissan TPMS pressure_PSI key (#2915)
- Changed HA script power to energy and UV index to float (#2913)
- Fixed Cotech-367959 lux and uv value (#2073)
- Fixed TPMS Nissan pressure_psi value (#2906)
- Fixed Bresser-6in1 rain vs temp (closes #2184)
- Changed a HA script device trigger to avoid duplicate trigger (#2829)
- Added some known fields to Marlec-Solar
- Added log rotate support for dumper files (#2876)
- Added contact_open reed_open mappings to rtl_433_mqtt_hass.py (#2881)
- Added microseconds to OOK pulse data outputs
- Added OpenMetrics/Prometheus API (#2863)
- Added strict checks to flex argument parsing
- Fixed EcoWitt-WS68 wind unit and decoding (#2871)
- Fixed event callback on shutdown (closes #2869)
- Fixed Badger-ORION return on decode success (#2854)
- Improved Bresser lightning correct msg length and lfsr digest check
- Improved FS20 decoding, add FHT support (#1783)
- Fixed properly install to /etc for /usr prefix (closes #2827)
- Added compatible model TST-507 TPMS to EezTire E618 (#2832)
- Fixed Bresser-7in1 to exclude unavailable sensor values (#2817)
- Added HTTP cmd API examples
- Fixed TPMS Elantra2012 for longer desync (closes #2806)
- Fixed KlikAanKlikUit-Switch for DIO remotes (#2789)
- Fixed rtl_433_mqtt_hass.py rain_in value template (#2801)
- Fixed Bresser-Lightning decoding of 'count' (#2797)
- Fixed detection of Bresser-ProRainGauge (#2431)
- Improved EcoWitt-WS68 LUX and UVI decoding and add units (#2790)
- Fixed Fineoffset-WS90 to support newer firmware (closes #2732)
- Added Ecowitt air quality sensors to rtl_433_mqtt_hass.py (#2772)
- Added mqtt base topic option (closes #2768)
- Added reading mqtt auth from env vars (closes #2769)
- Fixed converting inches to mm (#2755)
- Changed rtl_433_mqtt_hass.py to support storm_dist_km from WH31L (#2748)
- Added channel/button to Acurite-606TX
- Fixed TFA-303151 negative temps (closes #2538)
- Fixed temperature for Bresser 3-in-1 Wind Gauge (closes #2523)
- Improved code and annotations for cpplint (#2683)

## Release 23.11 (2023-11-28)

### Breaking Changes

- Changed conf dir defaults to just SYSCONFDIR (#2660)
- Changed verbosity of Protocols Registered output (#1700)
- Changed example conf file to use defaults (#2670)
- Changed help texts to print to stdout (#2542)
- Fixed Oregon Scientific channel renumbering, BREAKING change to THN132N channel 3 (#2033)
- Changed MQTT client ID to contain all params (#1129)
- Fixed GEO-minim matching, BREAKING change to id field (#2363)
- Changed Inkbird-ITH20R temperature2_C to temperature_2_C BREAKING change (#2220)

### Highlights

- Added support for Schou 72543 rain sensor (#2686)
- Added support for Bresser Lightning and Bresser Air Quality (#2698)
- Added support for Tekelek oil gauge (#2306)
- Added support for Nissan Leaf TPMS (#2536)
- Added support for Carchet TPMS (#2677)
- Added support for Bresser water leakage sensor PN: 7009975 (#2590)
- Added support for discovering Govee water sensors to rtl_433_mqtt_hass (#2605)
- Added support for newer Chuango DWC-102 close command (#2630)
- Added support for TFA Stratos 30.3151 and improve Fineoffset WH1050 (#2549)
- Added support for IROX ETS69 to Ewig Emos-TTX201 (#2547)
- Added support for ThermoPro TX-2C (#2466)
- Added support for Fineoffset WS90 (#2448)
- Added support for Acurite 592TX (#2457)
- Added support for Oregon Scientific AWR129 BBQ thermometer (#2439)
- Added support for Celsia CZC1 (#2391)
- Added support for Baldr/Rainpoint rain gauge (#2394)
- Added support for EezTire-E618 TPMS10ATC (#2387)
- Added support for LaCrosse TX31U-IT (#2386)
- Added support for Revolt Energy Monitor NC-5462 (#2361)
- Added support for Emax EM3551H with Gust without UV/Lux to Emax-W6 (#2376)
- Added support for Wireless M-Bus Mode T Downlink (#2366)
- Added support for Gasmate-BA1008 (#2359)
- Added support for Oil-SonicSmart (#2279)
- Added support for Watchman Sonic Advanced / Plus decoder (#2323)
- Added support for CED7000 timer (#2319)
- Added support for Emax Weather Sensor, improves Altronics X7064 sensor (#2300)
- Added support for TFA Dostmann 14.1504 Radio-controlled grill and meat thermometer (#2296)
- Added support for new revision of Govee H5054 water leak detector (#2273)
- Added support for Vauno EN8822C (#2231)
- Added support for WEC-2103 temperature/humidity sensor (#2185)
- Added support for Neptune R900 flow meters (#2180)
- Added support for SRSmith SRS-2C-TX Pool Remote Control (#2147)
- Added support for Kia Rio III (UB) and Hyundai TPMS sensors (#2083)
- Added support for TyreGuard 400 TPMS (#1976)
- Added support for GEO minim+ energy monitor (#1970)
- Added support for longer EFTH800 messages (#2278)
- Added decoder conf for PHOX garage gate opener (#2560)
- Added decoder conf for Driveway alarm motion sensor I8-W1901 (#2493)
- Added decoder conf for Reolink doorbell (#2277)
- Added decoder conf for SWETUP garage door remote (#2403)
- Added decoder conf for ELRO AB440 remote (#2066)
- Added decoder conf for xmas tree remote 2APJZ-CW002 (#2250)
- Added decoder conf for GE Smartremote Plus (#2249)
- Added standardized detect key for Govee-Water (#2625)
- Added restartable SDR device (#2411)
- Changed to async SDR acquire thread (#1978)
- Changed to second Ctrl-C is a hard abort
- Added log output, log redirect, colored KV log (#2254)

### Changed

- Changed rtl_433_mqtt_hass.py to use moisture class (#2726)
- Changed rtl_433_mqtt_hass.py to add battery_mV (#2725)
- Changed Fineoffset-WS90 packet size check (#2702)
- Fixed logging message in HA script (#2696)
- Added Pool/Spa Thermometer PN 7009973 note to Bresser-6in1 (#2689)
- Added php example stream script (#2687)
- Added checksum and battery_ok to WEC-2103 (#2662)
- Changed version number to exclude nightly tag
- Changed EezTire-E618 checksum, include flags (#2664)
- Changed startup help text to the actual help page (#2659)
- Improved some strcpy strncpy to snprintf
- Improved all plain sprintf to snprintf
- Fixed Somfy-IOHC length check (#2655)
- Added warning if firewall blocks loopback (#2621)
- Improved HA script with precipitation and wind speed class (#2643)
- Fixed Honeywell-CM921 temperature msg (#2637)
- Added Lidl Auriol 4-LD6313 and 4-LD5972 temperature/rain sensor (#2633)
- Improved HA script with current class (#2626)
- Improved handling of units within HA UI (#2624)
- Improved HA script with detailed units (#2607)
- Fixed HA script allow list id typo (#2602)
- Fixed Fineoffset-WH1050 return value (#2600)
- Fixed Inkbird-ITH20R battery_ok key and range (#2596)
- Fixed HA script remove device name from entities (#2594)
- Fixed HA script topics (#2593)
- Fixed malformed json on empty row print (#2588)
- Fixed Ecowitt-WS90 extra data output (#2585)
- Added description of startup bit to Bresser-5in1 (#2583)
- Fixed various spelling (#2579)
- Added lower temp bounds to Acurite-5n1, Acurite-Atlas (#2571)
- Added humidity_1, humidity_2 to rtl_433_mqtt_hass (#2567)
- Added timestamp to logs in rtl_433_mqtt_hass (#2566)
- Fixed HASS script rain_rate_mm_h typo (#2565)
- Fixed Eurochron-EFTH800 radio_clock hour decoding (#2526)
- Changed Fineoffset-WS90 to add firmware version (#2517)
- Changed ThermoPro TX-2C to enable humidity (#2514)
- Added radio clock to Fineoffset-WH1050 (#2463)
- Added battery voltage to EcoWitt-WH40 (#2488)
- Changed EMOS-E6016 wind speed and battery  (#2484)
- Improved Holman ws5029, Add support for AOK-5056 and correction for Emax (#2419)
- Fixed current frequency and sample rate info (#2468)
- Changed rtl_433_mqtt_hass to enable passing custom topics (PR #2289)
- Added extra digit to Oregon Scientific for AWR129 (#2446)
- Changed Acurite 896 rain gauge to default enabled (#2430)
- Changed CM160 output to double (#2428)
- Fixed CM160 energy calculation factor (#2427)
- Changed r_device.fields to constant pointer (#2421)
- Added total energy kWh to CM160 readings (#2418)
- Fixed Fitipower FC0012 gain quirk (#2417)
- Added unlockable rtl_tcp control (#2412)
- Fixed rtl_tcp for slow send buffers
- Fixed LibreSSL PSK error (#1569)
- Fixed Oil-SonicAdv missing messages
- Fixed LaCrosse-R1/LaCrosse-R3 rain value (#2313)
- Added char const check to symbolizer (#2390)
- Fixed flowis protocol decoding, alarm and back flow parameters.
- Changed literals to string const for strict discarded-qualifiers warnings (#2379)
- Added Schrader 3039 TPMS for Infiniti Nissan Renault note to Schrader-SMD3MA4
- Fixed Emax units (#2374)
- Added TLS debug info for influxs and mqtts
- Fixed Emax LUX decoding (#2346)
- Fixed Vauno-EN8822C false positives (#2364)
- Added Flowis protocol decoder (#2357)
- Added Wireless M-Bus, Mode T Downlink (#2366)
- Fixed out-of-bounds in Klimalogg-Pro (#2362)
- Fixed Somfy-RTS for wrong bitrate (#2356)
- Changed all r_device declarations to const (#2352)
- Fixed pointer restrict for C++ compilers (#2351)
- Fixed TFA-141504v2 decoder length check (#2339)
- Added radio clock decode to Eurochron-EFTH800 (#2331)
- Changed Somfy-IOHC to recognize more messages (#2258)
- Fixed Oregon Scientific negative temp, add BCD sanity checks (#2086)
- Added ESIC/SCMplus fields to rtl_433_mqtt_hass (#2114)
- Changed LaCrosse TX invalid humidity handling (#2335)
- Fixed json keys for wmbus to be unique (#2316)
- Fixed Bresser-ProRainGauge rain digits (#2312)
- Fixed light reading on Cotech-367959 when no sensor installed (#2305)
- Fixed HCS200 serial ID decoding (#2308)
- Added TLS options to InfluxDB output
- Added output log level options (#2282)
- Added ANSI colors for Windows 10 (#2280)
- Fixed to use pthread compat on WIN32 always
- Fixed battery flag in AmbientWeather-WH31E/WH31B (#2272)
- Changed more fprintf to log prints
- Changed fprintf to log prints (#2266)
- Changed verbosity to match log level (#2264)
- Added basic logger (#2263)
- Fixed JSON output string escaping
- Fixed Win32 thread calling convention
- Added decode_dm flex option (#2241)

## Release 22.11 (2022-11-19)

### Breaking Changes

- Fixed irregular model names (#1883)
    - "Inkbird ITH-20R" -> "Inkbird-ITH20R"
    - "LaCrosse-WS7000-27/28" -> "LaCrosse-WS700027"
    - "LaCrosse-WS7000-22/25" -> "LaCrosse-WS700022"
    - "LaCrosse-WS7000-16" -> "LaCrosse-WS700016"
    - "LaCrosse-WS7000-15" -> "LaCrosse-WS700015"
    - "LaCrosse-WS7000-20" -> "LaCrosse-WS700020"
    - "LaCrosse-WS2500-19" -> "LaCrosse-WS250019"
    - "Abarth 124 Spider" -> "Abarth-124Spider"
    - "Jansite Solar" -> "Jansite-Solar"
    - "Klimalogg Pro" -> "Klimalogg-Pro"
    - "Secplus_v1" -> "Secplus-v1"
    - "SCM+" -> "SCMplus"
- Changed light_klx to light_lux in Bresser-7in1 (#2061)
- Removed VS15 project files

### Highlights

- Added rtl_tcp pass-through output (#1915)
- Added realtime replay option for file inputs
- Added support for Badger ORION water meter (#2089)
- Added support for Rubicson pool thermometer 48942 (#2137)
- Added support for Fine Offset WN34 temperature sensor (#2122)
- Added support for KS200/KS300 to ELV WS2000 (#2103)
- Added support for Maverick XR-30 (#2090)
- Added support for Fine Offset WH45 air quality sensor
- Added support for HCS200/HCS300 based remotes with FSK transmitters (#2052)
- Added support for Emos E6016 Rain Gauge (#2032)
- Added support for ANT and ANT+ devices (#2004)
- Added support for Altronics X7064 sensor (#2000)
- Added support for EMOS 6016 (#1983)
- Added support for FineOffset WS80 weather station (#1965)
- Added support for Renault-0435R TPMS (#1924)
- Added support for AcuRite 01190 Leak Detector (#1953)
- Added support for Regency ceiling fans (#1948)
- Added support for Microchip HCS300 KeeLoq remotes BREAKING CHANGE (#1752)
- Added support for Yale HSA (#1929)
- Added support for SimpliSafe-Gen3 (#1257)
- Added support for AVE TPMS (#1909)
- Added decoder conf for sgooway door detector (#1707)
- Added decoder conf for ContinentalRemote (#2125)
- Added decoder conf for Mondeo remote (#1282)
- Added decoder conf for LeakDetector
- Added decoder conf for Heatilator-Gas-Log (#1963)
- Added decoder conf for Honeywell-Fan (#1962)
- Added decoder conf for DrivewayAlert (#1928)
- Added decoder conf for GhostControls (#1922)
- Added Threads if available

### Changed

- Added note regarding WH51 915MHz decoding (#2236)
- Added publish secret knocks as device automations
- Added time, channel, and button device automation triggers
- Improved false positives for acurite_01185m (#2214)
- Changed rtl_433_mqtt_hass rain value template round to two digits (#2210)
- Changed rtl_433_mqtt_hass value templates round to one digit (#2209)
- Fixed Chuango devices with some zeroes in their ID (#2205)
- Changed Proove/Nexa/Kaku to support Smartwares SH4-90152 (#2174)
- Changed Acurite TXR decoder to improve validation (#2162)
- Fixed Efergy-e2CT current above 53 Amp (#2166)
- Added sanity check to Ambient Weather F007th (#2155)
- Added decode symbol helper and flex option (#2161)
- Added InFactory PT-310 support to Rubicson (#2123)
- Added HTTP API example scripts
- Changed rain gauge multiplier for Auriol-4LD5661 (#2129)
- Added CSV names for flex getters with unique mode
- Added php example script (#2087)
- Improved Ford TPMS decoder (#2071)
- Fixed crash when reading a conf file (#2068)
- Changed SDR data buffers to persist valid
- Added ERT-SCM consumption data to mqtt hass mappings (#2023)
- Added id filter to mqtt hass (#1988)
- Fixed overflow in Acurite-00275rm (#2012)
- Changed the PCM/NRZ/RZ naming
- Added cmake option to select IPv6 support
- Fixed EMOS-6016 checksum, add DCF77
- Added bitbuffer_find_repeated_prefix function
- Fixed pulse reset on spurious pulses (#1982)
- Removed confusing -G register all option
- Changed hass script duplicate dict key 'light_lux' back to 'lux' for legacy reasons (#1989)
- Added Honeywell-cm921 Ticker and Heat Demand commands (#1985)
- Changed most decoder-verbose to log level
- Changed fprintf in decoders to decoder_log
- Added decoder log to replace bitbuffer bitrow print
- Added decoder log to replace fprintf
- Fixed Digitech-XC0324 humidity readings (FT-005TH Sensor) (#1971)
- Changed wt0124 to use additional checksum (#1959)
- Added diagnostic entity category to mqtt hass example (#1952)
- Removed invalid "weather" device class in HASS script (#1584)
- Added trigger stream output (#1910)
- Changed Hideki to accept short sync (#1908)

## Release 21.12 (2021-12-14)

### Highlights

- Added noise stats, autolevel, and squelch (#1763)
- Added automatic file format detection from filename
- Added support for SmartFire Proflame 2 remote control (#1905)
- Added support for Lacrosse TX34 rain gauge (#1890)
- Added support for Telldus-FT0385R (#1841)
- Added support for GE Choice Alert wireless alarm sensors (#1768)
- Added support for Porsche Boxter/Cayman TPMS
- Added support for Funkbus/Instafunk (#1896)
- Added support for Truck TPMS (#1893)
- Added support for LaCrosse LTV-W1 wind sensor (#1855)
- Added support for Auriol 4-LD5661 temperature/rain sensor (#1843)
- Added support for Linear Megacode Remote (#1834)
- Added support for EnOcean ERP1 decoder (#1829)
- Added support for Acurite-01185M (#1824)
- Added support for ATech-WS308 temperature sensor (#1605)
- Added support for RainPoint sensor (#1781)
- Added support for Inkbird ITH-20R
- Added support for Clipsal CMR112 cent-a-meter power meter (#1814)
- Added support for Govee Water Leak Detector H5054 and Govee Contact Sensor B5023 (#1653)
- Added support for Markisol curtain remote (#1775)
- Added support for Oregon Scientific BTHR918 (#1767)
- Added UV index add decimals to Bresser-7in1 (#1789)
- Changed InfluxDB output of 'mic' from field to tag (#1773)
- Added biastee, digital_agc, direct_samp, offset_tune option for rtlsdr and rtl_tcp (#1788)
- Added QoS to MQTT options (#1769)

### Changed

- Changed PCM slicer to measure bit length in more cases (#1897)
- Added CS8 as file input format
- Added decoder priority stages (#1895)
- Fixed fprintf to use an unsigned marker when an unsigned value is given (#1872)
- Added RTL_433_REDUCE_STACK_USE to reduce size of bitbuffers (#1863)
- Fixed rainpoint msg buffer must be initialized (#1862)
- Fixed Reduce stack use in slicers (#1860)
- Fixed Windows CreateTimerQueueTimer alarm handle is not valid for CloseHandle (#1859)
- Changed HASS script to logging (#1851)
- Added SwitchDocLabs SM23 note
- Added SwitchDocLabs F016TH note
- Added SwitchDocLabs FT020T note
- Fixed Inovalley-kw9015b rain bits (#1660)
- Added battery_ok to Bresser-7in1 (#1795)
- Added HASS long term statistics (#1835)
- Added bitbuffer row spill
- Updated Govee Leak Sensor with new parity check (#1810)
- Fixed Springfield-Soil/AlectoV1 false positives
- Fixed LaCrosse-TH3 checksum (#1398)
- Added cmake found lib versions output

## Release 21.05 (2021-05-09)

### Highlights

- Last release to support Autotools (autoconf, automake) builds (#1644)
- Last release to offer "oldmodel" keys (deprecated since 2020)
- Added Github Release builds for Windows
- Added GPSd tags option (#1636)
- Added optional TLS support to MQTT (#1633)
- Added OpenSSL support for influxs TLS (#1569)
- Added support for ELK-319DWM, Alula RE101 to Interlogix (#1711)
- Added conf for Tesla charge port opener (#1704)
- Added support for  Hyundai-VDO TPMS (#1643)
- Added support for TX25U dual channel temp sensor
- Added support for Honeywell CM921/BDR91/Evohome (#1336)
- Added support for Auriol AFT 77 B2
- Added support for Auriol AHFL (#1683)
- Added support for Bresser Professional Rain Gauge (#1676)
- Added support for TFA Marbella pool thermometer (#1675)
- Added support for Amazon Basics Meat Thermometer (#1671)
- Added support for Owl 180i support
- Added support for Jansite TPMS Model Solar (#1663)
- Added support for Cavius alarms (#1648)
- Added support for Security plus v1 (#1483)
- Added conf for Skylink HA-434TL motion sensor (s.a. #814)
- Added support for Burnhard BBQ thermometer (#1624)
- Added support for wmbus water meter Maddalena (#1610)
- Added conf for ATC Technology LMT-430 (#1600)
- Added support for Blueline PowerCost Monitor
- Added conf for FAN-53T (#1588)
- Added support for Acurite 515 fridge/freezer sensors (#1579)
- Added support for TelFix-RadioLoop (#1571)
- Added conf for Salus RT300RF thermostat, Heatmiser PRT-W thermostat (#1573)

### Changed

- Added Release build workflow
- Added pressure_kPa key for HA (#1712)
- Added support for ELK-319DWM, Alula RE101 to Interlogix (#1711)
- Fixed and style Honeywell CM921
- Added option to set force_update for all sensors (#1695)
- Added Tesla charge port opener decoder conf (#1704)
- Added battery flags to Bresser 7in1 (#1703)
- Fixed Hyundai-VDO TPMS
- Added Hyundai-VDO TPMS (#1643)
- Added X10 Dim, Bright, All Lights ON, and All Off commands (#1687)
- Added support for TX25U dual channel temp sensor
- Fixed code warnings
- Fixed code style
- Added forgotten id
- Added Honeywell CM921/BDR91/Evohome decoder (#1336)
- Added Auriol AFT 77 B2 protocol decoder
- Fixed Holman-WS5029 rain count (#1686)
- Fixed explanation of supposed PM10 (estimated) value (#1678)
- Added support for Auriol AHFL protocol (#1683)
- Fixed PSI calculation for Ford TPMS
- Added support for higher pressure range in Ford TPMS
- Fixed secplus_v1 endless loop (#1662)
- Fixed secplus_v1 overflow
- Added support for some Ecowitt WH41 sensor signals
- Added comment regarding PM10 readings in the FineOffset WH0290 decoder
- Added support for Bresser Professional Rain Gauge (#1676)
- Added TFA Marbella pool thermometer protocol decoder (#1675)
- Added Amazon Basics Meat Thermometer decoder (#1671)
- Fixed exit if http server can't start
- Fixed missing sdr_stop for WIN32
- Added Owl 180i support
- Added website and sensor specifications for Jansite TPMS Model Solar (#1666)
- Added decoder for jansite solar tpms (#1663)
- Added Ford TPMS pressure and temperature (#1654)
- Fixed http redirect to index for Chrome
- Added support for Cavius alarms (#1648)
- Added mqtt token slash accepts any character
- Added variable fm low pass filter option
- Added support for Security plus v1 (#1483)
- Added GPSd tags option (#1636)
- Added FineOffset WH0290 extra fields (#1639)
- Fixed Hideki Gust speed by Udo Kirsten
- Added option for multiple data tags
- Added optional TLS support to MQTT (#1633)
- Added OpenSSL support for influxs TLS (#1569)
- Added LaCrosse TX141TH-Bv2 checksum
- Changed rain field format for WS2032
- Added m_bus decoded values + HCA (#1630)
- Changed battery_ok, rain field for WS2032
- Fixed m_bus Show invalid dates as invalid (#1628)
- Fixed mqtt retain on hass script (#1602)
- Added Skylink HA-434TL motion sensor conf (s.a. #814)
- Added support for Burnhard BBQ thermometer (#1624)
- Added TFA 30.3208.02 note (#1622)
- Added raw pulse printing mode
- Added support for parsing timedate in wbus (#1616)
- Added Battery Level for Fineoffset WH0290 Wireless Air Quality Monitor (#1617)
- Fixed Blueline tweaks and improvements (#1590)
- Added support for wmbus water meter Maddalena (#1610)
- Changed soil moisture to percent display (#1595)
- Added ATC Technology LMT-430 conf (#1600)
- Fixed buffer length in honeywell (#1598)
- Fixed buffer size error (#1596)
- Fixed FineOffset WH1050 field widths (#1592)
- Added support for Blueline PowerCost Monitor
- Added FAN-53T decoder conf (#1588)
- Added support for Acurite 515 fridge/freezer sensors (#1579)
- Fixed invalid HASS "weather" device_class (#1548)
- Fixed rtlsdr_read_async() abort on read stall (#1581)
- Fixed rtlsdr_set_freq_correction non-error code
- Added support for UV index and light intensity readings in Cotech (#1575)
- Fixed false positive bug in Nexus (#1576)
- Added support for TelFix-RadioLoop to Somfy (#1571)
- Added Thermostat example conf files with mqtt outputs (#1573)
- Added lacrosse decoder sanity checks

## Release 20.11 (2020-11-13)

### Highlights

- HTTP server, JSON-RPC
- Added RfRaw analyzer output and format input support
- Added support for LaCrosse Technology View LTV-R1 Rainfall Gauge
- Added support for ECODHOME smart socket
- Added support for LaCrosse Technology View TH2 Thermo/Hygro sensor
- Added support for Bresser 6-in-1, 7-in-1 weather station
- Added support for LaCrosse Technology View TH3 Thermo/Hygro Sensor
- Added support for LaCrosse LTV-WR1 Multi Sensor
- Added support for Nice Flor-s remote
- Added support for Schrader TPMS SMD3MA4 (Subaru)
- Added support for MightyMule Driveway Alarm FM231
- Added support for Somfy RTS
- Added support for LaCrosse LTV-WSDTH01
- Added support for TFA 30.3221.02 Temperature/Humidity sensor
- Added support for Security plus v2 keyfob
- Added support for Acurite Atlas and Atlas Lightning Detector
- Added support for Acurite 590TX
- Added support for ThermoPro TX2
- Added support for IDM and NetIDM decoders
- Added support for Insteon decoder
- Added support for LaCrosse TX141B
- Added support for Sharp SPC775
- Added support for Missil ML0757
- Added support for Fineoffset WH32
- Added support for Abarth124 TPMS sensor
- Added support for Fine Offset WH1080 FSK version
- Added support for SCM+ decoder
- Added support for Kerui WD51 Water leak sensor
- Added support for Cotech 36-7959
- Added support for Eurochron EFTH-800
- Added support for Visonic Powercode devices
- Added support for Klimalogg decoder and needed nrzs demodulator

### Changed

- Added support for LaCrosse Technology View R1 Rainfall Gauge (#1553)
- Added http server (#871)
- Added jsmn json lib
- Added support for ECODHOME smart socket (#1544)
- Fixed Lacrosse-THx hardcoded strings to support data extractor scripts
- Added support for LaCrosse Technology View TH2 Thermo/Hygro sensor (#1552)
- Added stats start time reporting
- Fixed Analyzer FSK/OOK hint (#1557)
- Improved unit tests for bitbuffer with extra assertions
- Fixed UNUSED in term_ctl
- Removed "http" as "influx" alias
- Added arguments and docs to Home Assistant MQTT auto discovery script (#1546)
- Changed LaCrosse LTV-WR1 to wind_avg_km_h key (#1549)
- Fixed rfraw builder overflow (#1539)
- Added Dooya Curtain Remote conf (#1545)
- Added SDR loop api
- Changed to sig_atomic_t for sighandler
- Fixed wmbus csv output parameters
- Fixed flags field for TPMS Jansite (#1538)
- Added note for TFA Dostmann 30.3159.IT (#1537)
- Added SDR runtime settings api
- Changed exit async naming
- Added SDR device info
- Added support for Bresser 6-in-1, 7-in-1 weather station (#1225)
- Added support for LaCrosse Technology View TH3 Thermo/Hygro Sensor (#1536)
- Added support for LaCrosse LTV-WR1 Multi Sensor (#1533)
- Added support for Nice Flor-s remote (#1526)
- Changed remove DSC subtype key (#1522)
- Changed Acurite subtype key to message_type (#1520)
- Added support for WH31E RCC packet type (#1528)
- Fixed wmbus mode S buffer length issue for Lansen meters
- Added SoapySDR to MinGW-w64 build
- Added output format option to flex getters (#1532)
- Added TFA 30.3209 note to Nexus (#1516)
- Added TFA-Dostmann 30.3161 rain scale (#1531)
- Fixed Insteon string overflow
- Fixed missing CSV fields, add a debug check
- Added named output tag option (#1517)
- Added support for Schrader TPMS SMD3MA4 (Subaru) (#1511)
- Removed unneeded update_protocol
- Changed width calc from r_device to slicers (#1513)
- Added support for mightymule driveway alarm FM231 (#1407) (#1515)
- Changed rfraw parse to accept multiple codes
- Fixed include for memcmp in rfraw (#1507)
- Added id key to scmplus (#1503)
- Removed list of supported device protocols from man page (#1345)
- Added RfRaw analyzer output support
- Added RfRaw format input support
- Removed FSK_PULSE_MANCHESTER_ZEROBIT from ook_demods
- Fixed Inovalley kw9015b temp/rain fields proper
- Fixed Inovalley kw9015b temp/rain fields (#1501)
- Added support for Somfy RTS (#1496)
- Added 7-bit clean strings check to actions
- Added maintainer_update check
- Fixed Security+ 2.0 decoder for new gap_limit rows (#1498)
- Added clang-analyzer action
- Added build action
- Added style check action
- Improved PCM NRZ 0-bit slicing precision
- Fixed output keys for FineOffset WH51 (#1495)
- Fixed index bug in TFA 30.3221
- Fixed simplisafe non-printable character output
- Added support for LaCrosse LTV-WSDTH01 (#1485)
- Added gap_limit to PCM demod
- Fixed invalid dumpers on ook input (#1463)
- Added support for TFA 30.3221.02 Temperature/Humidity sensor (#1426)
- Fixed Acurite 6045 temperature 2.0F too low (#1482 #1401)
- Added support for Security plus v2 keyfob (#1480)
- Fixed opus_xt300 added sanity check to data values (#1470)
- Fixed runtime error 'left shift of 229 by 24 places cannot be represented in type int (#1479)
- Fixed bad conf for Fan-11t (#1477)
- Added came top432 flex decoder config (#1474)
- Fixed wmbus raw telegram output, mainly for wmbusmeters use
- Fixed efergy_e2_classic False Trigger (#1475)
- FIXed check manchester_decode check decoded bit length in a consistent method, removed superfluous comment
- FIXed check manchester_decode result length
- Fixed current_cost 8 bytes required
- Fixed TPMS Abarth124 false positive (#1466)
- Fixed alectov1 csv fields (#1457)
- Added Atlas Lightning Detector support (#1418)
- Added Acurite Atlas support (#1124)
- Added Nexus-TE82s compatibility note (#1455)
- Updated idm scmplus Meter type list (#1445)
- Added Acurite 590TX support (#1411)
- Added ThermoPro TX2 support (#1450)
- Improved program exit code in case of error (#1451)
- Improved Home Assistant MQTT auto discovery (#1390)
- Fixed Many False Positives (#1444)
- Fixed Globaltronics QUIGG GT-TMBBQ-05 false positives (#1443)
- Fixed Oregon Scientific SL109H false positives (#1442)
- Added IDM and NetIDM decoders (#1421)
- Changed Fineoffset WH32 to exclude pressure
- Added Insteon decoder (#1285)
- Added Friedland EVO door bell conf
- Added support for LaCrosse TX141B (#1434)
- Added missing parts for Sharp SPC775 decoder
- Added Sharp SPC775 support (#1433)
- Added support for Missil ML0757
- Fixed use of return code in Abarth Spider decoder
- Added conditional to data_make (#1432)
- Added support for Fineoffset WH32 (#1431)
- Added bit reversed output for HCS200 decoder to match official tools
- Added reverse32 function
- Improved x10sec add sensors, tamper, crc (#1413)
- Improved inFactory e.g. MIC (#1325)
- Changed Kerui to break out additional fields from state (#1018)
- Updated rtl_433.example.conf
- Improved validations checks for smoke_gs558 protocol
- Added Equation/Siemens ADLM FPRF remote conf
- Added Abarth124 tpms sensor support
- Added missing protocol to readme
- Added attenuation histogram output (#1387)
- Added Fine Offset WH1080 FSK version support
- Improved FSK demodulation of distorted signals better
- Added SCM+ decoder (#1410)
- Added support for Kerui WD51 Water leak sensor (#1406)
- Fixed cancel watchdog when reading from file input
- Fixed ERT Endpoint Type extraction (#1379)
- Added custom data processor example
- Improved Honeywell sensor support (#1384)
- Added delay and low battery codes for DS10A door sensor (#1397)
- Fixed free results from SoapySDR API
- Fixed handle empty filenames
- Added support for Cotech 36-7959 (#1382)
- Removed deprecated positional flex syntax
- Changed div 10 to mul 0.1 in all decoders
- Changed value scaling for double to float in all decoders
- Changed checks on Rubicson/Nexus/Solight
- Fixed Bresser 5in1 Wind calculation (#1353)
- Improved MQTT Home Assistant example (#1357)
- Added decode_uart util (#1376)
- Fixed Eurochron EFTH-800 missing mic
- Added Eurochron EFTH-800 support (#1375)
- Fixed MQTTT mgr free
- Fixed Soapy string leaks
- Added Prometheus/OpenMetrics relay example (#1371)
- Fixed missing levels with minmax demod (fixes #1363)
- Fixed socket portability
- Fixed visonic device battery reporting
- Improved visonic_powercode
- Fixed rtl_tcp gain/rate/freq status output
- Fixed missing WSAStartup in rtl_tcp
- Added support for Visonic Powercode devices (#1349)
- Added message length check for ESIC EMT7110.
- Updated Acurite 6045 to capture all 8 bits of strike counter (#1348)
- Added configuration file for SMC5326 (#1346)
- Updated template guideline for verbosity (#1344)
- Fixed failing style-check test by adding allocation check to write-sigrok
- Added support for sigrok convert on windows (#1341)
- Fixed flex map parse
- Changed -l n to -Y level=n
- Changed detector level limits to dB
- Fixed Fineoffset-WHx080 temperature (#1327)
- Fixed Ecowitt-WH53, Maverick-ET73 timings
- Fixed Klimalogg device settings, tolerance was set to low
- Added Klimalogg decoder and needed nrzs demodulator
- Fixed negative temperatures in wmbus decoder
- Added pulse-eval example

## Release 20.02 (2020-02-17)

### Highlights

- Added InfluxDB output (#1192)
- Added native Sigrok writer (#1297)
- Changed to newmodel keys default
- Fixed SoapySDR for 0.8 API
- Added new minmax FSK pulse detector
- Changed default to use new minmax detector and sample rate of 1MS/s for frequency above 800MHz
- Changed -a and -G option to discourage usage
- Improvements and support for many more sensors

### Changed

- Changed CurrentCost and EfergyOptical keys to have units (#1313)
- Added command line information when new defaults are active
- Added mic to csv output in the ert decoder
- Added subtype to DSC (#1318)
- Added meta to OOK output
- Fixed json escaping (#1299)
- Added ERT SCM protocol decoder
- Added return codes for most devices
- Changed remaining wind dir keys (see #1019)
- Fixed optparse strtod with rounding (#1308)
- Fixed for wmbus records parser
- Added integrity check for Thermopro TP11 and TP12
- Fixed conf eol comments (#1307)
- Added config for unknown car key.
- Fixed sync word for Honeywell CMI alarm systems
- Fixed Wno-format-security for nixos gcc9 (#1306)
- Fixed negative length in data_array (#1305)
- Added native Sigrok writer (#1297)
- Added checksum check for Rubicson 48659 meat thermometer
- Changed Updated Fan 11t conf (#1287)
- Fixed failure on low sample rates (#1290)
- Improved format conversions
- Fixed radiohead-ask buffer overflow (#1289)
- Changed Enable IKEA Sparsnäs by default
- Changed cmake build to static lib
- Changed to newmodel keys default
- Changed model TFA-Drop-30.3233.01 to TFA-Drop
- Added config for Fan-11T fan remote (#1284)
- Added preliminary EcoWitt WS68 Anemometer support (#1283)
- Added EcoWitt WH40 support (#1275)
- Improved PCM RZ bit width detection
- Fixed for #1114 DSC Security Contact WS4945 (#1188)
- Fixed LaCrosse TX145wsdth repeat requirement
- Added preliminary LaCrosse TX141TH-BV3 support
- Fixed SoapySDR for 0.8 API
- Fixed Auriol AFW2A1 missing check
- Changed flex decode to count as successful output
- Added Nexus compatible sensor descriptions
- Improved LaCrosse TX29-IT support (#1279)
- Added LaCrosse TX145wsdth support (#1272)
- Changed KNX-RF output
- Added support for Lansen wmbus door/window sensor
- Improved PCM bit period detection
- Fixed OS PCR800 and RGR968 displayed unit name
- Fixed battery_level in Fineoffset-WH51
- Fixed type of battery_mv in Fineoffset-WH51 (#1274)
- Added reflected LFSR util
- Added support for TFA Drop 30.3233.01 (#1255)
- Added Auriol AFW2A1 support (#1230)
- Added Verisure Alarm config file
- Added wmbus mode S support and KNX RF telegram support.
- Added support for decoding Lansen and Bmeters wmbus based temperature/hygrometers
- Improved Honeywell 2Gig support
- Changed -a and -G option to discourage usage
- Added support for WS2032 weather station (#1208)
- Added timezone offset print option (#1207)
- Added LaCrosse TX141W support
- Added battery level to Fineoffset WH51
- Added Archos-TBH support (#1199)
- Added Oregon ID_THGR810a ID_WGR800a version ids (#1258)
- Improved OWL CM180 support (#1247)
- Added Holman iWeather WS5029 older PWM (#947)
- Added support for FineOffset/ECOWITT WH51 (#1242)
- Added config for 21 key remote
- Added rtlsdr_find_tuner_gain for exact gains
- Improved fineoffset more heuristics to separate WH65B and WH24
- Fixed missing csv fields on default disabled
- Improved Efergy Optical decoder (#1229)
- Added TX-button to some decoders (#1205)
- Improved for TFA pool temperature sensor (#1219)
- Added pulse analyzer support for read OOK data (#1216)
- Fixed ook input support bug from a9de888 (#1215)
- Fixed missing hop_time when reading file (#1211)
- Fixed Acurite 899 rain_mm conversion value (#1203)
- Fixed build files (#1201)
- Added more input format validation
- Changed FSK pulse detector mode option
- Fixed overlong msg in Radiohead (#1190)
- Added optional CSA checker to tests
- Added InfluxDB output (#1192)
- Fixed Hondaremote for missing first bit
- Fixed integer promotion for uint32_t fields (#1193)
- Fixed data format in ELV (#1187)
- Fixed closing brace bug in test bitbuffer (#1186)
- Fixed issue where bt_rain  decoder uses -1 as index
- Changed if the set frequency is > 800MHz then set sample rate to 1MS/s
- Added new minmax FSK pulse detector
- Added InfluxDB relay example script
- Fixed radiohead buffer underflow (#1181)
- Fixed range clamping on RSSI (#1179)
- Fixed unaligned sample buffer length (#1177)
- Fixed bad event return value in elantra (#1176)
- Fixed accounting if decoder misbehaves (#1175)
- Fixed ge_coloreffects undef behav (#1173)
- Added protocol selection to test bitbuffer input
- Added streaming test bitbuffers (#1062)
- Fixed parsing oversized bitbuffer (#1171)
- Added length check for interlogix device and update return codes (#1169)
- Added preamble check for microchip hcs200 to reduce false positives (#1170)
- Added unboxed types for data
- Added warnings on alloc failure
- Added alloc checks, fixes #1156
- Improved Compact doubles in mqtt devices topics
- Added Auriol-HG02832 support (#1166)
- Improved Honeywell for 2Gig, RE208 (#747)
- Changed Upgrade Mongoose 6.13+patches to 6.16+patches
- Fixed expand Efergy-e2CT exp range (#1163)
- Added RTL-SDR error code output
- Added Hyundai Elantra 2012 TPMS support (#1158)
- Added Norgo NGE101 support (#1042)
- Improved Convert read OOK pulse_data to current sample rate (#1160)
- Fixed Acurite 899 rain_mm format (#1154)
- Added gt_tmbbq05 parity check
- Changed GT-WT-03 added checksum (#1149)
- Changed Updated QUIGG GT-TMBBQ-05 with MIC
- Changed GT-TMBBQ-05 added ID, finetuned pulse lengths (#1152)
- Added Sonoff RM433 conf example (#1150)
- Added support for Globaltronics GT-WT-03 (#1149)
- Added support for QUIGG GT-TMBBQ-05 (#1151)
- Improved Reorder some keys, normalize some keys (#998)
- Improved Oregon Scientific V3 preamble match
- Added support for Oregon Scientific WGR800X (#1045)
- Added Integration docs
- Added RRD example script

## Release 19.08 (2019-08-29)

### Highlights

- Added MQTT output (#1016)
- Added stats reporting (#733)
- Added SoapySDR general keyword settings option, e.g. antenna
- Added new model keys option
- Changed Normalize odd general keys on devices (#1010)
- Changed Use battery_ok instead of battery for newmodel
- Added report model description option (#987)
- Added pulse data text file support (#967)
- Added color to console help output
- Fixed CF32 loader; addeded CS8, CF32 dumper

### Changed

- Added CurrentCost EnviR support (#1115)
- Added ESIC-EMT7170 power meter (#1132)
- Added LaCrosse-TX141Bv3 support (#1134)
- Added channel to inFactory-TH (#1133)
- Added man page rtl_433.1 (#1121)
- Added color to console help output
- Added support for Philips AJ7010 (#1047)
- Added frequency hopping signal support for win32 (#1128)
- Added Holman WS5029 decoder
- Added Acurite Rain 899 support
- Added support for Oregon scientific THGR328N and RTGR328N (#1107) (#1109)
- Added frequency hop on USR1 signal
- Added '-E hop' option
- Added option for multiple hop times
- Added sensor similar to GT-WT-02 (#1080)
- Added Rubicson 48659 Cooking Thermometer
- Added TFA Dostmann 30.3196 decoder (#983)
- Added support for HCS200 KeeLoq encoder (#1081)
- Added channel output to lacrosse_TX141TH_Bv2 (#1097)
- Added IKEA Sparsnäs decoder.
- Added support for Eurochron weather station sensor (#1090)
- Added MQTT topic format strings (#1079)
- Added two EV1527 based sample configurations (#1087)
- Added DirecTV RC66RX Remote Control
- Added support for Ecowitt temperature sensor
- Added Companion WTR001 decoder (#1055)
- Changed Thermopro TP12 also supports TP20 (#1061)
- Added configuration for PIR-EF4 sensor (#1049)
- Added Alecto WS-1200 v1/v2/DCF decoders to Fineoffset (#975)
- Added TS-FT002 decoder (#1015)
- Added Fine Offset WH32B support (#1040)
- Added LaCrosse-WS3600 support, change LaCrosse-WS to LaCrosse-WS2310
- Added LaCrosse WS7000 support (#1029) (#1030)
- Changed Omit humidity on Prologue if invalid
- Added MQTT output (#1016)
- Added stats reporting (#733)
- Added Interface Specification for data output (#827)
- Added checksum to Ambient Weather TX-8300
- Added Interlogix glassbreak subtype
- Added Jansite TPMS support (#1020)
- Added Oregon Scientific RTHN129 support (#941)
- Changed Use battery_ok instead of battery for newmodel
- Changed Update battery_low, temperatureN keys
- Changed Normalize odd general keys on devices (#1010)
- Fixed Efergy-e2 current reading exponent
- Added FS20 remote decoder (#999)
- Added SoapySDR general keyword settings option
- Added option to select antenna on SoapySDR devices (#968)
- Fixed CF32 loader; added CS8, CF32 dumper
- Added ASAN to Debug builds
- Changed tfa_twin_plus_30.3049: Add mic to output
- Added new model keys option
- Enhanced Kedsum, S3318, Esperanza with MIC (#985)
- Added support for XT300/XH300 soil moisture sensor (#946)
- Changed Schrader unit from bar to kPa
- Added report model description option (#987)
- Added native scale for SDRplay
- Added Chungear BCF-0019x2 example conf
- Changed GT-WT-02 to support newer timings; changed model name
- Added pulse data text file support (#967)
- Added Digitech XC0346 support to Fine Offset WH1050 (#922)
- Added bitbuffer NRZI(NRZS/NRZM) decodes
- Added Rosenborg/WH5 quirk to Fineoffset
- Added support for Silverline doorbells (#942)
- Changed TPMS Toyota to match shorter preamble
- Changed TPMS Citroen data readings
- Changed TPMS Renault data readings
- Added Digitech XC-0324 temperature sensor decoder (#849)
- Added sample rate switching
- Added Mongoose

## Release 18.12 (2018-12-16)

### Highlights

- Added conf file support with examples in etc/rtl_433/
- Default KV output has pretty colors on console
- Added meta data for levels, precision time, protocol, debug, tagging
- Added rtl_tcp input (#894)
- Added SoapySDR support with CU8/CS16/F32 input/output conversions (#842)
- Added VCD output, Sigrok pulseview converter

### Changed

- Install example conf files will to etc/rtl_433/
- Default output is terse with just the most important info
- Deprecate option q and D for new v to set verbosity
- Default KV output has pretty colors on console
- Added debug bits output option
- Added protocol number meta data option
- Added precision time and time report options (#905)
- Deprecate option t and I for new S none|all|unknown|known
- Changed to use pulse detect to track and grab frames
- Added rtl_tcp input (#894)
- Added bitrow debugging output helper
- Added bitbuffer_debug, bitrow_print, bitrow_debug
- Changed flex to use keys for all values (#885)
- Allow multiple input files, positional args are input files
- Added option for output tagging
- Added conf examples for generic SCV2260 and PT2260
- Added a conf file parser (#790)
- Added negative protocol numbers to disable a device
- Added Freq/RSSI/SNR output to data_acquired_handler (#865)
- Added flex suggestion to analyzer output, switch to unit of us
- Added null output option (suppress default KV)
- Added option to skip the tests to be built. (#832)
- Added SoapySDR support (#842)
- Added CU8/CS16 output conversion
- Improved dumpers to allow multiple dumpers
- Removed rtlsdr sync mode
- Added VCD output
- Added Sigrok pulseview converter
- Added f32 output modes
- Added flex getter (#786)
- Added version (-V) and help (-h) option (#810)
- Added example MS Visual Studio 2015 project (#789)
- Added CS16 input and output (#773)
- Added preamble option to flex decoder

### Added and improved devices

- Added Gust to Hideki, report proper mph (#891)
- Changed raincounter_raw field to rain_inch for acurite (#893)
- Removed EC3k, converted to flex conf
- Removed Valeo, converted to flex conf
- Removed Steffen, converted to flex conf
- Changed ELV-EM1000, ELV-WS2000 to structured output
- Changed X10-RF to structured output
- Changed Lightwave-RF to structured output
- Added confs ported from old devices
- Improved Fine Offset WH-3080 to support new version Watts/m value calculation
- Added support for Bresser Weather Center 5-in-1
- Added Biltema rain gauge protocol decoder, disabled by default
- Added ESA 1000/2000 protocol decoder
- Added support for Honeywell Wireless Doorbell
- Improved inFactory with added checks, enabled by default
- Added Maverick et73
- Added Ambient Weather WH31E (#882)
- Added AmbientWeather-TX8300 (TFA 30.3211.02) support
- Added Emos TTX201 (#782)
- Added Hideki / Cresta temperature sensor (#858)
- Added Fine Offset WH65B support (#845)
- Added AcuRite 3-n-1 (#720)
- Added PMV-107J TPMS (#825)
- Added Fine Offset WH65b support
- Added Fine Offset WH24 (#809)
- Added TP08 remote thermometer (#750)
- Added WT0124 Pool Thermometer
- Added Hyundai WS sensor (#779)
- Added M-Bus (EN 13757-4) - Data Link layer (#768)
- Improved RadioHead to unify the applications
- Added Sensible Living protocol (#742)
- Added Oregon Scientific UVR128 UV sensor (#738)
- Added Pacific PMV-C210 TMPS support (#717)
- Added SimpliSafe Sensor (#721)

## Release 18.05 (2018-05-02)

### Highlights

- Preparations for features like MQTT and SoapySDR
- Syslog for simple network output
- Rewritten demodulators to support a "precise" mode using a given tolerance and optional sync symbols
- Simplified data output layers

### Changed

- Added conversion hPA/inHG, kPa/PSI (#711)
- Added remote syslog output
- Added a flexible general purpose decoder (#647)
- Added git version info to usage output if available
- Added number suffixes on e.g. frequency, samplerate, duration, hoptime
- Added Profile build type using GPerfTools
- Changed grab file name to gNNN_FFFM_RRRk.cu8 (#642)
- Added option to use receiver serial number -d :SERIAL (#648)
- Added option to stop after outputting successful event(s)
- Changed to new data API
- Added option to verify simulated decoding of raw data

### Added and improved devices

- Added decoder for Dish Network UHF Remote 6.3 (#700)
- Added interlogix devices driver (#649)
- Added Euroster 3000TX, Elro DB270 (#683)
- Added x10_sec device for decoding X10 Security RF signals (#671)
- Added device LaCrosse TX141 support to lacrosse_TX141TH_Bv2.c (#670)
- Added GE Color Effects Remote indent and MAX_PROTOCOLS
- Added support for Telldus variants of fineoffset (#639)
- Added support to Oregon Scientific RTGN129
- Added device NEXA LMST-606 magnetic sensor
- Added support for Philips outdoor temperature sensor
- Added support for Ford car remote.
- Added support for the Thermopro TP-12.
- Added infactory sensor
- Added Renault TPMS sensor
- Added Ford TPMS sensor
- Added Toyota TPMS sensor
- Added GE Color Effects remote control
- Added Generic off-brand wireless motion sensor and alarm system
- Added Wireless Smoke and Heat Detector GS 558
- Added Solight TE44 wireless thermometer
