#include "schpriv.h"
#include "schvers.h"
#include "schminc.h"

/* Generated by the build process in the build area; might simply
   redirect to "startup.inc": */
#include "cstartup.inc"

#ifndef SCHEME_STARTUP_DEFINED

static Scheme_Linklet *eval_linklet_string(const char *str, intptr_t len, int extract)
{
  Scheme_Object *port, *expr;

  if (len < 0)
    len = strlen(str);
  port = scheme_make_sized_byte_string_input_port(str, -len); /* negative means it's constant */

  if (extract) {
    /* expr is a linklet bundle; 'startup is mapped to the linklet */
    expr = scheme_read_linklet_bundle_hash(port);
    return (Scheme_Linklet *)scheme_hash_tree_get((Scheme_Hash_Tree *)expr,
                                                  scheme_intern_symbol("startup"));
  } else {
    expr = scheme_internal_read(port, 1, 1, -1, scheme_init_load_on_demand ? scheme_true : scheme_false);
    return scheme_compile_and_optimize_linklet(scheme_datum_to_syntax(expr, scheme_false, 0),
                                               scheme_intern_symbol("startup"));
  }
}

static Scheme_Linklet *startup_linklet()
{
#define EVAL_ONE_STR(str) return eval_linklet_string(str, -1, 0)
#define EVAL_ONE_SIZED_STR(str, len) return eval_linklet_string(str, len, 1)
  EVAL_STARTUP;
}

void scheme_init_startup(void)
{
  /* called once (not per-place) */
}

void scheme_init_startup_instance(Scheme_Instance *inst)
{
  /* called per-places */
  scheme_instantiate_linklet_multi(startup_linklet(), inst, 0, NULL, 0);
}

#endif
