% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bats.R, R/ggplot.R, R/tbats.R
\name{plot.bats}
\alias{plot.bats}
\alias{autoplot.tbats}
\alias{autoplot.bats}
\alias{plot.tbats}
\title{Plot components from BATS model}
\usage{
\method{plot}{bats}(x, main = "Decomposition by BATS model", ...)

\method{autoplot}{tbats}(object, range.bars = FALSE, ...)

\method{autoplot}{bats}(object, range.bars = FALSE, ...)

\method{plot}{tbats}(x, main = "Decomposition by TBATS model", ...)
}
\arguments{
\item{x}{Object of class \dQuote{bats/tbats}.}

\item{main}{Main title for plot.}

\item{...}{Other plotting parameters passed to \code{\link[graphics:par]{graphics::par()}}.}

\item{object}{Object of class \dQuote{bats/tbats}.}

\item{range.bars}{Logical indicating if each plot should have a bar at its
right side representing relative size. If \code{NULL}, automatic selection
takes place.}
}
\value{
None. Function produces a plot
}
\description{
Produces a plot of the level, slope and seasonal components from a BATS or
TBATS model. The plotted components are Box-Cox transformed using the estimated transformation parameter.
}
\examples{

\dontrun{
fit <- tbats(USAccDeaths)
plot(fit)
autoplot(fit, range.bars = TRUE)
}

}
\seealso{
\code{\link[=bats]{bats()}}], \code{\link[=tbats]{tbats()}}
}
\author{
Rob J Hyndman
}
\keyword{hplot}
