/***************************************************************************
                              qgswfsserver.h
                              -------------------
  begin                : February 27, 2012
  copyright            : (C) 2012 by René-Luc D'Hont
  email                : rldhont at 3liz dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGSWFSSERVER_H
#define QGSWFSSERVER_H

#include <QDomDocument>
#include <QMap>
#include <QString>
#include <map>
#include "qgis.h"
#include "qgsvectorlayer.h"

class QgsCoordinateReferenceSystem;
class QgsComposerLayerItem;
class QgsComposerLegendItem;
class QgsComposition;
class QgsFields;
class QgsMapLayer;
class QgsMapRenderer;
class QgsPoint;
class QgsRasterLayer;
class QgsConfigParser;
class QgsVectorLayer;
class QgsCoordinateReferenceSystem;
class QgsField;
class QgsFeature;
class QgsRectangle;
class QgsGeometry;
class QgsSymbol;
class QgsRequestHandler;
class QFile;
class QFont;
class QImage;
class QPaintDevice;
class QPainter;


/**This class handles all the wms server requests. The parameters and values have to be passed in the form of
a map<QString, QString>. This map is usually generated by a subclass of QgsWMSRequestHandler, which makes QgsWFSServer
independent from any server side technology*/

class QgsWFSServer
{
  public:
    /**Constructor. Takes parameter map and a pointer to a renderer object (does not take ownership)*/
    QgsWFSServer( QMap<QString, QString> parameters );
    ~QgsWFSServer();
    /**Returns an XML file with the capabilities description (as described in the WFS specs)*/
    QDomDocument getCapabilities();

    /**Returns an XML file with the describe feature type (as described in the WFS specs)*/
    QDomDocument describeFeatureType();

    /**Creates a document that describes the result of the getFeature request.
       @return 0 in case of success*/
    int getFeature( QgsRequestHandler& request, const QString& format );

    /**Read and apply the transaction
       @return 0 in case of success*/
    QDomDocument transaction( const QString& requestBody );

    /**Sets configuration parser for administration settings. Does not take ownership*/
    void setAdminConfigParser( QgsConfigParser* parser ) { mConfigParser = parser; }

  private:
    /**Don't use the default constructor*/
    QgsWFSServer();

    /**Get service address from REQUEST_URI if not specified in the configuration*/
    QString serviceUrl() const;

    /**Map containing the WMS parameters*/
    QMap<QString, QString> mParameterMap;
    QgsConfigParser* mConfigParser;
    /* The Type of Feature created */
    QString mTypeName;
    /* The list of Feature's Type requested */
    QStringList mTypeNames;
    QString mPropertyName;
    bool mWithGeom;
    /* Error messages */
    QStringList mErrors;

  protected:

    void startGetFeature( QgsRequestHandler& request, const QString& format, QgsCoordinateReferenceSystem& crs, QgsRectangle* rect );
    void sendGetFeature( QgsRequestHandler& request, const QString& format, QgsFeature* feat, int featIdx, QgsCoordinateReferenceSystem& crs, QgsAttributeList attrIndexes, QSet<QString> excludedAttributes );
    void endGetFeature( QgsRequestHandler& request, const QString& format );

    //method for transaction
    QgsFeatureIds getFeatureIdsFromFilter( QDomElement filter, QgsVectorLayer* layer );

    //methods to write GeoJSON
    QString createFeatureGeoJSON( QgsFeature* feat, QgsCoordinateReferenceSystem& crs, QgsAttributeList attrIndexes, QSet<QString> excludedAttributes ) /*const*/;

    //methods to write GML2
    QDomElement createFeatureGML2( QgsFeature* feat, QDomDocument& doc, QgsCoordinateReferenceSystem& crs, QgsAttributeList attrIndexes, QSet<QString> excludedAttributes ) /*const*/;

    //methods to write GML3
    QDomElement createFeatureGML3( QgsFeature* feat, QDomDocument& doc, QgsCoordinateReferenceSystem& crs, QgsAttributeList attrIndexes, QSet<QString> excludedAttributes ) /*const*/;
};

#endif
