
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StdSelect_Shape.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Face.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <SelectMgr_EntityOwner.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <SelectMgr_EntityOwner.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <SelectMgr_EntityOwner.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <StdSelect.hxx>
#include <StdSelect_BRepOwner.hxx>
#include <StdSelect_BRepSelectionTool.hxx>
#include <StdSelect_EdgeFilter.hxx>
#include <StdSelect_FaceFilter.hxx>
#include <StdSelect_Shape.hxx>
#include <StdSelect_ShapeTypeFilter.hxx>
#include <StdSelect_TypeOfEdge.hxx>
#include <StdSelect_TypeOfFace.hxx>
#include <StdSelect_TypeOfSelectionImage.hxx>
#include <StdSelect_ViewerSelector3d.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <V3d_Viewer.hxx>

// Module definiiton
void register_StdSelect(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("StdSelect"));
py::object klass;

//Python trampoline classes

// classes

    // Class StdSelect from ./opencascade/StdSelect.hxx
    klass = m.attr("StdSelect");

    // default constructor
    register_default_constructor<StdSelect , shared_ptr<StdSelect>>(m,"StdSelect");

    // nested enums

    static_cast<py::class_<StdSelect , shared_ptr<StdSelect>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("SetDrawerForBRepOwner_s",
                    (void (*)( const opencascade::handle<SelectMgr_Selection> & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<SelectMgr_Selection> & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&StdSelect::SetDrawerForBRepOwner),
                    R"#(puts The same drawer in every BRepOwner Of SensitivePrimitive Used Only for hilight Of BRepOwner...)#"  , py::arg("aSelection"),  py::arg("aDrawer")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdSelect_BRepOwner from ./opencascade/StdSelect_BRepOwner.hxx
    klass = m.attr("StdSelect_BRepOwner");


    // nested enums

    static_cast<py::class_<StdSelect_BRepOwner ,opencascade::handle<StdSelect_BRepOwner>  , SelectMgr_EntityOwner >>(klass)
    // constructors
        .def(py::init< const Standard_Integer >()  , py::arg("aPriority") )
        .def(py::init< const TopoDS_Shape &,const Standard_Integer,const Standard_Boolean >()  , py::arg("aShape"),  py::arg("aPriority")=static_cast<const Standard_Integer>(0),  py::arg("ComesFromDecomposition")=static_cast<const Standard_Boolean>(Standard_False) )
        .def(py::init< const TopoDS_Shape &,const opencascade::handle<SelectMgr_SelectableObject> &,const Standard_Integer,const Standard_Boolean >()  , py::arg("aShape"),  py::arg("theOrigin"),  py::arg("aPriority")=static_cast<const Standard_Integer>(0),  py::arg("FromDecomposition")=static_cast<const Standard_Boolean>(Standard_False) )
    // custom constructors
    // methods
        .def("HasShape",
             (Standard_Boolean (StdSelect_BRepOwner::*)() const) static_cast<Standard_Boolean (StdSelect_BRepOwner::*)() const>(&StdSelect_BRepOwner::HasShape),
             R"#(returns False if no shape was set)#" 
          )
        .def("HasHilightMode",
             (Standard_Boolean (StdSelect_BRepOwner::*)() const) static_cast<Standard_Boolean (StdSelect_BRepOwner::*)() const>(&StdSelect_BRepOwner::HasHilightMode),
             R"#(Returns true if this framework has a highlight mode defined for it.)#" 
          )
        .def("SetHilightMode",
             (void (StdSelect_BRepOwner::*)( const Standard_Integer  ) ) static_cast<void (StdSelect_BRepOwner::*)( const Standard_Integer  ) >(&StdSelect_BRepOwner::SetHilightMode),
             R"#(Sets the highlight mode for this framework. This defines the type of display used to highlight the owner of the shape when it is detected by the selector. The default type of display is wireframe, defined by the index 0.)#"  , py::arg("theMode")
          )
        .def("ResetHilightMode",
             (void (StdSelect_BRepOwner::*)() ) static_cast<void (StdSelect_BRepOwner::*)() >(&StdSelect_BRepOwner::ResetHilightMode),
             R"#(Resets the higlight mode for this framework. This defines the type of display used to highlight the owner of the shape when it is detected by the selector. The default type of display is wireframe, defined by the index 0.)#" 
          )
        .def("HilightMode",
             (Standard_Integer (StdSelect_BRepOwner::*)() const) static_cast<Standard_Integer (StdSelect_BRepOwner::*)() const>(&StdSelect_BRepOwner::HilightMode),
             R"#(Returns the highlight mode for this framework. This defines the type of display used to highlight the owner of the shape when it is detected by the selector. The default type of display is wireframe, defined by the index 0.)#" 
          )
        .def("IsHilighted",
             (Standard_Boolean (StdSelect_BRepOwner::*)( const opencascade::handle<PrsMgr_PresentationManager> & ,  const Standard_Integer  ) const) static_cast<Standard_Boolean (StdSelect_BRepOwner::*)( const opencascade::handle<PrsMgr_PresentationManager> & ,  const Standard_Integer  ) const>(&StdSelect_BRepOwner::IsHilighted),
             R"#(Returns true if an object with the selection mode aMode is highlighted in the presentation manager aPM.)#"  , py::arg("aPM"),  py::arg("aMode")=static_cast<const Standard_Integer>(0)
          )
        .def("HilightWithColor",
             (void (StdSelect_BRepOwner::*)( const opencascade::handle<PrsMgr_PresentationManager> & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Integer  ) ) static_cast<void (StdSelect_BRepOwner::*)( const opencascade::handle<PrsMgr_PresentationManager> & ,  const opencascade::handle<Prs3d_Drawer> & ,  const Standard_Integer  ) >(&StdSelect_BRepOwner::HilightWithColor),
             R"#(None)#"  , py::arg("thePM"),  py::arg("theStyle"),  py::arg("theMode")
          )
        .def("Unhilight",
             (void (StdSelect_BRepOwner::*)( const opencascade::handle<PrsMgr_PresentationManager> & ,  const Standard_Integer  ) ) static_cast<void (StdSelect_BRepOwner::*)( const opencascade::handle<PrsMgr_PresentationManager> & ,  const Standard_Integer  ) >(&StdSelect_BRepOwner::Unhilight),
             R"#(Removes highlighting from the type of shape identified the selection mode aMode in the presentation manager aPM.)#"  , py::arg("aPM"),  py::arg("aMode")=static_cast<const Standard_Integer>(0)
          )
        .def("Clear",
             (void (StdSelect_BRepOwner::*)( const opencascade::handle<PrsMgr_PresentationManager> & ,  const Standard_Integer  ) ) static_cast<void (StdSelect_BRepOwner::*)( const opencascade::handle<PrsMgr_PresentationManager> & ,  const Standard_Integer  ) >(&StdSelect_BRepOwner::Clear),
             R"#(Clears the presentation manager object aPM of all shapes with the selection mode aMode.)#"  , py::arg("aPM"),  py::arg("aMode")=static_cast<const Standard_Integer>(0)
          )
        .def("SetLocation",
             (void (StdSelect_BRepOwner::*)( const TopLoc_Location &  ) ) static_cast<void (StdSelect_BRepOwner::*)( const TopLoc_Location &  ) >(&StdSelect_BRepOwner::SetLocation),
             R"#(None)#"  , py::arg("aLoc")
          )
        .def("UpdateHighlightTrsf",
             (void (StdSelect_BRepOwner::*)( const opencascade::handle<V3d_Viewer> & ,  const opencascade::handle<PrsMgr_PresentationManager> & ,  const Standard_Integer  ) ) static_cast<void (StdSelect_BRepOwner::*)( const opencascade::handle<V3d_Viewer> & ,  const opencascade::handle<PrsMgr_PresentationManager> & ,  const Standard_Integer  ) >(&StdSelect_BRepOwner::UpdateHighlightTrsf),
             R"#(Implements immediate application of location transformation of parent object to dynamic highlight structure)#"  , py::arg("theViewer"),  py::arg("theManager"),  py::arg("theDispMode")
          )
        .def("DumpJson",
             (void (StdSelect_BRepOwner::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (StdSelect_BRepOwner::*)( std::ostream & ,  Standard_Integer  ) const>(&StdSelect_BRepOwner::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&StdSelect_BRepOwner::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&StdSelect_BRepOwner::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (StdSelect_BRepOwner::*)() const) static_cast<const opencascade::handle<Standard_Type> & (StdSelect_BRepOwner::*)() const>(&StdSelect_BRepOwner::DynamicType),
             R"#(None)#"
             
         )
       .def("Shape",
             (const TopoDS_Shape & (StdSelect_BRepOwner::*)() const) static_cast<const TopoDS_Shape & (StdSelect_BRepOwner::*)() const>(&StdSelect_BRepOwner::Shape),
             R"#(Returns the shape.)#"
             
         )
;

    // Class StdSelect_BRepSelectionTool from ./opencascade/StdSelect_BRepSelectionTool.hxx
    klass = m.attr("StdSelect_BRepSelectionTool");

    // default constructor
    register_default_constructor<StdSelect_BRepSelectionTool , shared_ptr<StdSelect_BRepSelectionTool>>(m,"StdSelect_BRepSelectionTool");

    // nested enums

    static_cast<py::class_<StdSelect_BRepSelectionTool , shared_ptr<StdSelect_BRepSelectionTool>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Load_s",
                    (void (*)( const opencascade::handle<SelectMgr_Selection> & ,  const TopoDS_Shape & ,  const TopAbs_ShapeEnum ,  const Standard_Real ,  const Standard_Real ,  const Standard_Boolean ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Real  ) ) static_cast<void (*)( const opencascade::handle<SelectMgr_Selection> & ,  const TopoDS_Shape & ,  const TopAbs_ShapeEnum ,  const Standard_Real ,  const Standard_Real ,  const Standard_Boolean ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Real  ) >(&StdSelect_BRepSelectionTool::Load),
                    R"#(Decomposition of <aShape> into sensitive entities following a mode of decomposition <aType>. These entities are stored in <aSelection>. BrepOwners are created to store the identity of the picked shapes during the selection process. In those BRepOwners is also stored the original shape. But One can't get the selectable object which was decomposed to give the sensitive entities. maximal parameter is used for infinite objects, to limit the sensitive Domain.... If AutoTriangulation = True, a Triangulation will be computed for faces which have no existing one. if AutoTriangulation = False the old algorithm will be called to compute sensitive entities on faces.)#"  , py::arg("aSelection"),  py::arg("aShape"),  py::arg("aType"),  py::arg("theDeflection"),  py::arg("theDeviationAngle"),  py::arg("AutoTriangulation")=static_cast<const Standard_Boolean>(Standard_True),  py::arg("aPriority")=static_cast<const Standard_Integer>(- 1),  py::arg("NbPOnEdge")=static_cast<const Standard_Integer>(9),  py::arg("MaximalParameter")=static_cast<const Standard_Real>(500)
          )
        .def_static("Load_s",
                    (void (*)( const opencascade::handle<SelectMgr_Selection> & ,  const opencascade::handle<SelectMgr_SelectableObject> & ,  const TopoDS_Shape & ,  const TopAbs_ShapeEnum ,  const Standard_Real ,  const Standard_Real ,  const Standard_Boolean ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Real  ) ) static_cast<void (*)( const opencascade::handle<SelectMgr_Selection> & ,  const opencascade::handle<SelectMgr_SelectableObject> & ,  const TopoDS_Shape & ,  const TopAbs_ShapeEnum ,  const Standard_Real ,  const Standard_Real ,  const Standard_Boolean ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Real  ) >(&StdSelect_BRepSelectionTool::Load),
                    R"#(Same functionalities ; the only difference is that the selectable object from which the selection comes is stored in each Sensitive EntityOwner; decomposition of <aShape> into sensitive entities following a mode of decomposition <aType>. These entities are stored in <aSelection> The Major difference is that the known users are first inserted in the BRepOwners. the original shape is the last user... (see EntityOwner from SelectBasics and BrepOwner)...)#"  , py::arg("aSelection"),  py::arg("Origin"),  py::arg("aShape"),  py::arg("aType"),  py::arg("theDeflection"),  py::arg("theDeviationAngle"),  py::arg("AutoTriangulation")=static_cast<const Standard_Boolean>(Standard_True),  py::arg("aPriority")=static_cast<const Standard_Integer>(- 1),  py::arg("NbPOnEdge")=static_cast<const Standard_Integer>(9),  py::arg("MaximalParameter")=static_cast<const Standard_Real>(500)
          )
        .def_static("GetStandardPriority_s",
                    (Standard_Integer (*)( const TopoDS_Shape & ,  const TopAbs_ShapeEnum  ) ) static_cast<Standard_Integer (*)( const TopoDS_Shape & ,  const TopAbs_ShapeEnum  ) >(&StdSelect_BRepSelectionTool::GetStandardPriority),
                    R"#(Returns the standard priority of the shape aShap having the type aType. This priority is passed to a StdSelect_BRepOwner object. You can use the function Load to modify the selection priority of an owner to make one entity more selectable than another one.)#"  , py::arg("theShape"),  py::arg("theType")
          )
        .def_static("ComputeSensitive_s",
                    (void (*)( const TopoDS_Shape & ,  const opencascade::handle<SelectMgr_EntityOwner> & ,  const opencascade::handle<SelectMgr_Selection> & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Real ,  const Standard_Boolean  ) ) static_cast<void (*)( const TopoDS_Shape & ,  const opencascade::handle<SelectMgr_EntityOwner> & ,  const opencascade::handle<SelectMgr_Selection> & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Real ,  const Standard_Boolean  ) >(&StdSelect_BRepSelectionTool::ComputeSensitive),
                    R"#(Computes the sensitive primitives, stores them in the SelectMgr_Selection object, and returns this object.)#"  , py::arg("theShape"),  py::arg("theOwner"),  py::arg("theSelection"),  py::arg("theDeflection"),  py::arg("theDeflAngle"),  py::arg("theNbPOnEdge"),  py::arg("theMaxiParam"),  py::arg("theAutoTriang")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("GetSensitiveForFace_s",
                    (Standard_Boolean (*)( const TopoDS_Face & ,  const opencascade::handle<SelectMgr_EntityOwner> & ,  NCollection_Sequence<opencascade::handle<Select3D_SensitiveEntity>> & ,  const Standard_Boolean ,  const Standard_Integer ,  const Standard_Real ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (*)( const TopoDS_Face & ,  const opencascade::handle<SelectMgr_EntityOwner> & ,  NCollection_Sequence<opencascade::handle<Select3D_SensitiveEntity>> & ,  const Standard_Boolean ,  const Standard_Integer ,  const Standard_Real ,  const Standard_Boolean  ) >(&StdSelect_BRepSelectionTool::GetSensitiveForFace),
                    R"#(Creates the 3D sensitive entities for Face selection.)#"  , py::arg("theFace"),  py::arg("theOwner"),  py::arg("theOutList"),  py::arg("theAutoTriang")=static_cast<const Standard_Boolean>(Standard_True),  py::arg("theNbPOnEdge")=static_cast<const Standard_Integer>(9),  py::arg("theMaxiParam")=static_cast<const Standard_Real>(500),  py::arg("theInteriorFlag")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("GetSensitiveForCylinder_s",
                    (Standard_Boolean (*)(  const NCollection_IndexedMap<TopoDS_Shape, TopTools_ShapeMapHasher> & ,  const opencascade::handle<SelectMgr_EntityOwner> & ,  const opencascade::handle<SelectMgr_Selection> &  ) ) static_cast<Standard_Boolean (*)(  const NCollection_IndexedMap<TopoDS_Shape, TopTools_ShapeMapHasher> & ,  const opencascade::handle<SelectMgr_EntityOwner> & ,  const opencascade::handle<SelectMgr_Selection> &  ) >(&StdSelect_BRepSelectionTool::GetSensitiveForCylinder),
                    R"#(Creates a sensitive cylinder.)#"  , py::arg("theSubfacesMap"),  py::arg("theOwner"),  py::arg("theSelection")
          )
        .def_static("PreBuildBVH_s",
                    (void (*)( const opencascade::handle<SelectMgr_Selection> &  ) ) static_cast<void (*)( const opencascade::handle<SelectMgr_Selection> &  ) >(&StdSelect_BRepSelectionTool::PreBuildBVH),
                    R"#(Traverses the selection given and pre-builds BVH trees for heavyweight sensitive entities containing more than BVH_PRIMITIVE_LIMIT (defined in .cxx file) sub-elements.)#"  , py::arg("theSelection")
          )
    // static methods using call by reference i.s.o. return
        .def_static("GetEdgeSensitive_s",
            [](const TopoDS_Shape & theShape,const opencascade::handle<SelectMgr_EntityOwner> & theOwner,const opencascade::handle<SelectMgr_Selection> & theSelection,const Standard_Real theDeflection,const Standard_Real theDeviationAngle,const Standard_Integer theNbPOnEdge,const Standard_Real theMaxiParam,Select3D_SensitiveEntity& theSensitive ){
                opencascade::handle<Select3D_SensitiveEntity>  theSensitive_ptr; theSensitive_ptr = &theSensitive;

                StdSelect_BRepSelectionTool::GetEdgeSensitive(theShape,theOwner,theSelection,theDeflection,theDeviationAngle,theNbPOnEdge,theMaxiParam,theSensitive_ptr);
                if ( theSensitive_ptr.get() != &theSensitive ) copy_if_copy_constructible(theSensitive, *theSensitive_ptr);

 },
            R"#(Create a sensitive edge or sensitive wire.)#"  , py::arg("theShape"),  py::arg("theOwner"),  py::arg("theSelection"),  py::arg("theDeflection"),  py::arg("theDeviationAngle"),  py::arg("theNbPOnEdge"),  py::arg("theMaxiParam"),  py::arg("theSensitive")
          )
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdSelect_EdgeFilter from ./opencascade/StdSelect_EdgeFilter.hxx
    klass = m.attr("StdSelect_EdgeFilter");


    // nested enums

    static_cast<py::class_<StdSelect_EdgeFilter ,opencascade::handle<StdSelect_EdgeFilter>  , SelectMgr_Filter >>(klass)
    // constructors
        .def(py::init< const StdSelect_TypeOfEdge >()  , py::arg("Edge") )
    // custom constructors
    // methods
        .def("SetType",
             (void (StdSelect_EdgeFilter::*)( const StdSelect_TypeOfEdge  ) ) static_cast<void (StdSelect_EdgeFilter::*)( const StdSelect_TypeOfEdge  ) >(&StdSelect_EdgeFilter::SetType),
             R"#(Sets the type of edge aNewType. aNewType is to be highlighted in selection.)#"  , py::arg("aNewType")
          )
        .def("Type",
             (StdSelect_TypeOfEdge (StdSelect_EdgeFilter::*)() const) static_cast<StdSelect_TypeOfEdge (StdSelect_EdgeFilter::*)() const>(&StdSelect_EdgeFilter::Type),
             R"#(Returns the type of edge to be highlighted in selection.)#" 
          )
        .def("IsOk",
             (Standard_Boolean (StdSelect_EdgeFilter::*)( const opencascade::handle<SelectMgr_EntityOwner> &  ) const) static_cast<Standard_Boolean (StdSelect_EdgeFilter::*)( const opencascade::handle<SelectMgr_EntityOwner> &  ) const>(&StdSelect_EdgeFilter::IsOk),
             R"#(None)#"  , py::arg("anobj")
          )
        .def("ActsOn",
             (Standard_Boolean (StdSelect_EdgeFilter::*)( const TopAbs_ShapeEnum  ) const) static_cast<Standard_Boolean (StdSelect_EdgeFilter::*)( const TopAbs_ShapeEnum  ) const>(&StdSelect_EdgeFilter::ActsOn),
             R"#(None)#"  , py::arg("aStandardMode")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&StdSelect_EdgeFilter::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&StdSelect_EdgeFilter::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (StdSelect_EdgeFilter::*)() const) static_cast<const opencascade::handle<Standard_Type> & (StdSelect_EdgeFilter::*)() const>(&StdSelect_EdgeFilter::DynamicType),
             R"#(None)#"
             
         )
;

    // Class StdSelect_FaceFilter from ./opencascade/StdSelect_FaceFilter.hxx
    klass = m.attr("StdSelect_FaceFilter");


    // nested enums

    static_cast<py::class_<StdSelect_FaceFilter ,opencascade::handle<StdSelect_FaceFilter>  , SelectMgr_Filter >>(klass)
    // constructors
        .def(py::init< const StdSelect_TypeOfFace >()  , py::arg("aTypeOfFace") )
    // custom constructors
    // methods
        .def("SetType",
             (void (StdSelect_FaceFilter::*)( const StdSelect_TypeOfFace  ) ) static_cast<void (StdSelect_FaceFilter::*)( const StdSelect_TypeOfFace  ) >(&StdSelect_FaceFilter::SetType),
             R"#(Sets the type of face aNewType. aNewType is to be highlighted in selection.)#"  , py::arg("aNewType")
          )
        .def("Type",
             (StdSelect_TypeOfFace (StdSelect_FaceFilter::*)() const) static_cast<StdSelect_TypeOfFace (StdSelect_FaceFilter::*)() const>(&StdSelect_FaceFilter::Type),
             R"#(Returns the type of face to be highlighted in selection.)#" 
          )
        .def("IsOk",
             (Standard_Boolean (StdSelect_FaceFilter::*)( const opencascade::handle<SelectMgr_EntityOwner> &  ) const) static_cast<Standard_Boolean (StdSelect_FaceFilter::*)( const opencascade::handle<SelectMgr_EntityOwner> &  ) const>(&StdSelect_FaceFilter::IsOk),
             R"#(None)#"  , py::arg("anobj")
          )
        .def("ActsOn",
             (Standard_Boolean (StdSelect_FaceFilter::*)( const TopAbs_ShapeEnum  ) const) static_cast<Standard_Boolean (StdSelect_FaceFilter::*)( const TopAbs_ShapeEnum  ) const>(&StdSelect_FaceFilter::ActsOn),
             R"#(None)#"  , py::arg("aStandardMode")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&StdSelect_FaceFilter::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&StdSelect_FaceFilter::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (StdSelect_FaceFilter::*)() const) static_cast<const opencascade::handle<Standard_Type> & (StdSelect_FaceFilter::*)() const>(&StdSelect_FaceFilter::DynamicType),
             R"#(None)#"
             
         )
;

    // Class StdSelect_Shape from ./opencascade/StdSelect_Shape.hxx
    klass = m.attr("StdSelect_Shape");


    // nested enums

    static_cast<py::class_<StdSelect_Shape ,opencascade::handle<StdSelect_Shape>  , PrsMgr_PresentableObject >>(klass)
    // constructors
        .def(py::init< const TopoDS_Shape &,const opencascade::handle<Prs3d_Drawer> & >()  , py::arg("theShape"),  py::arg("theDrawer")=static_cast<const opencascade::handle<Prs3d_Drawer> &>(Handle ( Prs3d_Drawer ) ( )) )
    // custom constructors
    // methods
        .def("Compute",
             (void (StdSelect_Shape::*)( const opencascade::handle<PrsMgr_PresentationManager> & ,  const opencascade::handle<Prs3d_Presentation> & ,  const Standard_Integer  ) ) static_cast<void (StdSelect_Shape::*)( const opencascade::handle<PrsMgr_PresentationManager> & ,  const opencascade::handle<Prs3d_Presentation> & ,  const Standard_Integer  ) >(&StdSelect_Shape::Compute),
             R"#(None)#"  , py::arg("thePrsMgr"),  py::arg("thePrs"),  py::arg("theMode")
          )
        .def("Shape",
             (void (StdSelect_Shape::*)( const TopoDS_Shape &  ) ) static_cast<void (StdSelect_Shape::*)( const TopoDS_Shape &  ) >(&StdSelect_Shape::Shape),
             R"#(None)#"  , py::arg("theShape")
          )
        .def("DumpJson",
             (void (StdSelect_Shape::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (StdSelect_Shape::*)( std::ostream & ,  Standard_Integer  ) const>(&StdSelect_Shape::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&StdSelect_Shape::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&StdSelect_Shape::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (StdSelect_Shape::*)() const) static_cast<const opencascade::handle<Standard_Type> & (StdSelect_Shape::*)() const>(&StdSelect_Shape::DynamicType),
             R"#(None)#"
             
         )
       .def("Shape",
             (const TopoDS_Shape & (StdSelect_Shape::*)() const) static_cast<const TopoDS_Shape & (StdSelect_Shape::*)() const>(&StdSelect_Shape::Shape),
             R"#(None)#"
             
         )
;

    // Class StdSelect_ShapeTypeFilter from ./opencascade/StdSelect_ShapeTypeFilter.hxx
    klass = m.attr("StdSelect_ShapeTypeFilter");


    // nested enums

    static_cast<py::class_<StdSelect_ShapeTypeFilter ,opencascade::handle<StdSelect_ShapeTypeFilter>  , SelectMgr_Filter >>(klass)
    // constructors
        .def(py::init< const TopAbs_ShapeEnum >()  , py::arg("aType") )
    // custom constructors
    // methods
        .def("Type",
             (TopAbs_ShapeEnum (StdSelect_ShapeTypeFilter::*)() const) static_cast<TopAbs_ShapeEnum (StdSelect_ShapeTypeFilter::*)() const>(&StdSelect_ShapeTypeFilter::Type),
             R"#(Returns the type of shape selected by the filter.)#" 
          )
        .def("IsOk",
             (Standard_Boolean (StdSelect_ShapeTypeFilter::*)( const opencascade::handle<SelectMgr_EntityOwner> &  ) const) static_cast<Standard_Boolean (StdSelect_ShapeTypeFilter::*)( const opencascade::handle<SelectMgr_EntityOwner> &  ) const>(&StdSelect_ShapeTypeFilter::IsOk),
             R"#(None)#"  , py::arg("anobj")
          )
        .def("ActsOn",
             (Standard_Boolean (StdSelect_ShapeTypeFilter::*)( const TopAbs_ShapeEnum  ) const) static_cast<Standard_Boolean (StdSelect_ShapeTypeFilter::*)( const TopAbs_ShapeEnum  ) const>(&StdSelect_ShapeTypeFilter::ActsOn),
             R"#(None)#"  , py::arg("aStandardMode")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&StdSelect_ShapeTypeFilter::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&StdSelect_ShapeTypeFilter::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (StdSelect_ShapeTypeFilter::*)() const) static_cast<const opencascade::handle<Standard_Type> & (StdSelect_ShapeTypeFilter::*)() const>(&StdSelect_ShapeTypeFilter::DynamicType),
             R"#(None)#"
             
         )
;

// functions
// ./opencascade/StdSelect.hxx
// ./opencascade/StdSelect_BRepOwner.hxx
// ./opencascade/StdSelect_BRepSelectionTool.hxx
// ./opencascade/StdSelect_EdgeFilter.hxx
// ./opencascade/StdSelect_FaceFilter.hxx
// ./opencascade/StdSelect_Shape.hxx
// ./opencascade/StdSelect_ShapeTypeFilter.hxx
// ./opencascade/StdSelect_TypeOfEdge.hxx
// ./opencascade/StdSelect_TypeOfFace.hxx
// ./opencascade/StdSelect_TypeOfSelectionImage.hxx
// ./opencascade/StdSelect_ViewerSelector3d.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
