# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appplatform import AppPlatformManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAppPlatformManagementDeploymentsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AppPlatformManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.deployments.get(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            deployment_name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update(self, resource_group):
        response = self.client.deployments.begin_create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            deployment_name="str",
            deployment_resource={
                "id": "str",
                "name": "str",
                "properties": {
                    "active": bool,
                    "deploymentSettings": {
                        "addonConfigs": {"str": {}},
                        "apms": [{"resourceId": "str"}],
                        "containerProbeSettings": {"disableProbe": bool},
                        "environmentVariables": {"str": "str"},
                        "livenessProbe": {
                            "disableProbe": False,
                            "failureThreshold": 0,
                            "initialDelaySeconds": 0,
                            "periodSeconds": 0,
                            "probeAction": "probe_action",
                            "successThreshold": 0,
                            "timeoutSeconds": 0,
                        },
                        "readinessProbe": {
                            "disableProbe": False,
                            "failureThreshold": 0,
                            "initialDelaySeconds": 0,
                            "periodSeconds": 0,
                            "probeAction": "probe_action",
                            "successThreshold": 0,
                            "timeoutSeconds": 0,
                        },
                        "resourceRequests": {"cpu": "str", "memory": "str"},
                        "startupProbe": {
                            "disableProbe": False,
                            "failureThreshold": 0,
                            "initialDelaySeconds": 0,
                            "periodSeconds": 0,
                            "probeAction": "probe_action",
                            "successThreshold": 0,
                            "timeoutSeconds": 0,
                        },
                        "terminationGracePeriodSeconds": 90,
                    },
                    "instances": [
                        {
                            "discoveryStatus": "str",
                            "name": "str",
                            "reason": "str",
                            "startTime": "str",
                            "status": "str",
                            "zone": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "source": "user_source_info",
                    "status": "str",
                },
                "sku": {"capacity": 0, "name": "S0", "tier": "Standard"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2023-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.deployments.begin_delete(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            deployment_name="str",
            api_version="2023-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_update(self, resource_group):
        response = self.client.deployments.begin_update(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            deployment_name="str",
            deployment_resource={
                "id": "str",
                "name": "str",
                "properties": {
                    "active": bool,
                    "deploymentSettings": {
                        "addonConfigs": {"str": {}},
                        "apms": [{"resourceId": "str"}],
                        "containerProbeSettings": {"disableProbe": bool},
                        "environmentVariables": {"str": "str"},
                        "livenessProbe": {
                            "disableProbe": False,
                            "failureThreshold": 0,
                            "initialDelaySeconds": 0,
                            "periodSeconds": 0,
                            "probeAction": "probe_action",
                            "successThreshold": 0,
                            "timeoutSeconds": 0,
                        },
                        "readinessProbe": {
                            "disableProbe": False,
                            "failureThreshold": 0,
                            "initialDelaySeconds": 0,
                            "periodSeconds": 0,
                            "probeAction": "probe_action",
                            "successThreshold": 0,
                            "timeoutSeconds": 0,
                        },
                        "resourceRequests": {"cpu": "str", "memory": "str"},
                        "startupProbe": {
                            "disableProbe": False,
                            "failureThreshold": 0,
                            "initialDelaySeconds": 0,
                            "periodSeconds": 0,
                            "probeAction": "probe_action",
                            "successThreshold": 0,
                            "timeoutSeconds": 0,
                        },
                        "terminationGracePeriodSeconds": 90,
                    },
                    "instances": [
                        {
                            "discoveryStatus": "str",
                            "name": "str",
                            "reason": "str",
                            "startTime": "str",
                            "status": "str",
                            "zone": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "source": "user_source_info",
                    "status": "str",
                },
                "sku": {"capacity": 0, "name": "S0", "tier": "Standard"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2023-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.deployments.list(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            api_version="2023-12-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_for_cluster(self, resource_group):
        response = self.client.deployments.list_for_cluster(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2023-12-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_start(self, resource_group):
        response = self.client.deployments.begin_start(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            deployment_name="str",
            api_version="2023-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_stop(self, resource_group):
        response = self.client.deployments.begin_stop(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            deployment_name="str",
            api_version="2023-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_restart(self, resource_group):
        response = self.client.deployments.begin_restart(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            deployment_name="str",
            api_version="2023-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_enable_remote_debugging(self, resource_group):
        response = self.client.deployments.begin_enable_remote_debugging(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            deployment_name="str",
            api_version="2023-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_disable_remote_debugging(self, resource_group):
        response = self.client.deployments.begin_disable_remote_debugging(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            deployment_name="str",
            api_version="2023-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_remote_debugging_config(self, resource_group):
        response = self.client.deployments.get_remote_debugging_config(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            deployment_name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_log_file_url(self, resource_group):
        response = self.client.deployments.get_log_file_url(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            deployment_name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_generate_heap_dump(self, resource_group):
        response = self.client.deployments.begin_generate_heap_dump(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            deployment_name="str",
            diagnostic_parameters={"appInstance": "str", "duration": "str", "filePath": "str"},
            api_version="2023-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_generate_thread_dump(self, resource_group):
        response = self.client.deployments.begin_generate_thread_dump(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            deployment_name="str",
            diagnostic_parameters={"appInstance": "str", "duration": "str", "filePath": "str"},
            api_version="2023-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_start_jfr(self, resource_group):
        response = self.client.deployments.begin_start_jfr(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            deployment_name="str",
            diagnostic_parameters={"appInstance": "str", "duration": "str", "filePath": "str"},
            api_version="2023-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
