# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MetricSpecificationV1(Model):
    """Metric specification version 1.

    :param name: Name of the metric.
    :type name: str
    :param display_name: Display name of the metric.
    :type display_name: str
    :param display_description: Description of the metric to be displayed.
    :type display_description: str
    :param unit: Metric units. Possible values include: 'NotSpecified',
     'Percent', 'Count', 'Seconds', 'Milliseconds', 'Bytes', 'BytesPerSecond',
     'CountPerSecond'
    :type unit: str or ~azure.mgmt.edgegateway.models.MetricUnit
    :param aggregation_type: Metric aggregation type. Possible values include:
     'NotSpecified', 'None', 'Average', 'Minimum', 'Maximum', 'Total', 'Count'
    :type aggregation_type: str or
     ~azure.mgmt.edgegateway.models.MetricAggregationType
    :param dimensions: Metric dimensions, other than default dimension which
     is resource.
    :type dimensions: list[~azure.mgmt.edgegateway.models.MetricDimensionV1]
    :param fill_gap_with_zero: Set true to fill the gaps with zero.
    :type fill_gap_with_zero: bool
    :param category: Metric category. Possible values include: 'Capacity',
     'Transaction'
    :type category: str or ~azure.mgmt.edgegateway.models.MetricCategory
    :param resource_id_dimension_name_override: Resource name override.
    :type resource_id_dimension_name_override: str
    :param supported_time_grain_types: Support granularity of metrics.
    :type supported_time_grain_types: list[str or
     ~azure.mgmt.edgegateway.models.TimeGrain]
    :param supported_aggregation_types: Support metric aggregation type.
    :type supported_aggregation_types: list[str or
     ~azure.mgmt.edgegateway.models.MetricAggregationType]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimensionV1]'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'category': {'key': 'category', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(MetricSpecificationV1, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.dimensions = kwargs.get('dimensions', None)
        self.fill_gap_with_zero = kwargs.get('fill_gap_with_zero', None)
        self.category = kwargs.get('category', None)
        self.resource_id_dimension_name_override = kwargs.get('resource_id_dimension_name_override', None)
        self.supported_time_grain_types = kwargs.get('supported_time_grain_types', None)
        self.supported_aggregation_types = kwargs.get('supported_aggregation_types', None)
