# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._automation_client_enums import *


class Activity(msrest.serialization.Model):
    """Definition of the activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Gets or sets the id of the resource.
    :type id: str
    :ivar name: Gets the name of the activity.
    :vartype name: str
    :param definition: Gets or sets the user name of the activity.
    :type definition: str
    :param parameter_sets: Gets or sets the parameter sets of the activity.
    :type parameter_sets: list[~azure.mgmt.automation.models.ActivityParameterSet]
    :param output_types: Gets or sets the output types of the activity.
    :type output_types: list[~azure.mgmt.automation.models.ActivityOutputType]
    :param creation_time: Gets or sets the creation time.
    :type creation_time: ~datetime.datetime
    :param last_modified_time: Gets or sets the last modified time.
    :type last_modified_time: ~datetime.datetime
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'definition': {'key': 'properties.definition', 'type': 'str'},
        'parameter_sets': {'key': 'properties.parameterSets', 'type': '[ActivityParameterSet]'},
        'output_types': {'key': 'properties.outputTypes', 'type': '[ActivityOutputType]'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        definition: Optional[str] = None,
        parameter_sets: Optional[List["ActivityParameterSet"]] = None,
        output_types: Optional[List["ActivityOutputType"]] = None,
        creation_time: Optional[datetime.datetime] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(Activity, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.definition = definition
        self.parameter_sets = parameter_sets
        self.output_types = output_types
        self.creation_time = creation_time
        self.last_modified_time = last_modified_time
        self.description = description


class ActivityListResult(msrest.serialization.Model):
    """The response model for the list activity operation.

    :param value: Gets or sets a list of activities.
    :type value: list[~azure.mgmt.automation.models.Activity]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Activity]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Activity"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ActivityListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ActivityOutputType(msrest.serialization.Model):
    """Definition of the activity output type.

    :param name: Gets or sets the name of the activity output type.
    :type name: str
    :param type: Gets or sets the type of the activity output type.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(ActivityOutputType, self).__init__(**kwargs)
        self.name = name
        self.type = type


class ActivityParameter(msrest.serialization.Model):
    """Definition of the activity parameter.

    :param name: Gets or sets the name of the activity parameter.
    :type name: str
    :param type: Gets or sets the type of the activity parameter.
    :type type: str
    :param is_mandatory: Gets or sets a Boolean value that indicates true if the parameter is
     required. If the value is false, the parameter is optional.
    :type is_mandatory: bool
    :param is_dynamic: Gets or sets a Boolean value that indicates true if the parameter is
     dynamic.
    :type is_dynamic: bool
    :param position: Gets or sets the position of the activity parameter.
    :type position: long
    :param value_from_pipeline: Gets or sets a Boolean value that indicates true if the parameter
     can take values from the incoming pipeline objects. This setting is used if the cmdlet must
     access the complete input object. false indicates that the parameter cannot take values from
     the complete input object.
    :type value_from_pipeline: bool
    :param value_from_pipeline_by_property_name: Gets or sets a Boolean value that indicates true
     if the parameter can be filled from a property of the incoming pipeline object that has the
     same name as this parameter. false indicates that the parameter cannot be filled from the
     incoming pipeline object property with the same name.
    :type value_from_pipeline_by_property_name: bool
    :param value_from_remaining_arguments: Gets or sets a Boolean value that indicates true if the
     cmdlet parameter accepts all the remaining command-line arguments that are associated with this
     parameter in the form of an array. false if the cmdlet parameter does not accept all the
     remaining argument values.
    :type value_from_remaining_arguments: bool
    :param description: Gets or sets the description of the activity parameter.
    :type description: str
    :param validation_set: Gets or sets the validation set of activity parameter.
    :type validation_set: list[~azure.mgmt.automation.models.ActivityParameterValidationSet]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_mandatory': {'key': 'isMandatory', 'type': 'bool'},
        'is_dynamic': {'key': 'isDynamic', 'type': 'bool'},
        'position': {'key': 'position', 'type': 'long'},
        'value_from_pipeline': {'key': 'valueFromPipeline', 'type': 'bool'},
        'value_from_pipeline_by_property_name': {'key': 'valueFromPipelineByPropertyName', 'type': 'bool'},
        'value_from_remaining_arguments': {'key': 'valueFromRemainingArguments', 'type': 'bool'},
        'description': {'key': 'description', 'type': 'str'},
        'validation_set': {'key': 'validationSet', 'type': '[ActivityParameterValidationSet]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        is_mandatory: Optional[bool] = None,
        is_dynamic: Optional[bool] = None,
        position: Optional[int] = None,
        value_from_pipeline: Optional[bool] = None,
        value_from_pipeline_by_property_name: Optional[bool] = None,
        value_from_remaining_arguments: Optional[bool] = None,
        description: Optional[str] = None,
        validation_set: Optional[List["ActivityParameterValidationSet"]] = None,
        **kwargs
    ):
        super(ActivityParameter, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.is_mandatory = is_mandatory
        self.is_dynamic = is_dynamic
        self.position = position
        self.value_from_pipeline = value_from_pipeline
        self.value_from_pipeline_by_property_name = value_from_pipeline_by_property_name
        self.value_from_remaining_arguments = value_from_remaining_arguments
        self.description = description
        self.validation_set = validation_set


class ActivityParameterSet(msrest.serialization.Model):
    """Definition of the activity parameter set.

    :param name: Gets or sets the name of the activity parameter set.
    :type name: str
    :param parameters: Gets or sets the parameters of the activity parameter set.
    :type parameters: list[~azure.mgmt.automation.models.ActivityParameter]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[ActivityParameter]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        parameters: Optional[List["ActivityParameter"]] = None,
        **kwargs
    ):
        super(ActivityParameterSet, self).__init__(**kwargs)
        self.name = name
        self.parameters = parameters


class ActivityParameterValidationSet(msrest.serialization.Model):
    """Definition of the activity parameter validation set.

    :param member_value: Gets or sets the name of the activity parameter validation set member.
    :type member_value: str
    """

    _attribute_map = {
        'member_value': {'key': 'memberValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        member_value: Optional[str] = None,
        **kwargs
    ):
        super(ActivityParameterValidationSet, self).__init__(**kwargs)
        self.member_value = member_value


class AdvancedSchedule(msrest.serialization.Model):
    """The properties of the create Advanced Schedule.

    :param week_days: Days of the week that the job should execute on.
    :type week_days: list[str]
    :param month_days: Days of the month that the job should execute on. Must be between 1 and 31.
    :type month_days: list[int]
    :param monthly_occurrences: Occurrences of days within a month.
    :type monthly_occurrences:
     list[~azure.mgmt.automation.models.AdvancedScheduleMonthlyOccurrence]
    """

    _attribute_map = {
        'week_days': {'key': 'weekDays', 'type': '[str]'},
        'month_days': {'key': 'monthDays', 'type': '[int]'},
        'monthly_occurrences': {'key': 'monthlyOccurrences', 'type': '[AdvancedScheduleMonthlyOccurrence]'},
    }

    def __init__(
        self,
        *,
        week_days: Optional[List[str]] = None,
        month_days: Optional[List[int]] = None,
        monthly_occurrences: Optional[List["AdvancedScheduleMonthlyOccurrence"]] = None,
        **kwargs
    ):
        super(AdvancedSchedule, self).__init__(**kwargs)
        self.week_days = week_days
        self.month_days = month_days
        self.monthly_occurrences = monthly_occurrences


class AdvancedScheduleMonthlyOccurrence(msrest.serialization.Model):
    """The properties of the create advanced schedule monthly occurrence.

    :param occurrence: Occurrence of the week within the month. Must be between 1 and 5.
    :type occurrence: int
    :param day: Day of the occurrence. Must be one of monday, tuesday, wednesday, thursday, friday,
     saturday, sunday. Possible values include: "Monday", "Tuesday", "Wednesday", "Thursday",
     "Friday", "Saturday", "Sunday".
    :type day: str or ~azure.mgmt.automation.models.ScheduleDay
    """

    _attribute_map = {
        'occurrence': {'key': 'occurrence', 'type': 'int'},
        'day': {'key': 'day', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        occurrence: Optional[int] = None,
        day: Optional[Union[str, "ScheduleDay"]] = None,
        **kwargs
    ):
        super(AdvancedScheduleMonthlyOccurrence, self).__init__(**kwargs)
        self.occurrence = occurrence
        self.day = day


class AgentRegistration(msrest.serialization.Model):
    """Definition of the agent registration information type.

    :param dsc_meta_configuration: Gets or sets the dsc meta configuration.
    :type dsc_meta_configuration: str
    :param endpoint: Gets or sets the dsc server endpoint.
    :type endpoint: str
    :param keys: Gets or sets the agent registration keys.
    :type keys: ~azure.mgmt.automation.models.AgentRegistrationKeys
    :param id: Gets or sets the id.
    :type id: str
    """

    _attribute_map = {
        'dsc_meta_configuration': {'key': 'dscMetaConfiguration', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'keys': {'key': 'keys', 'type': 'AgentRegistrationKeys'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        dsc_meta_configuration: Optional[str] = None,
        endpoint: Optional[str] = None,
        keys: Optional["AgentRegistrationKeys"] = None,
        id: Optional[str] = None,
        **kwargs
    ):
        super(AgentRegistration, self).__init__(**kwargs)
        self.dsc_meta_configuration = dsc_meta_configuration
        self.endpoint = endpoint
        self.keys = keys
        self.id = id


class AgentRegistrationKeys(msrest.serialization.Model):
    """Definition of the agent registration keys.

    :param primary: Gets or sets the primary key.
    :type primary: str
    :param secondary: Gets or sets the secondary key.
    :type secondary: str
    """

    _attribute_map = {
        'primary': {'key': 'primary', 'type': 'str'},
        'secondary': {'key': 'secondary', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary: Optional[str] = None,
        secondary: Optional[str] = None,
        **kwargs
    ):
        super(AgentRegistrationKeys, self).__init__(**kwargs)
        self.primary = primary
        self.secondary = secondary


class AgentRegistrationRegenerateKeyParameter(msrest.serialization.Model):
    """The parameters supplied to the regenerate keys operation.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. Gets or sets the agent registration key name - primary or secondary.
     Possible values include: "primary", "secondary".
    :type key_name: str or ~azure.mgmt.automation.models.AgentRegistrationKeyName
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: Union[str, "AgentRegistrationKeyName"],
        **kwargs
    ):
        super(AgentRegistrationRegenerateKeyParameter, self).__init__(**kwargs)
        self.key_name = key_name


class Resource(msrest.serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: The Azure Region where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class AutomationAccount(TrackedResource):
    """Definition of the automation account type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: The Azure Region where the resource lives.
    :type location: str
    :param etag: Gets or sets the etag of the resource.
    :type etag: str
    :param sku: Gets or sets the SKU of account.
    :type sku: ~azure.mgmt.automation.models.Sku
    :param last_modified_by: Gets or sets the last modified by.
    :type last_modified_by: str
    :ivar state: Gets status of account. Possible values include: "Ok", "Unavailable", "Suspended".
    :vartype state: str or ~azure.mgmt.automation.models.AutomationAccountState
    :ivar creation_time: Gets the creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: Gets the last modified time.
    :vartype last_modified_time: ~datetime.datetime
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'creation_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'Sku'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        etag: Optional[str] = None,
        sku: Optional["Sku"] = None,
        last_modified_by: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(AutomationAccount, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = etag
        self.sku = sku
        self.last_modified_by = last_modified_by
        self.state = None
        self.creation_time = None
        self.last_modified_time = None
        self.description = description


class AutomationAccountCreateOrUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update automation account operation.

    :param name: Gets or sets name of the resource.
    :type name: str
    :param location: Gets or sets the location of the resource.
    :type location: str
    :param tags: A set of tags. Gets or sets the tags attached to the resource.
    :type tags: dict[str, str]
    :param sku: Gets or sets account SKU.
    :type sku: ~azure.mgmt.automation.models.Sku
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'properties.sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        super(AutomationAccountCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.sku = sku


class AutomationAccountListResult(msrest.serialization.Model):
    """The response model for the list account operation.

    :param value: Gets or sets list of accounts.
    :type value: list[~azure.mgmt.automation.models.AutomationAccount]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AutomationAccount]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AutomationAccount"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AutomationAccountListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AutomationAccountUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the update automation account operation.

    :param name: Gets or sets the name of the resource.
    :type name: str
    :param location: Gets or sets the location of the resource.
    :type location: str
    :param tags: A set of tags. Gets or sets the tags attached to the resource.
    :type tags: dict[str, str]
    :param sku: Gets or sets account SKU.
    :type sku: ~azure.mgmt.automation.models.Sku
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'properties.sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        super(AutomationAccountUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.sku = sku


class AzureQueryProperties(msrest.serialization.Model):
    """Azure query for the update configuration.

    :param scope: List of Subscription or Resource Group ARM Ids.
    :type scope: list[str]
    :param locations: List of locations to scope the query to.
    :type locations: list[str]
    :param tag_settings: Tag settings for the VM.
    :type tag_settings: ~azure.mgmt.automation.models.TagSettingsProperties
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': '[str]'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'tag_settings': {'key': 'tagSettings', 'type': 'TagSettingsProperties'},
    }

    def __init__(
        self,
        *,
        scope: Optional[List[str]] = None,
        locations: Optional[List[str]] = None,
        tag_settings: Optional["TagSettingsProperties"] = None,
        **kwargs
    ):
        super(AzureQueryProperties, self).__init__(**kwargs)
        self.scope = scope
        self.locations = locations
        self.tag_settings = tag_settings


class Certificate(Resource):
    """Definition of the certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar thumbprint: Gets the thumbprint of the certificate.
    :vartype thumbprint: str
    :ivar expiry_time: Gets the expiry time of the certificate.
    :vartype expiry_time: ~datetime.datetime
    :ivar is_exportable: Gets the is exportable flag of the certificate.
    :vartype is_exportable: bool
    :ivar creation_time: Gets the creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: Gets the last modified time.
    :vartype last_modified_time: ~datetime.datetime
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'thumbprint': {'readonly': True},
        'expiry_time': {'readonly': True},
        'is_exportable': {'readonly': True},
        'creation_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'expiry_time': {'key': 'properties.expiryTime', 'type': 'iso-8601'},
        'is_exportable': {'key': 'properties.isExportable', 'type': 'bool'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        **kwargs
    ):
        super(Certificate, self).__init__(**kwargs)
        self.thumbprint = None
        self.expiry_time = None
        self.is_exportable = None
        self.creation_time = None
        self.last_modified_time = None
        self.description = description


class CertificateCreateOrUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update or replace certificate operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Gets or sets the name of the certificate.
    :type name: str
    :param base64_value: Required. Gets or sets the base64 encoded value of the certificate.
    :type base64_value: str
    :param description: Gets or sets the description of the certificate.
    :type description: str
    :param thumbprint: Gets or sets the thumbprint of the certificate.
    :type thumbprint: str
    :param is_exportable: Gets or sets the is exportable flag of the certificate.
    :type is_exportable: bool
    """

    _validation = {
        'name': {'required': True},
        'base64_value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'base64_value': {'key': 'properties.base64Value', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'is_exportable': {'key': 'properties.isExportable', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        base64_value: str,
        description: Optional[str] = None,
        thumbprint: Optional[str] = None,
        is_exportable: Optional[bool] = None,
        **kwargs
    ):
        super(CertificateCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.base64_value = base64_value
        self.description = description
        self.thumbprint = thumbprint
        self.is_exportable = is_exportable


class CertificateListResult(msrest.serialization.Model):
    """The response model for the list certificate operation.

    :param value: Gets or sets a list of certificates.
    :type value: list[~azure.mgmt.automation.models.Certificate]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Certificate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Certificate"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(CertificateListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CertificateUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the update certificate operation.

    :param name: Gets or sets the name of the certificate.
    :type name: str
    :param description: Gets or sets the description of the certificate.
    :type description: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(CertificateUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.description = description


class Connection(Resource):
    """Definition of the connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param connection_type: Gets or sets the connectionType of the connection.
    :type connection_type: ~azure.mgmt.automation.models.ConnectionTypeAssociationProperty
    :ivar field_definition_values: Gets the field definition values of the connection.
    :vartype field_definition_values: dict[str, str]
    :ivar creation_time: Gets the creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: Gets the last modified time.
    :vartype last_modified_time: ~datetime.datetime
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'field_definition_values': {'readonly': True},
        'creation_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'ConnectionTypeAssociationProperty'},
        'field_definition_values': {'key': 'properties.fieldDefinitionValues', 'type': '{str}'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connection_type: Optional["ConnectionTypeAssociationProperty"] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(Connection, self).__init__(**kwargs)
        self.connection_type = connection_type
        self.field_definition_values = None
        self.creation_time = None
        self.last_modified_time = None
        self.description = description


class ConnectionCreateOrUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update connection operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Gets or sets the name of the connection.
    :type name: str
    :param description: Gets or sets the description of the connection.
    :type description: str
    :param connection_type: Required. Gets or sets the connectionType of the connection.
    :type connection_type: ~azure.mgmt.automation.models.ConnectionTypeAssociationProperty
    :param field_definition_values: Gets or sets the field definition properties of the connection.
    :type field_definition_values: dict[str, str]
    """

    _validation = {
        'name': {'required': True},
        'connection_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'ConnectionTypeAssociationProperty'},
        'field_definition_values': {'key': 'properties.fieldDefinitionValues', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        name: str,
        connection_type: "ConnectionTypeAssociationProperty",
        description: Optional[str] = None,
        field_definition_values: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ConnectionCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.connection_type = connection_type
        self.field_definition_values = field_definition_values


class ConnectionListResult(msrest.serialization.Model):
    """The response model for the list connection operation.

    :param value: Gets or sets a list of connection.
    :type value: list[~azure.mgmt.automation.models.Connection]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Connection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Connection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ConnectionType(msrest.serialization.Model):
    """Definition of the connection type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Gets the id of the resource.
    :vartype id: str
    :ivar name: Gets the name of the connection type.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param is_global: Gets or sets a Boolean value to indicate if the connection type is global.
    :type is_global: bool
    :ivar field_definitions: Gets the field definitions of the connection type.
    :vartype field_definitions: dict[str, ~azure.mgmt.automation.models.FieldDefinition]
    :ivar creation_time: Gets the creation time.
    :vartype creation_time: ~datetime.datetime
    :param last_modified_time: Gets or sets the last modified time.
    :type last_modified_time: ~datetime.datetime
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'field_definitions': {'readonly': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_global': {'key': 'properties.isGlobal', 'type': 'bool'},
        'field_definitions': {'key': 'properties.fieldDefinitions', 'type': '{FieldDefinition}'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        is_global: Optional[bool] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionType, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.is_global = is_global
        self.field_definitions = None
        self.creation_time = None
        self.last_modified_time = last_modified_time
        self.description = description


class ConnectionTypeAssociationProperty(msrest.serialization.Model):
    """The connection type property associated with the entity.

    :param name: Gets or sets the name of the connection type.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionTypeAssociationProperty, self).__init__(**kwargs)
        self.name = name


class ConnectionTypeCreateOrUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update connection type operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Gets or sets the name of the connection type.
    :type name: str
    :param is_global: Gets or sets a Boolean value to indicate if the connection type is global.
    :type is_global: bool
    :param field_definitions: Required. Gets or sets the field definitions of the connection type.
    :type field_definitions: dict[str, ~azure.mgmt.automation.models.FieldDefinition]
    """

    _validation = {
        'name': {'required': True},
        'field_definitions': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_global': {'key': 'properties.isGlobal', 'type': 'bool'},
        'field_definitions': {'key': 'properties.fieldDefinitions', 'type': '{FieldDefinition}'},
    }

    def __init__(
        self,
        *,
        name: str,
        field_definitions: Dict[str, "FieldDefinition"],
        is_global: Optional[bool] = None,
        **kwargs
    ):
        super(ConnectionTypeCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.is_global = is_global
        self.field_definitions = field_definitions


class ConnectionTypeListResult(msrest.serialization.Model):
    """The response model for the list connection type operation.

    :param value: Gets or sets a list of connection types.
    :type value: list[~azure.mgmt.automation.models.ConnectionType]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ConnectionType]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ConnectionType"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionTypeListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ConnectionUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the update connection operation.

    :param name: Gets or sets the name of the connection.
    :type name: str
    :param description: Gets or sets the description of the connection.
    :type description: str
    :param field_definition_values: Gets or sets the field definition values of the connection.
    :type field_definition_values: dict[str, str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'field_definition_values': {'key': 'properties.fieldDefinitionValues', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        field_definition_values: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ConnectionUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.field_definition_values = field_definition_values


class ContentHash(msrest.serialization.Model):
    """Definition of the runbook property type.

    All required parameters must be populated in order to send to Azure.

    :param algorithm: Required. Gets or sets the content hash algorithm used to hash the content.
    :type algorithm: str
    :param value: Required. Gets or sets expected hash value of the content.
    :type value: str
    """

    _validation = {
        'algorithm': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'algorithm': {'key': 'algorithm', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        algorithm: str,
        value: str,
        **kwargs
    ):
        super(ContentHash, self).__init__(**kwargs)
        self.algorithm = algorithm
        self.value = value


class ContentLink(msrest.serialization.Model):
    """Definition of the content link.

    :param uri: Gets or sets the uri of the runbook content.
    :type uri: str
    :param content_hash: Gets or sets the hash.
    :type content_hash: ~azure.mgmt.automation.models.ContentHash
    :param version: Gets or sets the version of the content.
    :type version: str
    """

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
        'content_hash': {'key': 'contentHash', 'type': 'ContentHash'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: Optional[str] = None,
        content_hash: Optional["ContentHash"] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        super(ContentLink, self).__init__(**kwargs)
        self.uri = uri
        self.content_hash = content_hash
        self.version = version


class ContentSource(msrest.serialization.Model):
    """Definition of the content source.

    :param hash: Gets or sets the hash.
    :type hash: ~azure.mgmt.automation.models.ContentHash
    :param type: Gets or sets the content source type. Possible values include: "embeddedContent",
     "uri".
    :type type: str or ~azure.mgmt.automation.models.ContentSourceType
    :param value: Gets or sets the value of the content. This is based on the content source type.
    :type value: str
    :param version: Gets or sets the version of the content.
    :type version: str
    """

    _attribute_map = {
        'hash': {'key': 'hash', 'type': 'ContentHash'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        hash: Optional["ContentHash"] = None,
        type: Optional[Union[str, "ContentSourceType"]] = None,
        value: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        super(ContentSource, self).__init__(**kwargs)
        self.hash = hash
        self.type = type
        self.value = value
        self.version = version


class Credential(Resource):
    """Definition of the credential.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar user_name: Gets the user name of the credential.
    :vartype user_name: str
    :ivar creation_time: Gets the creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: Gets the last modified time.
    :vartype last_modified_time: ~datetime.datetime
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'user_name': {'readonly': True},
        'creation_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        **kwargs
    ):
        super(Credential, self).__init__(**kwargs)
        self.user_name = None
        self.creation_time = None
        self.last_modified_time = None
        self.description = description


class CredentialCreateOrUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update credential operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Gets or sets the name of the credential.
    :type name: str
    :param user_name: Required. Gets or sets the user name of the credential.
    :type user_name: str
    :param password: Required. Gets or sets the password of the credential.
    :type password: str
    :param description: Gets or sets the description of the credential.
    :type description: str
    """

    _validation = {
        'name': {'required': True},
        'user_name': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        user_name: str,
        password: str,
        description: Optional[str] = None,
        **kwargs
    ):
        super(CredentialCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.user_name = user_name
        self.password = password
        self.description = description


class CredentialListResult(msrest.serialization.Model):
    """The response model for the list credential operation.

    :param value: Gets or sets a list of credentials.
    :type value: list[~azure.mgmt.automation.models.Credential]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Credential]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Credential"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(CredentialListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CredentialUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the Update credential operation.

    :param name: Gets or sets the name of the credential.
    :type name: str
    :param user_name: Gets or sets the user name of the credential.
    :type user_name: str
    :param password: Gets or sets the password of the credential.
    :type password: str
    :param description: Gets or sets the description of the credential.
    :type description: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(CredentialUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.user_name = user_name
        self.password = password
        self.description = description


class DscCompilationJob(Resource):
    """Definition of the Dsc Compilation job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param configuration: Gets or sets the configuration.
    :type configuration: ~azure.mgmt.automation.models.DscConfigurationAssociationProperty
    :ivar started_by: Gets the compilation job started by.
    :vartype started_by: str
    :ivar job_id: Gets the id of the job.
    :vartype job_id: str
    :ivar creation_time: Gets the creation time of the job.
    :vartype creation_time: ~datetime.datetime
    :param provisioning_state: The current provisioning state of the job. Possible values include:
     "Failed", "Succeeded", "Suspended", "Processing".
    :type provisioning_state: str or ~azure.mgmt.automation.models.JobProvisioningState
    :param run_on: Gets or sets the runOn which specifies the group name where the job is to be
     executed.
    :type run_on: str
    :param status: Gets or sets the status of the job. Possible values include: "New",
     "Activating", "Running", "Completed", "Failed", "Stopped", "Blocked", "Suspended",
     "Disconnected", "Suspending", "Stopping", "Resuming", "Removing".
    :type status: str or ~azure.mgmt.automation.models.JobStatus
    :param status_details: Gets or sets the status details of the job.
    :type status_details: str
    :ivar start_time: Gets the start time of the job.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets the end time of the job.
    :vartype end_time: ~datetime.datetime
    :ivar exception: Gets the exception of the job.
    :vartype exception: str
    :ivar last_modified_time: Gets the last modified time of the job.
    :vartype last_modified_time: ~datetime.datetime
    :ivar last_status_modified_time: Gets the last status modified time of the job.
    :vartype last_status_modified_time: ~datetime.datetime
    :param parameters: Gets or sets the parameters of the job.
    :type parameters: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'started_by': {'readonly': True},
        'job_id': {'readonly': True},
        'creation_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'exception': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'last_status_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'configuration': {'key': 'properties.configuration', 'type': 'DscConfigurationAssociationProperty'},
        'started_by': {'key': 'properties.startedBy', 'type': 'str'},
        'job_id': {'key': 'properties.jobId', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'run_on': {'key': 'properties.runOn', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'status_details': {'key': 'properties.statusDetails', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'exception': {'key': 'properties.exception', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'last_status_modified_time': {'key': 'properties.lastStatusModifiedTime', 'type': 'iso-8601'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        configuration: Optional["DscConfigurationAssociationProperty"] = None,
        provisioning_state: Optional[Union[str, "JobProvisioningState"]] = None,
        run_on: Optional[str] = None,
        status: Optional[Union[str, "JobStatus"]] = None,
        status_details: Optional[str] = None,
        parameters: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(DscCompilationJob, self).__init__(**kwargs)
        self.configuration = configuration
        self.started_by = None
        self.job_id = None
        self.creation_time = None
        self.provisioning_state = provisioning_state
        self.run_on = run_on
        self.status = status
        self.status_details = status_details
        self.start_time = None
        self.end_time = None
        self.exception = None
        self.last_modified_time = None
        self.last_status_modified_time = None
        self.parameters = parameters


class DscCompilationJobCreateParameters(msrest.serialization.Model):
    """The parameters supplied to the create compilation job operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Gets or sets name of the resource.
    :type name: str
    :param location: Gets or sets the location of the resource.
    :type location: str
    :param tags: A set of tags. Gets or sets the tags attached to the resource.
    :type tags: dict[str, str]
    :param configuration: Required. Gets or sets the configuration.
    :type configuration: ~azure.mgmt.automation.models.DscConfigurationAssociationProperty
    :param parameters: Gets or sets the parameters of the job.
    :type parameters: dict[str, str]
    :param increment_node_configuration_build: If a new build version of NodeConfiguration is
     required.
    :type increment_node_configuration_build: bool
    """

    _validation = {
        'configuration': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'configuration': {'key': 'properties.configuration', 'type': 'DscConfigurationAssociationProperty'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
        'increment_node_configuration_build': {'key': 'properties.incrementNodeConfigurationBuild', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        configuration: "DscConfigurationAssociationProperty",
        name: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        parameters: Optional[Dict[str, str]] = None,
        increment_node_configuration_build: Optional[bool] = None,
        **kwargs
    ):
        super(DscCompilationJobCreateParameters, self).__init__(**kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.configuration = configuration
        self.parameters = parameters
        self.increment_node_configuration_build = increment_node_configuration_build


class DscCompilationJobListResult(msrest.serialization.Model):
    """The response model for the list job operation.

    :param value: Gets or sets a list of Dsc Compilation jobs.
    :type value: list[~azure.mgmt.automation.models.DscCompilationJob]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DscCompilationJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DscCompilationJob"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DscCompilationJobListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DscConfiguration(TrackedResource):
    """Definition of the configuration type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: The Azure Region where the resource lives.
    :type location: str
    :param etag: Gets or sets the etag of the resource.
    :type etag: str
    :ivar provisioning_state: Gets or sets the provisioning state of the configuration. Default
     value: "Succeeded".
    :vartype provisioning_state: str
    :param job_count: Gets or sets the job count of the configuration.
    :type job_count: int
    :param parameters: Gets or sets the configuration parameters.
    :type parameters: dict[str, ~azure.mgmt.automation.models.DscConfigurationParameter]
    :param source: Gets or sets the source.
    :type source: ~azure.mgmt.automation.models.ContentSource
    :param state: Gets or sets the state of the configuration. Possible values include: "New",
     "Edit", "Published".
    :type state: str or ~azure.mgmt.automation.models.DscConfigurationState
    :param log_verbose: Gets or sets verbose log option.
    :type log_verbose: bool
    :param creation_time: Gets or sets the creation time.
    :type creation_time: ~datetime.datetime
    :param last_modified_time: Gets or sets the last modified time.
    :type last_modified_time: ~datetime.datetime
    :param node_configuration_count: Gets the number of compiled node configurations.
    :type node_configuration_count: int
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'constant': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'job_count': {'key': 'properties.jobCount', 'type': 'int'},
        'parameters': {'key': 'properties.parameters', 'type': '{DscConfigurationParameter}'},
        'source': {'key': 'properties.source', 'type': 'ContentSource'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'log_verbose': {'key': 'properties.logVerbose', 'type': 'bool'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'node_configuration_count': {'key': 'properties.nodeConfigurationCount', 'type': 'int'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    provisioning_state = "Succeeded"

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        etag: Optional[str] = None,
        job_count: Optional[int] = None,
        parameters: Optional[Dict[str, "DscConfigurationParameter"]] = None,
        source: Optional["ContentSource"] = None,
        state: Optional[Union[str, "DscConfigurationState"]] = None,
        log_verbose: Optional[bool] = None,
        creation_time: Optional[datetime.datetime] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        node_configuration_count: Optional[int] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(DscConfiguration, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = etag
        self.job_count = job_count
        self.parameters = parameters
        self.source = source
        self.state = state
        self.log_verbose = log_verbose
        self.creation_time = creation_time
        self.last_modified_time = last_modified_time
        self.node_configuration_count = node_configuration_count
        self.description = description


class DscConfigurationAssociationProperty(msrest.serialization.Model):
    """The Dsc configuration property associated with the entity.

    :param name: Gets or sets the name of the Dsc configuration.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(DscConfigurationAssociationProperty, self).__init__(**kwargs)
        self.name = name


class DscConfigurationCreateOrUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update configuration operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Gets or sets name of the resource.
    :type name: str
    :param location: Gets or sets the location of the resource.
    :type location: str
    :param tags: A set of tags. Gets or sets the tags attached to the resource.
    :type tags: dict[str, str]
    :param log_verbose: Gets or sets verbose log option.
    :type log_verbose: bool
    :param log_progress: Gets or sets progress log option.
    :type log_progress: bool
    :param source: Required. Gets or sets the source.
    :type source: ~azure.mgmt.automation.models.ContentSource
    :param parameters: Gets or sets the configuration parameters.
    :type parameters: dict[str, ~azure.mgmt.automation.models.DscConfigurationParameter]
    :param description: Gets or sets the description of the configuration.
    :type description: str
    """

    _validation = {
        'source': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'log_verbose': {'key': 'properties.logVerbose', 'type': 'bool'},
        'log_progress': {'key': 'properties.logProgress', 'type': 'bool'},
        'source': {'key': 'properties.source', 'type': 'ContentSource'},
        'parameters': {'key': 'properties.parameters', 'type': '{DscConfigurationParameter}'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source: "ContentSource",
        name: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        log_verbose: Optional[bool] = None,
        log_progress: Optional[bool] = None,
        parameters: Optional[Dict[str, "DscConfigurationParameter"]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(DscConfigurationCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.log_verbose = log_verbose
        self.log_progress = log_progress
        self.source = source
        self.parameters = parameters
        self.description = description


class DscConfigurationListResult(msrest.serialization.Model):
    """The response model for the list configuration operation.

    :param value: Gets or sets a list of configurations.
    :type value: list[~azure.mgmt.automation.models.DscConfiguration]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    :param total_count: Gets the total number of configurations matching filter criteria.
    :type total_count: int
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DscConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'total_count': {'key': 'totalCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DscConfiguration"]] = None,
        next_link: Optional[str] = None,
        total_count: Optional[int] = None,
        **kwargs
    ):
        super(DscConfigurationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link
        self.total_count = total_count


class DscConfigurationParameter(msrest.serialization.Model):
    """Definition of the configuration parameter type.

    :param type: Gets or sets the type of the parameter.
    :type type: str
    :param is_mandatory: Gets or sets a Boolean value to indicate whether the parameter is
     mandatory or not.
    :type is_mandatory: bool
    :param position: Get or sets the position of the parameter.
    :type position: int
    :param default_value: Gets or sets the default value of parameter.
    :type default_value: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_mandatory': {'key': 'isMandatory', 'type': 'bool'},
        'position': {'key': 'position', 'type': 'int'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        is_mandatory: Optional[bool] = None,
        position: Optional[int] = None,
        default_value: Optional[str] = None,
        **kwargs
    ):
        super(DscConfigurationParameter, self).__init__(**kwargs)
        self.type = type
        self.is_mandatory = is_mandatory
        self.position = position
        self.default_value = default_value


class DscConfigurationUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update configuration operation.

    :param name: Gets or sets name of the resource.
    :type name: str
    :param tags: A set of tags. Gets or sets the tags attached to the resource.
    :type tags: dict[str, str]
    :param log_verbose: Gets or sets verbose log option.
    :type log_verbose: bool
    :param log_progress: Gets or sets progress log option.
    :type log_progress: bool
    :param source: Gets or sets the source.
    :type source: ~azure.mgmt.automation.models.ContentSource
    :param parameters: Gets or sets the configuration parameters.
    :type parameters: dict[str, ~azure.mgmt.automation.models.DscConfigurationParameter]
    :param description: Gets or sets the description of the configuration.
    :type description: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'log_verbose': {'key': 'properties.logVerbose', 'type': 'bool'},
        'log_progress': {'key': 'properties.logProgress', 'type': 'bool'},
        'source': {'key': 'properties.source', 'type': 'ContentSource'},
        'parameters': {'key': 'properties.parameters', 'type': '{DscConfigurationParameter}'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        log_verbose: Optional[bool] = None,
        log_progress: Optional[bool] = None,
        source: Optional["ContentSource"] = None,
        parameters: Optional[Dict[str, "DscConfigurationParameter"]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(DscConfigurationUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.tags = tags
        self.log_verbose = log_verbose
        self.log_progress = log_progress
        self.source = source
        self.parameters = parameters
        self.description = description


class DscMetaConfiguration(msrest.serialization.Model):
    """Definition of the DSC Meta Configuration.

    :param configuration_mode_frequency_mins: Gets or sets the ConfigurationModeFrequencyMins value
     of the meta configuration.
    :type configuration_mode_frequency_mins: int
    :param reboot_node_if_needed: Gets or sets the RebootNodeIfNeeded value of the meta
     configuration.
    :type reboot_node_if_needed: bool
    :param configuration_mode: Gets or sets the ConfigurationMode value of the meta configuration.
    :type configuration_mode: str
    :param action_after_reboot: Gets or sets the ActionAfterReboot value of the meta configuration.
    :type action_after_reboot: str
    :param certificate_id: Gets or sets the CertificateId value of the meta configuration.
    :type certificate_id: str
    :param refresh_frequency_mins: Gets or sets the RefreshFrequencyMins value of the meta
     configuration.
    :type refresh_frequency_mins: int
    :param allow_module_overwrite: Gets or sets the AllowModuleOverwrite value of the meta
     configuration.
    :type allow_module_overwrite: bool
    """

    _attribute_map = {
        'configuration_mode_frequency_mins': {'key': 'configurationModeFrequencyMins', 'type': 'int'},
        'reboot_node_if_needed': {'key': 'rebootNodeIfNeeded', 'type': 'bool'},
        'configuration_mode': {'key': 'configurationMode', 'type': 'str'},
        'action_after_reboot': {'key': 'actionAfterReboot', 'type': 'str'},
        'certificate_id': {'key': 'certificateId', 'type': 'str'},
        'refresh_frequency_mins': {'key': 'refreshFrequencyMins', 'type': 'int'},
        'allow_module_overwrite': {'key': 'allowModuleOverwrite', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        configuration_mode_frequency_mins: Optional[int] = None,
        reboot_node_if_needed: Optional[bool] = None,
        configuration_mode: Optional[str] = None,
        action_after_reboot: Optional[str] = None,
        certificate_id: Optional[str] = None,
        refresh_frequency_mins: Optional[int] = None,
        allow_module_overwrite: Optional[bool] = None,
        **kwargs
    ):
        super(DscMetaConfiguration, self).__init__(**kwargs)
        self.configuration_mode_frequency_mins = configuration_mode_frequency_mins
        self.reboot_node_if_needed = reboot_node_if_needed
        self.configuration_mode = configuration_mode
        self.action_after_reboot = action_after_reboot
        self.certificate_id = certificate_id
        self.refresh_frequency_mins = refresh_frequency_mins
        self.allow_module_overwrite = allow_module_overwrite


class DscNode(Resource):
    """Definition of a DscNode.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param last_seen: Gets or sets the last seen time of the node.
    :type last_seen: ~datetime.datetime
    :param registration_time: Gets or sets the registration time of the node.
    :type registration_time: ~datetime.datetime
    :param ip: Gets or sets the ip of the node.
    :type ip: str
    :param account_id: Gets or sets the account id of the node.
    :type account_id: str
    :param status: Gets or sets the status of the node.
    :type status: str
    :param node_id: Gets or sets the node id.
    :type node_id: str
    :param etag: Gets or sets the etag of the resource.
    :type etag: str
    :param total_count: Gets the total number of records matching filter criteria.
    :type total_count: int
    :param extension_handler: Gets or sets the list of extensionHandler properties for a Node.
    :type extension_handler:
     list[~azure.mgmt.automation.models.DscNodeExtensionHandlerAssociationProperty]
    :param name_properties_node_configuration_name: Gets or sets the name of the dsc node
     configuration.
    :type name_properties_node_configuration_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'last_seen': {'key': 'properties.lastSeen', 'type': 'iso-8601'},
        'registration_time': {'key': 'properties.registrationTime', 'type': 'iso-8601'},
        'ip': {'key': 'properties.ip', 'type': 'str'},
        'account_id': {'key': 'properties.accountId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'node_id': {'key': 'properties.nodeId', 'type': 'str'},
        'etag': {'key': 'properties.etag', 'type': 'str'},
        'total_count': {'key': 'properties.totalCount', 'type': 'int'},
        'extension_handler': {'key': 'properties.extensionHandler', 'type': '[DscNodeExtensionHandlerAssociationProperty]'},
        'name_properties_node_configuration_name': {'key': 'properties.nodeConfiguration.name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        last_seen: Optional[datetime.datetime] = None,
        registration_time: Optional[datetime.datetime] = None,
        ip: Optional[str] = None,
        account_id: Optional[str] = None,
        status: Optional[str] = None,
        node_id: Optional[str] = None,
        etag: Optional[str] = None,
        total_count: Optional[int] = None,
        extension_handler: Optional[List["DscNodeExtensionHandlerAssociationProperty"]] = None,
        name_properties_node_configuration_name: Optional[str] = None,
        **kwargs
    ):
        super(DscNode, self).__init__(**kwargs)
        self.last_seen = last_seen
        self.registration_time = registration_time
        self.ip = ip
        self.account_id = account_id
        self.status = status
        self.node_id = node_id
        self.etag = etag
        self.total_count = total_count
        self.extension_handler = extension_handler
        self.name_properties_node_configuration_name = name_properties_node_configuration_name


class DscNodeConfiguration(Resource):
    """Definition of the dsc node configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param last_modified_time: Gets or sets the last modified time.
    :type last_modified_time: ~datetime.datetime
    :param creation_time: Gets or sets creation time.
    :type creation_time: ~datetime.datetime
    :param configuration: Gets or sets the configuration of the node.
    :type configuration: ~azure.mgmt.automation.models.DscConfigurationAssociationProperty
    :param source: Source of node configuration.
    :type source: str
    :param node_count: Number of nodes with this node configuration assigned.
    :type node_count: long
    :param increment_node_configuration_build: If a new build version of NodeConfiguration is
     required.
    :type increment_node_configuration_build: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'configuration': {'key': 'properties.configuration', 'type': 'DscConfigurationAssociationProperty'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'node_count': {'key': 'properties.nodeCount', 'type': 'long'},
        'increment_node_configuration_build': {'key': 'properties.incrementNodeConfigurationBuild', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        last_modified_time: Optional[datetime.datetime] = None,
        creation_time: Optional[datetime.datetime] = None,
        configuration: Optional["DscConfigurationAssociationProperty"] = None,
        source: Optional[str] = None,
        node_count: Optional[int] = None,
        increment_node_configuration_build: Optional[bool] = None,
        **kwargs
    ):
        super(DscNodeConfiguration, self).__init__(**kwargs)
        self.last_modified_time = last_modified_time
        self.creation_time = creation_time
        self.configuration = configuration
        self.source = source
        self.node_count = node_count
        self.increment_node_configuration_build = increment_node_configuration_build


class DscNodeConfigurationCreateOrUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update node configuration operation.

    :param name: Name of the node configuration.
    :type name: str
    :param tags: A set of tags. Gets or sets the tags attached to the resource.
    :type tags: dict[str, str]
    :param source: Gets or sets the source.
    :type source: ~azure.mgmt.automation.models.ContentSource
    :param configuration: Gets or sets the configuration of the node.
    :type configuration: ~azure.mgmt.automation.models.DscConfigurationAssociationProperty
    :param increment_node_configuration_build: If a new build version of NodeConfiguration is
     required.
    :type increment_node_configuration_build: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'source': {'key': 'properties.source', 'type': 'ContentSource'},
        'configuration': {'key': 'properties.configuration', 'type': 'DscConfigurationAssociationProperty'},
        'increment_node_configuration_build': {'key': 'properties.incrementNodeConfigurationBuild', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        source: Optional["ContentSource"] = None,
        configuration: Optional["DscConfigurationAssociationProperty"] = None,
        increment_node_configuration_build: Optional[bool] = None,
        **kwargs
    ):
        super(DscNodeConfigurationCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.tags = tags
        self.source = source
        self.configuration = configuration
        self.increment_node_configuration_build = increment_node_configuration_build


class DscNodeConfigurationListResult(msrest.serialization.Model):
    """The response model for the list job operation.

    :param value: Gets or sets a list of Dsc node configurations.
    :type value: list[~azure.mgmt.automation.models.DscNodeConfiguration]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    :param total_count: Gets or sets the total rows in query.
    :type total_count: int
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DscNodeConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'total_count': {'key': 'totalCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DscNodeConfiguration"]] = None,
        next_link: Optional[str] = None,
        total_count: Optional[int] = None,
        **kwargs
    ):
        super(DscNodeConfigurationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link
        self.total_count = total_count


class DscNodeExtensionHandlerAssociationProperty(msrest.serialization.Model):
    """The dsc extensionHandler property associated with the node.

    :param name: Gets or sets the name of the extension handler.
    :type name: str
    :param version: Gets or sets the version of the extension handler.
    :type version: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        super(DscNodeExtensionHandlerAssociationProperty, self).__init__(**kwargs)
        self.name = name
        self.version = version


class DscNodeListResult(msrest.serialization.Model):
    """The response model for the list dsc nodes operation.

    :param value: Gets or sets a list of dsc nodes.
    :type value: list[~azure.mgmt.automation.models.DscNode]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    :param total_count: Gets the total number of nodes matching filter criteria.
    :type total_count: int
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DscNode]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'total_count': {'key': 'totalCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DscNode"]] = None,
        next_link: Optional[str] = None,
        total_count: Optional[int] = None,
        **kwargs
    ):
        super(DscNodeListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link
        self.total_count = total_count


class DscNodeReport(msrest.serialization.Model):
    """Definition of the dsc node report type.

    :param end_time: Gets or sets the end time of the node report.
    :type end_time: ~datetime.datetime
    :param last_modified_time: Gets or sets the lastModifiedTime of the node report.
    :type last_modified_time: ~datetime.datetime
    :param start_time: Gets or sets the start time of the node report.
    :type start_time: ~datetime.datetime
    :param type: Gets or sets the type of the node report.
    :type type: str
    :param report_id: Gets or sets the id of the node report.
    :type report_id: str
    :param status: Gets or sets the status of the node report.
    :type status: str
    :param refresh_mode: Gets or sets the refreshMode of the node report.
    :type refresh_mode: str
    :param reboot_requested: Gets or sets the rebootRequested of the node report.
    :type reboot_requested: str
    :param report_format_version: Gets or sets the reportFormatVersion of the node report.
    :type report_format_version: str
    :param configuration_version: Gets or sets the configurationVersion of the node report.
    :type configuration_version: str
    :param id: Gets or sets the id.
    :type id: str
    :param errors: Gets or sets the errors for the node report.
    :type errors: list[~azure.mgmt.automation.models.DscReportError]
    :param resources: Gets or sets the resource for the node report.
    :type resources: list[~azure.mgmt.automation.models.DscReportResource]
    :param meta_configuration: Gets or sets the metaConfiguration of the node at the time of the
     report.
    :type meta_configuration: ~azure.mgmt.automation.models.DscMetaConfiguration
    :param host_name: Gets or sets the hostname of the node that sent the report.
    :type host_name: str
    :param i_pv4_addresses: Gets or sets the IPv4 address of the node that sent the report.
    :type i_pv4_addresses: list[str]
    :param i_pv6_addresses: Gets or sets the IPv6 address of the node that sent the report.
    :type i_pv6_addresses: list[str]
    :param number_of_resources: Gets or sets the number of resource in the node report.
    :type number_of_resources: int
    :param raw_errors: Gets or sets the unparsed errors for the node report.
    :type raw_errors: str
    """

    _attribute_map = {
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'report_id': {'key': 'reportId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'refresh_mode': {'key': 'refreshMode', 'type': 'str'},
        'reboot_requested': {'key': 'rebootRequested', 'type': 'str'},
        'report_format_version': {'key': 'reportFormatVersion', 'type': 'str'},
        'configuration_version': {'key': 'configurationVersion', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[DscReportError]'},
        'resources': {'key': 'resources', 'type': '[DscReportResource]'},
        'meta_configuration': {'key': 'metaConfiguration', 'type': 'DscMetaConfiguration'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'i_pv4_addresses': {'key': 'iPV4Addresses', 'type': '[str]'},
        'i_pv6_addresses': {'key': 'iPV6Addresses', 'type': '[str]'},
        'number_of_resources': {'key': 'numberOfResources', 'type': 'int'},
        'raw_errors': {'key': 'rawErrors', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        end_time: Optional[datetime.datetime] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        start_time: Optional[datetime.datetime] = None,
        type: Optional[str] = None,
        report_id: Optional[str] = None,
        status: Optional[str] = None,
        refresh_mode: Optional[str] = None,
        reboot_requested: Optional[str] = None,
        report_format_version: Optional[str] = None,
        configuration_version: Optional[str] = None,
        id: Optional[str] = None,
        errors: Optional[List["DscReportError"]] = None,
        resources: Optional[List["DscReportResource"]] = None,
        meta_configuration: Optional["DscMetaConfiguration"] = None,
        host_name: Optional[str] = None,
        i_pv4_addresses: Optional[List[str]] = None,
        i_pv6_addresses: Optional[List[str]] = None,
        number_of_resources: Optional[int] = None,
        raw_errors: Optional[str] = None,
        **kwargs
    ):
        super(DscNodeReport, self).__init__(**kwargs)
        self.end_time = end_time
        self.last_modified_time = last_modified_time
        self.start_time = start_time
        self.type = type
        self.report_id = report_id
        self.status = status
        self.refresh_mode = refresh_mode
        self.reboot_requested = reboot_requested
        self.report_format_version = report_format_version
        self.configuration_version = configuration_version
        self.id = id
        self.errors = errors
        self.resources = resources
        self.meta_configuration = meta_configuration
        self.host_name = host_name
        self.i_pv4_addresses = i_pv4_addresses
        self.i_pv6_addresses = i_pv6_addresses
        self.number_of_resources = number_of_resources
        self.raw_errors = raw_errors


class DscNodeReportListResult(msrest.serialization.Model):
    """The response model for the list dsc nodes operation.

    :param value: Gets or sets a list of dsc node reports.
    :type value: list[~azure.mgmt.automation.models.DscNodeReport]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DscNodeReport]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DscNodeReport"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DscNodeReportListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DscNodeUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the update dsc node operation.

    :param node_id: Gets or sets the id of the dsc node.
    :type node_id: str
    :param properties:
    :type properties: ~azure.mgmt.automation.models.DscNodeUpdateParametersProperties
    """

    _attribute_map = {
        'node_id': {'key': 'nodeId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DscNodeUpdateParametersProperties'},
    }

    def __init__(
        self,
        *,
        node_id: Optional[str] = None,
        properties: Optional["DscNodeUpdateParametersProperties"] = None,
        **kwargs
    ):
        super(DscNodeUpdateParameters, self).__init__(**kwargs)
        self.node_id = node_id
        self.properties = properties


class DscNodeUpdateParametersProperties(msrest.serialization.Model):
    """DscNodeUpdateParametersProperties.

    :param name: Gets or sets the name of the dsc node configuration.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'nodeConfiguration.name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(DscNodeUpdateParametersProperties, self).__init__(**kwargs)
        self.name = name


class DscReportError(msrest.serialization.Model):
    """Definition of the dsc node report error type.

    :param error_source: Gets or sets the source of the error.
    :type error_source: str
    :param resource_id: Gets or sets the resource ID which generated the error.
    :type resource_id: str
    :param error_code: Gets or sets the error code.
    :type error_code: str
    :param error_message: Gets or sets the error message.
    :type error_message: str
    :param locale: Gets or sets the locale of the error.
    :type locale: str
    :param error_details: Gets or sets the error details.
    :type error_details: str
    """

    _attribute_map = {
        'error_source': {'key': 'errorSource', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'locale': {'key': 'locale', 'type': 'str'},
        'error_details': {'key': 'errorDetails', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        error_source: Optional[str] = None,
        resource_id: Optional[str] = None,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        locale: Optional[str] = None,
        error_details: Optional[str] = None,
        **kwargs
    ):
        super(DscReportError, self).__init__(**kwargs)
        self.error_source = error_source
        self.resource_id = resource_id
        self.error_code = error_code
        self.error_message = error_message
        self.locale = locale
        self.error_details = error_details


class DscReportResource(msrest.serialization.Model):
    """Definition of the DSC Report Resource.

    :param resource_id: Gets or sets the ID of the resource.
    :type resource_id: str
    :param source_info: Gets or sets the source info of the resource.
    :type source_info: str
    :param depends_on: Gets or sets the Resource Navigation values for resources the resource
     depends on.
    :type depends_on: list[~azure.mgmt.automation.models.DscReportResourceNavigation]
    :param module_name: Gets or sets the module name of the resource.
    :type module_name: str
    :param module_version: Gets or sets the module version of the resource.
    :type module_version: str
    :param resource_name: Gets or sets the name of the resource.
    :type resource_name: str
    :param error: Gets or sets the error of the resource.
    :type error: str
    :param status: Gets or sets the status of the resource.
    :type status: str
    :param duration_in_seconds: Gets or sets the duration in seconds for the resource.
    :type duration_in_seconds: float
    :param start_date: Gets or sets the start date of the resource.
    :type start_date: ~datetime.datetime
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'source_info': {'key': 'sourceInfo', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[DscReportResourceNavigation]'},
        'module_name': {'key': 'moduleName', 'type': 'str'},
        'module_version': {'key': 'moduleVersion', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'error': {'key': 'error', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'duration_in_seconds': {'key': 'durationInSeconds', 'type': 'float'},
        'start_date': {'key': 'startDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        source_info: Optional[str] = None,
        depends_on: Optional[List["DscReportResourceNavigation"]] = None,
        module_name: Optional[str] = None,
        module_version: Optional[str] = None,
        resource_name: Optional[str] = None,
        error: Optional[str] = None,
        status: Optional[str] = None,
        duration_in_seconds: Optional[float] = None,
        start_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(DscReportResource, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.source_info = source_info
        self.depends_on = depends_on
        self.module_name = module_name
        self.module_version = module_version
        self.resource_name = resource_name
        self.error = error
        self.status = status
        self.duration_in_seconds = duration_in_seconds
        self.start_date = start_date


class DscReportResourceNavigation(msrest.serialization.Model):
    """Navigation for DSC Report Resource.

    :param resource_id: Gets or sets the ID of the resource to navigate to.
    :type resource_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        super(DscReportResourceNavigation, self).__init__(**kwargs)
        self.resource_id = resource_id


class ErrorResponse(msrest.serialization.Model):
    """Error response of an operation failure.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class FieldDefinition(msrest.serialization.Model):
    """Definition of the connection fields.

    All required parameters must be populated in order to send to Azure.

    :param is_encrypted: Gets or sets the isEncrypted flag of the connection field definition.
    :type is_encrypted: bool
    :param is_optional: Gets or sets the isOptional flag of the connection field definition.
    :type is_optional: bool
    :param type: Required. Gets or sets the type of the connection field definition.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'is_encrypted': {'key': 'isEncrypted', 'type': 'bool'},
        'is_optional': {'key': 'isOptional', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: str,
        is_encrypted: Optional[bool] = None,
        is_optional: Optional[bool] = None,
        **kwargs
    ):
        super(FieldDefinition, self).__init__(**kwargs)
        self.is_encrypted = is_encrypted
        self.is_optional = is_optional
        self.type = type


class HybridRunbookWorker(msrest.serialization.Model):
    """Definition of hybrid runbook worker.

    :param name: Gets or sets the worker machine name.
    :type name: str
    :param ip: Gets or sets the assigned machine IP address.
    :type ip: str
    :param registration_time: Gets or sets the registration time of the worker machine.
    :type registration_time: ~datetime.datetime
    :param last_seen_date_time: Last Heartbeat from the Worker.
    :type last_seen_date_time: ~datetime.datetime
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'ip': {'key': 'ip', 'type': 'str'},
        'registration_time': {'key': 'registrationTime', 'type': 'iso-8601'},
        'last_seen_date_time': {'key': 'lastSeenDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        ip: Optional[str] = None,
        registration_time: Optional[datetime.datetime] = None,
        last_seen_date_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(HybridRunbookWorker, self).__init__(**kwargs)
        self.name = name
        self.ip = ip
        self.registration_time = registration_time
        self.last_seen_date_time = last_seen_date_time


class HybridRunbookWorkerGroup(msrest.serialization.Model):
    """Definition of hybrid runbook worker group.

    :param id: Gets or sets the id of the resource.
    :type id: str
    :param name: Gets or sets the name of the group.
    :type name: str
    :param hybrid_runbook_workers: Gets or sets the list of hybrid runbook workers.
    :type hybrid_runbook_workers: list[~azure.mgmt.automation.models.HybridRunbookWorker]
    :param credential: Sets the credential of a worker group.
    :type credential: ~azure.mgmt.automation.models.RunAsCredentialAssociationProperty
    :param group_type: Type of the HybridWorkerGroup. Possible values include: "User", "System".
    :type group_type: str or ~azure.mgmt.automation.models.GroupTypeEnum
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'hybrid_runbook_workers': {'key': 'hybridRunbookWorkers', 'type': '[HybridRunbookWorker]'},
        'credential': {'key': 'credential', 'type': 'RunAsCredentialAssociationProperty'},
        'group_type': {'key': 'groupType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        hybrid_runbook_workers: Optional[List["HybridRunbookWorker"]] = None,
        credential: Optional["RunAsCredentialAssociationProperty"] = None,
        group_type: Optional[Union[str, "GroupTypeEnum"]] = None,
        **kwargs
    ):
        super(HybridRunbookWorkerGroup, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.hybrid_runbook_workers = hybrid_runbook_workers
        self.credential = credential
        self.group_type = group_type


class HybridRunbookWorkerGroupsListResult(msrest.serialization.Model):
    """The response model for the list hybrid runbook worker groups.

    :param value: Gets or sets a list of hybrid runbook worker groups.
    :type value: list[~azure.mgmt.automation.models.HybridRunbookWorkerGroup]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HybridRunbookWorkerGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["HybridRunbookWorkerGroup"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(HybridRunbookWorkerGroupsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class HybridRunbookWorkerGroupUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to the update operation.

    :param credential: Sets the credential of a worker group.
    :type credential: ~azure.mgmt.automation.models.RunAsCredentialAssociationProperty
    """

    _attribute_map = {
        'credential': {'key': 'credential', 'type': 'RunAsCredentialAssociationProperty'},
    }

    def __init__(
        self,
        *,
        credential: Optional["RunAsCredentialAssociationProperty"] = None,
        **kwargs
    ):
        super(HybridRunbookWorkerGroupUpdateParameters, self).__init__(**kwargs)
        self.credential = credential


class Job(Resource):
    """Definition of the job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param runbook: Gets or sets the runbook.
    :type runbook: ~azure.mgmt.automation.models.RunbookAssociationProperty
    :param started_by: Gets or sets the job started by.
    :type started_by: str
    :param run_on: Gets or sets the runOn which specifies the group name where the job is to be
     executed.
    :type run_on: str
    :param job_id: Gets or sets the id of the job.
    :type job_id: str
    :param creation_time: Gets or sets the creation time of the job.
    :type creation_time: ~datetime.datetime
    :param status: Gets or sets the status of the job. Possible values include: "New",
     "Activating", "Running", "Completed", "Failed", "Stopped", "Blocked", "Suspended",
     "Disconnected", "Suspending", "Stopping", "Resuming", "Removing".
    :type status: str or ~azure.mgmt.automation.models.JobStatus
    :param status_details: Gets or sets the status details of the job.
    :type status_details: str
    :param start_time: Gets or sets the start time of the job.
    :type start_time: ~datetime.datetime
    :param end_time: Gets or sets the end time of the job.
    :type end_time: ~datetime.datetime
    :param exception: Gets or sets the exception of the job.
    :type exception: str
    :param last_modified_time: Gets or sets the last modified time of the job.
    :type last_modified_time: ~datetime.datetime
    :param last_status_modified_time: Gets or sets the last status modified time of the job.
    :type last_status_modified_time: ~datetime.datetime
    :param parameters: Gets or sets the parameters of the job.
    :type parameters: dict[str, str]
    :param provisioning_state: The current provisioning state of the job. Possible values include:
     "Failed", "Succeeded", "Suspended", "Processing".
    :type provisioning_state: str or ~azure.mgmt.automation.models.JobProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'runbook': {'key': 'properties.runbook', 'type': 'RunbookAssociationProperty'},
        'started_by': {'key': 'properties.startedBy', 'type': 'str'},
        'run_on': {'key': 'properties.runOn', 'type': 'str'},
        'job_id': {'key': 'properties.jobId', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'status_details': {'key': 'properties.statusDetails', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'exception': {'key': 'properties.exception', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'last_status_modified_time': {'key': 'properties.lastStatusModifiedTime', 'type': 'iso-8601'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        runbook: Optional["RunbookAssociationProperty"] = None,
        started_by: Optional[str] = None,
        run_on: Optional[str] = None,
        job_id: Optional[str] = None,
        creation_time: Optional[datetime.datetime] = None,
        status: Optional[Union[str, "JobStatus"]] = None,
        status_details: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        exception: Optional[str] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        last_status_modified_time: Optional[datetime.datetime] = None,
        parameters: Optional[Dict[str, str]] = None,
        provisioning_state: Optional[Union[str, "JobProvisioningState"]] = None,
        **kwargs
    ):
        super(Job, self).__init__(**kwargs)
        self.runbook = runbook
        self.started_by = started_by
        self.run_on = run_on
        self.job_id = job_id
        self.creation_time = creation_time
        self.status = status
        self.status_details = status_details
        self.start_time = start_time
        self.end_time = end_time
        self.exception = exception
        self.last_modified_time = last_modified_time
        self.last_status_modified_time = last_status_modified_time
        self.parameters = parameters
        self.provisioning_state = provisioning_state


class JobCollectionItem(Resource):
    """Job collection item properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar runbook: The runbook association.
    :vartype runbook: ~azure.mgmt.automation.models.RunbookAssociationProperty
    :ivar job_id: The id of the job.
    :vartype job_id: str
    :ivar creation_time: The creation time of the job.
    :vartype creation_time: ~datetime.datetime
    :ivar status: The status of the job. Possible values include: "New", "Activating", "Running",
     "Completed", "Failed", "Stopped", "Blocked", "Suspended", "Disconnected", "Suspending",
     "Stopping", "Resuming", "Removing".
    :vartype status: str or ~azure.mgmt.automation.models.JobStatus
    :ivar start_time: The start time of the job.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the job.
    :vartype end_time: ~datetime.datetime
    :ivar last_modified_time: The last modified time of the job.
    :vartype last_modified_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of a resource.
    :vartype provisioning_state: str
    :param run_on: Specifies the runOn group name where the job was executed.
    :type run_on: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'runbook': {'readonly': True},
        'job_id': {'readonly': True},
        'creation_time': {'readonly': True},
        'status': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'runbook': {'key': 'properties.runbook', 'type': 'RunbookAssociationProperty'},
        'job_id': {'key': 'properties.jobId', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'run_on': {'key': 'properties.runOn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        run_on: Optional[str] = None,
        **kwargs
    ):
        super(JobCollectionItem, self).__init__(**kwargs)
        self.runbook = None
        self.job_id = None
        self.creation_time = None
        self.status = None
        self.start_time = None
        self.end_time = None
        self.last_modified_time = None
        self.provisioning_state = None
        self.run_on = run_on


class JobCreateParameters(msrest.serialization.Model):
    """The parameters supplied to the create job operation.

    :param runbook: Gets or sets the runbook.
    :type runbook: ~azure.mgmt.automation.models.RunbookAssociationProperty
    :param parameters: Gets or sets the parameters of the job.
    :type parameters: dict[str, str]
    :param run_on: Gets or sets the runOn which specifies the group name where the job is to be
     executed.
    :type run_on: str
    """

    _attribute_map = {
        'runbook': {'key': 'properties.runbook', 'type': 'RunbookAssociationProperty'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
        'run_on': {'key': 'properties.runOn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        runbook: Optional["RunbookAssociationProperty"] = None,
        parameters: Optional[Dict[str, str]] = None,
        run_on: Optional[str] = None,
        **kwargs
    ):
        super(JobCreateParameters, self).__init__(**kwargs)
        self.runbook = runbook
        self.parameters = parameters
        self.run_on = run_on


class JobListResultV2(msrest.serialization.Model):
    """The response model for the list job operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of jobs.
    :type value: list[~azure.mgmt.automation.models.JobCollectionItem]
    :ivar next_link: The  link to the next page.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobCollectionItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["JobCollectionItem"]] = None,
        **kwargs
    ):
        super(JobListResultV2, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class JobNavigation(msrest.serialization.Model):
    """Software update configuration machine run job navigation properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id of the job associated with the software update configuration run.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobNavigation, self).__init__(**kwargs)
        self.id = None


class JobSchedule(msrest.serialization.Model):
    """Definition of the job schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Gets the id of the resource.
    :vartype id: str
    :ivar name: Gets the name of the variable.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param job_schedule_id: Gets or sets the id of job schedule.
    :type job_schedule_id: str
    :param schedule: Gets or sets the schedule.
    :type schedule: ~azure.mgmt.automation.models.ScheduleAssociationProperty
    :param runbook: Gets or sets the runbook.
    :type runbook: ~azure.mgmt.automation.models.RunbookAssociationProperty
    :param run_on: Gets or sets the hybrid worker group that the scheduled job should run on.
    :type run_on: str
    :param parameters: Gets or sets the parameters of the job schedule.
    :type parameters: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'job_schedule_id': {'key': 'properties.jobScheduleId', 'type': 'str'},
        'schedule': {'key': 'properties.schedule', 'type': 'ScheduleAssociationProperty'},
        'runbook': {'key': 'properties.runbook', 'type': 'RunbookAssociationProperty'},
        'run_on': {'key': 'properties.runOn', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        job_schedule_id: Optional[str] = None,
        schedule: Optional["ScheduleAssociationProperty"] = None,
        runbook: Optional["RunbookAssociationProperty"] = None,
        run_on: Optional[str] = None,
        parameters: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(JobSchedule, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.job_schedule_id = job_schedule_id
        self.schedule = schedule
        self.runbook = runbook
        self.run_on = run_on
        self.parameters = parameters


class JobScheduleCreateParameters(msrest.serialization.Model):
    """The parameters supplied to the create job schedule operation.

    All required parameters must be populated in order to send to Azure.

    :param schedule: Required. Gets or sets the schedule.
    :type schedule: ~azure.mgmt.automation.models.ScheduleAssociationProperty
    :param runbook: Required. Gets or sets the runbook.
    :type runbook: ~azure.mgmt.automation.models.RunbookAssociationProperty
    :param run_on: Gets or sets the hybrid worker group that the scheduled job should run on.
    :type run_on: str
    :param parameters: Gets or sets a list of job properties.
    :type parameters: dict[str, str]
    """

    _validation = {
        'schedule': {'required': True},
        'runbook': {'required': True},
    }

    _attribute_map = {
        'schedule': {'key': 'properties.schedule', 'type': 'ScheduleAssociationProperty'},
        'runbook': {'key': 'properties.runbook', 'type': 'RunbookAssociationProperty'},
        'run_on': {'key': 'properties.runOn', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        schedule: "ScheduleAssociationProperty",
        runbook: "RunbookAssociationProperty",
        run_on: Optional[str] = None,
        parameters: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(JobScheduleCreateParameters, self).__init__(**kwargs)
        self.schedule = schedule
        self.runbook = runbook
        self.run_on = run_on
        self.parameters = parameters


class JobScheduleListResult(msrest.serialization.Model):
    """The response model for the list job schedule operation.

    :param value: Gets or sets a list of job schedules.
    :type value: list[~azure.mgmt.automation.models.JobSchedule]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobSchedule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["JobSchedule"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(JobScheduleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class JobStream(msrest.serialization.Model):
    """Definition of the job stream.

    :param id: Gets or sets the id of the resource.
    :type id: str
    :param job_stream_id: Gets or sets the id of the job stream.
    :type job_stream_id: str
    :param time: Gets or sets the creation time of the job.
    :type time: ~datetime.datetime
    :param stream_type: Gets or sets the stream type. Possible values include: "Progress",
     "Output", "Warning", "Error", "Debug", "Verbose", "Any".
    :type stream_type: str or ~azure.mgmt.automation.models.JobStreamType
    :param stream_text: Gets or sets the stream text.
    :type stream_text: str
    :param summary: Gets or sets the summary.
    :type summary: str
    :param value: Gets or sets the values of the job stream.
    :type value: dict[str, object]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'job_stream_id': {'key': 'properties.jobStreamId', 'type': 'str'},
        'time': {'key': 'properties.time', 'type': 'iso-8601'},
        'stream_type': {'key': 'properties.streamType', 'type': 'str'},
        'stream_text': {'key': 'properties.streamText', 'type': 'str'},
        'summary': {'key': 'properties.summary', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        job_stream_id: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
        stream_type: Optional[Union[str, "JobStreamType"]] = None,
        stream_text: Optional[str] = None,
        summary: Optional[str] = None,
        value: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(JobStream, self).__init__(**kwargs)
        self.id = id
        self.job_stream_id = job_stream_id
        self.time = time
        self.stream_type = stream_type
        self.stream_text = stream_text
        self.summary = summary
        self.value = value


class JobStreamListResult(msrest.serialization.Model):
    """The response model for the list job stream operation.

    :param value: A list of job streams.
    :type value: list[~azure.mgmt.automation.models.JobStream]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobStream]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["JobStream"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(JobStreamListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Key(msrest.serialization.Model):
    """Automation key which is used to register a DSC Node.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_name: Automation key name. Possible values include: "Primary", "Secondary".
    :vartype key_name: str or ~azure.mgmt.automation.models.AutomationKeyName
    :ivar permissions: Automation key permissions. Possible values include: "Read", "Full".
    :vartype permissions: str or ~azure.mgmt.automation.models.AutomationKeyPermissions
    :ivar value: Value of the Automation Key used for registration.
    :vartype value: str
    """

    _validation = {
        'key_name': {'readonly': True},
        'permissions': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'key_name': {'key': 'KeyName', 'type': 'str'},
        'permissions': {'key': 'Permissions', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Key, self).__init__(**kwargs)
        self.key_name = None
        self.permissions = None
        self.value = None


class KeyListResult(msrest.serialization.Model):
    """KeyListResult.

    :param keys: Lists the automation keys.
    :type keys: list[~azure.mgmt.automation.models.Key]
    """

    _attribute_map = {
        'keys': {'key': 'keys', 'type': '[Key]'},
    }

    def __init__(
        self,
        *,
        keys: Optional[List["Key"]] = None,
        **kwargs
    ):
        super(KeyListResult, self).__init__(**kwargs)
        self.keys = keys


class LinkedWorkspace(msrest.serialization.Model):
    """Definition of the linked workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Gets the id of the linked workspace.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedWorkspace, self).__init__(**kwargs)
        self.id = None


class LinuxProperties(msrest.serialization.Model):
    """Linux specific update configuration.

    :param included_package_classifications: Update classifications included in the software update
     configuration. Possible values include: "Unclassified", "Critical", "Security", "Other".
    :type included_package_classifications: str or ~azure.mgmt.automation.models.LinuxUpdateClasses
    :param excluded_package_name_masks: packages excluded from the software update configuration.
    :type excluded_package_name_masks: list[str]
    :param included_package_name_masks: packages included from the software update configuration.
    :type included_package_name_masks: list[str]
    :param reboot_setting: Reboot setting for the software update configuration.
    :type reboot_setting: str
    """

    _attribute_map = {
        'included_package_classifications': {'key': 'includedPackageClassifications', 'type': 'str'},
        'excluded_package_name_masks': {'key': 'excludedPackageNameMasks', 'type': '[str]'},
        'included_package_name_masks': {'key': 'includedPackageNameMasks', 'type': '[str]'},
        'reboot_setting': {'key': 'rebootSetting', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        included_package_classifications: Optional[Union[str, "LinuxUpdateClasses"]] = None,
        excluded_package_name_masks: Optional[List[str]] = None,
        included_package_name_masks: Optional[List[str]] = None,
        reboot_setting: Optional[str] = None,
        **kwargs
    ):
        super(LinuxProperties, self).__init__(**kwargs)
        self.included_package_classifications = included_package_classifications
        self.excluded_package_name_masks = excluded_package_name_masks
        self.included_package_name_masks = included_package_name_masks
        self.reboot_setting = reboot_setting


class Module(TrackedResource):
    """Definition of the module type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: The Azure Region where the resource lives.
    :type location: str
    :param etag: Gets or sets the etag of the resource.
    :type etag: str
    :param is_global: Gets or sets the isGlobal flag of the module.
    :type is_global: bool
    :param version: Gets or sets the version of the module.
    :type version: str
    :param size_in_bytes: Gets or sets the size in bytes of the module.
    :type size_in_bytes: long
    :param activity_count: Gets or sets the activity count of the module.
    :type activity_count: int
    :param provisioning_state: Gets or sets the provisioning state of the module. Possible values
     include: "Created", "Creating", "StartingImportModuleRunbook", "RunningImportModuleRunbook",
     "ContentRetrieved", "ContentDownloaded", "ContentValidated", "ConnectionTypeImported",
     "ContentStored", "ModuleDataStored", "ActivitiesStored", "ModuleImportRunbookComplete",
     "Succeeded", "Failed", "Cancelled", "Updating".
    :type provisioning_state: str or ~azure.mgmt.automation.models.ModuleProvisioningState
    :param content_link: Gets or sets the contentLink of the module.
    :type content_link: ~azure.mgmt.automation.models.ContentLink
    :param error: Gets or sets the error info of the module.
    :type error: ~azure.mgmt.automation.models.ModuleErrorInfo
    :param creation_time: Gets or sets the creation time.
    :type creation_time: ~datetime.datetime
    :param last_modified_time: Gets or sets the last modified time.
    :type last_modified_time: ~datetime.datetime
    :param description: Gets or sets the description.
    :type description: str
    :param is_composite: Gets or sets type of module, if its composite or not.
    :type is_composite: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'is_global': {'key': 'properties.isGlobal', 'type': 'bool'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'size_in_bytes': {'key': 'properties.sizeInBytes', 'type': 'long'},
        'activity_count': {'key': 'properties.activityCount', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'content_link': {'key': 'properties.contentLink', 'type': 'ContentLink'},
        'error': {'key': 'properties.error', 'type': 'ModuleErrorInfo'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_composite': {'key': 'properties.isComposite', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        etag: Optional[str] = None,
        is_global: Optional[bool] = None,
        version: Optional[str] = None,
        size_in_bytes: Optional[int] = None,
        activity_count: Optional[int] = None,
        provisioning_state: Optional[Union[str, "ModuleProvisioningState"]] = None,
        content_link: Optional["ContentLink"] = None,
        error: Optional["ModuleErrorInfo"] = None,
        creation_time: Optional[datetime.datetime] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        description: Optional[str] = None,
        is_composite: Optional[bool] = None,
        **kwargs
    ):
        super(Module, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = etag
        self.is_global = is_global
        self.version = version
        self.size_in_bytes = size_in_bytes
        self.activity_count = activity_count
        self.provisioning_state = provisioning_state
        self.content_link = content_link
        self.error = error
        self.creation_time = creation_time
        self.last_modified_time = last_modified_time
        self.description = description
        self.is_composite = is_composite


class ModuleCreateOrUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update module operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Gets or sets name of the resource.
    :type name: str
    :param location: Gets or sets the location of the resource.
    :type location: str
    :param tags: A set of tags. Gets or sets the tags attached to the resource.
    :type tags: dict[str, str]
    :param content_link: Required. Gets or sets the module content link.
    :type content_link: ~azure.mgmt.automation.models.ContentLink
    """

    _validation = {
        'content_link': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'content_link': {'key': 'properties.contentLink', 'type': 'ContentLink'},
    }

    def __init__(
        self,
        *,
        content_link: "ContentLink",
        name: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ModuleCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.content_link = content_link


class ModuleErrorInfo(msrest.serialization.Model):
    """Definition of the module error info type.

    :param code: Gets or sets the error code.
    :type code: str
    :param message: Gets or sets the error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ModuleErrorInfo, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ModuleListResult(msrest.serialization.Model):
    """The response model for the list module operation.

    :param value: Gets or sets a list of modules.
    :type value: list[~azure.mgmt.automation.models.Module]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Module]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Module"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ModuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ModuleUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the update module operation.

    :param name: Gets or sets name of the resource.
    :type name: str
    :param location: Gets or sets the location of the resource.
    :type location: str
    :param tags: A set of tags. Gets or sets the tags attached to the resource.
    :type tags: dict[str, str]
    :param content_link: Gets or sets the module content link.
    :type content_link: ~azure.mgmt.automation.models.ContentLink
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'content_link': {'key': 'properties.contentLink', 'type': 'ContentLink'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        content_link: Optional["ContentLink"] = None,
        **kwargs
    ):
        super(ModuleUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.content_link = content_link


class NodeCount(msrest.serialization.Model):
    """Number of nodes based on the Filter.

    :param name: Gets the name of a count type.
    :type name: str
    :param properties:
    :type properties: ~azure.mgmt.automation.models.NodeCountProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'NodeCountProperties'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["NodeCountProperties"] = None,
        **kwargs
    ):
        super(NodeCount, self).__init__(**kwargs)
        self.name = name
        self.properties = properties


class NodeCountProperties(msrest.serialization.Model):
    """NodeCountProperties.

    :param count: Gets the count for the name.
    :type count: int
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        **kwargs
    ):
        super(NodeCountProperties, self).__init__(**kwargs)
        self.count = count


class NodeCounts(msrest.serialization.Model):
    """Gets the count of nodes by count type.

    :param value: Gets an array of counts.
    :type value: list[~azure.mgmt.automation.models.NodeCount]
    :param total_count: Gets the total number of records matching countType criteria.
    :type total_count: int
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NodeCount]'},
        'total_count': {'key': 'totalCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NodeCount"]] = None,
        total_count: Optional[int] = None,
        **kwargs
    ):
        super(NodeCounts, self).__init__(**kwargs)
        self.value = value
        self.total_count = total_count


class NonAzureQueryProperties(msrest.serialization.Model):
    """Non Azure query for the update configuration.

    :param function_alias: Log Analytics Saved Search name.
    :type function_alias: str
    :param workspace_id: Workspace Id for Log Analytics in which the saved Search is resided.
    :type workspace_id: str
    """

    _attribute_map = {
        'function_alias': {'key': 'functionAlias', 'type': 'str'},
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        function_alias: Optional[str] = None,
        workspace_id: Optional[str] = None,
        **kwargs
    ):
        super(NonAzureQueryProperties, self).__init__(**kwargs)
        self.function_alias = function_alias
        self.workspace_id = workspace_id


class Operation(msrest.serialization.Model):
    """Automation REST API operation.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: Provider, Resource and Operation values.
    :type display: ~azure.mgmt.automation.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """Provider, Resource and Operation values.

    :param provider: Service provider: Microsoft.Automation.
    :type provider: str
    :param resource: Resource on which the operation is performed: Runbooks, Jobs etc.
    :type resource: str
    :param operation: Operation type: Read, write, delete, etc.
    :type operation: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation


class OperationListResult(msrest.serialization.Model):
    """The response model for the list of Automation operations.

    :param value: List of Automation operations supported by the Automation resource provider.
    :type value: list[~azure.mgmt.automation.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value


class ProxyResource(Resource):
    """ARM proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class PythonPackageCreateParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update module operation.

    All required parameters must be populated in order to send to Azure.

    :param tags: A set of tags. Gets or sets the tags attached to the resource.
    :type tags: dict[str, str]
    :param content_link: Required. Gets or sets the module content link.
    :type content_link: ~azure.mgmt.automation.models.ContentLink
    """

    _validation = {
        'content_link': {'required': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'content_link': {'key': 'properties.contentLink', 'type': 'ContentLink'},
    }

    def __init__(
        self,
        *,
        content_link: "ContentLink",
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(PythonPackageCreateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.content_link = content_link


class PythonPackageUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the update module operation.

    :param tags: A set of tags. Gets or sets the tags attached to the resource.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(PythonPackageUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class RunAsCredentialAssociationProperty(msrest.serialization.Model):
    """Definition of RunAs credential to use for hybrid worker.

    :param name: Gets or sets the name of the credential.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(RunAsCredentialAssociationProperty, self).__init__(**kwargs)
        self.name = name


class Runbook(TrackedResource):
    """Definition of the runbook type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: The Azure Region where the resource lives.
    :type location: str
    :param etag: Gets or sets the etag of the resource.
    :type etag: str
    :param runbook_type: Gets or sets the type of the runbook. Possible values include: "Script",
     "Graph", "PowerShellWorkflow", "PowerShell", "GraphPowerShellWorkflow", "GraphPowerShell".
    :type runbook_type: str or ~azure.mgmt.automation.models.RunbookTypeEnum
    :param publish_content_link: Gets or sets the published runbook content link.
    :type publish_content_link: ~azure.mgmt.automation.models.ContentLink
    :param state: Gets or sets the state of the runbook. Possible values include: "New", "Edit",
     "Published".
    :type state: str or ~azure.mgmt.automation.models.RunbookState
    :param log_verbose: Gets or sets verbose log option.
    :type log_verbose: bool
    :param log_progress: Gets or sets progress log option.
    :type log_progress: bool
    :param log_activity_trace: Gets or sets the option to log activity trace of the runbook.
    :type log_activity_trace: int
    :param job_count: Gets or sets the job count of the runbook.
    :type job_count: int
    :param parameters: Gets or sets the runbook parameters.
    :type parameters: dict[str, ~azure.mgmt.automation.models.RunbookParameter]
    :param output_types: Gets or sets the runbook output types.
    :type output_types: list[str]
    :param draft: Gets or sets the draft runbook properties.
    :type draft: ~azure.mgmt.automation.models.RunbookDraft
    :ivar provisioning_state: Gets or sets the provisioning state of the runbook. Default value:
     "Succeeded".
    :vartype provisioning_state: str
    :param last_modified_by: Gets or sets the last modified by.
    :type last_modified_by: str
    :param creation_time: Gets or sets the creation time.
    :type creation_time: ~datetime.datetime
    :param last_modified_time: Gets or sets the last modified time.
    :type last_modified_time: ~datetime.datetime
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'constant': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'runbook_type': {'key': 'properties.runbookType', 'type': 'str'},
        'publish_content_link': {'key': 'properties.publishContentLink', 'type': 'ContentLink'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'log_verbose': {'key': 'properties.logVerbose', 'type': 'bool'},
        'log_progress': {'key': 'properties.logProgress', 'type': 'bool'},
        'log_activity_trace': {'key': 'properties.logActivityTrace', 'type': 'int'},
        'job_count': {'key': 'properties.jobCount', 'type': 'int'},
        'parameters': {'key': 'properties.parameters', 'type': '{RunbookParameter}'},
        'output_types': {'key': 'properties.outputTypes', 'type': '[str]'},
        'draft': {'key': 'properties.draft', 'type': 'RunbookDraft'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    provisioning_state = "Succeeded"

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        etag: Optional[str] = None,
        runbook_type: Optional[Union[str, "RunbookTypeEnum"]] = None,
        publish_content_link: Optional["ContentLink"] = None,
        state: Optional[Union[str, "RunbookState"]] = None,
        log_verbose: Optional[bool] = None,
        log_progress: Optional[bool] = None,
        log_activity_trace: Optional[int] = None,
        job_count: Optional[int] = None,
        parameters: Optional[Dict[str, "RunbookParameter"]] = None,
        output_types: Optional[List[str]] = None,
        draft: Optional["RunbookDraft"] = None,
        last_modified_by: Optional[str] = None,
        creation_time: Optional[datetime.datetime] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(Runbook, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = etag
        self.runbook_type = runbook_type
        self.publish_content_link = publish_content_link
        self.state = state
        self.log_verbose = log_verbose
        self.log_progress = log_progress
        self.log_activity_trace = log_activity_trace
        self.job_count = job_count
        self.parameters = parameters
        self.output_types = output_types
        self.draft = draft
        self.last_modified_by = last_modified_by
        self.creation_time = creation_time
        self.last_modified_time = last_modified_time
        self.description = description


class RunbookAssociationProperty(msrest.serialization.Model):
    """The runbook property associated with the entity.

    :param name: Gets or sets the name of the runbook.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(RunbookAssociationProperty, self).__init__(**kwargs)
        self.name = name


class RunbookCreateOrUpdateDraftParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update runbook operation.

    All required parameters must be populated in order to send to Azure.

    :param runbook_content: Required. Content of the Runbook.
    :type runbook_content: str
    """

    _validation = {
        'runbook_content': {'required': True},
    }

    _attribute_map = {
        'runbook_content': {'key': 'runbookContent', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        runbook_content: str,
        **kwargs
    ):
        super(RunbookCreateOrUpdateDraftParameters, self).__init__(**kwargs)
        self.runbook_content = runbook_content


class RunbookCreateOrUpdateDraftProperties(msrest.serialization.Model):
    """The parameters supplied to the create or update draft runbook properties.

    All required parameters must be populated in order to send to Azure.

    :param log_verbose: Gets or sets verbose log option.
    :type log_verbose: bool
    :param log_progress: Gets or sets progress log option.
    :type log_progress: bool
    :param runbook_type: Required. Gets or sets the type of the runbook. Possible values include:
     "Script", "Graph", "PowerShellWorkflow", "PowerShell", "GraphPowerShellWorkflow",
     "GraphPowerShell".
    :type runbook_type: str or ~azure.mgmt.automation.models.RunbookTypeEnum
    :param draft: Required. Gets or sets the draft runbook properties.
    :type draft: ~azure.mgmt.automation.models.RunbookDraft
    :param description: Gets or sets the description of the runbook.
    :type description: str
    :param log_activity_trace: Gets or sets the activity-level tracing options of the runbook.
    :type log_activity_trace: int
    """

    _validation = {
        'runbook_type': {'required': True},
        'draft': {'required': True},
    }

    _attribute_map = {
        'log_verbose': {'key': 'logVerbose', 'type': 'bool'},
        'log_progress': {'key': 'logProgress', 'type': 'bool'},
        'runbook_type': {'key': 'runbookType', 'type': 'str'},
        'draft': {'key': 'draft', 'type': 'RunbookDraft'},
        'description': {'key': 'description', 'type': 'str'},
        'log_activity_trace': {'key': 'logActivityTrace', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        runbook_type: Union[str, "RunbookTypeEnum"],
        draft: "RunbookDraft",
        log_verbose: Optional[bool] = None,
        log_progress: Optional[bool] = None,
        description: Optional[str] = None,
        log_activity_trace: Optional[int] = None,
        **kwargs
    ):
        super(RunbookCreateOrUpdateDraftProperties, self).__init__(**kwargs)
        self.log_verbose = log_verbose
        self.log_progress = log_progress
        self.runbook_type = runbook_type
        self.draft = draft
        self.description = description
        self.log_activity_trace = log_activity_trace


class RunbookCreateOrUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update runbook operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Gets or sets the name of the resource.
    :type name: str
    :param location: Gets or sets the location of the resource.
    :type location: str
    :param tags: A set of tags. Gets or sets the tags attached to the resource.
    :type tags: dict[str, str]
    :param log_verbose: Gets or sets verbose log option.
    :type log_verbose: bool
    :param log_progress: Gets or sets progress log option.
    :type log_progress: bool
    :param runbook_type: Required. Gets or sets the type of the runbook. Possible values include:
     "Script", "Graph", "PowerShellWorkflow", "PowerShell", "GraphPowerShellWorkflow",
     "GraphPowerShell".
    :type runbook_type: str or ~azure.mgmt.automation.models.RunbookTypeEnum
    :param draft: Gets or sets the draft runbook properties.
    :type draft: ~azure.mgmt.automation.models.RunbookDraft
    :param publish_content_link: Gets or sets the published runbook content link.
    :type publish_content_link: ~azure.mgmt.automation.models.ContentLink
    :param description: Gets or sets the description of the runbook.
    :type description: str
    :param log_activity_trace: Gets or sets the activity-level tracing options of the runbook.
    :type log_activity_trace: int
    """

    _validation = {
        'runbook_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'log_verbose': {'key': 'properties.logVerbose', 'type': 'bool'},
        'log_progress': {'key': 'properties.logProgress', 'type': 'bool'},
        'runbook_type': {'key': 'properties.runbookType', 'type': 'str'},
        'draft': {'key': 'properties.draft', 'type': 'RunbookDraft'},
        'publish_content_link': {'key': 'properties.publishContentLink', 'type': 'ContentLink'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'log_activity_trace': {'key': 'properties.logActivityTrace', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        runbook_type: Union[str, "RunbookTypeEnum"],
        name: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        log_verbose: Optional[bool] = None,
        log_progress: Optional[bool] = None,
        draft: Optional["RunbookDraft"] = None,
        publish_content_link: Optional["ContentLink"] = None,
        description: Optional[str] = None,
        log_activity_trace: Optional[int] = None,
        **kwargs
    ):
        super(RunbookCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.log_verbose = log_verbose
        self.log_progress = log_progress
        self.runbook_type = runbook_type
        self.draft = draft
        self.publish_content_link = publish_content_link
        self.description = description
        self.log_activity_trace = log_activity_trace


class RunbookDraft(msrest.serialization.Model):
    """RunbookDraft.

    :param in_edit: Gets or sets whether runbook is in edit mode.
    :type in_edit: bool
    :param draft_content_link: Gets or sets the draft runbook content link.
    :type draft_content_link: ~azure.mgmt.automation.models.ContentLink
    :param creation_time: Gets or sets the creation time of the runbook draft.
    :type creation_time: ~datetime.datetime
    :param last_modified_time: Gets or sets the last modified time of the runbook draft.
    :type last_modified_time: ~datetime.datetime
    :param parameters: Gets or sets the runbook draft parameters.
    :type parameters: dict[str, ~azure.mgmt.automation.models.RunbookParameter]
    :param output_types: Gets or sets the runbook output types.
    :type output_types: list[str]
    """

    _attribute_map = {
        'in_edit': {'key': 'inEdit', 'type': 'bool'},
        'draft_content_link': {'key': 'draftContentLink', 'type': 'ContentLink'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
        'parameters': {'key': 'parameters', 'type': '{RunbookParameter}'},
        'output_types': {'key': 'outputTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        in_edit: Optional[bool] = None,
        draft_content_link: Optional["ContentLink"] = None,
        creation_time: Optional[datetime.datetime] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        parameters: Optional[Dict[str, "RunbookParameter"]] = None,
        output_types: Optional[List[str]] = None,
        **kwargs
    ):
        super(RunbookDraft, self).__init__(**kwargs)
        self.in_edit = in_edit
        self.draft_content_link = draft_content_link
        self.creation_time = creation_time
        self.last_modified_time = last_modified_time
        self.parameters = parameters
        self.output_types = output_types


class RunbookDraftUndoEditResult(msrest.serialization.Model):
    """The response model for the undo edit runbook operation.

    :param status_code:  Possible values include: "Continue", "SwitchingProtocols", "OK",
     "Created", "Accepted", "NonAuthoritativeInformation", "NoContent", "ResetContent",
     "PartialContent", "MultipleChoices", "Ambiguous", "MovedPermanently", "Moved", "Found",
     "Redirect", "SeeOther", "RedirectMethod", "NotModified", "UseProxy", "Unused",
     "TemporaryRedirect", "RedirectKeepVerb", "BadRequest", "Unauthorized", "PaymentRequired",
     "Forbidden", "NotFound", "MethodNotAllowed", "NotAcceptable", "ProxyAuthenticationRequired",
     "RequestTimeout", "Conflict", "Gone", "LengthRequired", "PreconditionFailed",
     "RequestEntityTooLarge", "RequestUriTooLong", "UnsupportedMediaType",
     "RequestedRangeNotSatisfiable", "ExpectationFailed", "UpgradeRequired", "InternalServerError",
     "NotImplemented", "BadGateway", "ServiceUnavailable", "GatewayTimeout",
     "HttpVersionNotSupported".
    :type status_code: str or ~azure.mgmt.automation.models.HttpStatusCode
    :param request_id:
    :type request_id: str
    """

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status_code: Optional[Union[str, "HttpStatusCode"]] = None,
        request_id: Optional[str] = None,
        **kwargs
    ):
        super(RunbookDraftUndoEditResult, self).__init__(**kwargs)
        self.status_code = status_code
        self.request_id = request_id


class RunbookListResult(msrest.serialization.Model):
    """The response model for the list runbook operation.

    :param value: Gets or sets a list of runbooks.
    :type value: list[~azure.mgmt.automation.models.Runbook]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Runbook]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Runbook"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RunbookListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RunbookParameter(msrest.serialization.Model):
    """Definition of the runbook parameter type.

    :param type: Gets or sets the type of the parameter.
    :type type: str
    :param is_mandatory: Gets or sets a Boolean value to indicate whether the parameter is
     mandatory or not.
    :type is_mandatory: bool
    :param position: Get or sets the position of the parameter.
    :type position: int
    :param default_value: Gets or sets the default value of parameter.
    :type default_value: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_mandatory': {'key': 'isMandatory', 'type': 'bool'},
        'position': {'key': 'position', 'type': 'int'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        is_mandatory: Optional[bool] = None,
        position: Optional[int] = None,
        default_value: Optional[str] = None,
        **kwargs
    ):
        super(RunbookParameter, self).__init__(**kwargs)
        self.type = type
        self.is_mandatory = is_mandatory
        self.position = position
        self.default_value = default_value


class RunbookUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the update runbook operation.

    :param name: Gets or sets the name of the resource.
    :type name: str
    :param location: Gets or sets the location of the resource.
    :type location: str
    :param tags: A set of tags. Gets or sets the tags attached to the resource.
    :type tags: dict[str, str]
    :param description: Gets or sets the description of the runbook.
    :type description: str
    :param log_verbose: Gets or sets verbose log option.
    :type log_verbose: bool
    :param log_progress: Gets or sets progress log option.
    :type log_progress: bool
    :param log_activity_trace: Gets or sets the activity-level tracing options of the runbook.
    :type log_activity_trace: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'log_verbose': {'key': 'properties.logVerbose', 'type': 'bool'},
        'log_progress': {'key': 'properties.logProgress', 'type': 'bool'},
        'log_activity_trace': {'key': 'properties.logActivityTrace', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        log_verbose: Optional[bool] = None,
        log_progress: Optional[bool] = None,
        log_activity_trace: Optional[int] = None,
        **kwargs
    ):
        super(RunbookUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.description = description
        self.log_verbose = log_verbose
        self.log_progress = log_progress
        self.log_activity_trace = log_activity_trace


class Schedule(Resource):
    """Definition of the schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param start_time: Gets or sets the start time of the schedule.
    :type start_time: ~datetime.datetime
    :ivar start_time_offset_minutes: Gets the start time's offset in minutes.
    :vartype start_time_offset_minutes: float
    :param expiry_time: Gets or sets the end time of the schedule.
    :type expiry_time: ~datetime.datetime
    :param expiry_time_offset_minutes: Gets or sets the expiry time's offset in minutes.
    :type expiry_time_offset_minutes: float
    :param is_enabled: Gets or sets a value indicating whether this schedule is enabled.
    :type is_enabled: bool
    :param next_run: Gets or sets the next run time of the schedule.
    :type next_run: ~datetime.datetime
    :param next_run_offset_minutes: Gets or sets the next run time's offset in minutes.
    :type next_run_offset_minutes: float
    :param interval: Gets or sets the interval of the schedule.
    :type interval: object
    :param frequency: Gets or sets the frequency of the schedule. Possible values include:
     "OneTime", "Day", "Hour", "Week", "Month", "Minute".
    :type frequency: str or ~azure.mgmt.automation.models.ScheduleFrequency
    :param time_zone: Gets or sets the time zone of the schedule.
    :type time_zone: str
    :param advanced_schedule: Gets or sets the advanced schedule.
    :type advanced_schedule: ~azure.mgmt.automation.models.AdvancedSchedule
    :param creation_time: Gets or sets the creation time.
    :type creation_time: ~datetime.datetime
    :param last_modified_time: Gets or sets the last modified time.
    :type last_modified_time: ~datetime.datetime
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_time_offset_minutes': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'start_time_offset_minutes': {'key': 'properties.startTimeOffsetMinutes', 'type': 'float'},
        'expiry_time': {'key': 'properties.expiryTime', 'type': 'iso-8601'},
        'expiry_time_offset_minutes': {'key': 'properties.expiryTimeOffsetMinutes', 'type': 'float'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'next_run': {'key': 'properties.nextRun', 'type': 'iso-8601'},
        'next_run_offset_minutes': {'key': 'properties.nextRunOffsetMinutes', 'type': 'float'},
        'interval': {'key': 'properties.interval', 'type': 'object'},
        'frequency': {'key': 'properties.frequency', 'type': 'str'},
        'time_zone': {'key': 'properties.timeZone', 'type': 'str'},
        'advanced_schedule': {'key': 'properties.advancedSchedule', 'type': 'AdvancedSchedule'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        expiry_time: Optional[datetime.datetime] = None,
        expiry_time_offset_minutes: Optional[float] = None,
        is_enabled: Optional[bool] = False,
        next_run: Optional[datetime.datetime] = None,
        next_run_offset_minutes: Optional[float] = None,
        interval: Optional[object] = None,
        frequency: Optional[Union[str, "ScheduleFrequency"]] = None,
        time_zone: Optional[str] = None,
        advanced_schedule: Optional["AdvancedSchedule"] = None,
        creation_time: Optional[datetime.datetime] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(Schedule, self).__init__(**kwargs)
        self.start_time = start_time
        self.start_time_offset_minutes = None
        self.expiry_time = expiry_time
        self.expiry_time_offset_minutes = expiry_time_offset_minutes
        self.is_enabled = is_enabled
        self.next_run = next_run
        self.next_run_offset_minutes = next_run_offset_minutes
        self.interval = interval
        self.frequency = frequency
        self.time_zone = time_zone
        self.advanced_schedule = advanced_schedule
        self.creation_time = creation_time
        self.last_modified_time = last_modified_time
        self.description = description


class ScheduleAssociationProperty(msrest.serialization.Model):
    """The schedule property associated with the entity.

    :param name: Gets or sets the name of the Schedule.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(ScheduleAssociationProperty, self).__init__(**kwargs)
        self.name = name


class ScheduleCreateOrUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update schedule operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Gets or sets the name of the Schedule.
    :type name: str
    :param description: Gets or sets the description of the schedule.
    :type description: str
    :param start_time: Required. Gets or sets the start time of the schedule.
    :type start_time: ~datetime.datetime
    :param expiry_time: Gets or sets the end time of the schedule.
    :type expiry_time: ~datetime.datetime
    :param interval: Gets or sets the interval of the schedule.
    :type interval: object
    :param frequency: Required. Gets or sets the frequency of the schedule. Possible values
     include: "OneTime", "Day", "Hour", "Week", "Month", "Minute".
    :type frequency: str or ~azure.mgmt.automation.models.ScheduleFrequency
    :param time_zone: Gets or sets the time zone of the schedule.
    :type time_zone: str
    :param advanced_schedule: Gets or sets the AdvancedSchedule.
    :type advanced_schedule: ~azure.mgmt.automation.models.AdvancedSchedule
    """

    _validation = {
        'name': {'required': True},
        'start_time': {'required': True},
        'frequency': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'expiry_time': {'key': 'properties.expiryTime', 'type': 'iso-8601'},
        'interval': {'key': 'properties.interval', 'type': 'object'},
        'frequency': {'key': 'properties.frequency', 'type': 'str'},
        'time_zone': {'key': 'properties.timeZone', 'type': 'str'},
        'advanced_schedule': {'key': 'properties.advancedSchedule', 'type': 'AdvancedSchedule'},
    }

    def __init__(
        self,
        *,
        name: str,
        start_time: datetime.datetime,
        frequency: Union[str, "ScheduleFrequency"],
        description: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        interval: Optional[object] = None,
        time_zone: Optional[str] = None,
        advanced_schedule: Optional["AdvancedSchedule"] = None,
        **kwargs
    ):
        super(ScheduleCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.start_time = start_time
        self.expiry_time = expiry_time
        self.interval = interval
        self.frequency = frequency
        self.time_zone = time_zone
        self.advanced_schedule = advanced_schedule


class ScheduleListResult(msrest.serialization.Model):
    """The response model for the list schedule operation.

    :param value: Gets or sets a list of schedules.
    :type value: list[~azure.mgmt.automation.models.Schedule]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Schedule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Schedule"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ScheduleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ScheduleUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the update schedule operation.

    :param name: Gets or sets the name of the Schedule.
    :type name: str
    :param description: Gets or sets the description of the schedule.
    :type description: str
    :param is_enabled: Gets or sets a value indicating whether this schedule is enabled.
    :type is_enabled: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        is_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(ScheduleUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.is_enabled = is_enabled


class Sku(msrest.serialization.Model):
    """The account SKU.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Gets or sets the SKU name of the account. Possible values include:
     "Free", "Basic".
    :type name: str or ~azure.mgmt.automation.models.SkuNameEnum
    :param family: Gets or sets the SKU family.
    :type family: str
    :param capacity: Gets or sets the SKU capacity.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "SkuNameEnum"],
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.family = family
        self.capacity = capacity


class SoftwareUpdateConfiguration(msrest.serialization.Model):
    """Software update configuration properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Resource name.
    :vartype name: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar type: Resource type.
    :vartype type: str
    :param update_configuration: Required. update specific properties for the Software update
     configuration.
    :type update_configuration: ~azure.mgmt.automation.models.UpdateConfiguration
    :param schedule_info: Required. Schedule information for the Software update configuration.
    :type schedule_info: ~azure.mgmt.automation.models.SUCScheduleProperties
    :ivar provisioning_state: Provisioning state for the software update configuration, which only
     appears in the response.
    :vartype provisioning_state: str
    :param error: Details of provisioning error.
    :type error: ~azure.mgmt.automation.models.ErrorResponse
    :ivar creation_time: Creation time of the resource, which only appears in the response.
    :vartype creation_time: ~datetime.datetime
    :ivar created_by: CreatedBy property, which only appears in the response.
    :vartype created_by: str
    :ivar last_modified_time: Last time resource was modified, which only appears in the response.
    :vartype last_modified_time: ~datetime.datetime
    :ivar last_modified_by: LastModifiedBy property, which only appears in the response.
    :vartype last_modified_by: str
    :param tasks: Tasks information for the Software update configuration.
    :type tasks: ~azure.mgmt.automation.models.SoftwareUpdateConfigurationTasks
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'update_configuration': {'required': True},
        'schedule_info': {'required': True},
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'created_by': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'last_modified_by': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'update_configuration': {'key': 'properties.updateConfiguration', 'type': 'UpdateConfiguration'},
        'schedule_info': {'key': 'properties.scheduleInfo', 'type': 'SUCScheduleProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'ErrorResponse'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'created_by': {'key': 'properties.createdBy', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'str'},
        'tasks': {'key': 'properties.tasks', 'type': 'SoftwareUpdateConfigurationTasks'},
    }

    def __init__(
        self,
        *,
        update_configuration: "UpdateConfiguration",
        schedule_info: "SUCScheduleProperties",
        error: Optional["ErrorResponse"] = None,
        tasks: Optional["SoftwareUpdateConfigurationTasks"] = None,
        **kwargs
    ):
        super(SoftwareUpdateConfiguration, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.update_configuration = update_configuration
        self.schedule_info = schedule_info
        self.provisioning_state = None
        self.error = error
        self.creation_time = None
        self.created_by = None
        self.last_modified_time = None
        self.last_modified_by = None
        self.tasks = tasks


class SoftwareUpdateConfigurationCollectionItem(msrest.serialization.Model):
    """Software update configuration collection item properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the software update configuration.
    :vartype name: str
    :ivar id: Resource Id of the software update configuration.
    :vartype id: str
    :param update_configuration: Update specific properties of the software update configuration.
    :type update_configuration: ~azure.mgmt.automation.models.UpdateConfiguration
    :param tasks: Pre and Post Tasks defined.
    :type tasks: ~azure.mgmt.automation.models.SoftwareUpdateConfigurationTasks
    :param frequency: execution frequency of the schedule associated with the software update
     configuration. Possible values include: "OneTime", "Day", "Hour", "Week", "Month", "Minute".
    :type frequency: str or ~azure.mgmt.automation.models.ScheduleFrequency
    :param start_time: the start time of the update.
    :type start_time: ~datetime.datetime
    :ivar creation_time: Creation time of the software update configuration, which only appears in
     the response.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: Last time software update configuration was modified, which only
     appears in the response.
    :vartype last_modified_time: ~datetime.datetime
    :ivar provisioning_state: Provisioning state for the software update configuration, which only
     appears in the response.
    :vartype provisioning_state: str
    :param next_run: ext run time of the update.
    :type next_run: ~datetime.datetime
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'creation_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'update_configuration': {'key': 'properties.updateConfiguration', 'type': 'UpdateConfiguration'},
        'tasks': {'key': 'properties.tasks', 'type': 'SoftwareUpdateConfigurationTasks'},
        'frequency': {'key': 'properties.frequency', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'next_run': {'key': 'properties.nextRun', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        update_configuration: Optional["UpdateConfiguration"] = None,
        tasks: Optional["SoftwareUpdateConfigurationTasks"] = None,
        frequency: Optional[Union[str, "ScheduleFrequency"]] = None,
        start_time: Optional[datetime.datetime] = None,
        next_run: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SoftwareUpdateConfigurationCollectionItem, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.update_configuration = update_configuration
        self.tasks = tasks
        self.frequency = frequency
        self.start_time = start_time
        self.creation_time = None
        self.last_modified_time = None
        self.provisioning_state = None
        self.next_run = next_run


class SoftwareUpdateConfigurationListResult(msrest.serialization.Model):
    """result of listing all software update configuration.

    :param value: outer object returned when listing all software update configurations.
    :type value: list[~azure.mgmt.automation.models.SoftwareUpdateConfigurationCollectionItem]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SoftwareUpdateConfigurationCollectionItem]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SoftwareUpdateConfigurationCollectionItem"]] = None,
        **kwargs
    ):
        super(SoftwareUpdateConfigurationListResult, self).__init__(**kwargs)
        self.value = value


class SoftwareUpdateConfigurationMachineRun(msrest.serialization.Model):
    """Software update configuration machine run model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the software update configuration machine run.
    :vartype name: str
    :ivar id: Resource Id of the software update configuration machine run.
    :vartype id: str
    :ivar target_computer: name of the updated computer.
    :vartype target_computer: str
    :ivar target_computer_type: type of the updated computer.
    :vartype target_computer_type: str
    :param software_update_configuration: software update configuration triggered this run.
    :type software_update_configuration:
     ~azure.mgmt.automation.models.UpdateConfigurationNavigation
    :ivar status: Status of the software update configuration machine run.
    :vartype status: str
    :ivar os_type: Operating system target of the software update configuration triggered this run.
    :vartype os_type: str
    :ivar correlation_id: correlation id of the software update configuration machine run.
    :vartype correlation_id: str
    :ivar source_computer_id: source computer id of the software update configuration machine run.
    :vartype source_computer_id: str
    :ivar start_time: Start time of the software update configuration machine run.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the software update configuration machine run.
    :vartype end_time: ~datetime.datetime
    :ivar configured_duration: configured duration for the software update configuration run.
    :vartype configured_duration: str
    :param job: Job associated with the software update configuration machine run.
    :type job: ~azure.mgmt.automation.models.JobNavigation
    :ivar creation_time: Creation time of the resource, which only appears in the response.
    :vartype creation_time: ~datetime.datetime
    :ivar created_by: createdBy property, which only appears in the response.
    :vartype created_by: str
    :ivar last_modified_time: Last time resource was modified, which only appears in the response.
    :vartype last_modified_time: ~datetime.datetime
    :ivar last_modified_by: lastModifiedBy property, which only appears in the response.
    :vartype last_modified_by: str
    :param error: Details of provisioning error.
    :type error: ~azure.mgmt.automation.models.ErrorResponse
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'target_computer': {'readonly': True},
        'target_computer_type': {'readonly': True},
        'status': {'readonly': True},
        'os_type': {'readonly': True},
        'correlation_id': {'readonly': True},
        'source_computer_id': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'configured_duration': {'readonly': True},
        'creation_time': {'readonly': True},
        'created_by': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'last_modified_by': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'target_computer': {'key': 'properties.targetComputer', 'type': 'str'},
        'target_computer_type': {'key': 'properties.targetComputerType', 'type': 'str'},
        'software_update_configuration': {'key': 'properties.softwareUpdateConfiguration', 'type': 'UpdateConfigurationNavigation'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'correlation_id': {'key': 'properties.correlationId', 'type': 'str'},
        'source_computer_id': {'key': 'properties.sourceComputerId', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'configured_duration': {'key': 'properties.configuredDuration', 'type': 'str'},
        'job': {'key': 'properties.job', 'type': 'JobNavigation'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'created_by': {'key': 'properties.createdBy', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        *,
        software_update_configuration: Optional["UpdateConfigurationNavigation"] = None,
        job: Optional["JobNavigation"] = None,
        error: Optional["ErrorResponse"] = None,
        **kwargs
    ):
        super(SoftwareUpdateConfigurationMachineRun, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.target_computer = None
        self.target_computer_type = None
        self.software_update_configuration = software_update_configuration
        self.status = None
        self.os_type = None
        self.correlation_id = None
        self.source_computer_id = None
        self.start_time = None
        self.end_time = None
        self.configured_duration = None
        self.job = job
        self.creation_time = None
        self.created_by = None
        self.last_modified_time = None
        self.last_modified_by = None
        self.error = error


class SoftwareUpdateConfigurationMachineRunListResult(msrest.serialization.Model):
    """result of listing all software update configuration machine runs.

    :param value: outer object returned when listing all software update configuration machine
     runs.
    :type value: list[~azure.mgmt.automation.models.SoftwareUpdateConfigurationMachineRun]
    :param next_link: link to next page of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SoftwareUpdateConfigurationMachineRun]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SoftwareUpdateConfigurationMachineRun"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SoftwareUpdateConfigurationMachineRunListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SoftwareUpdateConfigurationRun(msrest.serialization.Model):
    """Software update configuration Run properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the software update configuration run.
    :vartype name: str
    :ivar id: Resource Id of the software update configuration run.
    :vartype id: str
    :param software_update_configuration: software update configuration triggered this run.
    :type software_update_configuration:
     ~azure.mgmt.automation.models.UpdateConfigurationNavigation
    :ivar status: Status of the software update configuration run.
    :vartype status: str
    :ivar configured_duration: Configured duration for the software update configuration run.
    :vartype configured_duration: str
    :ivar os_type: Operating system target of the software update configuration triggered this run.
    :vartype os_type: str
    :ivar start_time: Start time of the software update configuration run.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the software update configuration run.
    :vartype end_time: ~datetime.datetime
    :ivar computer_count: Number of computers in the software update configuration run.
    :vartype computer_count: int
    :ivar failed_count: Number of computers with failed status.
    :vartype failed_count: int
    :ivar creation_time: Creation time of the resource, which only appears in the response.
    :vartype creation_time: ~datetime.datetime
    :ivar created_by: CreatedBy property, which only appears in the response.
    :vartype created_by: str
    :ivar last_modified_time: Last time resource was modified, which only appears in the response.
    :vartype last_modified_time: ~datetime.datetime
    :ivar last_modified_by: LastModifiedBy property, which only appears in the response.
    :vartype last_modified_by: str
    :param tasks: Software update configuration tasks triggered in this run.
    :type tasks: ~azure.mgmt.automation.models.SoftwareUpdateConfigurationRunTasks
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'status': {'readonly': True},
        'configured_duration': {'readonly': True},
        'os_type': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'computer_count': {'readonly': True},
        'failed_count': {'readonly': True},
        'creation_time': {'readonly': True},
        'created_by': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'last_modified_by': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'software_update_configuration': {'key': 'properties.softwareUpdateConfiguration', 'type': 'UpdateConfigurationNavigation'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'configured_duration': {'key': 'properties.configuredDuration', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'computer_count': {'key': 'properties.computerCount', 'type': 'int'},
        'failed_count': {'key': 'properties.failedCount', 'type': 'int'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'created_by': {'key': 'properties.createdBy', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'str'},
        'tasks': {'key': 'properties.tasks', 'type': 'SoftwareUpdateConfigurationRunTasks'},
    }

    def __init__(
        self,
        *,
        software_update_configuration: Optional["UpdateConfigurationNavigation"] = None,
        tasks: Optional["SoftwareUpdateConfigurationRunTasks"] = None,
        **kwargs
    ):
        super(SoftwareUpdateConfigurationRun, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.software_update_configuration = software_update_configuration
        self.status = None
        self.configured_duration = None
        self.os_type = None
        self.start_time = None
        self.end_time = None
        self.computer_count = None
        self.failed_count = None
        self.creation_time = None
        self.created_by = None
        self.last_modified_time = None
        self.last_modified_by = None
        self.tasks = tasks


class SoftwareUpdateConfigurationRunListResult(msrest.serialization.Model):
    """result of listing all software update configuration runs.

    :param value: outer object returned when listing all software update configuration runs.
    :type value: list[~azure.mgmt.automation.models.SoftwareUpdateConfigurationRun]
    :param next_link: link to next page of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SoftwareUpdateConfigurationRun]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SoftwareUpdateConfigurationRun"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SoftwareUpdateConfigurationRunListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SoftwareUpdateConfigurationRunTaskProperties(msrest.serialization.Model):
    """Task properties of the software update configuration.

    :param status: The status of the task.
    :type status: str
    :param source: The name of the source of the task.
    :type source: str
    :param job_id: The job id of the task.
    :type job_id: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        source: Optional[str] = None,
        job_id: Optional[str] = None,
        **kwargs
    ):
        super(SoftwareUpdateConfigurationRunTaskProperties, self).__init__(**kwargs)
        self.status = status
        self.source = source
        self.job_id = job_id


class SoftwareUpdateConfigurationRunTasks(msrest.serialization.Model):
    """Software update configuration run tasks model.

    :param pre_task: Pre task properties.
    :type pre_task: ~azure.mgmt.automation.models.SoftwareUpdateConfigurationRunTaskProperties
    :param post_task: Post task properties.
    :type post_task: ~azure.mgmt.automation.models.SoftwareUpdateConfigurationRunTaskProperties
    """

    _attribute_map = {
        'pre_task': {'key': 'preTask', 'type': 'SoftwareUpdateConfigurationRunTaskProperties'},
        'post_task': {'key': 'postTask', 'type': 'SoftwareUpdateConfigurationRunTaskProperties'},
    }

    def __init__(
        self,
        *,
        pre_task: Optional["SoftwareUpdateConfigurationRunTaskProperties"] = None,
        post_task: Optional["SoftwareUpdateConfigurationRunTaskProperties"] = None,
        **kwargs
    ):
        super(SoftwareUpdateConfigurationRunTasks, self).__init__(**kwargs)
        self.pre_task = pre_task
        self.post_task = post_task


class SoftwareUpdateConfigurationTasks(msrest.serialization.Model):
    """Task properties of the software update configuration.

    :param pre_task: Pre task properties.
    :type pre_task: ~azure.mgmt.automation.models.TaskProperties
    :param post_task: Post task properties.
    :type post_task: ~azure.mgmt.automation.models.TaskProperties
    """

    _attribute_map = {
        'pre_task': {'key': 'preTask', 'type': 'TaskProperties'},
        'post_task': {'key': 'postTask', 'type': 'TaskProperties'},
    }

    def __init__(
        self,
        *,
        pre_task: Optional["TaskProperties"] = None,
        post_task: Optional["TaskProperties"] = None,
        **kwargs
    ):
        super(SoftwareUpdateConfigurationTasks, self).__init__(**kwargs)
        self.pre_task = pre_task
        self.post_task = post_task


class SourceControl(Resource):
    """Definition of the source control.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param repo_url: The repo url of the source control.
    :type repo_url: str
    :param branch: The repo branch of the source control. Include branch as empty string for
     VsoTfvc.
    :type branch: str
    :param folder_path: The folder path of the source control.
    :type folder_path: str
    :param auto_sync: The auto sync of the source control. Default is false.
    :type auto_sync: bool
    :param publish_runbook: The auto publish of the source control. Default is true.
    :type publish_runbook: bool
    :param source_type: The source type. Must be one of VsoGit, VsoTfvc, GitHub. Possible values
     include: "VsoGit", "VsoTfvc", "GitHub".
    :type source_type: str or ~azure.mgmt.automation.models.SourceType
    :param description: The description.
    :type description: str
    :param creation_time: The creation time.
    :type creation_time: ~datetime.datetime
    :param last_modified_time: The last modified time.
    :type last_modified_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'repo_url': {'key': 'properties.repoUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'auto_sync': {'key': 'properties.autoSync', 'type': 'bool'},
        'publish_runbook': {'key': 'properties.publishRunbook', 'type': 'bool'},
        'source_type': {'key': 'properties.sourceType', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        repo_url: Optional[str] = None,
        branch: Optional[str] = None,
        folder_path: Optional[str] = None,
        auto_sync: Optional[bool] = None,
        publish_runbook: Optional[bool] = None,
        source_type: Optional[Union[str, "SourceType"]] = None,
        description: Optional[str] = None,
        creation_time: Optional[datetime.datetime] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SourceControl, self).__init__(**kwargs)
        self.repo_url = repo_url
        self.branch = branch
        self.folder_path = folder_path
        self.auto_sync = auto_sync
        self.publish_runbook = publish_runbook
        self.source_type = source_type
        self.description = description
        self.creation_time = creation_time
        self.last_modified_time = last_modified_time


class SourceControlCreateOrUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update source control operation.

    :param repo_url: The repo url of the source control.
    :type repo_url: str
    :param branch: The repo branch of the source control. Include branch as empty string for
     VsoTfvc.
    :type branch: str
    :param folder_path: The folder path of the source control. Path must be relative.
    :type folder_path: str
    :param auto_sync: The auto async of the source control. Default is false.
    :type auto_sync: bool
    :param publish_runbook: The auto publish of the source control. Default is true.
    :type publish_runbook: bool
    :param source_type: The source type. Must be one of VsoGit, VsoTfvc, GitHub, case sensitive.
     Possible values include: "VsoGit", "VsoTfvc", "GitHub".
    :type source_type: str or ~azure.mgmt.automation.models.SourceType
    :param security_token: The authorization token for the repo of the source control.
    :type security_token: ~azure.mgmt.automation.models.SourceControlSecurityTokenProperties
    :param description: The user description of the source control.
    :type description: str
    """

    _validation = {
        'repo_url': {'max_length': 2000, 'min_length': 0},
        'branch': {'max_length': 255, 'min_length': 0},
        'folder_path': {'max_length': 255, 'min_length': 0},
        'description': {'max_length': 512, 'min_length': 0},
    }

    _attribute_map = {
        'repo_url': {'key': 'properties.repoUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'auto_sync': {'key': 'properties.autoSync', 'type': 'bool'},
        'publish_runbook': {'key': 'properties.publishRunbook', 'type': 'bool'},
        'source_type': {'key': 'properties.sourceType', 'type': 'str'},
        'security_token': {'key': 'properties.securityToken', 'type': 'SourceControlSecurityTokenProperties'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        repo_url: Optional[str] = None,
        branch: Optional[str] = None,
        folder_path: Optional[str] = None,
        auto_sync: Optional[bool] = None,
        publish_runbook: Optional[bool] = None,
        source_type: Optional[Union[str, "SourceType"]] = None,
        security_token: Optional["SourceControlSecurityTokenProperties"] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(SourceControlCreateOrUpdateParameters, self).__init__(**kwargs)
        self.repo_url = repo_url
        self.branch = branch
        self.folder_path = folder_path
        self.auto_sync = auto_sync
        self.publish_runbook = publish_runbook
        self.source_type = source_type
        self.security_token = security_token
        self.description = description


class SourceControlListResult(msrest.serialization.Model):
    """The response model for the list source controls operation.

    :param value: The list of source controls.
    :type value: list[~azure.mgmt.automation.models.SourceControl]
    :param next_link: The next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SourceControl]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SourceControl"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SourceControlListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SourceControlSecurityTokenProperties(msrest.serialization.Model):
    """SourceControlSecurityTokenProperties.

    :param access_token: The access token.
    :type access_token: str
    :param refresh_token: The refresh token.
    :type refresh_token: str
    :param token_type: The token type. Must be either PersonalAccessToken or Oauth. Possible values
     include: "PersonalAccessToken", "Oauth".
    :type token_type: str or ~azure.mgmt.automation.models.TokenType
    """

    _validation = {
        'access_token': {'max_length': 1024, 'min_length': 0},
        'refresh_token': {'max_length': 1024, 'min_length': 0},
    }

    _attribute_map = {
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'token_type': {'key': 'tokenType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        access_token: Optional[str] = None,
        refresh_token: Optional[str] = None,
        token_type: Optional[Union[str, "TokenType"]] = None,
        **kwargs
    ):
        super(SourceControlSecurityTokenProperties, self).__init__(**kwargs)
        self.access_token = access_token
        self.refresh_token = refresh_token
        self.token_type = token_type


class SourceControlSyncJob(msrest.serialization.Model):
    """Definition of the source control sync job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar id: Resource id.
    :vartype id: str
    :param source_control_sync_job_id: The source control sync job id.
    :type source_control_sync_job_id: str
    :ivar creation_time: The creation time of the job.
    :vartype creation_time: ~datetime.datetime
    :param provisioning_state: The provisioning state of the job. Possible values include:
     "Completed", "Failed", "Running".
    :type provisioning_state: str or ~azure.mgmt.automation.models.ProvisioningState
    :ivar start_time: The start time of the job.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the job.
    :vartype end_time: ~datetime.datetime
    :param sync_type: The sync type. Possible values include: "PartialSync", "FullSync".
    :type sync_type: str or ~azure.mgmt.automation.models.SyncType
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'id': {'readonly': True},
        'creation_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'source_control_sync_job_id': {'key': 'properties.sourceControlSyncJobId', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'sync_type': {'key': 'properties.syncType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_control_sync_job_id: Optional[str] = None,
        provisioning_state: Optional[Union[str, "ProvisioningState"]] = None,
        sync_type: Optional[Union[str, "SyncType"]] = None,
        **kwargs
    ):
        super(SourceControlSyncJob, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.id = None
        self.source_control_sync_job_id = source_control_sync_job_id
        self.creation_time = None
        self.provisioning_state = provisioning_state
        self.start_time = None
        self.end_time = None
        self.sync_type = sync_type


class SourceControlSyncJobById(msrest.serialization.Model):
    """Definition of the source control sync job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: The id of the job.
    :type id: str
    :param source_control_sync_job_id: The source control sync job id.
    :type source_control_sync_job_id: str
    :ivar creation_time: The creation time of the job.
    :vartype creation_time: ~datetime.datetime
    :param provisioning_state: The provisioning state of the job. Possible values include:
     "Completed", "Failed", "Running".
    :type provisioning_state: str or ~azure.mgmt.automation.models.ProvisioningState
    :ivar start_time: The start time of the job.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the job.
    :vartype end_time: ~datetime.datetime
    :param sync_type: The sync type. Possible values include: "PartialSync", "FullSync".
    :type sync_type: str or ~azure.mgmt.automation.models.SyncType
    :param exception: The exceptions that occurred while running the sync job.
    :type exception: str
    """

    _validation = {
        'creation_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'source_control_sync_job_id': {'key': 'properties.sourceControlSyncJobId', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'sync_type': {'key': 'properties.syncType', 'type': 'str'},
        'exception': {'key': 'properties.exception', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        source_control_sync_job_id: Optional[str] = None,
        provisioning_state: Optional[Union[str, "ProvisioningState"]] = None,
        sync_type: Optional[Union[str, "SyncType"]] = None,
        exception: Optional[str] = None,
        **kwargs
    ):
        super(SourceControlSyncJobById, self).__init__(**kwargs)
        self.id = id
        self.source_control_sync_job_id = source_control_sync_job_id
        self.creation_time = None
        self.provisioning_state = provisioning_state
        self.start_time = None
        self.end_time = None
        self.sync_type = sync_type
        self.exception = exception


class SourceControlSyncJobCreateParameters(msrest.serialization.Model):
    """The parameters supplied to the create source control sync job operation.

    All required parameters must be populated in order to send to Azure.

    :param commit_id: Required. The commit id of the source control sync job. If not syncing to a
     commitId, enter an empty string.
    :type commit_id: str
    """

    _validation = {
        'commit_id': {'required': True},
    }

    _attribute_map = {
        'commit_id': {'key': 'properties.commitId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        commit_id: str,
        **kwargs
    ):
        super(SourceControlSyncJobCreateParameters, self).__init__(**kwargs)
        self.commit_id = commit_id


class SourceControlSyncJobListResult(msrest.serialization.Model):
    """The response model for the list source control sync jobs operation.

    :param value: The list of source control sync jobs.
    :type value: list[~azure.mgmt.automation.models.SourceControlSyncJob]
    :param next_link: The next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SourceControlSyncJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SourceControlSyncJob"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SourceControlSyncJobListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SourceControlSyncJobStream(msrest.serialization.Model):
    """Definition of the source control sync job stream.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource id.
    :vartype id: str
    :param source_control_sync_job_stream_id: The sync job stream id.
    :type source_control_sync_job_stream_id: str
    :param summary: The summary of the sync job stream.
    :type summary: str
    :ivar time: The time of the sync job stream.
    :vartype time: ~datetime.datetime
    :param stream_type: The type of the sync job stream. Possible values include: "Error",
     "Output".
    :type stream_type: str or ~azure.mgmt.automation.models.StreamType
    """

    _validation = {
        'id': {'readonly': True},
        'time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'source_control_sync_job_stream_id': {'key': 'properties.sourceControlSyncJobStreamId', 'type': 'str'},
        'summary': {'key': 'properties.summary', 'type': 'str'},
        'time': {'key': 'properties.time', 'type': 'iso-8601'},
        'stream_type': {'key': 'properties.streamType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_control_sync_job_stream_id: Optional[str] = None,
        summary: Optional[str] = None,
        stream_type: Optional[Union[str, "StreamType"]] = None,
        **kwargs
    ):
        super(SourceControlSyncJobStream, self).__init__(**kwargs)
        self.id = None
        self.source_control_sync_job_stream_id = source_control_sync_job_stream_id
        self.summary = summary
        self.time = None
        self.stream_type = stream_type


class SourceControlSyncJobStreamById(msrest.serialization.Model):
    """Definition of the source control sync job stream by id.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource id.
    :vartype id: str
    :param source_control_sync_job_stream_id: The sync job stream id.
    :type source_control_sync_job_stream_id: str
    :param summary: The summary of the sync job stream.
    :type summary: str
    :ivar time: The time of the sync job stream.
    :vartype time: ~datetime.datetime
    :param stream_type: The type of the sync job stream. Possible values include: "Error",
     "Output".
    :type stream_type: str or ~azure.mgmt.automation.models.StreamType
    :param stream_text: The text of the sync job stream.
    :type stream_text: str
    :param value: The values of the job stream.
    :type value: dict[str, object]
    """

    _validation = {
        'id': {'readonly': True},
        'time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'source_control_sync_job_stream_id': {'key': 'properties.sourceControlSyncJobStreamId', 'type': 'str'},
        'summary': {'key': 'properties.summary', 'type': 'str'},
        'time': {'key': 'properties.time', 'type': 'iso-8601'},
        'stream_type': {'key': 'properties.streamType', 'type': 'str'},
        'stream_text': {'key': 'properties.streamText', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        source_control_sync_job_stream_id: Optional[str] = None,
        summary: Optional[str] = None,
        stream_type: Optional[Union[str, "StreamType"]] = None,
        stream_text: Optional[str] = None,
        value: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(SourceControlSyncJobStreamById, self).__init__(**kwargs)
        self.id = None
        self.source_control_sync_job_stream_id = source_control_sync_job_stream_id
        self.summary = summary
        self.time = None
        self.stream_type = stream_type
        self.stream_text = stream_text
        self.value = value


class SourceControlSyncJobStreamsListBySyncJob(msrest.serialization.Model):
    """The response model for the list source control sync job streams operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of source control sync job streams.
    :type value: list[~azure.mgmt.automation.models.SourceControlSyncJobStream]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SourceControlSyncJobStream]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SourceControlSyncJobStream"]] = None,
        **kwargs
    ):
        super(SourceControlSyncJobStreamsListBySyncJob, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SourceControlUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the update source control operation.

    :param branch: The repo branch of the source control.
    :type branch: str
    :param folder_path: The folder path of the source control. Path must be relative.
    :type folder_path: str
    :param auto_sync: The auto sync of the source control. Default is false.
    :type auto_sync: bool
    :param publish_runbook: The auto publish of the source control. Default is true.
    :type publish_runbook: bool
    :param security_token: The authorization token for the repo of the source control.
    :type security_token: ~azure.mgmt.automation.models.SourceControlSecurityTokenProperties
    :param description: The user description of the source control.
    :type description: str
    """

    _attribute_map = {
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'auto_sync': {'key': 'properties.autoSync', 'type': 'bool'},
        'publish_runbook': {'key': 'properties.publishRunbook', 'type': 'bool'},
        'security_token': {'key': 'properties.securityToken', 'type': 'SourceControlSecurityTokenProperties'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        branch: Optional[str] = None,
        folder_path: Optional[str] = None,
        auto_sync: Optional[bool] = None,
        publish_runbook: Optional[bool] = None,
        security_token: Optional["SourceControlSecurityTokenProperties"] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(SourceControlUpdateParameters, self).__init__(**kwargs)
        self.branch = branch
        self.folder_path = folder_path
        self.auto_sync = auto_sync
        self.publish_runbook = publish_runbook
        self.security_token = security_token
        self.description = description


class Statistics(msrest.serialization.Model):
    """Definition of the statistic.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar counter_property: Gets the property value of the statistic.
    :vartype counter_property: str
    :ivar counter_value: Gets the value of the statistic.
    :vartype counter_value: long
    :ivar start_time: Gets the startTime of the statistic.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets the endTime of the statistic.
    :vartype end_time: ~datetime.datetime
    :ivar id: Gets the id.
    :vartype id: str
    """

    _validation = {
        'counter_property': {'readonly': True},
        'counter_value': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'id': {'readonly': True},
    }

    _attribute_map = {
        'counter_property': {'key': 'counterProperty', 'type': 'str'},
        'counter_value': {'key': 'counterValue', 'type': 'long'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Statistics, self).__init__(**kwargs)
        self.counter_property = None
        self.counter_value = None
        self.start_time = None
        self.end_time = None
        self.id = None


class StatisticsListResult(msrest.serialization.Model):
    """The response model for the list statistics operation.

    :param value: Gets or sets a list of statistics.
    :type value: list[~azure.mgmt.automation.models.Statistics]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Statistics]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Statistics"]] = None,
        **kwargs
    ):
        super(StatisticsListResult, self).__init__(**kwargs)
        self.value = value


class SUCScheduleProperties(msrest.serialization.Model):
    """Definition of schedule parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param start_time: Gets or sets the start time of the schedule.
    :type start_time: ~datetime.datetime
    :ivar start_time_offset_minutes: Gets the start time's offset in minutes.
    :vartype start_time_offset_minutes: float
    :param expiry_time: Gets or sets the end time of the schedule.
    :type expiry_time: ~datetime.datetime
    :param expiry_time_offset_minutes: Gets or sets the expiry time's offset in minutes.
    :type expiry_time_offset_minutes: float
    :param is_enabled: Gets or sets a value indicating whether this schedule is enabled.
    :type is_enabled: bool
    :param next_run: Gets or sets the next run time of the schedule.
    :type next_run: ~datetime.datetime
    :param next_run_offset_minutes: Gets or sets the next run time's offset in minutes.
    :type next_run_offset_minutes: float
    :param interval: Gets or sets the interval of the schedule.
    :type interval: long
    :param frequency: Gets or sets the frequency of the schedule. Possible values include:
     "OneTime", "Day", "Hour", "Week", "Month", "Minute".
    :type frequency: str or ~azure.mgmt.automation.models.ScheduleFrequency
    :param time_zone: Gets or sets the time zone of the schedule.
    :type time_zone: str
    :param advanced_schedule: Gets or sets the advanced schedule.
    :type advanced_schedule: ~azure.mgmt.automation.models.AdvancedSchedule
    :param creation_time: Gets or sets the creation time.
    :type creation_time: ~datetime.datetime
    :param last_modified_time: Gets or sets the last modified time.
    :type last_modified_time: ~datetime.datetime
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'start_time_offset_minutes': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'start_time_offset_minutes': {'key': 'startTimeOffsetMinutes', 'type': 'float'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'expiry_time_offset_minutes': {'key': 'expiryTimeOffsetMinutes', 'type': 'float'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'next_run': {'key': 'nextRun', 'type': 'iso-8601'},
        'next_run_offset_minutes': {'key': 'nextRunOffsetMinutes', 'type': 'float'},
        'interval': {'key': 'interval', 'type': 'long'},
        'frequency': {'key': 'frequency', 'type': 'str'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'advanced_schedule': {'key': 'advancedSchedule', 'type': 'AdvancedSchedule'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        expiry_time: Optional[datetime.datetime] = None,
        expiry_time_offset_minutes: Optional[float] = None,
        is_enabled: Optional[bool] = False,
        next_run: Optional[datetime.datetime] = None,
        next_run_offset_minutes: Optional[float] = None,
        interval: Optional[int] = None,
        frequency: Optional[Union[str, "ScheduleFrequency"]] = None,
        time_zone: Optional[str] = None,
        advanced_schedule: Optional["AdvancedSchedule"] = None,
        creation_time: Optional[datetime.datetime] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(SUCScheduleProperties, self).__init__(**kwargs)
        self.start_time = start_time
        self.start_time_offset_minutes = None
        self.expiry_time = expiry_time
        self.expiry_time_offset_minutes = expiry_time_offset_minutes
        self.is_enabled = is_enabled
        self.next_run = next_run
        self.next_run_offset_minutes = next_run_offset_minutes
        self.interval = interval
        self.frequency = frequency
        self.time_zone = time_zone
        self.advanced_schedule = advanced_schedule
        self.creation_time = creation_time
        self.last_modified_time = last_modified_time
        self.description = description


class TagSettingsProperties(msrest.serialization.Model):
    """Tag filter information for the VM.

    :param tags: A set of tags. Dictionary of tags with its list of values.
    :type tags: dict[str, list[str]]
    :param filter_operator: Filter VMs by Any or All specified tags. Possible values include:
     "All", "Any".
    :type filter_operator: str or ~azure.mgmt.automation.models.TagOperators
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{[str]}'},
        'filter_operator': {'key': 'filterOperator', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, List[str]]] = None,
        filter_operator: Optional[Union[str, "TagOperators"]] = None,
        **kwargs
    ):
        super(TagSettingsProperties, self).__init__(**kwargs)
        self.tags = tags
        self.filter_operator = filter_operator


class TargetProperties(msrest.serialization.Model):
    """Group specific to the update configuration.

    :param azure_queries: List of Azure queries in the software update configuration.
    :type azure_queries: list[~azure.mgmt.automation.models.AzureQueryProperties]
    :param non_azure_queries: List of non Azure queries in the software update configuration.
    :type non_azure_queries: list[~azure.mgmt.automation.models.NonAzureQueryProperties]
    """

    _attribute_map = {
        'azure_queries': {'key': 'azureQueries', 'type': '[AzureQueryProperties]'},
        'non_azure_queries': {'key': 'nonAzureQueries', 'type': '[NonAzureQueryProperties]'},
    }

    def __init__(
        self,
        *,
        azure_queries: Optional[List["AzureQueryProperties"]] = None,
        non_azure_queries: Optional[List["NonAzureQueryProperties"]] = None,
        **kwargs
    ):
        super(TargetProperties, self).__init__(**kwargs)
        self.azure_queries = azure_queries
        self.non_azure_queries = non_azure_queries


class TaskProperties(msrest.serialization.Model):
    """Task properties of the software update configuration.

    :param parameters: Gets or sets the parameters of the task.
    :type parameters: dict[str, str]
    :param source: Gets or sets the name of the runbook.
    :type source: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': '{str}'},
        'source': {'key': 'source', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        parameters: Optional[Dict[str, str]] = None,
        source: Optional[str] = None,
        **kwargs
    ):
        super(TaskProperties, self).__init__(**kwargs)
        self.parameters = parameters
        self.source = source


class TestJob(msrest.serialization.Model):
    """Definition of the test job.

    :param creation_time: Gets or sets the creation time of the test job.
    :type creation_time: ~datetime.datetime
    :param status: Gets or sets the status of the test job.
    :type status: str
    :param status_details: Gets or sets the status details of the test job.
    :type status_details: str
    :param run_on: Gets or sets the runOn which specifies the group name where the job is to be
     executed.
    :type run_on: str
    :param start_time: Gets or sets the start time of the test job.
    :type start_time: ~datetime.datetime
    :param end_time: Gets or sets the end time of the test job.
    :type end_time: ~datetime.datetime
    :param exception: Gets or sets the exception of the test job.
    :type exception: str
    :param last_modified_time: Gets or sets the last modified time of the test job.
    :type last_modified_time: ~datetime.datetime
    :param last_status_modified_time: Gets or sets the last status modified time of the test job.
    :type last_status_modified_time: ~datetime.datetime
    :param parameters: Gets or sets the parameters of the test job.
    :type parameters: dict[str, str]
    :param log_activity_trace: The activity-level tracing options of the runbook.
    :type log_activity_trace: int
    """

    _attribute_map = {
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'status_details': {'key': 'statusDetails', 'type': 'str'},
        'run_on': {'key': 'runOn', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'exception': {'key': 'exception', 'type': 'str'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
        'last_status_modified_time': {'key': 'lastStatusModifiedTime', 'type': 'iso-8601'},
        'parameters': {'key': 'parameters', 'type': '{str}'},
        'log_activity_trace': {'key': 'logActivityTrace', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        creation_time: Optional[datetime.datetime] = None,
        status: Optional[str] = None,
        status_details: Optional[str] = None,
        run_on: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        exception: Optional[str] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        last_status_modified_time: Optional[datetime.datetime] = None,
        parameters: Optional[Dict[str, str]] = None,
        log_activity_trace: Optional[int] = None,
        **kwargs
    ):
        super(TestJob, self).__init__(**kwargs)
        self.creation_time = creation_time
        self.status = status
        self.status_details = status_details
        self.run_on = run_on
        self.start_time = start_time
        self.end_time = end_time
        self.exception = exception
        self.last_modified_time = last_modified_time
        self.last_status_modified_time = last_status_modified_time
        self.parameters = parameters
        self.log_activity_trace = log_activity_trace


class TestJobCreateParameters(msrest.serialization.Model):
    """The parameters supplied to the create test job operation.

    :param parameters: Gets or sets the parameters of the test job.
    :type parameters: dict[str, str]
    :param run_on: Gets or sets the runOn which specifies the group name where the job is to be
     executed.
    :type run_on: str
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': '{str}'},
        'run_on': {'key': 'runOn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        parameters: Optional[Dict[str, str]] = None,
        run_on: Optional[str] = None,
        **kwargs
    ):
        super(TestJobCreateParameters, self).__init__(**kwargs)
        self.parameters = parameters
        self.run_on = run_on


class TypeField(msrest.serialization.Model):
    """Information about a field of a type.

    :param name: Gets or sets the name of the field.
    :type name: str
    :param type: Gets or sets the type of the field.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(TypeField, self).__init__(**kwargs)
        self.name = name
        self.type = type


class TypeFieldListResult(msrest.serialization.Model):
    """The response model for the list fields operation.

    :param value: Gets or sets a list of fields.
    :type value: list[~azure.mgmt.automation.models.TypeField]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TypeField]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["TypeField"]] = None,
        **kwargs
    ):
        super(TypeFieldListResult, self).__init__(**kwargs)
        self.value = value


class UpdateConfiguration(msrest.serialization.Model):
    """Update specific properties of the software update configuration.

    All required parameters must be populated in order to send to Azure.

    :param operating_system: Required. operating system of target machines. Possible values
     include: "Windows", "Linux".
    :type operating_system: str or ~azure.mgmt.automation.models.OperatingSystemType
    :param windows: Windows specific update configuration.
    :type windows: ~azure.mgmt.automation.models.WindowsProperties
    :param linux: Linux specific update configuration.
    :type linux: ~azure.mgmt.automation.models.LinuxProperties
    :param duration: Maximum time allowed for the software update configuration run. Duration needs
     to be specified using the format PT[n]H[n]M[n]S as per ISO8601.
    :type duration: ~datetime.timedelta
    :param azure_virtual_machines: List of azure resource Ids for azure virtual machines targeted
     by the software update configuration.
    :type azure_virtual_machines: list[str]
    :param non_azure_computer_names: List of names of non-azure machines targeted by the software
     update configuration.
    :type non_azure_computer_names: list[str]
    :param targets: Group targets for the software update configuration.
    :type targets: ~azure.mgmt.automation.models.TargetProperties
    """

    _validation = {
        'operating_system': {'required': True},
    }

    _attribute_map = {
        'operating_system': {'key': 'operatingSystem', 'type': 'str'},
        'windows': {'key': 'windows', 'type': 'WindowsProperties'},
        'linux': {'key': 'linux', 'type': 'LinuxProperties'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'azure_virtual_machines': {'key': 'azureVirtualMachines', 'type': '[str]'},
        'non_azure_computer_names': {'key': 'nonAzureComputerNames', 'type': '[str]'},
        'targets': {'key': 'targets', 'type': 'TargetProperties'},
    }

    def __init__(
        self,
        *,
        operating_system: Union[str, "OperatingSystemType"],
        windows: Optional["WindowsProperties"] = None,
        linux: Optional["LinuxProperties"] = None,
        duration: Optional[datetime.timedelta] = None,
        azure_virtual_machines: Optional[List[str]] = None,
        non_azure_computer_names: Optional[List[str]] = None,
        targets: Optional["TargetProperties"] = None,
        **kwargs
    ):
        super(UpdateConfiguration, self).__init__(**kwargs)
        self.operating_system = operating_system
        self.windows = windows
        self.linux = linux
        self.duration = duration
        self.azure_virtual_machines = azure_virtual_machines
        self.non_azure_computer_names = non_azure_computer_names
        self.targets = targets


class UpdateConfigurationNavigation(msrest.serialization.Model):
    """Software update configuration Run Navigation model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the software update configuration triggered the software update
     configuration run.
    :vartype name: str
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateConfigurationNavigation, self).__init__(**kwargs)
        self.name = None


class Usage(msrest.serialization.Model):
    """Definition of Usage.

    :param id: Gets or sets the id of the resource.
    :type id: str
    :param name: Gets or sets the usage counter name.
    :type name: ~azure.mgmt.automation.models.UsageCounterName
    :param unit: Gets or sets the usage unit name.
    :type unit: str
    :param current_value: Gets or sets the current usage value.
    :type current_value: float
    :param limit: Gets or sets max limit. -1 for unlimited.
    :type limit: long
    :param throttle_status: Gets or sets the throttle status.
    :type throttle_status: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'UsageCounterName'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'limit': {'key': 'limit', 'type': 'long'},
        'throttle_status': {'key': 'throttleStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional["UsageCounterName"] = None,
        unit: Optional[str] = None,
        current_value: Optional[float] = None,
        limit: Optional[int] = None,
        throttle_status: Optional[str] = None,
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.unit = unit
        self.current_value = current_value
        self.limit = limit
        self.throttle_status = throttle_status


class UsageCounterName(msrest.serialization.Model):
    """Definition of usage counter name.

    :param value: Gets or sets the usage counter name.
    :type value: str
    :param localized_value: Gets or sets the localized usage counter name.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        super(UsageCounterName, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class UsageListResult(msrest.serialization.Model):
    """The response model for the get usage operation.

    :param value: Gets or sets usage.
    :type value: list[~azure.mgmt.automation.models.Usage]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Usage"]] = None,
        **kwargs
    ):
        super(UsageListResult, self).__init__(**kwargs)
        self.value = value


class Variable(Resource):
    """Definition of the variable.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param value: Gets or sets the value of the variable.
    :type value: str
    :param is_encrypted: Gets or sets the encrypted flag of the variable.
    :type is_encrypted: bool
    :param creation_time: Gets or sets the creation time.
    :type creation_time: ~datetime.datetime
    :param last_modified_time: Gets or sets the last modified time.
    :type last_modified_time: ~datetime.datetime
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'is_encrypted': {'key': 'properties.isEncrypted', 'type': 'bool'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        is_encrypted: Optional[bool] = None,
        creation_time: Optional[datetime.datetime] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(Variable, self).__init__(**kwargs)
        self.value = value
        self.is_encrypted = is_encrypted
        self.creation_time = creation_time
        self.last_modified_time = last_modified_time
        self.description = description


class VariableCreateOrUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update variable operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Gets or sets the name of the variable.
    :type name: str
    :param value: Gets or sets the value of the variable.
    :type value: str
    :param description: Gets or sets the description of the variable.
    :type description: str
    :param is_encrypted: Gets or sets the encrypted flag of the variable.
    :type is_encrypted: bool
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_encrypted': {'key': 'properties.isEncrypted', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: Optional[str] = None,
        description: Optional[str] = None,
        is_encrypted: Optional[bool] = None,
        **kwargs
    ):
        super(VariableCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.value = value
        self.description = description
        self.is_encrypted = is_encrypted


class VariableListResult(msrest.serialization.Model):
    """The response model for the list variables operation.

    :param value: Gets or sets a list of variables.
    :type value: list[~azure.mgmt.automation.models.Variable]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Variable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Variable"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VariableListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VariableUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the update variable operation.

    :param name: Gets or sets the name of the variable.
    :type name: str
    :param value: Gets or sets the value of the variable.
    :type value: str
    :param description: Gets or sets the description of the variable.
    :type description: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(VariableUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.value = value
        self.description = description


class Watcher(Resource):
    """Definition of the watcher type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param etag: Gets or sets the etag of the resource.
    :type etag: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: The geo-location where the resource lives.
    :type location: str
    :param execution_frequency_in_seconds: Gets or sets the frequency at which the watcher is
     invoked.
    :type execution_frequency_in_seconds: long
    :param script_name: Gets or sets the name of the script the watcher is attached to, i.e. the
     name of an existing runbook.
    :type script_name: str
    :param script_parameters: Gets or sets the parameters of the script.
    :type script_parameters: dict[str, str]
    :param script_run_on: Gets or sets the name of the hybrid worker group the watcher will run on.
    :type script_run_on: str
    :ivar status: Gets the current status of the watcher.
    :vartype status: str
    :ivar creation_time: Gets or sets the creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: Gets or sets the last modified time.
    :vartype last_modified_time: ~datetime.datetime
    :ivar last_modified_by: Details of the user who last modified the watcher.
    :vartype last_modified_by: str
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'creation_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'last_modified_by': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'execution_frequency_in_seconds': {'key': 'properties.executionFrequencyInSeconds', 'type': 'long'},
        'script_name': {'key': 'properties.scriptName', 'type': 'str'},
        'script_parameters': {'key': 'properties.scriptParameters', 'type': '{str}'},
        'script_run_on': {'key': 'properties.scriptRunOn', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        execution_frequency_in_seconds: Optional[int] = None,
        script_name: Optional[str] = None,
        script_parameters: Optional[Dict[str, str]] = None,
        script_run_on: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(Watcher, self).__init__(**kwargs)
        self.etag = etag
        self.tags = tags
        self.location = location
        self.execution_frequency_in_seconds = execution_frequency_in_seconds
        self.script_name = script_name
        self.script_parameters = script_parameters
        self.script_run_on = script_run_on
        self.status = None
        self.creation_time = None
        self.last_modified_time = None
        self.last_modified_by = None
        self.description = description


class WatcherListResult(msrest.serialization.Model):
    """The response model for the list watcher operation.

    :param value: Gets or sets a list of watchers.
    :type value: list[~azure.mgmt.automation.models.Watcher]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Watcher]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Watcher"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(WatcherListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WatcherUpdateParameters(msrest.serialization.Model):
    """WatcherUpdateParameters.

    :param name: Gets or sets the name of the resource.
    :type name: str
    :param execution_frequency_in_seconds: Gets or sets the frequency at which the watcher is
     invoked.
    :type execution_frequency_in_seconds: long
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'execution_frequency_in_seconds': {'key': 'properties.executionFrequencyInSeconds', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        execution_frequency_in_seconds: Optional[int] = None,
        **kwargs
    ):
        super(WatcherUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.execution_frequency_in_seconds = execution_frequency_in_seconds


class Webhook(Resource):
    """Definition of the webhook type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param is_enabled: Gets or sets the value of the enabled flag of the webhook.
    :type is_enabled: bool
    :param uri: Gets or sets the webhook uri.
    :type uri: str
    :param expiry_time: Gets or sets the expiry time.
    :type expiry_time: ~datetime.datetime
    :param last_invoked_time: Gets or sets the last invoked time.
    :type last_invoked_time: ~datetime.datetime
    :param parameters: Gets or sets the parameters of the job that is created when the webhook
     calls the runbook it is associated with.
    :type parameters: dict[str, str]
    :param runbook: Gets or sets the runbook the webhook is associated with.
    :type runbook: ~azure.mgmt.automation.models.RunbookAssociationProperty
    :param run_on: Gets or sets the name of the hybrid worker group the webhook job will run on.
    :type run_on: str
    :param creation_time: Gets or sets the creation time.
    :type creation_time: ~datetime.datetime
    :param last_modified_time: Gets or sets the last modified time.
    :type last_modified_time: ~datetime.datetime
    :param last_modified_by: Details of the user who last modified the Webhook.
    :type last_modified_by: str
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'expiry_time': {'key': 'properties.expiryTime', 'type': 'iso-8601'},
        'last_invoked_time': {'key': 'properties.lastInvokedTime', 'type': 'iso-8601'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
        'runbook': {'key': 'properties.runbook', 'type': 'RunbookAssociationProperty'},
        'run_on': {'key': 'properties.runOn', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        is_enabled: Optional[bool] = False,
        uri: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        last_invoked_time: Optional[datetime.datetime] = None,
        parameters: Optional[Dict[str, str]] = None,
        runbook: Optional["RunbookAssociationProperty"] = None,
        run_on: Optional[str] = None,
        creation_time: Optional[datetime.datetime] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(Webhook, self).__init__(**kwargs)
        self.is_enabled = is_enabled
        self.uri = uri
        self.expiry_time = expiry_time
        self.last_invoked_time = last_invoked_time
        self.parameters = parameters
        self.runbook = runbook
        self.run_on = run_on
        self.creation_time = creation_time
        self.last_modified_time = last_modified_time
        self.last_modified_by = last_modified_by
        self.description = description


class WebhookCreateOrUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the create or update webhook operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Gets or sets the name of the webhook.
    :type name: str
    :param is_enabled: Gets or sets the value of the enabled flag of webhook.
    :type is_enabled: bool
    :param uri: Gets or sets the uri.
    :type uri: str
    :param expiry_time: Gets or sets the expiry time.
    :type expiry_time: ~datetime.datetime
    :param parameters: Gets or sets the parameters of the job.
    :type parameters: dict[str, str]
    :param runbook: Gets or sets the runbook.
    :type runbook: ~azure.mgmt.automation.models.RunbookAssociationProperty
    :param run_on: Gets or sets the name of the hybrid worker group the webhook job will run on.
    :type run_on: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'expiry_time': {'key': 'properties.expiryTime', 'type': 'iso-8601'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
        'runbook': {'key': 'properties.runbook', 'type': 'RunbookAssociationProperty'},
        'run_on': {'key': 'properties.runOn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        is_enabled: Optional[bool] = None,
        uri: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        parameters: Optional[Dict[str, str]] = None,
        runbook: Optional["RunbookAssociationProperty"] = None,
        run_on: Optional[str] = None,
        **kwargs
    ):
        super(WebhookCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.is_enabled = is_enabled
        self.uri = uri
        self.expiry_time = expiry_time
        self.parameters = parameters
        self.runbook = runbook
        self.run_on = run_on


class WebhookListResult(msrest.serialization.Model):
    """The response model for the list webhook operation.

    :param value: Gets or sets a list of webhooks.
    :type value: list[~azure.mgmt.automation.models.Webhook]
    :param next_link: Gets or sets the next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Webhook]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Webhook"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(WebhookListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WebhookUpdateParameters(msrest.serialization.Model):
    """The parameters supplied to the update webhook operation.

    :param name: Gets or sets the name of the webhook.
    :type name: str
    :param is_enabled: Gets or sets the value of the enabled flag of webhook.
    :type is_enabled: bool
    :param run_on: Gets or sets the name of the hybrid worker group the webhook job will run on.
    :type run_on: str
    :param parameters: Gets or sets the parameters of the job.
    :type parameters: dict[str, str]
    :param description: Gets or sets the description of the webhook.
    :type description: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'run_on': {'key': 'properties.runOn', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_enabled: Optional[bool] = None,
        run_on: Optional[str] = None,
        parameters: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(WebhookUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.is_enabled = is_enabled
        self.run_on = run_on
        self.parameters = parameters
        self.description = description


class WindowsProperties(msrest.serialization.Model):
    """Windows specific update configuration.

    :param included_update_classifications: Update classification included in the software update
     configuration. A comma separated string with required values. Possible values include:
     "Unclassified", "Critical", "Security", "UpdateRollup", "FeaturePack", "ServicePack",
     "Definition", "Tools", "Updates".
    :type included_update_classifications: str or
     ~azure.mgmt.automation.models.WindowsUpdateClasses
    :param excluded_kb_numbers: KB numbers excluded from the software update configuration.
    :type excluded_kb_numbers: list[str]
    :param included_kb_numbers: KB numbers included from the software update configuration.
    :type included_kb_numbers: list[str]
    :param reboot_setting: Reboot setting for the software update configuration.
    :type reboot_setting: str
    """

    _attribute_map = {
        'included_update_classifications': {'key': 'includedUpdateClassifications', 'type': 'str'},
        'excluded_kb_numbers': {'key': 'excludedKbNumbers', 'type': '[str]'},
        'included_kb_numbers': {'key': 'includedKbNumbers', 'type': '[str]'},
        'reboot_setting': {'key': 'rebootSetting', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        included_update_classifications: Optional[Union[str, "WindowsUpdateClasses"]] = None,
        excluded_kb_numbers: Optional[List[str]] = None,
        included_kb_numbers: Optional[List[str]] = None,
        reboot_setting: Optional[str] = None,
        **kwargs
    ):
        super(WindowsProperties, self).__init__(**kwargs)
        self.included_update_classifications = included_update_classifications
        self.excluded_kb_numbers = excluded_kb_numbers
        self.included_kb_numbers = included_kb_numbers
        self.reboot_setting = reboot_setting
