# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.authorization.v2019_08_01_preview.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.authorization.v2019_08_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~azure.mgmt.authorization.v2019_08_01_preview.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class RoleAssignmentMetricsResult(msrest.serialization.Model):
    """Role Assignment Metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subscription_id: The subscription ID.
    :vartype subscription_id: str
    :ivar role_assignments_limit: The role assignment limit.
    :vartype role_assignments_limit: long
    :ivar role_assignments_current_count: The number of current role assignments.
    :vartype role_assignments_current_count: long
    :ivar role_assignments_remaining_count: The number of remaining role assignments available.
    :vartype role_assignments_remaining_count: long
    """

    _validation = {
        'subscription_id': {'readonly': True},
        'role_assignments_limit': {'readonly': True},
        'role_assignments_current_count': {'readonly': True},
        'role_assignments_remaining_count': {'readonly': True},
    }

    _attribute_map = {
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'role_assignments_limit': {'key': 'roleAssignmentsLimit', 'type': 'long'},
        'role_assignments_current_count': {'key': 'roleAssignmentsCurrentCount', 'type': 'long'},
        'role_assignments_remaining_count': {'key': 'roleAssignmentsRemainingCount', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentMetricsResult, self).__init__(**kwargs)
        self.subscription_id = None
        self.role_assignments_limit = None
        self.role_assignments_current_count = None
        self.role_assignments_remaining_count = None
