---
id: fast-colors.histogram._constructor_
title: Histogram.(constructor)
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-colors](./fast-colors.md) &gt; [Histogram](./fast-colors.histogram.md) &gt; [(constructor)](./fast-colors.histogram._constructor_.md)

## Histogram.(constructor)

Constructs a new instance of the `Histogram` class

<b>Signature:</b>

```typescript
constructor(source: PixelBlob, significantBits?: number, pixelSkipping?: number, isHistogramPixelValid?: ((pixel: number[]) => boolean) | null);
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  source | [PixelBlob](./fast-colors.pixelblob.md) | the source pixel data. |
|  significantBits | number | The memory needed for the histogram increases dramatically if significantBits is increased. It needs a buffer which is 4\*2^(3\*significantBits) in size. EG: for 5 significant bits the histogram is 128K while for 8 it is 64 megs. |
|  pixelSkipping | number | CPU time increases linearly as pixelSkipping is reduced. |
|  isHistogramPixelValid | ((pixel: number\[\]) =&gt; boolean) \| null | isHistogramPixelValid is an optional predicate which can screen out unwanted pixels from the source data. EG: ignoring transparent pixels. |
