/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class TinyTextImpl
extends TinyNodeImpl {
    public TinyTextImpl(TinyTree tree, int nodeNr) {
        this.tree = tree;
        this.nodeNr = nodeNr;
    }

    public String getStringValue() {
        int start = this.tree.alpha[this.nodeNr];
        int len = this.tree.beta[this.nodeNr];
        return this.tree.charBuffer.substring(start, start + len);
    }

    public CharSequence getStringValueCS() {
        int start = this.tree.alpha[this.nodeNr];
        int len = this.tree.beta[this.nodeNr];
        return this.tree.charBuffer.subSequence(start, start + len);
    }

    public static CharSequence getStringValue(TinyTree tree, int nodeNr) {
        int start = tree.alpha[nodeNr];
        int len = tree.beta[nodeNr];
        return tree.charBuffer.subSequence(start, start + len);
    }

    public final int getNodeKind() {
        return 3;
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        out.characters(this.getStringValueCS(), 0, 0);
    }

    public SequenceIterator getTypedValue() throws XPathException {
        return SingletonIterator.makeIterator(new UntypedAtomicValue(this.getStringValueCS()));
    }

    public Value atomize() throws XPathException {
        return new UntypedAtomicValue(this.getStringValueCS());
    }
}

