/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model;

import java.io.InputStream;
import java.util.ArrayList;
import org.lisaac.ldt.model.AbstractLisaacParser;
import org.lisaac.ldt.model.ILisaacModel;
import org.lisaac.ldt.model.lip.LIP;
import org.lisaac.ldt.model.lip.LIPAffect;
import org.lisaac.ldt.model.lip.LIPBinary;
import org.lisaac.ldt.model.lip.LIPBoolean;
import org.lisaac.ldt.model.lip.LIPCall;
import org.lisaac.ldt.model.lip.LIPCode;
import org.lisaac.ldt.model.lip.LIPConstant;
import org.lisaac.ldt.model.lip.LIPIf;
import org.lisaac.ldt.model.lip.LIPInteger;
import org.lisaac.ldt.model.lip.LIPPrint;
import org.lisaac.ldt.model.lip.LIPSlotCode;
import org.lisaac.ldt.model.lip.LIPSlotData;
import org.lisaac.ldt.model.lip.LIPString;
import org.lisaac.ldt.model.lip.LIPUnary;
import org.lisaac.ldt.model.lip.LIPValue;

public class LipParser
extends AbstractLisaacParser {
    public LIP lipFile;

    public LipParser(InputStream contents, ILisaacModel model) {
        super(contents, model);
        this.lipFile = model.getLipCode();
    }

    public LipParser(String contents, int offset) {
        super(contents);
        this.setPosition(offset);
    }

    public boolean parse() {
        boolean result = false;
        while (this.readThisKeyword("Section")) {
            if (this.readThisKeyword("Inherit")) {
                while (this.readCharacter('+')) {
                    if (!this.readIdentifier()) {
                        this.reporter.syntaxError("Identifier needed.", this.getLine());
                        return false;
                    }
                    if (!this.readCharacter(':')) {
                        this.reporter.syntaxError("Added ':' is needed.", this.getLine());
                        return false;
                    }
                    if (!this.readWord("STRING")) {
                        this.reporter.warning("`STRING' type needed.", this.getLine());
                    }
                    if (this.readSymbol(":=")) {
                        if (!this.readString()) {
                            this.reporter.syntaxError("String needed.", this.getLine());
                            return false;
                        }
                        this.string_tmp = new String(this.lipFile.getFileName());
                        while (this.string_tmp.length() > 0) {
                            char c = this.string_tmp.charAt(this.string_tmp.length() - 1);
                            if (c == '/' || c == '\\') break;
                            this.string_tmp = this.string_tmp.substring(0, this.string_tmp.length() - 1);
                        }
                        this.string_tmp = String.valueOf(this.string_tmp) + this.lastString;
                    } else {
                        this.string_tmp = "";
                    }
                    this.lipFile.addParent(this.getString(this.string_tmp));
                    if (!this.readCharacter(';')) {
                        this.reporter.syntaxError("Added ';' is needed.", this.getLine());
                        return false;
                    }
                    result = true;
                }
                continue;
            }
            if (this.readThisKeyword("Public") || this.readThisKeyword("Private")) {
                String section = new String(this.lastString);
                while (this.readSlot(section)) {
                    if (!this.readCharacter(';')) {
                        this.reporter.syntaxError("Added ';' is needed.", this.getLine());
                        return false;
                    }
                    result = true;
                }
                continue;
            }
            this.reporter.syntaxError("`Public' or `Private' or `Inherit' needed.", this.getLine());
            return false;
        }
        if (this.position < this.source.length() - 2) {
            result = false;
        }
        return result;
    }

    private boolean readSlot(String sec) {
        boolean result = false;
        LIPSlotData data = null;
        if (this.readCharacter('+')) {
            result = true;
            if (sec.equals("Public")) {
                this.reporter.syntaxError("No data in Public section.", this.getPosition(1));
            }
            if (!this.readIdentifier()) {
                this.reporter.syntaxError("Identifier is incorrect.", this.getLine());
                return false;
            }
            String n = new String(this.lastString);
            if (!this.readCharacter(':')) {
                this.reporter.syntaxError("Added ':' is needed.", this.getLine());
                return false;
            }
            LIPConstant t = this.readType();
            if (t == null) {
                this.reporter.syntaxError("type is incorrect.", this.getLine());
                return false;
            }
            data = new LIPSlotData(n, t);
            this.lipFile.addData(data);
            if (this.readSymbol(":=")) {
                LIPConstant cst = this.readExprConstant();
                if (cst == null) {
                    this.reporter.syntaxError("Incorrect expression.", this.getLine());
                    return false;
                }
                data.setValue(cst);
                cst.free();
            }
        } else if (this.readCharacter('-')) {
            LIPCode instr;
            result = true;
            if (!this.readIdentifier()) {
                this.reporter.syntaxError("Identifier is incorrect.", this.getLine());
                return false;
            }
            this.setCatchComment();
            String n = new String(this.lastString);
            if (this.readIdentifier()) {
                String na = new String(this.lastString);
                if (!this.readCharacter(':')) {
                    this.reporter.syntaxError("Added ':' is needed.", this.getLine());
                    return false;
                }
                LIPConstant t = this.readType();
                if (t == null) {
                    this.reporter.syntaxError("Incorrect type.", this.getLine());
                    return false;
                }
                data = new LIPSlotData(na, t);
            }
            if (!this.readSymbol("<-")) {
                this.reporter.syntaxError("Added '<-' is needed.", this.getLine());
                return false;
            }
            if (!this.readCharacter('(')) {
                this.reporter.syntaxError("Added '(' is needed.", this.getLine());
                return false;
            }
            this.setCatchCommentOff();
            ArrayList<LIPCode> code = new ArrayList<LIPCode>();
            while ((instr = this.readExpr()) != null) {
                code.add(instr);
                if (this.readCharacter(';')) continue;
                this.reporter.syntaxError("Added ';' is needed.", this.getLine());
                return false;
            }
            if (!this.readCharacter(')')) {
                this.reporter.syntaxError("Added ')' is needed.", this.getLine());
                return false;
            }
            LIPSlotCode slotCode = new LIPSlotCode(sec, n, data, code.toArray(new LIPCode[code.size()]));
            this.lipFile.addMethod(slotCode);
            if (sec.equals("Public")) {
                if (lastComment == null || lastComment.length() == 0) {
                    this.reporter.syntaxError("Comment needed.", this.getPosition());
                } else {
                    slotCode.setComment(lastComment);
                }
            }
        }
        return result;
    }

    private LIPConstant readType() {
        LIPConstant result = null;
        if (this.readCapIdentifier()) {
            if (this.lastString.equals("INTEGER")) {
                result = LIPInteger.get(0);
            } else if (this.lastString.equals("STRING")) {
                result = LIPString.get(this.getString(""));
            } else if (this.lastString.equals("BOOLEAN")) {
                result = LIPBoolean.get(false);
            } else {
                this.reporter.syntaxError("Incorrect type.", this.getLine());
            }
        }
        return result;
    }

    public LIPCode readExpr() {
        LIPCode result = null;
        this.saveContext();
        if (this.readIdentifier()) {
            String name = new String(this.lastString);
            if (this.readSymbol(":=")) {
                LIPCode val = this.readExprOperator();
                if (val == null) {
                    this.reporter.syntaxError("Incorrect expression.", this.getLine());
                    return null;
                }
                result = new LIPAffect(name, val);
            } else {
                this.restoreContext();
            }
        }
        if (result == null && (result = this.readExprOperator()) != null && this.readCharacter('.') && (result = this.readFunction(result)) == null) {
            this.reporter.syntaxError("Incorrect slot.", this.getLine());
            return null;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private LIPCode readFunction(LIPCode rec) {
        block7: {
            block5: {
                block6: {
                    result /* !! */  = null;
                    thenArray = null;
                    elseArray = null;
                    if (!this.readWord("if")) break block5;
                    thenArray = new ArrayList<LIPCode>();
                    if (this.readCharacter('{')) ** GOTO lbl14
                    this.reporter.syntaxError("Added '{' is needed.", this.getLine());
                    return null;
lbl-1000:
                    // 1 sources

                    {
                        thenArray.add(val);
                        if (this.readCharacter(';')) continue;
                        this.reporter.syntaxError("Added ';' is needed.", this.getLine());
                        return null;
lbl14:
                        // 2 sources

                        ** while ((val = this.readExpr()) != null)
                    }
lbl15:
                    // 1 sources

                    if (!this.readCharacter('}')) {
                        this.reporter.syntaxError("Added '}' is needed.", this.getLine());
                        return null;
                    }
                    if (!this.readWord("else")) break block6;
                    elseArray = new ArrayList<LIPCode>();
                    if (this.readCharacter('{')) ** GOTO lbl28
                    this.reporter.syntaxError("Added '{' is needed.", this.getLine());
                    return null;
lbl-1000:
                    // 1 sources

                    {
                        elseArray.add(val);
                        if (this.readCharacter(';')) continue;
                        this.reporter.syntaxError("Added ';' is needed.", this.getLine());
                        return null;
lbl28:
                        // 2 sources

                        ** while ((val = this.readExpr()) != null)
                    }
lbl29:
                    // 1 sources

                    if (!this.readCharacter('}')) {
                        this.reporter.syntaxError("Added '}' is needed.", this.getLine());
                        return null;
                    }
                }
                result /* !! */  = new LIPIf(rec, thenArray.toArray(new LIPCode[thenArray.size()]), elseArray.toArray(new LIPCode[elseArray.size()]));
                break block7;
            }
            if (this.readWord("print")) {
                result /* !! */  = new LIPPrint(rec);
            }
        }
        return result /* !! */ ;
    }

    private LIPCode readExprOperator() {
        LIPCode result = null;
        boolean isOr = false;
        result = this.readExprCmp();
        if (result != null) {
            while ((isOr = this.readCharacter('|')) || this.readCharacter('&')) {
                LIPCode right = this.readExprCmp();
                if (right == null) {
                    this.reporter.syntaxError("Incorrect expression.", this.getLine());
                    return null;
                }
                result = isOr ? new LIPBinary(result, '|', right) : new LIPBinary(result, '&', right);
            }
        }
        return result;
    }

    private LIPCode readExprCmp() {
        LIPCode result = this.readExprBinary();
        if (result != null) {
            while (this.readSymbol(">=") || this.readSymbol("<=") || this.readSymbol("!=") || this.readSymbol("=") || this.readSymbol(">") || this.readSymbol("<")) {
                String op = new String(this.lastString);
                LIPCode right = this.readExprBinary();
                if (right == null) {
                    this.reporter.syntaxError("Incorrect expression.", this.getLine());
                    return null;
                }
                int type = 0;
                if (op.equals(">=")) {
                    type = 83;
                } else if (op.equals("<=")) {
                    type = 73;
                } else if (op.equals("!=")) {
                    type = 69;
                } else if (op.equals("=")) {
                    type = 61;
                } else if (op.equals(">")) {
                    type = 62;
                } else if (op.equals("<")) {
                    type = 60;
                }
                result = new LIPBinary(result, (char)type, right);
            }
        }
        return result;
    }

    private LIPCode readExprBinary() {
        LIPCode result = this.readExprUnary();
        if (result != null) {
            boolean isSub;
            while ((isSub = this.readCharacter('-')) || this.readCharacter('+')) {
                LIPCode right = this.readExprUnary();
                if (right == null) {
                    this.reporter.syntaxError("Incorrect expression.", this.getLine());
                    return null;
                }
                result = isSub ? new LIPBinary(result, '-', right) : new LIPBinary(result, '+', right);
            }
        }
        return result;
    }

    private LIPCode readExprUnary() {
        LIPCode result = null;
        boolean isNeg = this.readCharacter('-');
        if (isNeg || this.readCharacter('!')) {
            result = this.readExprUnary();
            if (result == null) {
                this.reporter.syntaxError("Incorrect expression.", this.getLine());
                return null;
            }
            char type = isNeg ? (char)'-' : '+';
            result = new LIPUnary(type, result);
        } else if (this.readIdentifier()) {
            String name = new String(this.lastString);
            LIPCode arg = this.readExprArgument();
            result = new LIPCall(name, arg);
        } else {
            result = this.readExprBase();
        }
        return result;
    }

    private LIPCode readExprBase() {
        LIPCode result = null;
        if (this.readCharacter('(')) {
            result = this.readExprOperator();
            if (result == null) {
                this.reporter.syntaxError("Incorrect expression.", this.getLine());
                return null;
            }
            if (!this.readCharacter(')')) {
                this.reporter.syntaxError("Added ')' is needed.", this.getLine());
                return null;
            }
        } else {
            LIPConstant v = this.readExprConstant();
            if (v != null) {
                result = new LIPValue(v);
            }
        }
        return result;
    }

    private LIPConstant readExprConstant() {
        LIPConstant result = null;
        if (this.readInteger()) {
            result = LIPInteger.get((int)this.lastInteger);
        } else if (this.readString()) {
            result = LIPString.get(this.lastString);
        } else if (this.readCapIdentifier()) {
            if (this.lastString.equals("TRUE")) {
                result = LIPBoolean.get(true);
            } else if (this.lastString.equals("FALSE")) {
                result = LIPBoolean.get(false);
            } else {
                this.reporter.syntaxError("Type incorrect.", this.getLine());
            }
        }
        return result;
    }

    private LIPCode readExprArgument() {
        LIPCode result = null;
        result = this.readIdentifier() ? new LIPCall(this.lastString, null) : this.readExprBase();
        return result;
    }
}

