/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.editors;

import java.util.Stack;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.widgets.Display;
import org.lisaac.ldt.editors.ColorManager;
import org.lisaac.ldt.editors.ILisaacColor;

public class HoverPresenter
implements DefaultInformationControl.IInformationPresenter,
DefaultInformationControl.IInformationPresenterExtension {
    private static final int NONE = 0;
    private static final int BOLD = 1;
    private static final int ITALIC = 2;
    private static final int GRAY = 3;
    protected ColorManager colorManager;

    public HoverPresenter(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String updatePresentation(Drawable drawable, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
        if (hoverInfo == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int style = 0;
        Stack<Integer> styles = new Stack<Integer>();
        int startOffset = 0;
        int len = hoverInfo.length();
        int i = 0;
        int derive = 0;
        while (i < len) {
            char c = hoverInfo.charAt(i);
            if (c == '<' && i < len - 3) {
                if (hoverInfo.charAt(i + 1) == '/') {
                    c = Character.toLowerCase(hoverInfo.charAt(i + 2));
                    if (hoverInfo.charAt(i + 3) == '>') {
                        style = (Integer)styles.pop();
                        startOffset = (Integer)styles.pop();
                        int styleDerive = (Integer)styles.pop();
                        int lengthDerive = derive - styleDerive;
                        if (lengthDerive > 0) {
                            style = 0;
                        }
                        switch (style) {
                            case 1: {
                                presentation.addStyleRange(new StyleRange(startOffset - styleDerive, i - startOffset - lengthDerive, null, null, 1));
                                break;
                            }
                            case 2: {
                                presentation.addStyleRange(new StyleRange(startOffset - styleDerive, i - startOffset - lengthDerive, null, null, 2));
                                break;
                            }
                            case 3: {
                                Color gray = this.colorManager.getColor(ILisaacColor.GRAY);
                                presentation.addStyleRange(new StyleRange(startOffset - styleDerive, i - startOffset - lengthDerive, gray, null, 0));
                            }
                        }
                        i += 3;
                        derive += 4;
                    }
                    style = 0;
                } else {
                    c = Character.toLowerCase(hoverInfo.charAt(i + 1));
                    startOffset = i + 3;
                    switch (c) {
                        case 'b': {
                            style = 1;
                            break;
                        }
                        case 'i': {
                            style = 2;
                            break;
                        }
                        case 'g': {
                            style = 3;
                        }
                    }
                    c = hoverInfo.charAt(i + 2);
                    if (c != '>') {
                        buffer.append(c);
                        style = 0;
                    } else {
                        i += 2;
                        styles.push(derive += 3);
                        styles.push(startOffset);
                        styles.push(style);
                    }
                }
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public String updatePresentation(Display display, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
        return this.updatePresentation((Drawable)display, hoverInfo, presentation, maxWidth, maxHeight);
    }
}

