package tests::helpers::TestDerivedAnalyzer;

use base qw/Lire::DlfAnalyser/;

use Lire::DlfSchema;

use Carp;

sub new {
    return bless {}, shift;
}

sub name {
    return 'derived';
}

sub title {
    return 'TestDerivedAnalyzer';
}

sub description {
    return '<para>A test analyser.</para>';
}

sub src_schema {
    return 'test';
}

sub dst_schema {
    return 'test-derived';
}

sub analyse {
    my ( $self, $process, $config ) = @_;

    my $schema = Lire::DlfSchema::load_schema( 'test' );
    my $query = $schema->dlf_query();
    $query->set_sort_spec( 'connection_id time_start' );

    my $filter = $process->source_filter();
    $query->set_filter_clause( $filter->sql_expr(), @{$filter->sql_params()} )
      if defined $filter;

    my $result = $query->execute( $process->dlf_store() );

    my $session_dlf = {};
    my $dlf_ids = [];
    while ( defined( my $dlf = $result->next_row() ) ) {
        no warnings 'uninitialized';
        if ( $session_dlf->{'connection_id'} ne $dlf->{'connection_id'} ) {
            $process->write_dlf( $session_dlf, $dlf_ids )
              if defined $session_dlf->{'connection_id'};
            $session_dlf->{'connection_id'} = $dlf->{'connection_id'};
            $session_dlf->{'session_start'} = $dlf->{'time_start'};
            $session_dlf->{'session_end'} = $dlf->{'time_end'};
            $dlf_ids = [];
        }
        $session_dlf->{'session_end'} = $dlf->{'time_end'}
          if $dlf->{'time_end'} > $sesion_dlf->{'session_end'};
        $session_dlf->{'session_length'} =
          $session_dlf->{'session_end'} - $session_dlf->{'session_start'};
        push @$dlf_ids, $dlf->{'dlf_id'};
    }
    $process->write_dlf( $session_dlf, $dlf_ids )
      if defined $session_dlf->{'connection_id'};

    return;
}

1;
