package tests::SQLExtRegistryTest;

use strict;

use base qw/Lire::Test::TestCase tests::TestStoreFixture/;

use Lire::SQLExt::Registry;

sub new {
    my $self = shift()->SUPER::new( @_ );

    $self->init();

    $self;
}

sub set_up {
    my $self = shift->SUPER::set_up();

    $self->set_up_test_store();
}

sub tear_down {
    my $self = shift->SUPER::tear_down();

    $self->tear_down_test_store();
}

sub mytestfunc {
    return 'mytestfunc';
}

sub test_register_aggregates {
    my $self = $_[0];

    local @Lire::SQLExt::Registry::EXT_AGGREGATES =
      (
       [ 'myaggregate', 0, 'myaggregate' ]
      );

    my $dbh = $self->{'store'}->_dbh();

    Lire::SQLExt::Registry->register_aggregates( $dbh );
    my $res =  $dbh->selectrow_arrayref( "SELECT myaggregate() FROM dlf_test");
    $self->assert_deep_equals( [ 260 ], $res );
}

sub test_register_functions {
    my $self = $_[0];

    local @Lire::SQLExt::Registry::EXT_FUNCTIONS =
      (
       [ 'mytestfunc', 0, \&mytestfunc ]
      );

    my $dbh = $self->{'store'}->_dbh();

    Lire::SQLExt::Registry->register_functions( $dbh );
    my $res =  $dbh->selectrow_arrayref( "SELECT mytestfunc()" );
    $self->assert_deep_equals( [ 'mytestfunc' ], $res );
}

package myaggregate;

sub new {
    return bless {}, shift;
}

sub step {
    return;
}

sub finalize {
    return 260;
}

1;
