/***************************************
  $Header: /cvs/src/jbofihe/memory.c,v 1.2 2000/04/29 23:14:58 richard Exp $

  malloc/free wrappers to allow auditing.
  ***************************************/

/**********************************************************************
 * Copyright (C) Richard P. Curnow  1998-2001
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * 
 *********************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "functions.h"

static unsigned long bytes_in_use = 0;
static unsigned long max_bytes_in_use = 0;

/*++++++++++++++++++++++++++++++
  Replacement for malloc()
  ++++++++++++++++++++++++++++++*/

void *Malloc(size_t n)
{
  char *s, *r;
  unsigned long *x;
  size_t nn;

  bytes_in_use += n;
  if (bytes_in_use > max_bytes_in_use) {
    max_bytes_in_use = bytes_in_use;
  }

  nn = n + 8;
  s = (char *) malloc(nn);
  x = (unsigned long *) s;
  *x = n;
  r = (void *) (s + 8);

  return r;
}
/*++++++++++++++++++++++++++++++
  Replacement for malloc()
  ++++++++++++++++++++++++++++++*/

void *Realloc(void *old, size_t n)
{
  char *s, *r;
  unsigned long *x;
  size_t nn;

  s = (char *)old - 8;
  x = (unsigned long *) s;

  bytes_in_use -= *x;
  bytes_in_use += n;
  if (bytes_in_use > max_bytes_in_use) {
    max_bytes_in_use = bytes_in_use;
  }

  nn = n + 8;
  s = (char *) realloc(s, nn);
  x = (unsigned long *) s;
  *x = n;
  r = (void *) (s + 8);

  return r;
}

/*++++++++++++++++++++++++++++++
  Replacement for free()
  ++++++++++++++++++++++++++++++*/

void Free(void *x)
{
  char *r, *s;
  unsigned long *v;
  size_t nn;

  r = (char *) x;
  s = (void *) (r - 8);
  v = (unsigned long *) s;

  nn = *v;
  bytes_in_use -= nn;

  free(s);
}

/*++++++++++++++++++++++++++++++
  Print amount of memory used
  ++++++++++++++++++++++++++++++*/

void
print_memory_statistics(void)
{
  fprintf(stderr,
          "Bytes in use at end  : %8lu\n"
          "Maximum bytes in use : %8lu\n",
          bytes_in_use, max_bytes_in_use);

}     
