// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKDATABOXMM_GRAPH_H
#define _GTKDATABOXMM_GRAPH_H

#include <gtkdataboxmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (c) 2012  iCub Facility, Istituto Italiano di Tecnologia
 *   @author Daniele E. Domenichelli <daniele.domenichelli@iit.it>
 *
 * This file is part of gtkdataboxmm.
 *
 * gtkdataboxmm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2.1 of the License,
 * or (at your option) any later version.
 *
 * gtkdataboxmm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/object.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkDataboxGraph GtkDataboxGraph;
typedef struct _GtkDataboxGraphClass GtkDataboxGraphClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace GDatabox
{ class Graph_Class; } // namespace GDatabox
namespace Gdk { class Color; }
namespace Gdk { class Gc; }

namespace GDatabox
{


class Graph : public Glib::Object
{
    
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Graph CppObjectType;
  typedef Graph_Class CppClassType;
  typedef GtkDataboxGraph BaseObjectType;
  typedef GtkDataboxGraphClass BaseClassType;

private:  friend class Graph_Class;
  static CppClassType graph_class_;

private:
  // noncopyable
  Graph(const Graph&);
  Graph& operator=(const Graph&);

protected:
  explicit Graph(const Glib::ConstructParams& construct_params);
  explicit Graph(GtkDataboxGraph* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Graph();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkDataboxGraph*       gobj()       { return reinterpret_cast<GtkDataboxGraph*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkDataboxGraph* gobj() const { return reinterpret_cast<GtkDataboxGraph*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkDataboxGraph* gobj_copy();

private:


protected:
    Graph();

public:
// GdkGC* gtk_databox_graph_get_gc (GtkDataboxGraph * graph);
//    _WRAP_METHOD(Gdk::GC* get_gc() const, gtk_databox_graph_get_gc)
//    _WRAP_METHOD(const Gdk::GC* get_gc() const, gtk_databox_graph_get_gc, constversion)
// void gtk_databox_graph_set_gc (GtkDataboxGraph * graph, GdkGC *gc);
//    _WRAP_METHOD(void set_gc(Gdk::GC &gc) gtk_databox_graph_set_gc)

// void gtk_databox_graph_set_hide (GtkDataboxGraph * graph, gboolean hide);
    
  /** Hidden graphs are not shown, when the Gtk::Databox containing them is redrawn.
   * @param hide Declares whether should be hidden (true) or not (false).
   */
  void set_hide(bool hide);
// gboolean gtk_databox_graph_get_hide (GtkDataboxGraph * graph);
    
  /** Gets the current "hide" status.
   * @return Whether the graph is hidden (true) or not (false).
   */
  bool get_hide();

// void gtk_databox_graph_set_color (GtkDataboxGraph * graph, GdkColor * color);
    
  /** Sets the color which the Gtk::DataboxGraph object is supposed to be using when drawing itself.
   * @param color Color which is to be used by the graph object.
   */
  void set_color(const Gdk::Color & color) const;
// GdkColor *gtk_databox_graph_get_color (GtkDataboxGraph * graph);
//    _WRAP_METHOD(Gdk::Color get_color() const, gtk_databox_graph_get_color)

    
  /** Sets the size (e.g.\ line width) which the Gtk::DataboxGraph object is supposed to be using when drawing itself.
   * @param size Size of graph elements for the graph object.
   */
  void set_size(int size);
    
  /** Gets the size of the graph elements (e.g.\ the line width).
   * @return Size of the graph elements.
   */
  int get_size() const;

    
  /** Virtual function which determines the minimum and maximum x and y values of the values of this 
   * Gtk::DataboxGraph object if applicable (there are graphs which do 
   * not contain data).
   * @param min_x Will be filled with the lowest x value of the dataset.
   * @param max_x Will be filled with the highest x value of the dataset.
   * @param min_y Will be filled with the lowest y value of the dataset.
   * @param max_y Will be filled with the highest y value of the dataset.
   * @return 0 on success,
   * -1 if no data is available,.
   */
  int calculate_extrema(float & min_x, float & max_x, float & min_y, float & max_y);

    #ifdef GLIBMM_PROPERTIES_ENABLED
/** Color of graph.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::Color > property_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Color of graph.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::Color > property_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

    #ifdef GLIBMM_PROPERTIES_ENABLED
/** Size of displayed items.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< int > property_size() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Size of displayed items.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_size() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

    #ifdef GLIBMM_PROPERTIES_ENABLED
/** Determine if graph is hidden or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_hide() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Determine if graph is hidden or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_hide() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


/* This function is called by GtkDatabox */
// void gtk_databox_graph_draw (GtkDataboxGraph * graph, GtkDatabox * box);
    

/* This function is called by derived graph classes */
//GdkGC* gtk_databox_graph_create_gc (GtkDataboxGraph * graph, GtkDatabox * box);
    

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace GDatabox


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates GDatabox::Graph
   */
  Glib::RefPtr<GDatabox::Graph> wrap(GtkDataboxGraph* object, bool take_copy = false);
}


#endif /* _GTKDATABOXMM_GRAPH_H */

