---
layout: default
title: custodian.gaussian.jobs.md
nav_exclude: true
---

# custodian.gaussian.jobs module

This module implements basic kinds of jobs for Gaussian runs.

## *class* custodian.gaussian.jobs.GaussianJob(gaussian_cmd: str, input_file: str, output_file: str, stderr_file: str = ‘stderr.txt’, suffix: str = ‘’, backup: bool = True)

Bases: `Job`

A basic Gaussian job.

* **Parameters:**
  * **gaussian_cmd** (*str*) – Command to run Gaussian.
  * **input_file** (*str*) – Name of the Gaussian input file.
  * **output_file** (*str*) – Name of the Gaussian output file.
  * **stderr_file** (*str*) – Name of the stderr file. Defaults to ‘stderr.txt’.
  * **suffix** (*str*) – String to append to the input and output files, e.g., to
    rename Gaussian input and output files from say gaussian.com and
    gaussian.out, to gaussian.com.guess1 and gaussian.out.guess1,
    respectively, provide “.guess1” as the suffix. . Defaults to ‘’.
  * **backup** (*bool*) – Whether to backup the input file. If True, the input will be
    copied with a “.orig” appended to the name. Defaults to True.

### *classmethod* generate_better_guess(gaussian_cmd: str, input_file: str, output_file: str, stderr_file: str = ‘stderr.txt’, backup: bool = True, cart_coords: bool = True, directory: str = ‘./’)

Generate a better initial guess for a Gaussian calculation (optimization or
SCF run). This is done by running the job at a lower level of theory
(e.g., STO-3G). The geometry for this job is read from the checkpoint file
generated by the previous job.

* **Parameters:**
  * **gaussian_cmd** (*str*) – Command to run Gaussian.
  * **input_file** (*str*) – Name of the Gaussian input file.
  * **output_file** (*str*) – Name of the Gaussian output file.
  * **stderr_file** (*str*) – Name of the stderr file. Defaults to ‘stderr.txt’.
  * **backup** (*bool*) – Whether to backup the input file. If True, the input will be
    copied with a “.orig” appended to the name. Defaults to True.
  * **cart_coords** (*bool*) – Whether to use Cartesian coordinates in the input file.
    Defaults to True.
  * **directory** (*str*) – Directory where the job will be run. Defaults to ‘./’.
* **Yields:**
  *GaussianJob* – The Gaussian job instance.

### postprocess(directory: str = ‘./’)

Perform any postprocessing of the Gaussian run. This includes making a copy
of the input and output file if a suffix is specified.

* **Parameters:**
  **directory** (*str*) – Directory where the job was run. Defaults to ‘./’.

### run(directory: str = ‘./’)

Perform the actual Gaussian run.

* **Parameters:**
  **directory** (*str*) – Directory where the job will be run. Defaults to ‘./’.
* **Returns:**
  The process running the Gaussian job.
* **Return type:**
  subprocess.Popen

### setup(directory: str = ‘./’)

Perform initial setup for the job, i.e., make a backup of the input file if
requested.

* **Parameters:**
  **directory** (*str*) – Directory where the job will be run. Defaults to ‘./’.

### terminate(directory: str = ‘./’)

Terminate the Gaussian job.

* **Parameters:**
  **directory** (*str*) – Directory where the job was run. Defaults to ‘./’.