/*
 * validation-graphs/validation-graph-widget.hh
 *
 * Copyright 2023 by Global Phasing Ltd.
 * Author: Jakub Smulski
 *
 * This file is part of Coot
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copies of the GNU General Public License and
 * the GNU Lesser General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 51 Franklin Street,
 * Fifth Floor, Boston, MA, 02110-1301, USA.
 * See http://www.gnu.org/licenses/
 *
 */
#ifndef VALIDATION_GRAPH_WIDGET_HH
#define VALIDATION_GRAPH_WIDGET_HH
#include <gtk/gtk.h>
#include "validation-information.hh"

#if __cplusplus > 201402L
    // good times

    #include <memory>

#else
    // cope

    #include <memory>
    // Copied from: https://gist.github.com/chinmaygarde/970fd5bbd124754b7d36
    // Thank you kind man
    namespace std {
        template <typename T, typename... Args>
        unique_ptr<T> make_unique(Args&&... args) {
            return std::unique_ptr<T>(new T(std::forward<Args>(args)...));
        }
    }
#endif


G_BEGIN_DECLS   

#define COOT_VALIDATION_GRAPH_TYPE (coot_validation_graph_get_type ())
G_DECLARE_FINAL_TYPE  (CootValidationGraph, coot_validation_graph, COOT, COOT_VALIDATION_GRAPH, GtkWidget)


CootValidationGraph *coot_validation_graph_new();
void coot_validation_graph_set_horizontal_zoom_scale(CootValidationGraph* self, float scale);

/// Enable single-chain mode for the given chain ID.
/// Single-chain mode is turned off if the `chain_id` is a null pointer
void coot_validation_graph_set_single_chain_mode(CootValidationGraph* self, const char* chain_id);

G_END_DECLS

void coot_validation_graph_set_validation_information(CootValidationGraph* self, std::shared_ptr<coot::validation_information_t> vi);




#endif // VALIDATION_GRAPH_WIDGET_HH
