# -*- coding: utf-8 -*-
# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2008 Jean-Baptiste LAMY
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os, sys

try:
  os.mkdir("~/tmp/balazar3_sprites")
  os.mkdir("./balazar3/room_shots")
  os.mkdir("./balazar3/sprites")
except: pass

for animation, nb, angles in [
  ("identification",  1, [0]),
  ("nomenclature",  1, [0]),
  ("teleportation1",  1, [0]),
  ("teleportation2",  1, [0]),
  ("elementaliste",  1, [0]),
  ("elementaliste2",  1, [0]),
   ]:
  for angle in angles:
    extra = """character.model = soya.Model.get("%s")
character.rotate_vertical(-30.0)
camera.set_xyz(0.0, 5.95 * .7, 4.25 * .7)
camera.look_at(character)""" % animation
    if os.system("""python ./balazar3/scripts/make_sprite.py --center --filename ~/tmp/balazar3_sprites/item_%s --path ./balazar3 --animation %s %s --extra-code '%s; character.rotate_lateral(%s.0)'""" % (angle, animation, nb, extra.replace("\n", "; "), angle)) != 0: sys.exit()

os.system("""python ./balazar3/scripts/join_sprites.py --name item --nb-colors 255""")





sys.exit()



# Balazar
#for weapon in ["gourdin", "massue", "gros_gourdin", "baton", "baton_feu", "baguette_feu", "baton_glace", "baguette_glace", "hache", "couteau", "epee", "epee_large"]:
for weapon in ["baton_glace", "baguette_glace"]:
  for animation, nb, angles in [
    ("attente",  1, [0, 45, 90, 135, 180, 225, 270, 315]),
    ("marche" , 15, [0, 90, 180, 270]),
    ("frappe" , 20, [0, 90, 180, 270]),
    ("couic"  ,  7, [0, 90, 180, 270]),
    ("mort"   , 10, [0, 90, 180, 270]),
    ("mort2"  ,  1, [0, 90, 180, 270]),
    ]:
    for angle in angles:
      extra = """character.model = soya.AnimatedModel.get("balazar")
right_hand = soya.World(character)
character.attach_to_bone(right_hand, "mainD")
weapon = soya.World(right_hand)
weapon.model = soya.Model.get("%s")
weapon.rotate_x(-90.0)
weapon.turn_z(180.0)
weapon.set_xyz(0.05, 0.08, -0.08)
head = soya.World(character)
character.attach_to_bone(head, "tete")
eyes = soya.Body(head, soya.Model.get("lunnettes"))
eyes.rotate_vertical(-90.0)
eyes.set_xyz(0.0, -0.26, -0.2)""" % weapon
#       if   weapon == "baguette_feu":
#         extra += """
# from balazar3.driver_3d import Torch
# weapon_extra = Torch(right_hand, make_sprite = 1)
# weapon_extra.set_xyz(0.15, -0.92, -0.08)"""
#       elif weapon == "baton_feu":
#         extra += """
# from balazar3.driver_3d import Torch
# weapon_extra = Torch(right_hand, make_sprite = 1)
# weapon_extra.set_sizes((0.1 / 0.45, 0.1 / 0.45))
# weapon_extra.set_xyz(0.30, -0.92, -0.08)
# wait_round = 20"""
      if os.system("""python ./balazar3/scripts/make_sprite.py --filename ~/tmp/balazar3_sprites/balazar_%s_%s --path ./balazar3 --animation %s %s --extra-code '%s; character.rotate_lateral(%s.0)'""" % (weapon, angle, animation, nb, extra.replace("\n", "; "), angle)) != 0: sys.exit()
  os.system("""python ./balazar3/scripts/join_sprites.py --name balazar_%s""" % weapon)


# Effects
for effect, nb in [("Blood", 20), ("Fire", 20), ("Ice", 14)]:
  extra = """from balazar3.driver_3d import %s
  effect = %s(character)
  """ % (effect, effect)
  os.system("""python ./balazar3/scripts/make_sprite.py --fade-dither --step 1.5 --scale-factor 0.3 --filename ~/tmp/balazar3_sprites/divers_%s --path ./balazar3 --animation %s %s --extra-code '%s'""" % (0, effect.lower(), nb, extra.replace("\n", "; ")))
  
os.system("""python ./balazar3/scripts/join_sprites.py --name divers --nb-colors 128""")



for animation, nb, angles in [
  ("baton",  1, [0]),
  ("baton_feu",  1, [0]),
  ("baguette_feu",  1, [0]),
  ("baton_glace",  1, [0]),
  ("baguette_glace",  1, [0]),
  ("gourdin",  1, [0]),
  ("gros_gourdin",  1, [0]),
  ("massue",  1, [0]),
  ("hache",  1, [0]),
  ("couteau",  1, [0]),
  ("epee",  1, [0]),
  ("epee_large",  1, [0]),
   ]:
  for angle in angles:
    extra = """character.model = soya.Model.get("%s")
character.rotate_z(145.0)
character.rotate_y(-65.0)
character.turn_z(90.0)
camera.set_xyz(0.0, 5.95 * .7, 4.25 * .7)
camera.look_at(character)""" % animation
    if animation.startswith("baton"):
      extra += "\ncharacter.scale(0.7, 0.7, 0.7)"
    if os.system("""python ./balazar3/scripts/make_sprite.py --center --filename ~/tmp/balazar3_sprites/item_%s --path ./balazar3 --animation %s %s --extra-code '%s; character.rotate_lateral(%s.0)'""" % (angle, animation, nb, extra.replace("\n", "; "), angle)) != 0: sys.exit()



for animation, nb, angles in [
  ("deguisement_echassien",  1, [0]),
  ("cogne_dur",  1, [0]),
  ("cogne_dur2",  1, [0]),
  ("cogne_dur3",  1, [0]),
  ("identification",  1, [0]),
  ("nomenclature",  1, [0]),
  ("teleportation1",  1, [0]),
  ("teleportation2",  1, [0]),
  ("elementaliste",  1, [0]),
  ("elementaliste2",  1, [0]),
   ]:
  for angle in angles:
    extra = """character.model = soya.Model.get("%s")
character.rotate_vertical(-30.0)
camera.set_xyz(0.0, 5.95 * .7, 4.25 * .7)
camera.look_at(character)""" % animation
    if os.system("""python ./balazar3/scripts/make_sprite.py --center --filename ~/tmp/balazar3_sprites/item_%s --path ./balazar3 --animation %s %s --extra-code '%s; character.rotate_lateral(%s.0)'""" % (angle, animation, nb, extra.replace("\n", "; "), angle)) != 0: sys.exit()

for animation, nb, angles in [
  ("potion_dexperience",  1, [0]),
  ("potion_de_vie",  1, [0]),
   ]:
  for angle in angles:
    extra = """character.model = soya.Model.get("%s")
character.rotate_vertical(-20.0)
camera.set_xyz(0.0, 5.95 * .7, 4.25 * .7)
camera.look_at(character)""" % animation
    if os.system("""python ./balazar3/scripts/make_sprite.py --center --filename ~/tmp/balazar3_sprites/item_%s --path ./balazar3 --animation %s %s --extra-code '%s; character.rotate_lateral(%s.0)'""" % (angle, animation, nb, extra.replace("\n", "; "), angle)) != 0: sys.exit()

os.system("""python ./balazar3/scripts/join_sprites.py --name item --nb-colors 255""")


for animation, nb, angles in [
  ("attente",  1, [0, 45, 90, 135, 180, 225, 270, 315]),
  ("marche" , 15, [0, 90, 180, 270]),
  ("frappe" , 20, [0, 90, 180, 270]),
  ("couic"  ,  7, [0, 90, 180, 270]),
  ("mort"   , 10, [0, 90, 180, 270]),
  ("mort2"  ,  1, [0, 90, 180, 270]),
  ]:
  for angle in angles:
    extra = """character.model = soya.AnimatedModel.get("echassien")
right_hand = soya.World(character)
character.attach_to_bone(right_hand, "mainD")
weapon = soya.World(right_hand)
weapon.model = soya.Model.get("epee")
weapon.rotate_x(-90.0)
weapon.turn_z(180.0)
weapon.set_xyz(0.05, 0.08, -0.08)
head = soya.World(character)
character.attach_to_bone(head, "tete")
eyes = soya.Body(head, soya.Model.get("yeux"))
eyes.rotate_vertical(-20.0)
eyes.set_xyz(0.0, 0.0, -0.4)"""
    if os.system("""python ./balazar3/scripts/make_sprite.py --filename ~/tmp/balazar3_sprites/echassien_%s --path ./balazar3 --animation %s %s --extra-code '%s; character.rotate_lateral(%s.0)'""" % (angle, animation, nb, extra.replace("\n", "; "), angle)) != 0: sys.exit()
os.system("""python ./balazar3/scripts/join_sprites.py --name echassien""")







for animation, nb, angles in [
  ("ouvert",  1, [180]),
  ("ferme" ,  1, [180]),
  ("ouvre" , 12, [180]),
   ]:
  for angle in angles:
    extra = """character.model = soya.AnimatedModel.get("coffre1")"""
    
    if os.system("""python ./balazar3/scripts/make_sprite.py --filename ~/tmp/balazar3_sprites/coffre1_%s --path ./balazar3 --animation %s %s --extra-code '%s; character.rotate_lateral(%s.0)'""" % (angle, animation, nb, extra.replace("\n", "; "), angle)) != 0: sys.exit()
os.system("""python ./balazar3/scripts/join_sprites.py --name coffre""")



