/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509SubjectName;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class X509SubjectNameResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog((String)X509SubjectNameResolver.class.getName());

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineLookupResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can I resolve " + element.getTagName() + "?"));
        }
        Element[] elementArray = null;
        XMLX509SubjectName[] xMLX509SubjectNameArray = null;
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            log.debug((Object)"I can't");
            return null;
        }
        elementArray = XMLUtils.selectDsNodes(element.getFirstChild(), "X509SubjectName");
        if (elementArray == null || elementArray.length <= 0) {
            log.debug((Object)"I can't");
            return null;
        }
        try {
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509SubjectName"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                log.info((Object)"", (Throwable)keyResolverException);
                throw keyResolverException;
            }
            xMLX509SubjectNameArray = new XMLX509SubjectName[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                xMLX509SubjectNameArray[i] = new XMLX509SubjectName(elementArray[i], string);
            }
            while (storageResolver.hasNext()) {
                X509Certificate x509Certificate = storageResolver.next();
                XMLX509SubjectName xMLX509SubjectName = new XMLX509SubjectName(element.getOwnerDocument(), x509Certificate);
                log.debug((Object)("Found Certificate SN: " + xMLX509SubjectName.getSubjectName()));
                for (int i = 0; i < xMLX509SubjectNameArray.length; ++i) {
                    log.debug((Object)("Found Element SN:     " + xMLX509SubjectNameArray[i].getSubjectName()));
                    if (xMLX509SubjectName.equals(xMLX509SubjectNameArray[i])) {
                        log.debug((Object)"match !!! ");
                        return x509Certificate;
                    }
                    log.debug((Object)"no match...");
                }
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug((Object)"XMLSecurityException", (Throwable)xMLSecurityException);
            throw new KeyResolverException("generic.EmptyMessage", xMLSecurityException);
        }
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }
}

