#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Blacksad: Under the Skin
# send your bug reports to contact@dotslashplay.it
###

script_version=20231015.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='blacksad-under-the-skin'
GAME_NAME='Blacksad: Under the Skin'

ARCHIVE_BASE_0_NAME='setup_blacksad_under_the_skin_1.0.5_12210.2935.2020040301_(37312).exe'
ARCHIVE_BASE_0_MD5='9c9211aac30170bf4ac85950094f99a2'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_blacksad_under_the_skin_1.0.5_12210.2935.2020040301_(37312)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='0d21ed49ef3377b4816ae364cbb5eee1'
ARCHIVE_BASE_0_PART2_NAME='setup_blacksad_under_the_skin_1.0.5_12210.2935.2020040301_(37312)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='58e82951055a5c863cd804f2421e729f'
ARCHIVE_BASE_0_PART3_NAME='setup_blacksad_under_the_skin_1.0.5_12210.2935.2020040301_(37312)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='acf9dc21ffa4d483b124561e5b19633d'
ARCHIVE_BASE_0_PART4_NAME='setup_blacksad_under_the_skin_1.0.5_12210.2935.2020040301_(37312)-4.bin'
ARCHIVE_BASE_0_PART4_MD5='d1c80d50a67c2a4212e9898416193562'
ARCHIVE_BASE_0_SIZE='16000000'
ARCHIVE_BASE_0_VERSION='1.0.5-gog37312'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/blacksad_under_the_skin'

UNITY3D_NAME='blacksad'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_DATA_ASSETS_FILES="
${UNITY3D_NAME}_data/streamingassets"

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/PenduloStudios/Blacksad'

PACKAGES_LIST='PKG_BIN PKG_DATA_ASSETS PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_DATA_ASSETS_ID="${PKG_DATA_ID}-assets"
PKG_DATA_ASSETS_DESCRIPTION="$PKG_DATA_DESCRIPTION - assets"
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_DATA_ASSETS_ID"

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

PKG='PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
