#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Vampyre Story
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220821.1

GAME_ID='a-vampyre-story'
GAME_NAME='A Vampyre Story'

# This DRM-free installer is no longer sold by GOG
ARCHIVE_BASE_0='setup_a_vampyre_story_1.0_(43163).exe'
ARCHIVE_BASE_0_MD5='f2441fb51aac6eaca5e97f6e6a3ea0ab'
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS='--progress=1 --silent'
ARCHIVE_BASE_0_PART1='setup_a_vampyre_story_1.0_(43163)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='2c652e191d82c70fbbe5af4d259f3ba2'
ARCHIVE_BASE_0_SIZE='3200000'
ARCHIVE_BASE_0_VERSION='1.0-gog43163'

CONTENT_PATH_DEFAULT='game'
ARCHIVE_DOC_DATA_FILES='
license.txt
readme.txt'
ARCHIVE_GAME_BIN_FILES='
main.exe
*.dll
*.pyd
__init__.pyc
library.zip
*.pyo
w9xpopen.exe'
ARCHIVE_GAME_DATA_FILES='
assets
etc
tcl
icon.ico
installer.bmp'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='main.exe'
APP_MAIN_ICON='icon.ico'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Set up a WINE virtual desktop on first launch, using the current desktop resolution

PKG_BIN_DEPS="$PKG_BIN_DEPS winetricks xrandr sed"
sed_expression='s/.*primary.* ([0-9]+x[0-9]+).*/\1/p'
sed_options="--regexp-extended --silent --expression='$sed_expression'"
APP_WINETRICKS="$APP_WINETRICKS vd=\$(LANG=C xrandr | sed $sed_options)"

# Disable CSMT rendering, as it messes up with movies playback
# cf. https://bugs.winehq.org/show_bug.cgi?id=37659

APP_WINETRICKS="$APP_WINETRICKS csmt=off"
PKG_BIN_DEPS="$PKG_BIN_DEPS winetricks"

# Use persistent storage for user data

DATA_DIRS='assets/scripts etc'

# Load common functions

target_version='2.17'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icon

PKG='PKG_DATA'
icons_inclusion

# Include game data

prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
