/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa.literal;

import java.util.Iterator;
import java.util.TreeMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CanonicalXMLEventWriter
implements XMLEventWriter {
    private final XMLStreamWriter swriter;
    private final Attribute contextLang;
    private int level;

    public CanonicalXMLEventWriter(XMLStreamWriter swriter, Attribute contextLang) {
        this.swriter = swriter;
        this.contextLang = contextLang;
        this.level = 0;
    }

    public void flush() throws XMLStreamException {
        this.swriter.flush();
    }

    public void close() throws XMLStreamException {
        this.swriter.close();
    }

    public void add(XMLEvent event) throws XMLStreamException {
        if (event.isEndElement()) {
            --this.level;
            this.swriter.writeEndElement();
        } else if (event.isCharacters()) {
            this.swriter.writeCharacters(event.asCharacters().getData());
        } else if (event.isProcessingInstruction()) {
            this.swriter.writeProcessingInstruction(((ProcessingInstruction)event).getData(), ((ProcessingInstruction)event).getTarget());
        } else if (event.isStartElement()) {
            ++this.level;
            StartElement se = event.asStartElement();
            if (se.getName().getNamespaceURI() == null || se.getName().getNamespaceURI().length() == 0) {
                this.swriter.writeStartElement(se.getName().getLocalPart());
            } else if (se.getName().getPrefix().length() == 0) {
                this.swriter.setDefaultNamespace(se.getName().getNamespaceURI());
                this.swriter.writeStartElement(se.getName().getNamespaceURI(), se.getName().getLocalPart());
            } else {
                this.swriter.writeStartElement(se.getName().getPrefix(), se.getName().getLocalPart(), se.getName().getNamespaceURI());
            }
            this.writeAttributes(se);
            this.swriter.writeCharacters("");
        } else {
            System.err.printf("Gah! Missed one <%s>, '%s'\n", event.getClass(), event);
        }
    }

    public void add(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            this.add(reader.nextEvent());
        }
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this.swriter.getPrefix(uri);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.swriter.setPrefix(prefix, uri);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.swriter.setDefaultNamespace(uri);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.swriter.setNamespaceContext(context);
    }

    public NamespaceContext getNamespaceContext() {
        return this.swriter.getNamespaceContext();
    }

    private void writeAttributes(StartElement se) throws XMLStreamException {
        TreeMap<String, Attribute> atts = new TreeMap<String, Attribute>();
        if (this.level == 2 && this.contextLang != null) {
            atts.put("_xml:lang", this.contextLang);
        }
        Iterator i = se.getAttributes();
        while (i.hasNext()) {
            Attribute a = (Attribute)i.next();
            atts.put(this.getName(a), a);
        }
        for (Attribute a : atts.values()) {
            if (a.getName().getNamespaceURI() == null || a.getName().getNamespaceURI().length() == 0) {
                this.swriter.writeAttribute(a.getName().getLocalPart(), a.getValue());
                continue;
            }
            if (a.getName().getPrefix().length() == 0) {
                this.swriter.writeAttribute(a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
                continue;
            }
            this.swriter.writeAttribute(a.getName().getPrefix(), a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
        }
    }

    private String getName(Attribute a) {
        QName name = a.getName();
        String toReturn = null;
        if (name.getLocalPart().contains(":")) {
            toReturn = name.getLocalPart();
        } else {
            String string = toReturn = name.getPrefix() == null ? name.getLocalPart() : name.getPrefix() + ":" + name.getLocalPart();
        }
        if (toReturn.startsWith("xml:")) {
            return "_" + toReturn;
        }
        return toReturn;
    }
}

