// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(docsrs, feature(doc_cfg))]

use gio_sys as gio;
use glib_sys as glib;
use gobject_sys as gobject;

mod manual;

pub use manual::*;

#[allow(unused_imports)]
use libc::{FILE, intptr_t, off_t, size_t, ssize_t, time_t, uintptr_t};
#[cfg(unix)]
#[allow(unused_imports)]
use libc::{dev_t, gid_t, pid_t, socklen_t, uid_t};
#[allow(unused_imports)]
use std::ffi::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
};

#[allow(unused_imports)]
use glib::{GType, gboolean, gconstpointer, gpointer};

// Constants
pub const G_DESKTOP_APP_INFO_LOOKUP_EXTENSION_POINT_NAME: &[u8] = b"gio-desktop-app-info-lookup\0";

// Callbacks
pub type GDesktopAppLaunchCallback =
    Option<unsafe extern "C" fn(*mut GDesktopAppInfo, glib::GPid, gpointer)>;

// Records
#[derive(Copy, Clone)]
#[repr(C)]
pub struct GDesktopAppInfoClass {
    pub parent_class: gobject::GObjectClass,
}

impl ::std::fmt::Debug for GDesktopAppInfoClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GDesktopAppInfoClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GDesktopAppInfoLookupIface {
    pub g_iface: gobject::GTypeInterface,
    pub get_default_for_uri_scheme: Option<
        unsafe extern "C" fn(*mut GDesktopAppInfoLookup, *const c_char) -> *mut gio::GAppInfo,
    >,
}

impl ::std::fmt::Debug for GDesktopAppInfoLookupIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GDesktopAppInfoLookupIface @ {self:p}"))
            .field("g_iface", &self.g_iface)
            .field(
                "get_default_for_uri_scheme",
                &self.get_default_for_uri_scheme,
            )
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GFileDescriptorBasedIface {
    pub g_iface: gobject::GTypeInterface,
    pub get_fd: Option<unsafe extern "C" fn(*mut GFileDescriptorBased) -> c_int>,
}

impl ::std::fmt::Debug for GFileDescriptorBasedIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GFileDescriptorBasedIface @ {self:p}"))
            .field("g_iface", &self.g_iface)
            .field("get_fd", &self.get_fd)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GUnixFDMessageClass {
    pub parent_class: gio::GSocketControlMessageClass,
    pub _g_reserved1: Option<unsafe extern "C" fn()>,
    pub _g_reserved2: Option<unsafe extern "C" fn()>,
}

impl ::std::fmt::Debug for GUnixFDMessageClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GUnixFDMessageClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("_g_reserved1", &self._g_reserved1)
            .field("_g_reserved2", &self._g_reserved2)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GUnixFDMessagePrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GUnixFDMessagePrivate = _GUnixFDMessagePrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GUnixInputStreamClass {
    pub parent_class: gio::GInputStreamClass,
    pub _g_reserved1: Option<unsafe extern "C" fn()>,
    pub _g_reserved2: Option<unsafe extern "C" fn()>,
    pub _g_reserved3: Option<unsafe extern "C" fn()>,
    pub _g_reserved4: Option<unsafe extern "C" fn()>,
    pub _g_reserved5: Option<unsafe extern "C" fn()>,
}

impl ::std::fmt::Debug for GUnixInputStreamClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GUnixInputStreamClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("_g_reserved1", &self._g_reserved1)
            .field("_g_reserved2", &self._g_reserved2)
            .field("_g_reserved3", &self._g_reserved3)
            .field("_g_reserved4", &self._g_reserved4)
            .field("_g_reserved5", &self._g_reserved5)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GUnixInputStreamPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GUnixInputStreamPrivate = _GUnixInputStreamPrivate;

#[repr(C)]
#[allow(dead_code)]
pub struct GUnixMountEntry {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for GUnixMountEntry {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GUnixMountEntry @ {self:p}"))
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GUnixMountMonitorClass {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GUnixMountMonitorClass = _GUnixMountMonitorClass;

#[repr(C)]
#[allow(dead_code)]
pub struct GUnixMountPoint {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for GUnixMountPoint {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GUnixMountPoint @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GUnixOutputStreamClass {
    pub parent_class: gio::GOutputStreamClass,
    pub _g_reserved1: Option<unsafe extern "C" fn()>,
    pub _g_reserved2: Option<unsafe extern "C" fn()>,
    pub _g_reserved3: Option<unsafe extern "C" fn()>,
    pub _g_reserved4: Option<unsafe extern "C" fn()>,
    pub _g_reserved5: Option<unsafe extern "C" fn()>,
}

impl ::std::fmt::Debug for GUnixOutputStreamClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GUnixOutputStreamClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("_g_reserved1", &self._g_reserved1)
            .field("_g_reserved2", &self._g_reserved2)
            .field("_g_reserved3", &self._g_reserved3)
            .field("_g_reserved4", &self._g_reserved4)
            .field("_g_reserved5", &self._g_reserved5)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GUnixOutputStreamPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GUnixOutputStreamPrivate = _GUnixOutputStreamPrivate;

// Classes
#[repr(C)]
#[allow(dead_code)]
pub struct GDesktopAppInfo {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for GDesktopAppInfo {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GDesktopAppInfo @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GUnixFDMessage {
    pub parent_instance: gio::GSocketControlMessage,
    pub priv_: *mut GUnixFDMessagePrivate,
}

impl ::std::fmt::Debug for GUnixFDMessage {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GUnixFDMessage @ {self:p}"))
            .field("parent_instance", &self.parent_instance)
            .field("priv_", &self.priv_)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GUnixInputStream {
    pub parent_instance: gio::GInputStream,
    pub priv_: *mut GUnixInputStreamPrivate,
}

impl ::std::fmt::Debug for GUnixInputStream {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GUnixInputStream @ {self:p}"))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GUnixMountMonitor {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for GUnixMountMonitor {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GUnixMountMonitor @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GUnixOutputStream {
    pub parent_instance: gio::GOutputStream,
    pub priv_: *mut GUnixOutputStreamPrivate,
}

impl ::std::fmt::Debug for GUnixOutputStream {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GUnixOutputStream @ {self:p}"))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

// Interfaces
#[repr(C)]
#[allow(dead_code)]
pub struct GDesktopAppInfoLookup {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for GDesktopAppInfoLookup {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "GDesktopAppInfoLookup @ {self:p}")
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GFileDescriptorBased {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for GFileDescriptorBased {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "GFileDescriptorBased @ {self:p}")
    }
}

unsafe extern "C" {

    //=========================================================================
    // GUnixMountEntry
    //=========================================================================
    pub fn g_unix_mount_entry_get_type() -> GType;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_compare(
        mount1: *mut GUnixMountEntry,
        mount2: *mut GUnixMountEntry,
    ) -> c_int;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_free(mount_entry: *mut GUnixMountEntry);
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_get_device_path(mount_entry: *mut GUnixMountEntry) -> *const c_char;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_get_fs_type(mount_entry: *mut GUnixMountEntry) -> *const c_char;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_get_mount_path(mount_entry: *mut GUnixMountEntry) -> *const c_char;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_get_options(mount_entry: *mut GUnixMountEntry) -> *const c_char;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_get_root_path(mount_entry: *mut GUnixMountEntry) -> *const c_char;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_guess_can_eject(mount_entry: *mut GUnixMountEntry) -> gboolean;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_guess_icon(mount_entry: *mut GUnixMountEntry) -> *mut gio::GIcon;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_guess_name(mount_entry: *mut GUnixMountEntry) -> *mut c_char;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_guess_should_display(mount_entry: *mut GUnixMountEntry) -> gboolean;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_guess_symbolic_icon(
        mount_entry: *mut GUnixMountEntry,
    ) -> *mut gio::GIcon;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_is_readonly(mount_entry: *mut GUnixMountEntry) -> gboolean;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_is_system_internal(mount_entry: *mut GUnixMountEntry) -> gboolean;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_at(
        mount_path: *const c_char,
        time_read: *mut u64,
    ) -> *mut GUnixMountEntry;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entry_for(
        file_path: *const c_char,
        time_read: *mut u64,
    ) -> *mut GUnixMountEntry;

    //=========================================================================
    // GUnixMountPoint
    //=========================================================================
    pub fn g_unix_mount_point_get_type() -> GType;
    pub fn g_unix_mount_point_compare(
        mount1: *mut GUnixMountPoint,
        mount2: *mut GUnixMountPoint,
    ) -> c_int;
    pub fn g_unix_mount_point_free(mount_point: *mut GUnixMountPoint);
    pub fn g_unix_mount_point_get_device_path(mount_point: *mut GUnixMountPoint) -> *const c_char;
    pub fn g_unix_mount_point_get_fs_type(mount_point: *mut GUnixMountPoint) -> *const c_char;
    pub fn g_unix_mount_point_get_mount_path(mount_point: *mut GUnixMountPoint) -> *const c_char;
    pub fn g_unix_mount_point_get_options(mount_point: *mut GUnixMountPoint) -> *const c_char;
    pub fn g_unix_mount_point_guess_can_eject(mount_point: *mut GUnixMountPoint) -> gboolean;
    pub fn g_unix_mount_point_guess_icon(mount_point: *mut GUnixMountPoint) -> *mut gio::GIcon;
    pub fn g_unix_mount_point_guess_name(mount_point: *mut GUnixMountPoint) -> *mut c_char;
    pub fn g_unix_mount_point_guess_symbolic_icon(
        mount_point: *mut GUnixMountPoint,
    ) -> *mut gio::GIcon;
    pub fn g_unix_mount_point_is_loopback(mount_point: *mut GUnixMountPoint) -> gboolean;
    pub fn g_unix_mount_point_is_readonly(mount_point: *mut GUnixMountPoint) -> gboolean;
    pub fn g_unix_mount_point_is_user_mountable(mount_point: *mut GUnixMountPoint) -> gboolean;
    #[cfg(feature = "v2_66")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_66")))]
    pub fn g_unix_mount_point_at(
        mount_path: *const c_char,
        time_read: *mut u64,
    ) -> *mut GUnixMountPoint;

    //=========================================================================
    // GDesktopAppInfo
    //=========================================================================
    pub fn g_desktop_app_info_get_type() -> GType;
    pub fn g_desktop_app_info_new(desktop_id: *const c_char) -> *mut GDesktopAppInfo;
    pub fn g_desktop_app_info_new_from_filename(filename: *const c_char) -> *mut GDesktopAppInfo;
    pub fn g_desktop_app_info_new_from_keyfile(
        key_file: *mut glib::GKeyFile,
    ) -> *mut GDesktopAppInfo;
    pub fn g_desktop_app_info_get_implementations(interface: *const c_char) -> *mut glib::GList;
    pub fn g_desktop_app_info_search(search_string: *const c_char) -> *mut *mut *mut c_char;
    pub fn g_desktop_app_info_set_desktop_env(desktop_env: *const c_char);
    pub fn g_desktop_app_info_get_action_name(
        info: *mut GDesktopAppInfo,
        action_name: *const c_char,
    ) -> *mut c_char;
    pub fn g_desktop_app_info_get_boolean(
        info: *mut GDesktopAppInfo,
        key: *const c_char,
    ) -> gboolean;
    pub fn g_desktop_app_info_get_categories(info: *mut GDesktopAppInfo) -> *const c_char;
    pub fn g_desktop_app_info_get_filename(info: *mut GDesktopAppInfo) -> *const c_char;
    pub fn g_desktop_app_info_get_generic_name(info: *mut GDesktopAppInfo) -> *const c_char;
    pub fn g_desktop_app_info_get_is_hidden(info: *mut GDesktopAppInfo) -> gboolean;
    pub fn g_desktop_app_info_get_keywords(info: *mut GDesktopAppInfo) -> *const *const c_char;
    pub fn g_desktop_app_info_get_locale_string(
        info: *mut GDesktopAppInfo,
        key: *const c_char,
    ) -> *mut c_char;
    pub fn g_desktop_app_info_get_nodisplay(info: *mut GDesktopAppInfo) -> gboolean;
    pub fn g_desktop_app_info_get_show_in(
        info: *mut GDesktopAppInfo,
        desktop_env: *const c_char,
    ) -> gboolean;
    pub fn g_desktop_app_info_get_startup_wm_class(info: *mut GDesktopAppInfo) -> *const c_char;
    pub fn g_desktop_app_info_get_string(
        info: *mut GDesktopAppInfo,
        key: *const c_char,
    ) -> *mut c_char;
    #[cfg(feature = "v2_60")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_60")))]
    pub fn g_desktop_app_info_get_string_list(
        info: *mut GDesktopAppInfo,
        key: *const c_char,
        length: *mut size_t,
    ) -> *mut *mut c_char;
    pub fn g_desktop_app_info_has_key(info: *mut GDesktopAppInfo, key: *const c_char) -> gboolean;
    pub fn g_desktop_app_info_launch_action(
        info: *mut GDesktopAppInfo,
        action_name: *const c_char,
        launch_context: *mut gio::GAppLaunchContext,
    );
    pub fn g_desktop_app_info_launch_uris_as_manager(
        appinfo: *mut GDesktopAppInfo,
        uris: *mut glib::GList,
        launch_context: *mut gio::GAppLaunchContext,
        spawn_flags: glib::GSpawnFlags,
        user_setup: glib::GSpawnChildSetupFunc,
        user_setup_data: gpointer,
        pid_callback: GDesktopAppLaunchCallback,
        pid_callback_data: gpointer,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(feature = "v2_58")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_58")))]
    pub fn g_desktop_app_info_launch_uris_as_manager_with_fds(
        appinfo: *mut GDesktopAppInfo,
        uris: *mut glib::GList,
        launch_context: *mut gio::GAppLaunchContext,
        spawn_flags: glib::GSpawnFlags,
        user_setup: glib::GSpawnChildSetupFunc,
        user_setup_data: gpointer,
        pid_callback: GDesktopAppLaunchCallback,
        pid_callback_data: gpointer,
        stdin_fd: c_int,
        stdout_fd: c_int,
        stderr_fd: c_int,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn g_desktop_app_info_list_actions(info: *mut GDesktopAppInfo) -> *const *const c_char;

    //=========================================================================
    // GUnixFDMessage
    //=========================================================================
    pub fn g_unix_fd_message_get_type() -> GType;
    pub fn g_unix_fd_message_new() -> *mut gio::GSocketControlMessage;
    pub fn g_unix_fd_message_new_with_fd_list(
        fd_list: *mut gio::GUnixFDList,
    ) -> *mut gio::GSocketControlMessage;
    pub fn g_unix_fd_message_append_fd(
        message: *mut GUnixFDMessage,
        fd: c_int,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn g_unix_fd_message_get_fd_list(message: *mut GUnixFDMessage) -> *mut gio::GUnixFDList;
    pub fn g_unix_fd_message_steal_fds(
        message: *mut GUnixFDMessage,
        length: *mut c_int,
    ) -> *mut c_int;

    //=========================================================================
    // GUnixInputStream
    //=========================================================================
    pub fn g_unix_input_stream_get_type() -> GType;
    pub fn g_unix_input_stream_new(fd: c_int, close_fd: gboolean) -> *mut gio::GInputStream;
    pub fn g_unix_input_stream_get_close_fd(stream: *mut GUnixInputStream) -> gboolean;
    pub fn g_unix_input_stream_get_fd(stream: *mut GUnixInputStream) -> c_int;
    pub fn g_unix_input_stream_set_close_fd(stream: *mut GUnixInputStream, close_fd: gboolean);

    //=========================================================================
    // GUnixMountMonitor
    //=========================================================================
    pub fn g_unix_mount_monitor_get_type() -> GType;
    pub fn g_unix_mount_monitor_new() -> *mut GUnixMountMonitor;
    pub fn g_unix_mount_monitor_get() -> *mut GUnixMountMonitor;
    pub fn g_unix_mount_monitor_set_rate_limit(
        mount_monitor: *mut GUnixMountMonitor,
        limit_msec: c_int,
    );

    //=========================================================================
    // GUnixOutputStream
    //=========================================================================
    pub fn g_unix_output_stream_get_type() -> GType;
    pub fn g_unix_output_stream_new(fd: c_int, close_fd: gboolean) -> *mut gio::GOutputStream;
    pub fn g_unix_output_stream_get_close_fd(stream: *mut GUnixOutputStream) -> gboolean;
    pub fn g_unix_output_stream_get_fd(stream: *mut GUnixOutputStream) -> c_int;
    pub fn g_unix_output_stream_set_close_fd(stream: *mut GUnixOutputStream, close_fd: gboolean);

    //=========================================================================
    // GDesktopAppInfoLookup
    //=========================================================================
    pub fn g_desktop_app_info_lookup_get_type() -> GType;
    pub fn g_desktop_app_info_lookup_get_default_for_uri_scheme(
        lookup: *mut GDesktopAppInfoLookup,
        uri_scheme: *const c_char,
    ) -> *mut gio::GAppInfo;

    //=========================================================================
    // GFileDescriptorBased
    //=========================================================================
    pub fn g_file_descriptor_based_get_type() -> GType;
    pub fn g_file_descriptor_based_get_fd(fd_based: *mut GFileDescriptorBased) -> c_int;

    //=========================================================================
    // Other functions
    //=========================================================================
    pub fn g_unix_is_mount_path_system_internal(mount_path: *const c_char) -> gboolean;
    pub fn g_unix_is_system_device_path(device_path: *const c_char) -> gboolean;
    pub fn g_unix_is_system_fs_type(fs_type: *const c_char) -> gboolean;
    pub fn g_unix_mount_at(mount_path: *const c_char, time_read: *mut u64) -> *mut GUnixMountEntry;
    pub fn g_unix_mount_compare(
        mount1: *mut GUnixMountEntry,
        mount2: *mut GUnixMountEntry,
    ) -> c_int;
    pub fn g_unix_mount_copy(mount_entry: *mut GUnixMountEntry) -> *mut GUnixMountEntry;
    pub fn g_unix_mount_entries_changed_since(time: u64) -> gboolean;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entries_get(time_read: *mut u64) -> *mut glib::GList;
    #[cfg(feature = "v2_84")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_84")))]
    pub fn g_unix_mount_entries_get_from_file(
        table_path: *const c_char,
        time_read_out: *mut u64,
        n_entries_out: *mut size_t,
    ) -> *mut *mut GUnixMountEntry;
    pub fn g_unix_mount_for(file_path: *const c_char, time_read: *mut u64) -> *mut GUnixMountEntry;
    pub fn g_unix_mount_free(mount_entry: *mut GUnixMountEntry);
    pub fn g_unix_mount_get_device_path(mount_entry: *mut GUnixMountEntry) -> *const c_char;
    pub fn g_unix_mount_get_fs_type(mount_entry: *mut GUnixMountEntry) -> *const c_char;
    pub fn g_unix_mount_get_mount_path(mount_entry: *mut GUnixMountEntry) -> *const c_char;
    #[cfg(feature = "v2_58")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_58")))]
    pub fn g_unix_mount_get_options(mount_entry: *mut GUnixMountEntry) -> *const c_char;
    #[cfg(feature = "v2_60")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_60")))]
    pub fn g_unix_mount_get_root_path(mount_entry: *mut GUnixMountEntry) -> *const c_char;
    pub fn g_unix_mount_guess_can_eject(mount_entry: *mut GUnixMountEntry) -> gboolean;
    pub fn g_unix_mount_guess_icon(mount_entry: *mut GUnixMountEntry) -> *mut gio::GIcon;
    pub fn g_unix_mount_guess_name(mount_entry: *mut GUnixMountEntry) -> *mut c_char;
    pub fn g_unix_mount_guess_should_display(mount_entry: *mut GUnixMountEntry) -> gboolean;
    pub fn g_unix_mount_guess_symbolic_icon(mount_entry: *mut GUnixMountEntry) -> *mut gio::GIcon;
    pub fn g_unix_mount_is_readonly(mount_entry: *mut GUnixMountEntry) -> gboolean;
    pub fn g_unix_mount_is_system_internal(mount_entry: *mut GUnixMountEntry) -> gboolean;
    pub fn g_unix_mount_points_changed_since(time: u64) -> gboolean;
    pub fn g_unix_mount_points_get(time_read: *mut u64) -> *mut glib::GList;
    #[cfg(feature = "v2_82")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_82")))]
    pub fn g_unix_mount_points_get_from_file(
        table_path: *const c_char,
        time_read_out: *mut u64,
        n_points_out: *mut size_t,
    ) -> *mut *mut GUnixMountPoint;
    pub fn g_unix_mounts_changed_since(time: u64) -> gboolean;
    pub fn g_unix_mounts_get(time_read: *mut u64) -> *mut glib::GList;
    #[cfg(feature = "v2_82")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_82")))]
    pub fn g_unix_mounts_get_from_file(
        table_path: *const c_char,
        time_read_out: *mut u64,
        n_entries_out: *mut size_t,
    ) -> *mut *mut GUnixMountEntry;

}
